<?php
$field_id = $request['field_id'];
$field_info = ft_get_form_field($field_id);

$file_upload_dir = (empty($field_info['file_upload_dir'])) ? "$g_root_dir/files" : $field_info['file_upload_dir'];
$file_upload_url = (empty($field_info['file_upload_url'])) ? "$g_root_url/files" : $field_info['file_upload_url'];

$uploaded_files = ft_get_uploaded_filenames($form_id, $field_id);
?>

<script type="text/javascript">

function handleIframeReturnValue(val, id)
{
  $(id).innerHTML = val;
}

// called by user to test the permissions on the folder they entered
function test_folder_permissions()
{
  document.hidden_form.file_upload_dir.value = document.file_upload_settings_form.file_upload_dir.value;
  document.hidden_form.action.value = "test_permissions";
  document.hidden_form.returnid.value = "permissions_message_id";
  document.hidden_form.submit();
}

// called by user to test the permissions on the folder they entered
function test_folder_url_match()
{
  document.hidden_form.file_upload_dir.value = document.file_upload_settings_form.file_upload_dir.value;
  document.hidden_form.file_upload_url.value = document.file_upload_settings_form.file_upload_url.value;
  document.hidden_form.action.value = "test_folder_url_match";
  document.hidden_form.returnid.value = "folder_match_message_id";
  document.hidden_form.submit();
}

</script>


<!-- TABS -->
<table cellpadding="0" cellspacing="0" border="0" width="650">
<tr>
  <td>
    <?php
    $tab = "display";
    require("_edit_form_tabs.php");
    ?>
  </td>
</tr>
<tr>
  <td colspan="2" class="tab_content">

  <?php
  // TODO. Ben, why REQUEST_URI, here? Not compatible with all systems... There are several instances of it
  // throughout the program. I thought I removed them all?
  ?>
  <form action="<?php echo $_SERVER['REQUEST_URI']?>" method="post" name="file_upload_settings_form">
	  <input type='hidden' name='form_id' value='<?php echo $form_id?>' />
	  <input type='hidden' name='field_id' value='<?php echo $field_id?>' />
	  
	  <div class="subtitle"><?php echo $LANG["phrase_file_upload_options"]; ?></div>
	  <br />

	  <table style="width: 100%" cellspacing="0">
	  <tr>
	    <td class="error">
	      <span><?php echo $LANG["word_warning"]; ?></span><br />
	      <br />
	      <span class="highlighted_text">*</span> <?php echo $LANG["text_please_enter_field_security_reasons"]; ?> 
	    </td>
	  </tr>
	  </table>
	
	  <br />
	  
	  <table cellpadding="0" cellspacing="1" class="list_table" width="100%">
	  <tr>
	    <td width="120">&nbsp;<?php echo $LANG["phrase_upload_folder_path"]; ?></td>
	    <td>
	      <input type="hidden" name="original_file_upload_dir" value="<?php echo $file_upload_dir; ?>" />
	
	      <table cellpadding="0" cellspacing="0" width="100%">
	      <tr>
	        <td><input type="text" name="file_upload_dir" value="<?php echo $file_upload_dir; ?>" style="width: 100%" /></td>
	        <td width="150">
	          <input type="button" value="<?php echo $LANG["phrase_test_folder_permissions"]; ?>" onclick="test_folder_permissions()" style="width: 150px;" />
	        </td>
	      </tr>
	      </table>
	      
	      <?php
	      // if the upload folder wasn't originally empty (i.e. unset) and there is at least one file that 
	      // has been uploaded through this field, provide an option to move all files in the event of them changing
	      // the upload dir
	      if (!empty($file_upload_dir) && !empty($uploaded_files))
	      {
	        echo "<input type='checkbox' name='move_files' id='move_files' value='yes' />
                  <label for='move_files'>{$LANG["phrase_move_existing_files"]}</label><br />"; 
	      }
	      ?>
	      
	      <div id="permissions_message_id"></div>
	      
	    </td>
	  </tr>
	  <tr>
	    <td>&nbsp;<?php echo $LANG["phrase_upload_folder_url"]; ?></td>
	    <td>
	
	      <table cellpadding="0" cellspacing="0" width="100%">
	      <tr>
	        <td><input type="text" name="file_upload_url" value="<?php echo $file_upload_url; ?>" style="width: 100%" /></td>
	
	        <?php
	        // if 
	        if (ini_get("allow_url_fopen") == "1")
	        {
	          echo "<td width='150'><input type='button' value=\"{$LANG["phrase_confirm_folder_url_match"]}\" 
	                  onclick='test_folder_url_match()' style='width: 150px;' /></td>";  
	        }
	        ?>
	        
	      </tr>
	      </table>
	
	      <div id="folder_match_message_id"></div>
	
	    </td>
	  </tr>
	  <tr height="20">
	    <td>&nbsp;<?php echo $LANG["phrase_max_file_size"]; ?></td>
	    <td><input type="text" name="file_upload_max_size" value="<?php echo $field_info['file_upload_max_size']; ?>" style="width: 60px" maxlength="10" />KB</td>
	  </tr>
	  <tr height="20">
	    <td>&nbsp;<?php echo $LANG["phrase_permitted_file_types"]; ?> <span class="highlighted_text">*</span></td>
	    <td>
	      <input type="text" name="file_upload_types" value="<?php echo $field_info['file_upload_types']; ?>" style="width: 100%" /><br />
	      <?php echo $LANG["text_file_extension_info"]; ?>
	    </td>
	  </tr>
	  </table>

	  <p>
	    <input type="submit" name="update_field_file_settings" value="<?php echo $LANG["word_update_uc"]; ?>" />
	  </p>
  </form> 

  <form method="POST" action="<?php echo $g_root_url?>/global/code/actions.php" name="hidden_form" target="hidden_iframe">
    <input type="hidden" name="action" value="" />
    <input type="hidden" name="file_upload_url" value="" />
    <input type="hidden" name="file_upload_dir" value="" />
    <input type="hidden" name="returnid" value="" />
  </form>

  <iframe src="about:blank" name="hidden_iframe" id="hidden_iframe" width="10" height="10" frameborder="0"></iframe>

  </td>
</tr>
</table>
