<?php

// retrieve all information about this field for use in the page
$field_id = $request['field_id'];
$field_options = ft_get_field_options($field_id);
$field_info = ft_get_form_field($field_id);

$num_options = mysql_num_rows($field_options);
$num_options = (empty($num_options) || $num_options == 0) ? 0 : $num_options;

// check to see if the form URL and the current URL are on the same host.
$form_url_info = parse_url($form_info['form_url']);
$form_host = $form_url_info['host'];
$current_host = $_SERVER['HTTP_HOST'];

?>

<script type="text/javascript">

var page_loaded = 0;
var field_name = "<?php echo $field_info['field_name']; ?>";
var g_num_rows = <?php echo $num_options ?>;

/*------------------------------------------------------------------------------------------------*\
  Function: smart_fill
  Purpose:  called by user to automatically fill the field options. Works best for single and 
            multi-dropdowns, since both the value and display text can be accessed and populated 
            consistently through the DOM. For checkboxes and radio buttons, only the values
            are populated.
\*------------------------------------------------------------------------------------------------*/
function smart_fill()
{
  if (page_loaded == 0)
    return;
    
  // locate this element in the page
  var formIframe = hidden_form.window.document;
  var num_forms  = formIframe.forms.length;
  var form_index = null;
  for (i=0; i<num_forms; i++)
  {
    if (formIframe.forms[i][field_name] || formIframe.forms[i][field_name + "[]"])
      form_index = i;
  }

  if (form_index == null)
  {
    smart_fill_err();
    return;
  }

  // should have warning here to tell them all old values will be lost.
  empty_rows();

  // get our field (checks for myField[] syntax, too)
  if (formIframe.forms[form_index][field_name])
    var field = formIframe.forms[form_index][field_name];
  else
    var field = formIframe.forms[form_index][field_name + "[]"];

  // if field.type is undefined, it's probably an array
  if (field.type == undefined)
    field.type = field[0].type;
  
  // if field.type is still undefined, Smart Fill won't work. Alert the user
  if (field.type == undefined)
    smart_fill_err();


  switch (field.type)
  {
    case "select-one":
    case "select-multiple":
      addRows(field.length.toString());
      
      for (i=0; i<field.length; i++)
      {
        document.field_options["value_" + (i+1)].value = field[i].value;
        document.field_options["text_" + (i+1)].value = field[i].text;
      }
      break;

    case "checkbox":
    case "radio":
      is_single = true;
      if (field.length != undefined)
        is_single = false;

      // Single Checkbox
      if (is_single)
      {
        addRows("1");
        document.field_options["value_1"].value = field.value;
      }

      // multiple checkboxes      
      else
      {           
        rows = field.length.toString();
        addRows(rows);
        for (i=0; i<field.length; i++)
          document.field_options["value_" + (i+1)].value = field[i].value;
      }

      break;

    default:
      alert("<?php echo $LANG["phrase_unknown_field_type_c"]; ?> " + field.type);
      break;
  }
}


/*------------------------------------------------------------------------------------------------*\
  Function: addRows
  Purpose:  this is used on the manage field options page when editing a form.
\*------------------------------------------------------------------------------------------------*/
function addRows(num_rows)
{
  // check num_rows is an integer
  if (num_rows.match(/\D/) || num_rows == 0 || num_rows == "")
  {
    alert("<?php echo $LANG["validation_num_rows_to_add"]; ?>");
    document.num_options.num_rows.focus();
    return;
  }

  // get the current table
  var tbody = document.getElementById("options_table").getElementsByTagName("tbody")[0];

  for (var i=1; i<=num_rows; i++)
  {
    var currRow = ++g_num_rows;
    var row = document.createElement("tr");

    // [1] first cell: row number
    var td1 = document.createElement("td");
    td1.setAttribute("align", "center");
    td1.appendChild(document.createTextNode(currRow));

    // [2] second <td> cell: "value" field
    var td2 = document.createElement("td");
    var title = document.createElement("input");
    title.setAttribute("type", "text");
    title.setAttribute("name", "value_" + currRow);
    title.setAttribute("style", "width: 150px;");
    td2.appendChild(title);

    // [3] second <td> cell: "display text" field
    var td3 = document.createElement("td");
    var title = document.createElement("input");
    title.setAttribute("type", "text");
    title.setAttribute("name", "text_" + currRow);
    title.setAttribute("style", "width: 150px;");
    td3.appendChild(title);

    // add the table data cells to the row
    row.appendChild(td1);
    row.appendChild(td2);
    row.appendChild(td3);

    // add the row to the table
    tbody.appendChild(row);
  }

  // update the number of columns
  document.field_options.num_options.value = g_num_rows;
}


/*------------------------------------------------------------------------------------------------*\
  Function: empty_rows
  Purpose:  remove all but the heading row from the Options table
\*------------------------------------------------------------------------------------------------*/
function empty_rows()
{
  // get the current table
  var tbody = document.getElementById("options_table").getElementsByTagName("tbody")[0];

  for (i=tbody.childNodes.length-1; i>0; i--)
  {
    tbody.removeChild(tbody.childNodes[i]);
  }
  
  g_num_rows = 0;
}

/*------------------------------------------------------------------------------------------------*\
  Function: copy_values_to_text
  Purpose:  helper function for checkboxes and radio button fields, which copies the option values 
            over to the text as well.
\*------------------------------------------------------------------------------------------------*/
function copy_values_to_text(num_rows)
{
  for (i=0; i<g_num_rows; i++)
  {
    document.field_options["text_" + (i+1)].value = document.field_options["value_" + (i+1)].value;
  }
}


/*------------------------------------------------------------------------------------------------*\
  Function: smart_fill_err
  Purpose:  display a simple error message if unable to Smart Fill
\*------------------------------------------------------------------------------------------------*/
function smart_fill_err()
{
  alert("<?php echo $LANG["notify_smart_fill_failure"];?>"); 
  return;
}

</script>


<!-- TABS -->
<table cellpadding="0" cellspacing="0" border="0" width="650">
<tr>
  <td>
    <?php
    $tab = "display";
    require("_edit_form_tabs.php");
    ?>
  </td>
</tr>
<tr>
  <td colspan="2" class="tab_content">

  <form action="<?php echo $_SERVER['REQUEST_URI']?>" method="post" name="field_options">
	  <input type='hidden' name='form_id' value='<?php echo $form_id?>' />
	  <input type='hidden' name='field_id' value='<?php echo $field_id?>' />
	  <input type='hidden' name='num_options' value='<?php echo $num_options?>' />
	
	  <table cellpadding="0" cellspacing="1" class="list_table" width="100%">
	  <tr height="20">
	    <td width="140">&nbsp;<?php echo $LANG["word_field"]; ?></td>
	    <td>&nbsp;<b><?php echo $field_info['field_title']; ?></b></td>
	  </tr>
	  <tr height="20">
	    <td>&nbsp;<?php echo $LANG["phrase_field_type"]; ?></td>
	    <td>&nbsp;<?php
	    switch($field_info['field_type']) 
	    {
	      case "radio-buttons":   echo $LANG["phrase_radio_buttons"];         break;
	      case "select":          echo $LANG["word_dropdown"];                break;
	      case "multi-select":    echo $LANG["phrase_multi_select_dropdown"]; break;
	      case "checkboxes":      echo $LANG["word_checkboxes"];              break;
	      default:
	        break;
	    }
	    ?>
	    </td>
	  </tr>
	  <?php
	  if ($field_info['field_type'] == "radio-buttons" || $field_info['field_type'] == "checkboxes")
	  {
	    $orientation = (isset($field_info['option_orientation'])) ? $field_info['option_orientation'] : "vertical";    
	  ?>
	    <tr height='20'>
	      <td>&nbsp;<?php
	      switch($field_info['field_type']) 
	      {
	        case "radio-buttons": echo $LANG["phrase_list_radio_buttons"]; break;
	        case "checkboxes":    echo $LANG["phrase_list_checkboxes"];    break;
	        default:
	          break;
	      }
	      ?>
	      </td>
	      <td>
	        <input type="radio" name="option_orientation" value="vertical" id="vertical" <?php if ($orientation == "vertical") echo "checked"; ?> /> 
	          <label for="vertical"><?php echo $LANG["word_vertically"]; ?></label><br />
	        <input type="radio" name="option_orientation" value="horizontal" id="horizontal" <?php if ($orientation == "horizontal") echo "checked"; ?> />
	          <label for="horizontal"><?php echo $LANG["word_horizontally"]; ?></label>
	      </td>
	    </tr>
	  <?php
	  }
	  ?>
	  </table>
	
	  <p class="subtitle"><?php echo $LANG["word_options"]; ?></p>
	  
	  <table cellpadding="0" cellspacing="0">
	  <tr>
	    <td valign="top">
	
	      <table cellpadding="0" cellspacing="1" class="list_table" id="options_table">
	        <tbody><tr>
	            <th width="40"><?php echo $LANG["word_order"]; ?></th>
	            <th width="150"><?php echo $LANG["phrase_option_value"]; ?></th>
	            <th width="150"><?php echo $LANG["phrase_option_text"]; ?></th>
	          </tr><?php
	      $curr_row = 1;
	      if ($num_options > 0)
	      {   
	        while ($option = mysql_fetch_assoc($field_options))
	        {
	          echo "<tr>
	                  <td align='center'>$curr_row</td> 
	                  <td><input type='text' style='width:150px' name='value_$curr_row' value='{$option['option_value']}' /></td>
	                  <td><input type='text' style='width:150px' name='text_$curr_row' value='{$option['option_name']}' /></td>
	                </tr>";
	          $curr_row++;
	        }
	      }
	      ?></tbody>
	      </table>
	
	    </td>
	    <td width="10"> </td>
	    <td valign="top">
	      <?php
	      $allow_smart_fill = false;
	      if ($form_host == $current_host)
	      {
	        $allow_smart_fill = true;
	        echo "<input type='button' value='{$LANG["phrase_smart_field_uc"]}' onclick='smart_fill()' style='margin:3px;' class='strong_button' /><br />";
	      }
	
	      if ($field_info['field_type'] == "radio-buttons" || $field_info['field_type'] == "checkboxes")
	        echo "<input type='button' value='{$LANG["phrase_values_to_text"]}' onclick='copy_values_to_text()' style='margin:3px;' />";
	      
	      // if we're not offering smart fill, explain why.
	      if (!$allow_smart_fill)
	      {
	      	$current_host_text = ft_replace_placeholders($LANG["text_current_host"], array("host" => "<b>$current_host</b>"));
	      	$form_host_text   = ft_replace_placeholders($LANG["text_form_host"], array("host" => "<b>$form_host</b>"));
	        echo "<p class='grey_text'>
	                {$LANG["notify_no_smart_fill"]} 
	              </p>
	              <p class='grey_text'>  
	                $current_host_text<br />
	                $form_host_text
	              </p>";
	      }
	      
	      ?>
	      
	    </td>
	  </tr>
	  </table>    
	
	  <p>
	    <?php echo $LANG["word_add"]; ?> <input type="text" name="num_rows" value="1" size="2" />
	    <input type="button" value="<?php echo $LANG["word_row_sp"]; ?>" onclick="addRows(document.field_options.num_rows.value)" />
	  </p>
	        
	  <p>
	    <input type="submit" name="update_field_options" value="<?php echo $LANG["word_update_uc"]; ?>" />
	  </p>
	  
  </form>

  <?php if ($num_options == 0) { ?>

  <script type="text/javascript" defer>
  addRows("2");
  </script>

  <?php } ?>
 
  <iframe style="width: 0px; height: 0px" frameborder="0" src="<?php echo $form_info['form_url']; ?>" onload="page_loaded=1;" name="hidden_form" />

  </td>
</tr>
</table>
