<?php
$form_field_info = array();
while ($info = mysql_fetch_assoc($form_template))
  $form_field_info[] = array($info["field_title"], $info["field_type"]);

$num_submissions = ft_get_submission_count($form_id);
?>

<script type="text/javascript">

var num_submissions = "<?php echo $num_submissions; ?>";

/*------------------------------------------------------------------------------------------------*\
  Function: updatePageOptions
  Purpose:  this function updates the editable (visible) content of the page, specifically:
            - toggle entire page visibility
            - hide/show user/admin-specific fields
\*------------------------------------------------------------------------------------------------*/
function updatePageOptions()
{
  f = document.email_form;

  var show_admin_settings = f.auto_email_admin.checked;
  var show_user_settings  = f.auto_email_user.checked;

  // show the page content if either email notifications are checked
  if (show_admin_settings || show_user_settings)
  {
    $("tab_content").style.display = "block";
    $("test_email").style.display = "block";
  }
  else
  {
    $("tab_content").style.display = "none";
    $("test_email").style.display = "none";
  }

  if (show_admin_settings)
    $("admin_settings").style.display = "block";
  else
    $('admin_settings').style.display = "none";

  if (show_user_settings)
    $("user_settings").style.display = "block";
  else
    $("user_settings").style.display = "none";


  // lastly, update the test email template dropdown list to only show the relevant options
  if (num_submissions > 0)
  {
    f2 = document.test_email_form;  
    f2.email_template.options.length = 0;

    if (show_admin_settings)
      add_option(f2.email_template, "<?php echo $LANG["word_client"]; ?>", "admin")
    if (show_user_settings)
      add_option(f2.email_template, "<?php echo $LANG["word_user"]; ?>", "user");
  } 
}

/*------------------------------------------------------------------------------------------------*\
  Function: submitForm
  Purpose:  called on form submit.
\*------------------------------------------------------------------------------------------------*/
function submitForm(f)
{ 
  var show_admin_settings = f.auto_email_admin.checked;
  var show_user_settings  = f.auto_email_user.checked;

  if (show_admin_settings)
  {
    if (f.admin_email_from.value == "custom" && !f.admin_email_from_custom.value)
    {
      alert("<?php echo $LANG["validation_no_custom_client_from_address"] ?>");
      f.admin_email_from_custom.focus();
      return false;
    }
    if (f.admin_email_reply_to.value == "custom" && !f.admin_email_reply_to_custom.value)
    {
      alert("<?php echo $LANG["validation_no_custom_client_reply_to_address"] ?>");
      f.admin_email_reply_to_custom.focus();
      return false;
    }
  }

  if (show_user_settings)
  {
    if (!f.user_email_field.value)
    {
      alert("<?php echo $LANG["validation_no_form_field_user_email"] ?>");
      f.user_email_field.focus();
      return false;
    }
    if (f.user_email_from.value == "custom" && !f.user_email_from_custom.value)
    {
      alert("<?php echo $LANG["validation_no_custom_user_from_address"] ?>");
      f.user_email_from_custom.focus();
      return false;
    }
    if (f.user_email_reply_to.value == "custom" && !f.user_email_reply_to_custom.value)
    {
      alert("<?php echo $LANG["validation_no_custom_user_reply_to_address"] ?>");
      f.user_email_reply_to_custom.focus();
      return false;
    }    
  }

  return true;
}


/*------------------------------------------------------------------------------------------------*\
  Function: show_custom_email_field
  Purpose:  hides/shows custom email fields based on user selection.
\*------------------------------------------------------------------------------------------------*/
function show_custom_email_field(field_id)
{
  if ($(field_id).value == "custom")
    $(field_id + "_custom_section").style.display = "block";
  else
    $(field_id + "_custom_section").style.display = "none";  
}

function updateUserEmailRecipientText()
{
  var empty_text = "Please specify the user email form field";
  var field = document.email_form.user_email_field;
  if (field.value)
  {
    var text_value = field[field.selectedIndex].text;
    var message = "<?php echo $LANG["text_email_field_info"]; ?>";
    $("user_recipient").innerHTML = message.replace(/%%fieldname%%/, "<b>" + text_value + "</b>");
  }
  else
    $("user_recipient").innerHTML = empty_text;
}


function handleIframeReturnValue(val, id)
{
  $(id).innerHTML = val;
}

</script>


<table cellpadding="0" cellspacing="0" border="0" width="650">
<tr>
  <td>
    <?php
    $tab = "emails";
    require("_edit_form_tabs.php");
    ?>
  </td>
</tr>
<tr>
  <td colspan="2" class="tab_content">

  <div class="subtitle underline"><?php echo $LANG["phrase_email_settings_uc"]; ?></div>
  <br />

  <form action="<?php echo $_SERVER['REQUEST_URI']?>" method="post" name="email_form" onsubmit="return submitForm(this)">
  <input type='hidden' name='form_id' value='<?php echo $form_id?>' />
  <input type='hidden' name='email_format' value='text' />

  <input type="checkbox" name="auto_email_admin" id="auto_email_admin" 
    <?php if ($form_info['auto_email_admin'] == "yes") echo "checked"; ?> onclick="updatePageOptions()" /> 
    <label for="auto_email_admin"><?php echo $LANG["text_email_settings_clients"]; ?></label><br />
  <input type="checkbox" name="auto_email_user" id="auto_email_user" 
    <?php if ($form_info['auto_email_user'] == "yes") echo "checked"; ?> onclick="updatePageOptions()" />
    <label for="auto_email_user"><?php echo $LANG["text_email_settings_users"]; ?></label>
  <br />
  <br />

  <div id="tab_content">
    
    <div>
      <?php
      $replacement_info = array("programsettingslink" => "$g_root_url/admin/settings/settings.php");
      echo ft_replace_placeholders($LANG["text_see_advanced_controls"], $replacement_info);
      ?>
    </div>
    <br />

    <table width="100%" cellpadding="0" cellspacing="1" class="list_table">
    <tr>
      <td width="160">&nbsp;<?php echo $LANG["phrase_user_email_address_field"] ?></td>
      <td>

        <select name="user_email_field" onchange="updateUserEmailRecipientText()">
          <option value=""><?php echo $LANG["phrase_please_select"]; ?></option>
          <?php
          while (list($key, $value) = each($column_info))
          {
            if ($key == "submission_id" || $key == "submission_date" || 
                $key == "is_finalized" || $key == "ip_address")
              continue;

            echo "<option value='$key'";
            if ($form_info['user_email_field'] == $key)
              echo " selected";
            echo ">$value</option>\n";
          }
          reset($column_info);
          ?>
        </select>

      </td>
    </tr>
    <tr>
      <td width="150">&nbsp;<?php echo $LANG["phrase_user_name_field"]; ?></td>
      <td>

        <select name="user_first_name_field">
          <option value=""><?php echo $LANG["word_na"]; ?></option>
          <?php
          while (list($key, $value) = each($column_info))
          {
            if ($key == "submission_id" || $key == "submission_date" || 
                $key == "is_finalized" || $key == "ip_address")
              continue;

            echo "<option value='$key'";
            if ($form_info['user_first_name_field'] == $key)
              echo " selected";
            echo ">$value</option>\n";
          }
          reset($column_info);
          ?>
        </select>

      </td>
    </tr>
    <tr>
      <td width="150">&nbsp;<?php echo $LANG["phrase_user_last_name_field"]; ?></td>
      <td>

        <select name="user_last_name_field">
          <option value=""><?php echo $LANG["word_na"]; ?></option>
          <?php
          while (list($key, $value) = each($column_info))
          {
            if ($key == "submission_id" || $key == "submission_date" || 
                $key == "is_finalized" || $key == "ip_address")
              continue;

            echo "<option value='$key'";
            if ($form_info['user_last_name_field'] == $key)
              echo " selected";
            echo ">$value</option>\n";
          }
          ?>
        </select>

      </td>
    </tr>
    </table>

    <br />

    <table cellpadding="0" cellspacing="1" class="list_table" width="100%">
    <tr>
      <td>

        <div id="admin_settings">

          <table width="100%" cellpadding="0" cellspacing="1" width="100%">
          <tr>
            <td width="100" rowspan="3" class="highlighted_text2" style="border-bottom: 1px solid #ffffff; border-right: 1px solid #ffffff;">&nbsp;<?php echo $LANG["phrase_client_emails"]; ?></td>
            <td width="100" style="border-bottom: 1px solid #ffffff; border-right: 1px solid #ffffff;">&nbsp;<?php echo $LANG["word_recipient_sp"]; ?></td>
            <td style="border-bottom: 1px solid #ffffff;" height="20">

              <table cellpadding="0" cellspacing="0" width="100%">
              <tr>
                <td><span id="client_recipient"><?php echo $LANG["phrase_clients_email_address"]; ?></span>&nbsp;&nbsp;</td>
                <td><input type="checkbox" name="include_admin_email" id="include_admin_email" value="yes" <?php if ($form_info['include_admin_email'] == "yes") echo "checked"; ?>/></td>
                <td><label for="include_admin_email"><?php echo $LANG["phrase_include_email_to_admin"]; ?></label></td>
              </tr>
              </table>
              
            </td>
          </tr>
          <tr height="20">
            <td style="border-bottom: 1px solid #ffffff; border-right: 1px solid #ffffff;">&nbsp;<?php echo $LANG["word_from"]; ?></td>
            <td style="border-bottom: 1px solid #ffffff;">
              
              <table cellpadding="0" cellspacing="0">
              <tr>
                <td>
                  <select name="admin_email_from" id="admin_email_from" onchange="show_custom_email_field(this.id)">
                    <option value="admin_email" <?php if ($form_info['admin_email_from'] == "admin_email") echo "selected"; ?>><?php echo $settings['program_name']; ?> &lt;<?php echo trim($settings['administrator_email']); ?>&gt;</option>
                    <option value="users_name" <?php if ($form_info['admin_email_from'] == "users_name") echo "selected"; ?>><?php echo $LANG["phrase_user_email_address_format"]; ?></option>
                    <option value="custom" <?php if ($form_info['admin_email_from'] == "custom") echo "selected"; ?>><?php echo $LANG["word_custom"]; ?></option>
                  </select>
                </td>
                <td>
                  <span id="admin_email_from_custom_section" <?php if ($form_info['admin_email_from'] == "custom") echo "style='display: block;'" ?>>
                    <input type="text" name="admin_email_from_custom" style="width: 190px;" value="<?php echo $form_info['admin_email_from_custom']; ?>"/>
                  </span>
                </td>
              </tr>
              </table>
              
            </td>
          </tr>
          <tr height="20">
            <td style="border-bottom: 1px solid #ffffff; border-right: 1px solid #ffffff;">&nbsp;<?php echo $LANG["word_reply_to"]; ?></td>
            <td style="border-bottom: 1px solid #ffffff;">

              <table cellpadding="0" cellspacing="0">
              <tr>
                <td>
                  <select name="admin_email_reply_to" id="admin_email_reply_to" onchange="show_custom_email_field(this.id)">
                    <option value="none" <?php if ($form_info['admin_email_reply_to'] == "none") echo "selected"; ?>><?php echo $LANG["word_none_dash_uc"]; ?></option>
                    <option value="admin_email" <?php if ($form_info['admin_email_reply_to'] == "admin_email") echo "selected"; ?>><?php echo $settings['program_name']; ?> &lt;<?php echo trim($settings['administrator_email']); ?>&gt;</option>
                    <option value="users_name" <?php if ($form_info['admin_email_reply_to'] == "users_name") echo "selected"; ?>><?php echo $LANG["phrase_user_email_address_format"]; ?></option>
                    <option value="custom" <?php if ($form_info['admin_email_reply_to'] == "custom") echo "selected"; ?>><?php echo $LANG["word_custom"]; ?></option>
                  </select>
                </td>
                <td>
                  <span id="admin_email_reply_to_custom_section" <?php if ($form_info['admin_email_reply_to'] == "custom") echo "style='display: block;'" ?>>
                    <input type="text" name="admin_email_reply_to_custom" style="width: 190px;" value="<?php echo $form_info['admin_email_reply_to_custom']; ?>"/>
                  </span>
                </td>
              </tr>
              </table>
              
            </td>
          </tr>
          </table>

        </div>
        
        <div id="user_settings">

          <table cellpadding="0" cellspacing="1" width="100%">
          <tr>
            <td width="100" rowspan="3" class="highlighted_text2" style="border-right: 1px solid #ffffff;">&nbsp;<?php echo $LANG["phrase_user_emails"]; ?></td>
            <td width="100" style="border-bottom: 1px solid #ffffff; border-right: 1px solid #ffffff;">&nbsp;<?php echo $LANG["word_recipient"]; ?></td>
            <td height="20" style="border-bottom: 1px solid #ffffff;">
              <div id="user_recipient">&nbsp;<?php echo $LANG["validation_no_user_email_form_field"]; ?></div>
            </td>
          </tr>
          <tr>
            <td style="border-bottom: 1px solid #ffffff; border-right: 1px solid #ffffff;">&nbsp;<?php echo $LANG["word_from"]; ?></td>
            <td style="border-bottom: 1px solid #ffffff;">

              <table cellpadding="0" cellspacing="0">
              <tr>
                <td>
                  <select name="user_email_from" id="user_email_from" onchange="show_custom_email_field(this.id)">
                    <option value="admin_email" <?php if ($form_info['user_email_from'] == "admin_email") echo "selected"; ?>><?php echo $settings['program_name']; ?> &lt;<?php echo trim($settings['administrator_email']); ?>&gt;</option>
                    <option value="users_name" <?php if ($form_info['user_email_from'] == "users_name") echo "selected"; ?>><?php echo $LANG["phrase_user_email_address_format"]; ?></option>
                    <option value="custom" <?php if ($form_info['user_email_from'] == "custom") echo "selected"; ?>><?php echo $LANG["word_custom"]; ?></option>
                  </select>
                </td>
                <td>
                  <span id="user_email_from_custom_section" <?php if ($form_info['user_email_from'] == "custom") echo "style='display: block;'" ?>>
                    <input type="text" name="user_email_from_custom" style="width: 190px;" value="<?php echo $form_info['user_email_from_custom']; ?>"/>
                  </span>
                </td>
              </tr>
              </table>

            </td>
          </tr>
          <tr height="20">
            <td>&nbsp;<?php echo $LANG["word_reply_to"]; ?></td>
            <td>

              <table cellpadding="0" cellspacing="0">
              <tr>
                <td>
                  <select name="user_email_reply_to" id="user_email_reply_to" onchange="show_custom_email_field(this.id)">
                    <option value="none" <?php if ($form_info['user_email_reply_to'] == "none") echo "selected"; ?>><?php echo $LANG["word_none_dash_uc"]; ?></option>
                    <option value="admin_email" <?php if ($form_info['user_email_reply_to'] == "admin_email") echo "selected"; ?>><?php echo $settings['program_name']; ?> &lt;<?php echo trim($settings['administrator_email']); ?>&gt;</option>
                    <option value="users_name" <?php if ($form_info['user_email_reply_to'] == "users_name") echo "selected"; ?>><?php echo $LANG["phrase_user_email_address_format"]; ?></option>
                    <option value="custom" <?php if ($form_info['user_email_reply_to'] == "custom") echo "selected"; ?>><?php echo $LANG["word_custom"]; ?></option>
                  </select>
                </td>
                <td>
                  <span id="user_email_reply_to_custom_section" <?php if ($form_info['user_email_reply_to'] == "custom") echo "style='display: block;'" ?>>
                    <input type="text" name="user_email_reply_to_custom" style="width: 190px;" value="<?php echo $form_info['user_email_reply_to_custom']; ?>" />
                  </span>
                </td>
              </tr>
              </table>

            </td>
          </tr> 
          </table>

        </div>
    
      </td>
    </tr>
    </table>
    
    <br />

  </div>

  <div>
    <input type="submit" name="update_emails_basic" value="<?php echo $LANG["word_update_uc"]; ?>" />
  </div>

  </form>

  
  <div id="test_email">

    <form method="POST" action="<?php echo $g_root_url?>/global/code/actions.php" name="test_email_form" target="hidden_iframe">
    <input type="hidden" name="action" value="test_email" />
    <input type="hidden" name="form_id" value="<?php echo $form_id?>" />
    <input type="hidden" name="returnid" value="test_email_message" />
    
    <br />
    <br />
    <div style="border-bottom: 1px solid #cccccc;" class="subtitle"><?php echo $LANG["phrase_test_email_uc"]; ?></div>

    <?php
    if ($num_submissions == 0)
      echo "<p>{$LANG["text_test_email_templates_no_submissions"]}</p>";
    else
    {
    ?>

    <p>
      <?php echo $LANG["text_email_tab_click_update_reminder"];?> 
    </p>

    <table cellpadding="0" cellspacing="1" class="list_table" width="100%">
    <tr>
      <td width="150">&nbsp;<?php echo $LANG["word_email"]; ?></td>
      <td>
        <select name="email_template">
          <option <?php if ($_SESSION["ft"]["email_template"] == "admin") echo "selected"; ?> value="admin"><?php echo $LANG["word_client"]; ?></option>
          <option <?php if ($_SESSION["ft"]["email_template"] == "user") echo "selected"; ?> value="user"><?php echo $LANG["word_user"]; ?></option>
        </select>
      </td>          
    </tr>
    <tr>
      <td>&nbsp;<?php echo $LANG["phrase_your_email_address"]; ?></td>
      <td>
        <input type="text" name="test_email_recipient" size="40" value="<?php echo $_SESSION['ft']['test_email_recipient']?>" />
      </td>
    </tr>
    <tr>
      <td>&nbsp;<?php echo $LANG["word_data"]; ?></td>
      <td>
        <input type="radio" name="test_email_data_source" id="test_email_data_random_submission"
          value="random_submission" <?php if ($_SESSION["ft"]["test_email_data_source"] == "random_submission") echo "checked"; ?>/>
          <label for="test_email_data_random_submission"><?php echo $LANG["phrase_random_form_submission"]; ?></span></label><br />
        <input type="radio" name="test_email_data_source" id="test_email_data_submission_id"
          value="submission_id" <?php if ($_SESSION["ft"]["test_email_data_source"] == "submission_id") echo "checked"; ?>/>
          <label for="test_email_data_submission_id"><?php echo $LANG["phrase_submission_id"]; ?></label>
          <input type="input" name="test_email_submission_id" size="2" value="<?php echo $_SESSION['ft']['test_email_submission_id']?>" />
      </td>
    </tr>
    </table>
    <br />

    <table cellpadding="0" cellspacing="0" width='100%'>
    <tr>
      <td width="120" valign="top"><input type="submit" name="send_test_email" value="<?php echo $LANG["phrase_send_test_email_uc"]; ?>" /></td>
      <td width="10">&nbsp;</td>
      <td>
        <div id="test_email_message"></div>
      </td>
    </tr>
    </table>

    <?php
    }
    ?>

    </form>

  </div>

  <iframe src="about:blank" name="hidden_iframe" id="hidden_iframe" width="10" height="10" frameborder="0"></iframe>

  </td>
</tr>
</table>


<!-- update the page options -->
<script type="text/javascript">
updatePageOptions();
updateUserEmailRecipientText();
</script>
