<?php
$form_field_info = array();
while ($info = mysql_fetch_assoc($form_template))
  $form_field_info[] = array($info["field_title"], $info["field_type"]);

$num_submissions = ft_get_submission_count($form_id);

if (!isset($_SESSION["ft"]["email_template"])) $_SESSION["ft"]["email_template"] = "";
if (!isset($_SESSION["ft"]["test_email_data_source"])) $_SESSION["ft"]["test_email_data_source"] = "";
if (!isset($_SESSION['ft']['test_email_recipient'])) $_SESSION['ft']['test_email_recipient'] = "";
if (!isset($_SESSION['ft']['test_email_submission_id'])) $_SESSION['ft']['test_email_submission_id'] = "";

?>

<script type="text/javascript">

var curr_tab = 1;
var num_submissions = "<?php echo $num_submissions; ?>";

/*------------------------------------------------------------------------------------------------*\
  Function: updatePageOptions
  Purpose:  this function updates the editable (visible) content of the page, specifically:
            - toggle entire page visibility
            - hide/show user/admin-specific fields
            - hide/show email tabs
\*------------------------------------------------------------------------------------------------*/
function updatePageOptions()
{
  f = document.email_form;

  var show_admin_settings = f.auto_email_admin.checked;
  var show_user_settings  = f.auto_email_user.checked;
  var show_HTML_tabs      = (f.email_format[1].checked || f.email_format[2].checked) ? true : false;
  var show_text_tabs      = (f.email_format[0].checked || f.email_format[2].checked) ? true : false;


  // show the page content if the user wants to either show 
  if (show_admin_settings || show_user_settings)
  {
    $("tab_content").style.display = "block";
    $("test_email").style.display = "block";
  }
  else
  {
    $("tab_content").style.display = "none";
    $("test_email").style.display = "none";
  }
  
  // show the appropriate tabs 
  if (show_admin_settings)
  {
    var text_display_val = (show_text_tabs) ? "block" : "none";
    $("tab1").style.display = text_display_val;

    var HTML_display_val = (show_HTML_tabs) ? "block" : "none";
    $("tab2").style.display = HTML_display_val;
    
    $("admin_settings").style.display = "block";

    // ensure that a tab is always visible
    if (curr_tab == 1 && !show_text_tabs)
      select_tab(2);
    if (curr_tab == 2 && !show_HTML_tabs)
      select_tab(1);
  }
  else
  {
    $("tab1").style.display = "none";
    $("tab2").style.display = "none";
    $('admin_settings').style.display = "none";
    
    if (curr_tab == 1 || curr_tab == 2)
    {
      if (show_HTML_tabs)
        select_tab(3);
      else
        select_tab(4);
    }
  }

  if (show_user_settings)
  {
    var text_display_val = (show_text_tabs) ? "block" : "none";
    $("tab3").style.display = text_display_val; 

    var HTML_display_val = (show_HTML_tabs) ? "block" : "none";
    $("tab4").style.display = HTML_display_val;

    $("user_settings").style.display = "block";
  }
  else
  {
    $("tab3").style.display = "none";
    $("tab4").style.display = "none";
    $("user_settings").style.display = "none";

    if (curr_tab == 3 || curr_tab == 4)
    {
      if (show_HTML_tabs)
        select_tab(1);
      else
        select_tab(2);
    }
  }

  // lastly, update the test email template dropdown list to only show the relevant options
  if (num_submissions > 0)
  {
    f2 = document.test_email_form;  
    f2.email_template.options.length = 0;
  
    if (show_admin_settings && show_HTML_tabs && show_text_tabs)
      add_option(f2.email_template, "<?php echo $LANG["phrase_client_email_both_formats"]; ?>", "admin")
    if (show_admin_settings && show_text_tabs)
      add_option(f2.email_template, "<?php echo $LANG["phrase_client_text"]; ?>", "admin_text");
    if (show_admin_settings && show_HTML_tabs)
      add_option(f2.email_template, "<?php echo $LANG["phrase_client_html"]; ?>", "admin_HTML");
    if (show_user_settings && show_HTML_tabs && show_text_tabs)
      add_option(f2.email_template, "<?php echo $LANG["phrase_user_email_both_formats"]; ?>", "user");
    if (show_user_settings && show_text_tabs)
      add_option(f2.email_template, "<?php echo $LANG["phrase_user_text"]; ?>", "user_text");
    if (show_user_settings && show_HTML_tabs)
      add_option(f2.email_template, "<?php echo $LANG["phrase_user_html"]; ?>", "user_HTML");
  }
}


/*------------------------------------------------------------------------------------------------*\
  Function: show_custom_email_field
  Purpose:  hides/shows custom email fields based on user selection.
\*------------------------------------------------------------------------------------------------*/
function show_custom_email_field(field_id)
{
  if ($(field_id).value == "custom")
    $(field_id + "_custom_section").style.display = "block";
  else
    $(field_id + "_custom_section").style.display = "none";  
}


/*------------------------------------------------------------------------------------------------*\
  Function: select_tab
  Purpose:  selects a new tab, hiding the others. Stores the current tab in sessions by passing 
            value to actions.php.
\*------------------------------------------------------------------------------------------------*/
function select_tab(tab)
{
  for (i=1; i<=5; i++)
  {
    if (tab == i)
    {
      $("tab" + i + "_selected").style.display = "block";
      $("tab" + i + "_not_selected").style.display = "none";
      $("tab" + i + "_content").style.display = "block";
    }
    else
    {
      $("tab" + i + "_selected").style.display = "none";
      $("tab" + i + "_not_selected").style.display = "block";    
      $("tab" + i + "_content").style.display = "none";
    }
  }
  
  curr_tab = tab;
  
  // store the current tab in memory
  $("hidden_iframe").src="../../global/code/actions.php?action=remember_email_tab&tab=" + tab + "&form_id=<?php echo $form_id?>";
}

// loads the appropriate tab content with the selected template
function selectTemplate(tab, val)
{
  $(tab + "_template").value = $(tab + "_" + val).value;
}


/*------------------------------------------------------------------------------------------------*\
  Function: submitForm
  Purpose:  called on form submit. It validates the user input, then if all checks out, copies the 
            content of the four template fields to the hidden fields to ensure they're passed to the 
            server in all browsers.
\*------------------------------------------------------------------------------------------------*/
function submitForm(f)
{ 
  var show_admin_settings = f.auto_email_admin.checked;
  var show_user_settings  = f.auto_email_user.checked;
  var show_HTML_tabs      = (f.email_format[1].checked || f.email_format[2].checked) ? true : false;
  var show_text_tabs      = (f.email_format[0].checked || f.email_format[2].checked) ? true : false;

  if (show_admin_settings)
  {
    if (f.admin_email_from.value == "custom" && !f.admin_email_from_custom.value)
    {
      alert("<?php echo $LANG["validation_no_custom_client_from_address"]; ?>");
      f.admin_email_from_custom.focus();
      return false;
    }
    if (f.admin_email_reply_to.value == "custom" && !f.admin_email_reply_to_custom.value)
    {
      alert("<?php echo $LANG["validation_no_custom_client_reply_to_address"]; ?>");
      f.admin_email_reply_to_custom.focus();
      return false;
    }    
    if (show_text_tabs && !f.tab1_template.value)
    {
      select_tab(1);
      alert("<?php echo $LANG["validation_no_client_text_email_template"]; ?>");
      f.tab1_template.focus();
      return false;
    }
    if (show_HTML_tabs && !f.tab2_template.value)
    {
      select_tab(2);
      alert("<?php echo $LANG["validation_no_client_html_email_template"]; ?>");
      f.tab2_template.focus();
      return false;
    }
  }

  if (show_user_settings)
  {
    if (!f.user_email_field.value)
    {
      alert("<?php echo $LANG["validation_no_form_field_user_email"]; ?>");
      f.user_email_field.focus();
      return false;
    }
    if (f.user_email_from.value == "custom" && !f.user_email_from_custom.value)
    {
      alert("<?php echo $LANG["validation_no_custom_user_from_address"]; ?>");
      f.user_email_from_custom.focus();
      return false;
    }
    if (f.user_email_reply_to.value == "custom" && !f.user_email_reply_to_custom.value)
    {
      alert("<?php echo $LANG["validation_no_custom_user_reply_to_address"]; ?>");
      f.user_email_reply_to_custom.focus();
      return false;
    }    

    if (show_text_tabs && !f.tab3_template.value)
    {
      select_tab(3);
      alert("<?php echo $LANG["validation_no_user_text_email_template"]; ?>");
      f.tab3_template.focus();
      return false;
    }
    if (show_HTML_tabs && !f.tab4_template.value)
    {
      select_tab(4);
      alert("<?php echo $LANG["validation_no_user_html_email_template"]; ?>");
      f.tab4_template.focus();
      return false;
    }
  }

  f.admin_text_email_template.value = f.tab1_template.value;
  f.admin_html_email_template.value = f.tab2_template.value;
  f.user_text_email_template.value  = f.tab3_template.value;
  f.user_html_email_template.value  = f.tab4_template.value;

  return true;
}

function updateUserEmailRecipientText()
{
  var empty_text = "<?php echo $LANG["validation_no_user_email_form_field"]; ?>";
  var field = document.email_form.user_email_field;
  if (field.value)
  {
    var text_value = field[field.selectedIndex].text;
    var message = "<?php echo $LANG["text_email_field_info"]; ?>";
    $("user_recipient").innerHTML = message.replace(/%%fieldname%%/, "<b>" + text_value + "</b>");
  }
  else
    $("user_recipient").innerHTML = empty_text;
}


function handleIframeReturnValue(val, id)
{
  $(id).innerHTML = val;
}

</script>


<!-- TABS -->
<table cellpadding="0" cellspacing="0" border="0" width="650">
<tr>
  <td>
    <?php
    $tab = "emails";
    require("_edit_form_tabs.php");
    ?>
  </td>
</tr>
<tr>
  <td colspan="2" class="tab_content">

  <div class="subtitle underline"><?php echo $LANG["phrase_email_settings_uc"]; ?></div>
  <br />

  <form action="<?php echo $_SERVER['REQUEST_URI']?>" method="post" name="email_form" onsubmit="return submitForm(this)">
  <input type='hidden' name='form_id' value='<?php echo $form_id?>' />
  
  <input type="hidden" name="admin_text_email_template" value="" />
  <input type="hidden" name="admin_html_email_template" value="" />
  <input type="hidden" name="user_text_email_template" value="" />
  <input type="hidden" name="user_html_email_template" value="" />
  
  
  <input type="checkbox" name="auto_email_admin" id="auto_email_admin" 
    <?php if ($form_info['auto_email_admin'] == "yes") echo "checked"; ?> onclick="updatePageOptions()" /> 
    <label for="auto_email_admin"><?php echo $LANG["text_email_settings_clients"]; ?></label><br />
  <input type="checkbox" name="auto_email_user" id="auto_email_user" 
    <?php if ($form_info['auto_email_user'] == "yes") echo "checked"; ?> onclick="updatePageOptions()" />
    <label for="auto_email_user"><?php echo $LANG["text_email_settings_users"]; ?></label>
  <br />
  <br />

  <div id="tab_content">

    <table width="100%" cellpadding="0" cellspacing="1" class="list_table">
    <tr>
      <td width="170">&nbsp;<?php echo $LANG["phrase_email_format_sp"]; ?></td>
      <td>

        <input type="radio" name="email_format" id="email_format1" value="text" 
          <?php if ($form_info['email_format'] == "text" || $form_info['email_format'] == "none") echo "checked"; ?> onclick="updatePageOptions()" /> 
          <label for="email_format1"><?php echo $LANG["word_text"]; ?></label>
        <input type="radio" name="email_format" id="email_format2" value="html" 
          <?php if ($form_info['email_format'] == "html") echo "checked"; ?> onclick="updatePageOptions()" />
          <label for="email_format2"><?php echo $LANG["word_html_uc"]; ?></label>
        <input type="radio" name="email_format" id="email_format3" value="both" 
          <?php if ($form_info['email_format'] == "both") echo "checked"; ?> onclick="updatePageOptions()" />
          <label for="email_format3"><?php echo $LANG["phrase_text_and_html"]; ?></label>

      </td>
    </tr>
    <tr>
      <td>&nbsp;<?php echo $LANG["phrase_user_email_address_field"]; ?></td>
      <td>

        <select name="user_email_field" onchange="updateUserEmailRecipientText()">
          <option value=""><?php echo $LANG["phrase_please_select"]; ?></option>
          <?php
          while (list($key, $value) = each($column_info))
          {
            if ($key == "submission_id" || $key == "submission_date" || 
                $key == "is_finalized" || $key == "ip_address")
              continue;

            echo "<option value='$key'";
            if ($form_info['user_email_field'] == $key)
              echo " selected";
            echo ">$value</option>\n";
          }
          reset($column_info);
          ?>
        </select>

      </td>
    </tr>
    <tr>
      <td>&nbsp;<?php echo $LANG["phrase_user_name_field"]; ?></td>
      <td>

        <select name="user_first_name_field">
          <option value=""><?php echo $LANG["word_na"]; ?></option>
          <?php
          while (list($key, $value) = each($column_info))
          {
            if ($key == "submission_id" || $key == "submission_date" || 
                $key == "is_finalized" || $key == "ip_address")
              continue;

            echo "<option value='$key'";
            if ($form_info['user_first_name_field'] == $key)
              echo " selected";
            echo ">$value</option>\n";
          }
          reset($column_info);
          ?>
        </select>

      </td>
    </tr>
    <tr>
      <td>&nbsp;<?php echo $LANG["phrase_user_last_name_field"]; ?></td>
      <td>

        <select name="user_last_name_field">
          <option value=""><?php echo $LANG["word_na"]; ?></option>
          <?php
          while (list($key, $value) = each($column_info))
          {
            if ($key == "submission_id" || $key == "submission_date" || 
                $key == "is_finalized" || $key == "ip_address")
              continue;

            echo "<option value='$key'";
            if ($form_info['user_last_name_field'] == $key)
              echo " selected";
            echo ">$value</option>\n";
          }
          ?>
        </select>

      </td>
    </tr>
    </table>
  
    <br />

    <table cellpadding="0" cellspacing="1" class="list_table" width="100%">
    <tr>
      <td>

        <div id="admin_settings">

          <table width="100%" cellpadding="0" cellspacing="1" width="100%">
          <tr>
            <td width="100" rowspan="4" class="highlighted_text2" style="border-bottom: 1px solid #ffffff; border-right: 1px solid #ffffff;">&nbsp;<?php echo $LANG["phrase_client_emails"]; ?></td>
            <td width="100" style="border-bottom: 1px solid #ffffff; border-right: 1px solid #ffffff;">&nbsp;<?php echo $LANG["word_subject"]; ?></td>
            <td style="border-bottom: 1px solid #ffffff; border-right: 1px solid #ffffff;"><input type="text" style="width: 100%" name="admin_email_subject" value="<?php echo htmlspecialchars($form_info['admin_email_subject']); ?>" maxlength="200" /></td>
          </tr>
          <tr>
            <td style="border-bottom: 1px solid #ffffff; border-right: 1px solid #ffffff;">&nbsp;<?php echo $LANG["word_recipient_sp"]; ?></td>
            <td style="border-bottom: 1px solid #ffffff;" height="20">

              <table cellpadding="0" cellspacing="0" width="100%">
              <tr>
                <td><span id="client_recipient"><?php echo $LANG["phrase_clients_email_address"]; ?></span>&nbsp;&nbsp;</td>
                <td><input type="checkbox" name="include_admin_email" id="include_admin_email" value="yes" <?php if ($form_info['include_admin_email'] == "yes") echo "checked"; ?>/></td>
                <td><label for="include_admin_email"><?php echo $LANG["phrase_include_email_to_admin"]; ?></label></td>
              </tr>
              </table>
              
            </td>
          </tr>
          <tr height="20">
            <td style="border-bottom: 1px solid #ffffff; border-right: 1px solid #ffffff;">&nbsp;<?php echo $LANG["word_from"]; ?></td>
            <td style="border-bottom: 1px solid #ffffff;">

              <table cellpadding="0" cellspacing="0">
              <tr>
                <td>
                  <select name="admin_email_from" id="admin_email_from" onchange="show_custom_email_field(this.id)">
                    <option value="admin_email" <?php if ($form_info['admin_email_from'] == "admin_email") echo "selected"; ?>><?php echo $settings['program_name']; ?> &lt;<?php echo trim($settings['administrator_email']); ?>&gt;</option>
                    <option value="users_name" <?php if ($form_info['admin_email_from'] == "users_name") echo "selected"; ?>><?php echo $LANG["phrase_user_email_address_format"]; ?></option>
                    <option value="custom" <?php if ($form_info['admin_email_from'] == "custom") echo "selected"; ?>><?php echo $LANG["word_custom"]; ?></option>
                  </select>
                </td>
                <td>
                  <span id="admin_email_from_custom_section" <?php if ($form_info['admin_email_from'] == "custom") echo "style='display: block;'" ?>>
                    <input type="text" name="admin_email_from_custom" style="width: 190px;" value="<?php echo $form_info['admin_email_from_custom']; ?>"/>
                  </span>
                </td>
              </tr>
              </table>
              
            </td>
          </tr>
          <tr height="20">
            <td style="border-bottom: 1px solid #ffffff; border-right: 1px solid #ffffff;">&nbsp;<?php echo $LANG["word_reply_to"]; ?></td>
            <td style="border-bottom: 1px solid #ffffff;">

              <table cellpadding="0" cellspacing="0">
              <tr>
                <td>
                  <select name="admin_email_reply_to" id="admin_email_reply_to" onchange="show_custom_email_field(this.id)">
                    <option value="none" <?php if ($form_info['admin_email_reply_to'] == "none") echo "selected"; ?>><?php echo $LANG["word_none_dash_uc"]; ?></option>
                    <option value="admin_email" <?php if ($form_info['admin_email_reply_to'] == "admin_email") echo "selected"; ?>><?php echo $settings['program_name']; ?> &lt;<?php echo trim($settings['administrator_email']); ?>&gt;</option>
                    <option value="users_name" <?php if ($form_info['admin_email_reply_to'] == "users_name") echo "selected"; ?>><?php echo $LANG["phrase_user_email_address_format"]; ?></option>
                    <option value="custom" <?php if ($form_info['admin_email_reply_to'] == "custom") echo "selected"; ?>><?php echo $LANG["word_custom"]; ?></option>
                  </select>
                </td>
                <td>
                  <span id="admin_email_reply_to_custom_section" <?php if ($form_info['admin_email_reply_to'] == "custom") echo "style='display: block;'" ?>>
                    <input type="text" name="admin_email_reply_to_custom" style="width: 190px;" value="<?php echo $form_info['admin_email_reply_to_custom']; ?>"/>
                  </span>
                </td>
              </tr>
              </table>

            </td>
          </tr>
          </table>

        </div>
        
        <div id="user_settings">

          <table cellpadding="0" cellspacing="1" width="100%">
          <tr>
            <td width="100" rowspan="4" class="highlighted_text2" style="border-bottom: 1px solid #ffffff; border-right: 1px solid #ffffff;">&nbsp;<?php echo $LANG["phrase_user_emails"]; ?></td>
            <td width="100" style="border-bottom: 1px solid #ffffff; border-right: 1px solid #ffffff;">&nbsp;<?php echo $LANG["word_subject"]; ?></td>
            <td style="border-bottom: 1px solid #ffffff; border-right: 1px solid #ffffff;"><input type="text" style="width: 100%" name="user_email_subject" value="<?php echo htmlspecialchars($form_info['user_email_subject']); ?>" maxlength="200" /></td>
          </tr>
          <tr>
            <td width="100" style="border-bottom: 1px solid #ffffff; border-right: 1px solid #ffffff;">&nbsp;<?php echo $LANG["word_recipient"]; ?></td>
            <td height="20" style="border-bottom: 1px solid #ffffff;">
              <div id="user_recipient">&nbsp;<?php echo $LANG["validation_no_user_email_form_field"]; ?></div>
            </td>
          </tr>
          <tr>
            <td style="border-bottom: 1px solid #ffffff; border-right: 1px solid #ffffff;">&nbsp;<?php echo $LANG["word_from"]; ?></td>
            <td style="border-bottom: 1px solid #ffffff;">

              <table cellpadding="0" cellspacing="0">
              <tr>
                <td>
                  <select name="user_email_from" id="user_email_from" onchange="show_custom_email_field(this.id)">
                    <option value="admin_email" <?php if ($form_info['user_email_from'] == "admin_email") echo "selected"; ?>><?php echo $settings['program_name']; ?> &lt;<?php echo trim($settings['administrator_email']); ?>&gt;</option>
                    <option value="users_name" <?php if ($form_info['user_email_from'] == "users_name") echo "selected"; ?>><?php echo $LANG["phrase_user_email_address_format"]; ?></option>
                    <option value="custom" <?php if ($form_info['user_email_from'] == "custom") echo "selected"; ?>><?php echo $LANG["word_custom"]; ?></option>
                  </select>
                </td>
                <td>
                  <span id="user_email_from_custom_section" <?php if ($form_info['user_email_from'] == "custom") echo "style='display: block;'" ?>>
                    <input type="text" name="user_email_from_custom" style="width: 190px;" value="<?php echo $form_info['user_email_from_custom']; ?>"/>
                  </span>
                </td>
              </tr>
              </table>

            </td>
          </tr>
          <tr height="20">
            <td>&nbsp;<?php echo $LANG["word_reply_to"]; ?></td>
            <td>

              <table cellpadding="0" cellspacing="0">
              <tr>
                <td>
                  <select name="user_email_reply_to" id="user_email_reply_to" onchange="show_custom_email_field(this.id)">
                    <option value="none" <?php if ($form_info['user_email_reply_to'] == "none") echo "selected"; ?>><?php echo $LANG["word_none_dash_uc"]; ?></option>
                    <option value="admin_email" <?php if ($form_info['user_email_reply_to'] == "admin_email") echo "selected"; ?>><?php echo $settings['program_name']; ?> &lt;<?php echo trim($settings['administrator_email']); ?>&gt;</option>
                    <option value="users_name" <?php if ($form_info['user_email_reply_to'] == "users_name") echo "selected"; ?>><?php echo $LANG["phrase_user_email_address_format"]; ?></option>
                    <option value="custom" <?php if ($form_info['user_email_reply_to'] == "custom") echo "selected"; ?>><?php echo $LANG["word_custom"]; ?></option>
                  </select>
                </td>
                <td>
                  <span id="user_email_reply_to_custom_section" <?php if ($form_info['user_email_reply_to'] == "custom") echo "style='display: block;'" ?>>
                    <input type="text" name="user_email_reply_to_custom" style="width: 190px;" value="<?php echo $form_info['user_email_reply_to_custom']; ?>" />
                  </span>
                </td>
              </tr>
              </table>

            </td>
          </tr> 
          </table>

        </div>
    
      </td>
    </tr>
    </table>
        
    <br />
    <br />
    
    <table border="0" cellpadding="0" cellspacing="0" width="100%">
    <tr>
      <td>

        <div id="tab1">
          <div id="tab1_selected">
            <table cellpadding="0" cellspacing="0">
            <tr>
              <td width="12" height="21"><img src="../../images/inner_tab1_left_selected.gif" width="12" height="21" alt=""></td>
              <td class="inner_tab1_selected" width="80" nowrap>
                <span class="admin_text bold"><?php echo $LANG["phrase_client_text"]; ?></span>
              </td>
              <td width="12" height="21"><img src="../../images/inner_tab1_right_selected.gif" width="12" height="21" alt=""></td>
              <td width="2" height="21" style="border-bottom: 1px solid #dadada;">&nbsp;</td>
            </tr>
            </table>
          </div>
          <div id="tab1_not_selected">
            <table cellpadding="0" cellspacing="0">
            <tr>
              <td width="12" height="21"><img src="../../images/inner_tab1_left_not_selected.gif" width="12" height="21" alt=""></td>
              <td class="inner_tab1_not_selected" width="80" nowrap>
                <a href="javascript:select_tab(1)" class="admin_text"><?php echo $LANG["phrase_client_text"]; ?></a>
              </td>
              <td width="12" height="21"><img src="../../images/inner_tab1_right_not_selected.gif" width="12" height="21" alt=""></td>
              <td width="2" height="21" style="border-bottom: 1px solid #dadada;">&nbsp;</td>
            </tr>
            </table>
          </div>
        </div>
      
      </td>      
      <td>

        <div id="tab2">
          <div id="tab2_selected">
            <table cellpadding="0" cellspacing="0">
            <tr>
              <td width="12" height="21"><img src="../../images/inner_tab1_left_selected.gif" width="12" height="21" alt=""></td>
              <td class="inner_tab1_selected bold" width="80" nowrap>
                <span class="admin_text"><?php echo $LANG["phrase_client_html"]; ?></span>
              </td>
              <td width="12" height="21"><img src="../../images/inner_tab1_right_selected.gif" width="12" height="21" alt=""></td>
              <td width="2" height="21" style="border-bottom: 1px solid #dadada;">&nbsp;</td>
            </tr>
            </table>
          </div>
  
          <div id="tab2_not_selected">
            <table cellpadding="0" cellspacing="0">
            <tr>
              <td width="12" height="21"><img src="../../images/inner_tab1_left_not_selected.gif" width="12" height="21" alt=""></td>
              <td class="inner_tab1_not_selected" width="80" nowrap>
                <a href="javascript:select_tab(2)" class="admin_text"><?php echo $LANG["phrase_client_html"]; ?></a>
              </td>
              <td width="12" height="21"><img src="../../images/inner_tab1_right_not_selected.gif" width="12" height="21" alt=""></td>
              <td width="2" height="21" style="border-bottom: 1px solid #dadada;">&nbsp;</td>
            </tr>
            </table>
          </div>
        </div>

      </td>
      <td>

        <div id="tab3">
          <div id="tab3_selected">
            <table cellpadding="0" cellspacing="0">
            <tr>
              <td width="12" height="21"><img src="../../images/inner_tab1_left_selected.gif" width="12" height="21" alt=""></td>
              <td class="inner_tab1_selected bold" width="80" nowrap>
                <span class="user_text"><?php echo $LANG["phrase_user_text"]; ?></span>
              </td>
              <td width="12" height="21"><img src="../../images/inner_tab1_right_selected.gif" width="12" height="21" alt=""></td>
              <td width="2" height="21" style="border-bottom: 1px solid #dadada;">&nbsp;</td>              
            </tr>
            </table>
          </div>

          <div id="tab3_not_selected">
            <table cellpadding="0" cellspacing="0">
            <tr>
              <td width="12" height="21"><img src="../../images/inner_tab1_left_not_selected.gif" width="12" height="21" alt=""></td>
              <td class="inner_tab1_not_selected" width="80" nowrap>
                <a href="javascript:select_tab(3)" class="user_text"><?php echo $LANG["phrase_user_text"]; ?></a>
              </td>
              <td width="12" height="21"><img src="../../images/inner_tab1_right_not_selected.gif" width="12" height="21" alt=""></td>
              <td width="2" height="21" style="border-bottom: 1px solid #dadada;">&nbsp;</td>
            </tr>
            </table>
          </div>
        </div>

      </td>
      <td>

        <div id="tab4">
          <div id="tab4_selected">
            <table cellpadding="0" cellspacing="0">
            <tr>
              <td width="12" height="21"><img src="../../images/inner_tab1_left_selected.gif" width="12" height="21" alt=""></td>
              <td class="inner_tab1_selected bold" width="80" nowrap>
                <span class="user_text"><?php echo $LANG["phrase_user_html"]; ?></span>
              </td>
              <td width="12" height="21"><img src="../../images/inner_tab1_right_selected.gif" width="12" height="21" alt=""></td>
            </tr>
            </table>
          </div>
  
          <div id="tab4_not_selected">
            <table cellpadding="0" cellspacing="0">
            <tr>
              <td width="12" height="21"><img src="../../images/inner_tab1_left_not_selected.gif" width="12" height="21" alt=""></td>
              <td class="inner_tab1_not_selected" width="80" nowrap>
                <a href="javascript:select_tab(4)" class="user_text"><?php echo $LANG["phrase_user_html"]; ?></a>
              </td>
              <td width="12" height="21"><img src="../../images/inner_tab1_right_not_selected.gif" width="12" height="21" alt=""></td>
            </tr>
            </table>
          </div>
        </div>

      </td>
      <td width="80%" style="border-bottom: 1px solid #dadada;">&nbsp;</td>
      <td>

        <div id="tab5">       
          <div id="tab5_selected">
            <table cellpadding="0" cellspacing="0">
            <tr>
              <td width="12" height="21"><img src="../../images/inner_tab1_left_selected.gif" width="12" height="21" alt=""></td>
              <td class="inner_tab1_selected bold" width="80" nowrap>
                <?php echo $LANG["word_reference"]; ?>
              </td>
              <td width="12" height="21"><img src="../../images/inner_tab1_right_selected.gif" width="12" height="21" alt=""></td>
            </tr>
            </table>
          </div>
  
          <div id="tab5_not_selected">
            <table cellpadding="0" cellspacing="0">
            <tr>
              <td width="12" height="21"><img src="../../images/inner_tab2_left.gif" width="12" height="21" alt=""></td>
              <td class="inner_tab2" width="80" nowrap>
                <a href="javascript:select_tab(5)" class="references_tab"><?php echo $LANG["word_reference"]; ?></a>              
              </td>
              <td width="12" height="21"><img src="../../images/inner_tab2_right.gif" width="12" height="21" alt=""></td>
            </tr>
            </table>
          </div>
        </div>

      </td>
    </tr>
    <tr> 
      <td colspan="19" id="inner_tab_content">

        <div id="tab1_content">

          <div><?php echo $LANG["text_client_email_text_tab_info"]; ?></div>
          <br />

          <table cellpadding="0" cellspacing="1" style="padding-bottom: 5px">
          <tr>
            <td width="110"><?php echo $LANG["phrase_example_templates_c"]; ?></td>
            <td> 
              <select onchange="selectTemplate('tab1', this.value)">
                <option value=""><?php echo $LANG["phrase_select_template"]; ?></option>
                <option value="full_submission"><?php echo $LANG["phrase_full_form_submission"]; ?></option>
                <option value="full_submission_no_empty_fields"><?php echo $LANG["phrase_full_form_submission_omit_empty"]; ?></option>
                <option value="notification"><?php echo $LANG["phrase_notification_only"]; ?></option>
              </select>
            </td>
          </tr>
          </table>
          
          <textarea style="width: 100%; height: 200px;" class="template" name="tab1_template" id="tab1_template"><?php echo $form_info['admin_text_email_template']; ?></textarea>
        </div>
        
        <div id="tab2_content">

          <div><?php echo $LANG["text_client_email_html_tab_info"]; ?></div>
          <br />

          <table cellpadding="0" cellspacing="1" style="padding-bottom: 5px">
          <tr>
            <td width="110"><?php echo $LANG["phrase_example_templates_c"]; ?></td>
            <td> 
              <select onchange="selectTemplate('tab2', this.value)">
                <option value=""><?php echo $LANG["phrase_select_template"]; ?></option>
                <option value="full_submission"><?php echo $LANG["phrase_full_form_submission"]; ?></option>
                <option value="full_submission_no_empty_fields"><?php echo $LANG["phrase_full_form_submission_omit_empty"]; ?></option>
                <option value="notification"><?php echo $LANG["phrase_notification_only"]; ?></option>
              </select>
            </td>
          </tr>
          </table>
  
          <textarea style="width: 100%; height: 200px;" class="template" name="tab2_template" id="tab2_template"><?php echo $form_info['admin_html_email_template']; ?></textarea>
        </div>

        <div id="tab3_content">

          <div><?php echo $LANG["text_user_email_text_tab_info"]; ?></div>
          <br />

          <table cellpadding="0" cellspacing="1" style="padding-bottom: 5px">
          <tr>
            <td width="110"><?php echo $LANG["phrase_example_templates_c"]; ?></td>
            <td> 
              <select onchange="selectTemplate('tab3', this.value)">
                <option value=""><?php echo $LANG["phrase_select_template"]; ?></option>
                <option value="full_submission"><?php echo $LANG["phrase_full_form_submission"]; ?></option>
                <option value="full_submission_no_empty_fields"><?php echo $LANG["phrase_full_form_submission_omit_empty"]; ?></option>
                <option value="notification"><?php echo $LANG["phrase_notification_only"]; ?></option>
              </select>
            </td>
          </tr>
          </table>
  
          <textarea style="width: 100%; height: 200px;" class="template" name="tab3_template" id="tab3_template"><?php echo $form_info['user_text_email_template']; ?></textarea>
        </div>

        <div id="tab4_content">

          <div><?php echo $LANG["text_user_email_html_tab_info"]; ?></div>
          <br />

          <table cellpadding="0" cellspacing="1" style="padding-bottom: 5px">
          <tr>
            <td width="110"><?php echo $LANG["phrase_example_templates_c"]; ?></td>
            <td> 
              <select onchange="selectTemplate('tab4', this.value)">
                <option value=""><?php echo $LANG["phrase_select_template"]; ?></option>
                <option value="full_submission"><?php echo $LANG["phrase_full_form_submission"]; ?></option>
                <option value="full_submission_no_empty_fields"><?php echo $LANG["phrase_full_form_submission_omit_empty"]; ?></option>
                <option value="notification"><?php echo $LANG["phrase_notification_only"]; ?></option>
              </select>
            </td>
          </tr>
          </table>

          <textarea style="width: 100%; height: 200px;" class="template" name="tab4_template" id="tab4_template"><?php echo $form_info['user_html_email_template']; ?></textarea>
        </div>

        <div id="tab5_content">
          
          <div><?php echo $LANG["text_reference_tab_info"]; ?></div>
          <br />
          
          <p class="subtitle"><?php echo $LANG["phrase_global_placeholders_uc"]; ?></p>
          <p>
            <?php echo $LANG["text_global_placeholder_info"]; ?>
          </p>
          
          <table cellpadding="1" cellspacing="1" class="list_table" width="100%">
          <tr height="18">
            <td class="highlighted_text2" width="160">&nbsp;%FORMNAME%</td>
            <td><?php echo $LANG["text_name_of_form"]; ?></td>
          </tr>
          <tr height="18">
            <td class="highlighted_text2">&nbsp;%LOGINURL%</td>
            <td><?php echo $LANG["text_form_tools_login_url"]; ?></td>
          </tr>
          <tr height="18">
            <td class="highlighted_text2">&nbsp;%FORMURL%</td>
            <td><?php echo $LANG["text_form_tools_form_url"]; ?></td>
          </tr>
          <tr height="18">
            <td class="highlighted_text2">&nbsp;%ADMINEMAIL%</td>
            <td><?php echo $LANG["text_admin_email_placeholder_info"]; ?></td>
          </tr>
          <tr height="18">
            <td class="highlighted_text2">&nbsp;%SUBMISSIONDATE%</td>
            <td>
              <?php
              $datetime_example = ft_get_date($settings["timezone_offset"], ft_get_current_datetime(), $settings["date_format"]); 
              $replacement_info = array("currenttime" => "<span class=\"highlighted_text bold\">$datetime_example</span>");
              echo ft_replace_placeholders($LANG["text_form_submission_date_placeholder"], $replacement_info);
              ?>
            </td>
          </tr>
          <tr height="18">
            <td class="highlighted_text2">&nbsp;%SUBMISSIONID%</td>
            <td><?php echo $LANG["text_unique_submission_id"]; ?></td>
          </tr>
          <tr height="18">
            <td class="highlighted_text2" width="160">&nbsp;%LOGO%</td>
            <td>
              <?php
              ft_replace_placeholders($LANG["text_logo_placeholder_info"], array("folder" => "<b>$g_root_url</b>"));  
              ?>
            </td>
          </tr>
          <tr height="18">
            <td class="highlighted_text2">&nbsp;%CLIENTCSS%</td>
            <td><?php echo $LANG["text_client_css_placeholder_info"];?></td>
          </tr>
          </table>
          <br />

          <p class="subtitle"><?php echo $LANG["phrase_form_placeholders_uc"];?></p>
          <p>
            <?php echo $LANG["text_form_placeholder_info"]; ?>
            <?php
            $has_file = false;
            for ($i=0; $i<count($form_field_info); $i++)
            {
              if ($form_field_info[$i][1] == "file")
                $has_file = true;
            }
            if ($has_file)
              echo $LANG["text_file_field_placeholders_info"];
            ?>
          </p>
          
          <table cellpadding="1" cellspacing="1" class="list_table" width="100%">
          <?php
          for ($i=0; $i<count($form_field_info); $i++)
          {
            $currNum = $i+1;
            echo "<tr height='18'>
                    <td class='highlighted_text2' width='50%'>%QUESTION{$currNum}% ";
                    
            // if this is a file field, display the image folder URL placeholder
            if ($form_field_info[$i][1] == "file")
              echo " %FILEURL{$currNum}% %FILENAME{$currNum}%";
            else
              echo "%ANSWER{$currNum}%";

            echo "</td>
                    <td>{$form_field_info[$i][0]}</td>
                  </tr>";
          } 
          ?>          
          </table>

        </div>

      </td>
    </tr>
    </table>

    <br />

  </div>

  <div>
    <input type="submit" name="update_emails_advanced" value="<?php echo $LANG["word_update_uc"]; ?>" />
  </div>

  </form>

  
  <div id="test_email">

    <form method="POST" action="<?php echo $g_root_url?>/global/code/actions.php" name="test_email_form" target="hidden_iframe">
    <input type="hidden" name="action" value="test_email" />
    <input type="hidden" name="form_id" value="<?php echo $form_id?>" />
    <input type="hidden" name="returnid" value="test_email_message" />
    <br />
    <br />
    <div style="border-bottom: 1px solid #cccccc;" class="subtitle"><?php echo $LANG["phrase_test_email_uc"]; ?></div>

    <?php
    if ($num_submissions == 0)
      echo "<p>{$LANG["text_test_email_templates_no_submissions"]}</p>";
    else
    {
    ?>

    <p><?php echo $LANG["text_email_tab_click_update_reminder"]; ?></p>

    <table cellpadding="0" cellspacing="1" class="list_table" width="100%">
    <tr>
      <td width="150">&nbsp;<?php echo $LANG["phrase_email_template"]; ?></td>
      <td>
        <select name="email_template">
          <option <?php if ($_SESSION["ft"]["email_template"] == "admin") echo "selected"; ?> value="admin"><?php echo $LANG["phrase_client_email_both_formats"]; ?></option>
          <option <?php if ($_SESSION["ft"]["email_template"] == "user") echo "selected"; ?> value="user"><?php echo $LANG["phrase_user_email_both_formats"]; ?></option>
          <option <?php if ($_SESSION["ft"]["email_template"] == "admin_text") echo "selected"; ?> value="admin_text"><?php echo $LANG["phrase_client_text"]; ?></option>
          <option <?php if ($_SESSION["ft"]["email_template"] == "admin_HTML") echo "selected"; ?> value="admin_HTML"><?php echo $LANG["phrase_client_html"]; ?></option>
          <option <?php if ($_SESSION["ft"]["email_template"] == "user_text") echo "selected"; ?> value="user_text"><?php echo $LANG["phrase_user_text"]; ?></option>
          <option <?php if ($_SESSION["ft"]["email_template"] == "user_HTML") echo "selected"; ?> value="user_HTML"><?php echo $LANG["phrase_user_html"]; ?></option>
        </select>
      </td>
    </tr>
    <tr>
      <td>&nbsp;<?php echo $LANG["phrase_your_email_address"]; ?></td>
      <td>
        <input type="text" name="test_email_recipient" size="40" value="<?php echo $_SESSION['ft']['test_email_recipient']?>" />
      </td>
    </tr>
    <tr>
      <td>&nbsp;<?php echo $LANG["word_data"]; ?></td>
      <td>
        <input type="radio" name="test_email_data_source" id="test_email_data_random_submission"
          value="random_submission" <?php if ($_SESSION["ft"]["test_email_data_source"] == "random_submission") echo "checked"; ?>/>
          <label for="test_email_data_random_submission"><?php echo $LANG["phrase_random_form_submission"]; ?></span></label><br />
        <input type="radio" name="test_email_data_source" id="test_email_data_submission_id"
          value="submission_id" <?php if ($_SESSION["ft"]["test_email_data_source"] == "submission_id") echo "checked"; ?>/>
          <label for="test_email_data_submission_id"><?php echo $LANG["phrase_submission_id"]; ?></label>
          <input type="input" name="test_email_submission_id" size="3" value="<?php echo $_SESSION['ft']['test_email_submission_id']?>" />
      </td>
    </tr>
    </table>
    <br />

    <table cellpadding="0" cellspacing="0" width='100%'>
    <tr>
      <td width="120" valign="top"><input type="submit" name="send_test_email" value="<?php echo $LANG["phrase_send_test_email_uc"]; ?>" /></td>
      <td width="10">&nbsp;</td>
      <td>
        <div id="test_email_message"></div>
      </td>
    </tr>
    </table>

    <?php
    }
    ?>

    </form>

  </div>

  <iframe src="about:blank" name="hidden_iframe" id="hidden_iframe" width="10" height="10" frameborder="0"></iframe>

  
  <div id="hidden_templates">
    <textarea id="tab1_full_submission"><?php
    $replacement_info = array("formname" => "%FORMNAME%");
    echo ft_replace_placeholders($LANG["text_email_template_text_1"], $replacement_info);

    echo "\n\n";
    
for ($i=1; $i<=count($form_field_info); $i++)
{
  if ($form_field_info[$i-1][1] != "file")
    echo "%QUESTION{$i}%: %ANSWER{$i}%\n";
  else
    echo "%QUESTION{$i}%: %FILEURL{$i}%\n";
}

echo "\n";

$replacement_info = array("submissiondate" => "%SUBMISSIONDATE%");
echo ft_replace_placeholders($LANG["phrase_submission_made"], $replacement_info);
?></textarea>

    <textarea id="tab1_full_submission_no_empty_fields"><?php
    $replacement_info = array("formname" => "%FORMNAME%");
    echo ft_replace_placeholders($LANG["text_email_template_text_1"], $replacement_info);

    echo "\n\n";

echo "&lt;?php\n";

for ($i=1; $i<=count($form_field_info); $i++)
{
  if ($form_field_info[$i-1][1] != "file")
  {
  	echo "\$q{$i} = <<<EOD
%QUESTION{$i}%
EOD;
\$a{$i} = <<<EOD
%ANSWER{$i}%
EOD;
\$a{$i} = trim(\$a{$i});
if (!empty(\$a{$i})) { echo \"\$q{$i}: \$a{$i}\\n\"; }\n\n";
  }
  else
  {
    $check  = "%FILENAME{$i}%";  
    $answer = "%FILEURL{$i}%";

  	echo "\$q{$i} = <<<EOD
%QUESTION{$i}%
EOD;
\$fn{$i} = <<<EOD
%FILENAME{$i}%
EOD;
\$fn{$i} = trim(\$fn{$i});
\$fu{$i} = <<<EOD
%FILEURL{$i}%
EOD;
if (!empty(\$fn{$i})) { echo \"\$q{$i}: \$fu{$i}\\n\"; }\n\n";
  }
}

echo "?&gt;\n\n";

$replacement_info = array("submissiondate" => "%SUBMISSIONDATE%");
echo ft_replace_placeholders($LANG["phrase_submission_made"], $replacement_info);
?></textarea>

    <textarea id="tab1_notification"><?php
$replacement_info = array("formname" => "%FORMNAME%");
echo ft_replace_placeholders($LANG["text_email_template_text_1"], $replacement_info);

echo "\n\n";
          
$replacement_info = array("submissiondate" => "%SUBMISSIONDATE%");
echo ft_replace_placeholders($LANG["phrase_submission_made"], $replacement_info);
?></textarea>

    <textarea id="tab2_full_submission">
&lt;p&gt;
<?php
$replacement_info = array("formname" => "%FORMNAME%");
echo "  " . ft_replace_placeholders($LANG["text_email_template_text_1"], $replacement_info);
?> 
&lt;/p&gt;

&lt;table cellpadding='0' cellspacing='1' class='list_table'&gt;
<?php
for ($i=1; $i<=count($form_field_info); $i++)
{
  if ($form_field_info[$i-1][1] != "file")
    $answer = "%ANSWER{$i}%";
  else
    $answer = "<a href=\"%FILEURL{$i}%\">%FILENAME{$i}%</a>";

    echo "&lt;tr&gt;
  &lt;td style='font-weight: bold'&gt;%QUESTION{$i}%:&lt;td&gt;
  &lt;td&gt;$answer&lt;td&gt;
&lt;/tr&gt;\n"; 
}
?>
&lt;/table&gt;

&lt;p&gt;
<?php
$replacement_info = array("submissiondate" => "%SUBMISSIONDATE%");
echo "  " . ft_replace_placeholders($LANG["phrase_submission_made"], $replacement_info);
?> 
&lt;/p&gt;</textarea>

    <textarea id="tab2_full_submission_no_empty_fields">
&lt;p&gt;
<?php
$replacement_info = array("formname" => "%FORMNAME%");
echo "  " . ft_replace_placeholders($LANG["text_email_template_text_1"], $replacement_info);
?> 
&lt;/p&gt;

&lt;table cellpadding='0' cellspacing='1' class='list_table'&gt;
<?php
for ($i=1; $i<=count($form_field_info); $i++)
{
  if ($form_field_info[$i-1][1] != "file")
  {
    echo "&lt;?php
\$a{$i} = <<<EOD
%ANSWER{$i}%
EOD;
\$a{$i} = trim(\$a{$i});
if (!empty(\$a{$i})) { ?&gt;
  &lt;tr&gt;
    &lt;td style='font-weight: bold'&gt;%QUESTION{$i}%:&lt;td&gt;
    &lt;td&gt;%ANSWER{$i}%&lt;td&gt;
  &lt;/tr&gt;
&lt;?php } ?&gt;
";
  }
  else
  {
    echo "&lt;?php
\$fn{$i} = <<<EOD
%FILENAME{$i}%
EOD;
\$fn{$i} = trim(\$fn{$i});
if (!empty(\$fn{$i})) { ?&gt;
  &lt;tr&gt;
    &lt;td style='font-weight: bold'&gt;%QUESTION{$i}%:&lt;td&gt;
    &lt;td&gt;&lt;a href=\"%FILEURL{$i}%\"&gt;%FILENAME{$i}%&lt;/a&gt;&lt;td&gt;
  &lt;/tr&gt;
&lt;?php } ?&gt;
";
  }
}
?>
&lt;/table&gt;

&lt;p&gt;
<?php
$replacement_info = array("submissiondate" => "%SUBMISSIONDATE%");
echo "  " . ft_replace_placeholders($LANG["phrase_submission_made"], $replacement_info);
?> 
&lt;/p&gt;</textarea>

    <textarea id="tab2_notification">
&lt;p&gt;
<?php
$replacement_info = array("formname" => "%FORMNAME%");
echo "  " . ft_replace_placeholders($LANG["text_email_template_text_1"], $replacement_info);
?> 
&lt;/p&gt;
    
&lt;p&gt;
<?php
$replacement_info = array("submissiondate" => "%SUBMISSIONDATE%");
echo "  " . ft_replace_placeholders($LANG["phrase_submission_made"], $replacement_info);
?> 
&lt;/p&gt;</textarea>


    <textarea id="tab3_full_submission"><?php echo $LANG["text_email_template_thanks"]; ?> 

<?php
for ($i=1; $i<=count($form_field_info); $i++)
{
  if ($form_field_info[$i-1][1] != "file")
    $answer = "%ANSWER{$i}%";
  else
    $answer = "%FILEURL{$i}%";

  echo "%QUESTION{$i}%: $answer\n";
}

echo "\n";

$replacement_info = array("submissiondate" => "%SUBMISSIONDATE%");
echo ft_replace_placeholders($LANG["phrase_submission_made"], $replacement_info);
?>  
</textarea>

    <textarea id="tab3_full_submission_no_empty_fields"><?php echo $LANG["text_email_template_thanks"]; ?> 

<?php
echo "&lt;?php\n";

for ($i=1; $i<=count($form_field_info); $i++)
{
  if ($form_field_info[$i-1][1] != "file")
  {
  	echo "\$q{$i} = <<<EOD
%QUESTION{$i}%
EOD;
\$a{$i} = <<<EOD
%ANSWER{$i}%
EOD;
\$a{$i} = trim(\$a{$i});
if (!empty(\$a{$i})) { echo \"\$q{$i}: \$a{$i}\\n\"; }\n\n";
  }
  else
  {
  	echo "\$q{$i} = <<<EOD
%QUESTION{$i}%
EOD;
\$fn{$i} = <<<EOD
%FILENAME{$i}%
EOD;
\$fn{$i} = trim(\$fn{$i});
\$fu{$i} = <<<EOD
%FILEURL{$i}%
EOD;
if (!empty(\$fn{$i})) { echo \"\$q{$i}: \$fu{$i}\\n\"; }\n\n";
  }
}
echo "?&gt;\n\n";

$replacement_info = array("submissiondate" => "%SUBMISSIONDATE%");
echo ft_replace_placeholders($LANG["phrase_submission_made"], $replacement_info);
?></textarea>

    <textarea id="tab3_notification"><?php echo $LANG["text_email_template_thanks"]; ?> 

<?php
$replacement_info = array("submissiondate" => "%SUBMISSIONDATE%");
echo ft_replace_placeholders($LANG["phrase_submission_made"], $replacement_info);
?></textarea>

    <textarea id="tab4_full_submission">
&lt;p&gt;
  <?php echo $LANG["text_email_template_thanks"]; ?> 
&lt;/p&gt;

&lt;table cellpadding='0' cellspacing='1' class='list_table'&gt;
<?php
for ($i=1; $i<=count($form_field_info); $i++)
{
  if ($form_field_info[$i-1][1] != "file")
    $answer = "%ANSWER{$i}%";
  else
    $answer = "<a href=\"%FILEURL{$i}%\">%FILENAME{$i}%</a>";

  echo "&lt;tr&gt;
  &lt;td style='font-weight: bold'&gt;%QUESTION{$i}%:&lt;td&gt;
  &lt;td&gt;$answer&lt;td&gt;
&lt;/tr&gt;\n";
}
?>
&lt;/table&gt;

&lt;p&gt;
<?php
$replacement_info = array("submissiondate" => "%SUBMISSIONDATE%");
echo "  " . ft_replace_placeholders($LANG["phrase_submission_made"], $replacement_info);
?> 
&lt;/p&gt;</textarea>

    <textarea id="tab4_full_submission_no_empty_fields">
&lt;p&gt;
  <?php echo $LANG["text_email_template_thanks"]; ?> 
&lt;/p&gt;

&lt;table cellpadding='0' cellspacing='1' class='list_table'&gt;
<?php
for ($i=1; $i<=count($form_field_info); $i++)
{
  if ($form_field_info[$i-1][1] != "file")
  {
    echo "&lt;?php
\$a{$i} = <<<EOD
%ANSWER{$i}%
EOD;
\$a{$i} = trim(\$a{$i});
if (!empty(\$a{$i})) { ?&gt;
  &lt;tr&gt;
    &lt;td style='font-weight: bold'&gt;%QUESTION{$i}%:&lt;td&gt;
    &lt;td&gt;%ANSWER{$i}%&lt;td&gt;
  &lt;/tr&gt;
&lt;?php } ?&gt;
";
  }
  else
  {
    echo "&lt;?php
\$fn{$i} = <<<EOD
%FILENAME{$i}%
EOD;
\$fn{$i} = trim(\$fn{$i});
if (!empty(\$fn{$i})) { ?&gt;
  &lt;tr&gt;
    &lt;td style='font-weight: bold'&gt;%QUESTION{$i}%:&lt;td&gt;
    &lt;td&gt;&lt;a href=\"%FILEURL{$i}%\"&gt;%FILENAME{$i}%&lt;/a&gt;&lt;td&gt;
  &lt;/tr&gt;
&lt;?php } ?&gt;
";
  }
}
?>
&lt;/table&gt;

&lt;p&gt;
<?php
$replacement_info = array("submissiondate" => "%SUBMISSIONDATE%");
echo "  " . ft_replace_placeholders($LANG["phrase_submission_made"], $replacement_info);
?> 
&lt;/p&gt;</textarea>

    <textarea id="tab4_notification">
&lt;p&gt;
  <?php echo $LANG["text_email_template_thanks"]; ?> 
&lt;/p&gt;

&lt;p&gt;
<?php
$replacement_info = array("submissiondate" => "%SUBMISSIONDATE%");
echo "  " . ft_replace_placeholders($LANG["phrase_submission_made"], $replacement_info);
?> 
&lt;/p&gt;</textarea>

  </div>

  </td>
</tr>
</table>


<!-- update the page options -->
<script type="text/javascript">
updatePageOptions();
updateUserEmailRecipientText();
<?php
// figure out which tab we should show by default
if (isset($_SESSION["ft"]["form_{$form_id}_email_tab"]))
  echo 'select_tab(' . $_SESSION["ft"]["form_{$form_id}_email_tab"] . ");";
?>
</script>
