<?php
session_start();
header("Cache-control: private");
header("Content-Type: text/html; charset=utf-8");
require_once("_submissions.php");

require_once("../../global/templates/admin_page_open.php");
?>

  <table cellpadding='0' cellspacing='0' width="650">
  <tr>
    <td><span class="title"><?php echo mb_strtoupper($form_info['form_name'])?></span></td>
    <td align="right"><a href="edit_form.php?form_id=<?php echo $form_id; ?>"><?php echo $LANG["word_edit_form_b"]; ?></a></td>
  </tr>
  </table>

  <br />

  <?php echo ft_display_message($success, $message);?>

  <?php
  // if there are submissions in this form, always display the search form
  if (isset($_SESSION["ft"]["form_{$form_id}_num_submissions"]) && !empty($_SESSION["ft"]["form_{$form_id}_num_submissions"]) && 
      $_SESSION["ft"]["form_{$form_id}_num_submissions"] > 0) {
  ?>
  
  <div id="search_form">
  
		<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post" name="search_form" onsubmit="return validateFields(this, rules)">
			<input type="hidden" name="form_id" value="<?php echo $form_id; ?>" />
			<input type="hidden" name="search" value="1" />
			<input type="hidden" name="select_all" value="<?php if ($_SESSION["ft"]["form_{$form_id}_select_all"] == "yes") echo "1"; ?>" />

			<table cellspacing="0" cellpadding="0" style="border-top: 1px solid #dddddd; border-bottom: 1px solid #dddddd; background-color: #efefef; padding: 5px;">
			<tr>
				<td class="highlighted_text2" width="70"><?php echo $LANG["word_search"]; ?></td>
				<td>
	
					<table cellspacing="2" cellpadding="0">
					<tr>
						<td>
							<select name="search_field" onchange="change_search_field(this.value)" onkeyup="change_search_field(this.value)"">
								<option value="all"><?php echo $LANG["phrase_all_fields"]?></option>
								<?php
								while (list($key, $value) = each($column_info))
								{
									if ($key == "submission_id" || $key == "is_finalized" || ($key == "ip_address" && $form_info["show_ip_address"] == "no"))
                    continue;
		
									if (isset($_SESSION["ft"]["form_{$form_id}_search_field"]) && !empty($_SESSION["ft"]["form_{$form_id}_search_field"]))
									  $selected = ($_SESSION["ft"]["form_{$form_id}_search_field"] == $key) ? "selected" : ""; 

									echo "<option value='$key' $selected>$value</option>\n";
								}
								?>
							</select>

						</td>
						<td>

							<div id="search_dropdown_section" <?php if ($_SESSION["ft"]["form_{$form_id}_search_field"] != "submission_date") echo 'style="display: none"'; ?>>
								<select name="search_date">
									<option value=""><?php echo $LANG["phrase_select_date_range"];?></option>
									<optgroup label="<?php echo $LANG["phrase_common_dates"]; ?>">
										<option value="1" <?php if ($_SESSION["ft"]["form_{$form_id}_search_date"] == "1") echo "selected"; ?>><?php echo $LANG["phrase_last_day"];?></option>
										<option value="2" <?php if ($_SESSION["ft"]["form_{$form_id}_search_date"] == "2") echo "selected"; ?>><?php echo $LANG["phrase_last_2_days"];?></option>
										<option value="3" <?php if ($_SESSION["ft"]["form_{$form_id}_search_date"] == "3") echo "selected"; ?>><?php echo $LANG["phrase_last_3_days"];?></option>
										<option value="5" <?php if ($_SESSION["ft"]["form_{$form_id}_search_date"] == "5") echo "selected"; ?>><?php echo $LANG["phrase_last_5_days"];?></option>
										<option value="7" <?php if ($_SESSION["ft"]["form_{$form_id}_search_date"] == "7") echo "selected"; ?>><?php echo $LANG["phrase_last_week"];?></option>
										<option value="30" <?php if ($_SESSION["ft"]["form_{$form_id}_search_date"] == "30") echo "selected"; ?>><?php echo $LANG["phrase_last_month"];?></option>
										<option value="365" <?php if ($_SESSION["ft"]["form_{$form_id}_search_date"] == "365") echo "selected"; ?>><?php echo $LANG["phrase_last_year"];?></option>
									</optgroup>
								  <?php
						   		if (!empty($search_months))
						   		{
						   		  echo "<optgroup label=\"{$LANG["phrase_specific_months"]}\">\n";

										while (list($key, $value) = each($search_months))
										{
											echo "<option value='$key'";
											if ($_SESSION["ft"]["form_{$form_id}_search_date"] == "$key")
											  echo "selected"; 
											echo ">$value</option>\n";
                    }
     								echo "</optgroup>\n";
									}
									?>
								</select>
							</div>

						</td>
					</tr>
					</table>
					
				</td>
				<td width="20" align="center"><?php echo $LANG["word_for"]; ?></td>
				<td>
					<input type="text" style="width: 120px;" name="search_keyword" value="<?php echo htmlspecialchars($_SESSION["ft"]["form_{$form_id}_search_keyword"]); ?>" />
				</td>
				<td>
				  <input type="submit" name="search" value="<?php echo $LANG['word_search']?>" />
				  <input type="button" name="" value="<?php echo $LANG['word_reset']?>" onclick="window.location='submissions.php?form_id=<?php echo $form_id; ?>&page=1&reset=1'" 
				    <?php if ($num_results < $_SESSION["ft"]["form_{$form_id}_num_submissions"]) echo "style='font-weight: bold'"; ?>/>
				</td>
			</tr>
			</table>

		</form>

  </div>
  
  <br />

  <?php
  }
  
  // if this form has content, display it.
  if (mysql_num_rows($search_query))
  {
		// build values to pass along in nav query string
		$full_pass_along_str = "form_id=$form_id&order=$order";
		$pass_along_str = "form_id=$form_id";
		$num_rows_in_page = mysql_num_rows($search_query);

		// display page navigation
		ft_display_page_nav($num_results, $results_per_page, $current_page, $full_pass_along_str);
  ?>

  <form name="current_form" action="<?php echo $_SERVER['PHP_SELF']?>" method="post">
  <input type="hidden" name="form_id" value="<?php echo $form_id?>" />
  
  <table class="list_table" cellpadding="1" cellspacing="1" border="0" width="650">
  <tr style="height: 20px;">
    <th align='center' width='25'> </th>
    <?php

    foreach ($display_fields as $field)
    {
      if ($field["col_name"] == "ip_address" && $form_info["show_ip_address"] == "no")
        continue;
        
      if ($field["is_sortable"] == "yes")
      {
        // determine the column sorting (if included in query string, reverse)
        if ($order == $field['col_name'] . "-DESC")
          $order_col = "&order={$field['col_name']}-ASC";
        else
          $order_col = "&order={$field['col_name']}-DESC";
  
        echo "<th><a href='{$_SERVER['PHP_SELF']}?{$pass_along_str}{$order_col}'>{$field['field_title']}</a></th>";
      }
      else
        echo "<th>{$field['field_title']}</th>";      
    }

    ?>
    <th width="50"><?php echo $LANG["word_view_uc"]; ?></th>
  </tr>

  <?php
    $row = 1;
    
    while ($submission = mysql_fetch_assoc($search_query))
    {
      $submission_id = $submission['submission_id'];

      $precheck = "";
      if (in_array($submission_id, $preselected_subids))
        $precheck = "checked";
      echo "<tr id='submission_row_$submission_id'>\n"
            . "<td align='center'><input type='checkbox' id='submission_cb_$submission_id' name='submissions[]' value='$submission_id' 
                 onchange='select_row($submission_id, $num_rows_in_page, \"JS\")' $precheck />&nbsp;</td>\n";

      foreach ($display_fields as $field)
      {
        if ($field["col_name"] == "ip_address" && $form_info["show_ip_address"] == "no")
          continue;

        $td_class = "";
        $cell_value = "";

        $field_template = ft_get_form_field($field['field_id']);

        switch ($field_template['field_type'])
        {
          case "select":
          case "radio-buttons":
            $field_options = ft_get_field_options($field['field_id']);
            while ($options = mysql_fetch_assoc($field_options))
            {
              if ($options['option_value'] == $submission[$field['col_name']])
                $cell_value = $options['option_name'];
            }          
            break;

          case "checkboxes":
          case "multi-select":
            $values = explode("$g_multi_val_delimiter", $submission[$field['col_name']]);
            $field_options = ft_get_field_options($field['field_id']);
            $display_vals = array();
            while ($options = mysql_fetch_assoc($field_options))
            {
              if (in_array($options['option_value'], $values))
                $display_vals[] = $options['option_name'];
            }
            $cell_value = join(", ", $display_vals);
            break;
          
          case "system":
            switch ($field["col_name"])
            {
              case "submission_id":
								$td_class = "submission_id";
								$cell_value = $submission_id;
                break;
              case "submission_date":
                $td_class = "submission_date";
                $submission_date = ft_get_date($settings['timezone_offset'], $submission['submission_date'], $settings['date_format']);
                $cell_value = $submission_date;
                break;
              case "ip_address":
								$td_class = "ip_address";
								$cell_value = $submission['ip_address'];
                break;
            }
            break;

          default:
            $cell_value = $submission[$field['col_name']];
            break;
        }
       
        echo "<td class='$td_class'>$cell_value</td>";
      }

      // add VIEW link
      echo "<td align='center'><a href='edit_submission.php?submission_id=$submission_id&form_id=$form_id'>{$LANG["word_view_uc"]}</a></td>\n"
         . "</tr>\n";
      $row++;
    }

  ?>
  </table>

  <div style="padding-top: 5px; padding-bottom: 5px;">
    <input type="button" id="select_button" value="<?php echo $LANG["phrase_select_all_on_page"]?>" onclick="select_all('JS');" />
    <input type="button" id="unselect_button" value="<?php echo $LANG["phrase_unselect_all"]?>" onclick="unselect_all('JS')" />
    <input type="button" value="<?php echo $LANG["word_delete"]?>" onclick="delete_submissions()" />
  </div>

  <hr size="1" align="left" style="width: 650px;" />

  <table cellpadding="0" cellpadding="1">
  <tr>
    <td width="25"><img src="../../images/xls.gif"/></td>
    <td width="80"><?php echo $LANG["phrase_excel_file"]?></td>
    <td>
      <select name="excel_type">
        <option value="all"      <?php if ($excel_type == "all") echo "selected"; ?>><?php echo $LANG["word_all"]?></option>
        <option value="selected" <?php if ($excel_type == "selected") echo "selected"; ?>><?php echo $LANG["word_selected"]?></option>
      </select>
    </td>
    <td>
      <input type="submit" name="xls_download" value="<?php echo $LANG["word_download"]?>" style="width: 60px" 
        onclick="return check_selected('excel_download', this.form.excel_type.value)" />
    </td>
  </tr>
  <tr>
    <td><img src="../../images/printer.gif"/></td>
    <td><?php echo $LANG["phrase_printer_friendly"]?></td>
    <td>
      <select name="print_type">
        <option value="all"      <?php if ($print_type == "all") echo "selected"; ?>><?php echo $LANG["word_all"]?></option>
        <option value="selected" <?php if ($print_type == "selected") echo "selected"; ?>><?php echo $LANG["word_selected"]?></option>
      </select>
    </td>
    <td>
      <input type="submit" name="print_view" value="<?php echo $LANG["word_view"]?>" style="width: 60px" 
        onclick="return check_selected('print_preview', this.form.print_type.value)" />
    </td>
  </tr>  
  </table>

  </form>

  <?php

  if ($excel_download)
    echo "<iframe name='hiddenIframe' src='excel_download.php?form_id={$form_id}' frameborder='0' style='width: 20px; height:20px' />";

  } else {
  ?>

  <p class="common_width">
    <?php echo $LANG["text_no_submissions_found"]; ?>
  </p>
  
  <?php } ?>


  <form method="POST" action="<?php echo $g_root_url?>/global/code/actions.php" name="hidden_form" target="hidden_iframe">
	<input type="hidden" name="action" value="" />
	<input type="hidden" name="form_id" value="<?php echo $form_id?>" />
	</form>

  <iframe src="about:blank" name="hidden_iframe" id="hidden_iframe" width="10" height="10" frameborder="0"></iframe>


<?php require_once("../../global/templates/footer.php"); ?>