<?php
session_start();
header("Cache-Control: private");
header("Content-Type: text/html; charset=utf-8");

require("_print_preview.php");
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html dir="<?php echo $LANG['special_text_direction']?>">
<head>
  <title><?php echo "{$_SESSION['ft']['program_name']} - {$LANG['phrase_print_preview']}"; ?></title>
  <link type="text/css" rel="stylesheet" href="../../global/admin_styles.css" />

	<script type="text/javascript">
	function changeDisplayOption(option)
	{
		window.location = "<?php echo $new_url; ?>&display_format=" + option;
	}
	</script>
	
	<style type="text/css" media="print">
	.no_print { display: none; }
	</style>
	
</head>
<body style="padding: 10px">

<table cellpadding="0" cellspacing="0" border="0" width="100%">
<tr>
  <td class='print_title'><?php echo mb_strtoupper($form_info['form_name'])?></td>
  <td width="250" align="right">
 
    <table cellpadding="0" cellspacing="0" class="no_print">
    <tr>
      <td>
        <select name="display_option" onchange="changeDisplayOption(this.value)">
          <option value="table" <?php if ($display_format == "table") echo "selected"; ?>><?php echo $LANG["phrase_table_format"]; ?></option>
          <option value="one_by_one" <?php if ($display_format == "one_by_one") echo "selected"; ?>><?php echo $LANG["phrase_one_by_one"]; ?></option>
          <option value="one_per_page" <?php if ($display_format == "one_per_page") echo "selected"; ?>><?php echo $LANG["phrase_one_submission_per_page"]; ?></option>
        </select>
      </td>
      <td><input type="button" onclick="javascript: window.close()" value="<?php echo $LANG['word_close_uc']; ?>"/></td>
      <td><input type="button" onclick="javascript: window.print()" value="<?php echo $LANG['word_print_uc']; ?>"/></td>
    </tr>
    </table>
    
  </td>
</tr>
</table>

<br />

<?php 

// table format
if ($display_format == "table")
{

?>

<table class="print_table" cellpadding="2" cellspacing="0" width="100%">
<tr>
  <?php
  foreach ($display_fields as $field)
  {
		if ($field["col_name"] == "ip_address" && $form_info["show_ip_address"] == "no")
  		continue;

    echo "<th>{$field['field_title']}</th>\n";
  }
  ?>
</tr>

<?php

  while ($submission = mysql_fetch_assoc($search_query))
  {
    // if the user has selected to only view specific items in this search result, check this is to be viewed
    if (!empty($submission_view_subset) && !in_array($submission["submission_id"], $submission_view_subset))
      continue;

    $submission_date = ft_get_date($settings['timezone_offset'], $submission['submission_date'], $settings['date_format']);
    echo "<tr>\n";

    foreach ($display_fields as $field)
    {
			if ($field["col_name"] == "ip_address" && $form_info["show_ip_address"] == "no")
				continue;

			$cell_value = "";

      // if this is a radio, checkbox or select
      $field_template = ft_get_form_field($field['field_id']);
     
			switch ($field_template['field_type'])
			{
				case "select":
				case "radio-buttons":
					$field_options = ft_get_field_options($field['field_id']);
					while ($options = mysql_fetch_assoc($field_options))
					{
						if ($options['option_value'] == $submission[$field['col_name']])
							$cell_value = $options['option_name'];
					}          
					break;

				case "checkboxes":
				case "multi-select":
					$values = explode("$g_multi_val_delimiter", $submission[$field['col_name']]);
					$field_options = ft_get_field_options($field['field_id']);
					$display_vals = array();
					while ($options = mysql_fetch_assoc($field_options))
					{
						if (in_array($options['option_value'], $values))
							$display_vals[] = $options['option_name'];
					}
					$cell_value = join(", ", $display_vals);
					break;

				case "system":
					switch ($field["col_name"])
					{
						case "submission_id":
							$cell_value = $submission["submission_id"];
							break;
						case "submission_date":
							$submission_date = ft_get_date($settings['timezone_offset'], $submission['submission_date'], $settings['date_format']);
							$cell_value = $submission_date;
							break;
						case "ip_address":
							$cell_value = $submission['ip_address'];
							break;
					}
					break;

				default:
					$cell_value = $submission[$field['col_name']];
					break;
			}
		 
			echo "<td>$cell_value&nbsp;</td>";
		}

    echo "</tr>\n";
  }

?>
</table>

<?php
}

// printer-friendly format 
else if ($display_format == "one_per_page" || $display_format == "one_by_one")
{
  $num_rows = mysql_num_rows($search_query);  
  if (!empty($submission_view_subset))
    $num_rows -= count($submission_view_subset);
  
  $row = 1;

  while ($submission = mysql_fetch_assoc($search_query))
  {
    // if the user has selected to only view specific items in this search result, check this is to be viewed
    if (!empty($submission_view_subset) && !in_array($submission["submission_id"], $submission_view_subset))
      continue;

    $submission_date = ft_get_date($settings['timezone_offset'], $submission['submission_date'], $settings['date_format']); 
    echo "<table class='print_table' cellpadding='2' cellspacing='0' width='100%'>";

    foreach ($display_fields as $field)
    {       
			if ($field["col_name"] == "ip_address" && $form_info["show_ip_address"] == "no")
				continue;

      // if this is a radio, checkbox or select 
      $field_template = ft_get_form_field($field['field_id']);

      
      $cell_value = "";
      switch ($field_template['field_type'])
      {
        case "select":
        case "radio-buttons":
          $field_options = ft_get_field_options($field['field_id']);
          while ($options = mysql_fetch_assoc($field_options))
          {
            if ($options['option_value'] == $submission[$field['col_name']])
              $cell_value = $options['option_name'];
          }
          break;

        case "multi-select":
        case "checkboxes":
          $values = explode("$g_multi_val_delimiter", $submission[$field['col_name']]);
          $field_options = ft_get_field_options($field['field_id']);
          $display_vals = array();
          while ($options = mysql_fetch_assoc($field_options))
          {
            if (in_array($options['option_value'], $values))
              $display_vals[] = $options['option_name'];
          }
          $cell_value = join(", ", $display_vals);
          break;

				case "system":
					switch ($field["col_name"])
					{
						case "submission_id":
							$cell_value = $submission["submission_id"];
							break;
						case "submission_date":
							$submission_date = ft_get_date($settings['timezone_offset'], $submission['submission_date'], $settings['date_format']);
							$cell_value = $submission_date;
							break;
						case "ip_address":
							$cell_value = $submission['ip_address'];
							break;
					}
					break;

        default:
          $cell_value = $submission[$field['col_name']];
          break;
      }

      if ($form_info['hide_printer_friendly_empty_fields'] == "no" || !empty($cell_value))
      {
        echo "<tr><th class='print_th'>{$field['field_title']}</th><td>\n";
        echo $cell_value;
        echo "&nbsp;</td></tr>\n";
      }
    }

    echo "</table>\n";

    if ($display_format == "one_per_page" && $row < $num_rows)
      echo "<br />\n<div class='no_print'><i>- {$LANG["phrase_new_page"]} -</i></div>\n<br class='page_break' />\n\n";
    else 
      echo "<br /><br />"; 
    
    $row++;   
  }
}
?>

</body>
</html>