<?php
session_start();
header("Cache-control: private");
header("Content-Type: text/html; charset=utf-8");
require("_index.php");

require("../../global/templates/admin_page_open.php");
?>

	<table cellpadding="0" cellspacing="0" height="35">
	<tr>
		<td width="45"><img src="../../images/icon_forms.jpg" /></td>
		<td class="title"><?php echo $LANG["word_forms_uc"]; ?></td>
	</tr>
	</table>

	<?php 
	if (count($forms) == 0)
	{
		if ($has_client)
			echo "<p class='common_width'>{$LANG['text_no_forms']}</p>";
		else
			echo "<p class='common_width'>{$LANG['text_no_forms_no_clients']}</p>";
	}
	else
	{ ?>

	<p class="common_width">
		<?php echo $LANG["text_list_form_page"]; ?>
	</p>

	<?php    
	// if required, show pagination
	ft_display_dhtml_page_nav(count($forms), $settings['num_forms_per_page'], 1);
	?>

	<form action="<?php echo $_SERVER['PHP_SELF']?>" method="post">

		<?php
		$row = 1;
		$table_group_id = 1;
		$current_page = 1;
	
		for ($i=0; $i<count($forms); $i++)
		{
			$form_info = $forms[$i][0];
			$user_info = $forms[$i][1];
			$form_id   = $form_info['form_id'];
	
			$previous_row = $row - 1;
			
			// if it's the first row or the start of a new table
			if ($row == 1 || ($row != 1 && $previous_row % $settings['num_forms_per_page'] == 0))
			{
				$style = ($current_page == $table_group_id) ? "display: block;" : "display: none;";
	
				echo "<div id='page_$table_group_id' style='$style'>
								<table class='list_table' width='650' cellpadding='0' cellspacing='1'>
								<tr style='height: 20px;'>
									<th width='25'>{$LANG['word_id_uc']}</th>
									<th>{$LANG['word_form']}</th>
									<th>{$LANG['word_client_sp']}</td>
									<th width='70'>{$LANG['word_status']}</th>
									<th width='85'>{$LANG['word_submissions_uc']}</th>
									<th width='60'>{$LANG['word_edit_uc']}</th>
									<th width='60'>{$LANG['word_delete_uc']}</th>
								</tr>";
			}
	
			// determine the status 
			$status  = "<span style='color: green'>{$LANG['word_online']}</span>";  
			if ($form_info['is_active'] == "no")
				$status = "<span style='color: orange'>{$LANG['word_offline']}</span>";
			if ($form_info['is_complete'] == "no")
			{
				$status = "<span style='color: red'>{$LANG['word_incomplete']}</span>";
				$file = "add_form1.php";
			}
			else
				$file = "edit_form.php";
	
			// users 
			$user_dropdown = "<select>\n";
			foreach ($user_info as $user)
				$user_dropdown .= "<option>{$user['first_name']} {$user['last_name']}</option>\n";
			$user_dropdown .= "</select>\n";
	
			echo "<tr style='height: 20px;'>
							<td align='center' class='form_id'>$form_id</td>
							<td>&nbsp;<a href='{$form_info['form_url']}' target='_blank'>{$form_info['form_name']}</a></td>
							<td>&nbsp;$user_dropdown</td>
							<td align='center'>$status</td>
							<td align='center'>";
	
			if ($form_info['is_complete'] == "yes")
				echo "(" . $_SESSION["ft"]["form_{$form_id}_num_submissions"] . ")&nbsp;<a href='submissions.php?form_id=$form_id'>{$LANG['word_view_uc']}</a>";
	
			echo "</td>\n<td align='center'>";
			
			if ($form_info['is_complete'] == "yes")            
				echo "<a href='$file?form_id=$form_id'>{$LANG['word_edit_uc']}</a>";
			else
				echo "<a href='$file?form_id=$form_id'>{$LANG['word_complete_uc']}</a>";
	
			echo "</td>
					  <td align='center'><a href='delete_form.php?form_id=$form_id'>{$LANG['word_delete_uc']}</a></td>
				  </tr>";
		
			if ($row != 1 && $row % $settings['num_forms_per_page'] == 0)
			{
				echo "</table></div>\n\n";
				$table_group_id++;
			}
			
			$row++;
		}
	
		// if the table wasn't closed, close it! 
		if (($row-1) % $settings['num_forms_per_page'] != 0)
			echo "</table></div>";
		?>
	</form>

  <br />
  
	<?php
	}
	if ($has_client)
		echo "<form method='post' action='add_form1.php?add=1'><input type='submit' value='{$LANG['phrase_add_form_uc']}' /></form>";
	else
		echo "<form method='post' action='../clients/add_client.php'><input type='submit' value='{$LANG['phrase_add_client_uc']}' /></form>";
	?>

<?php require_once("../../global/templates/footer.php"); ?>