<?php
session_start();

$xls_spreadsheet_name = "submission";
header("Pragma: public");
header("Cache-Control: max-age=0");
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=$xls_spreadsheet_name.xls");

require("_excel_download.php");
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html dir="<?php echo $LANG['special_text_direction']?>">
<head>
  <title><?php echo $_SESSION["ft"]["program_name"]?></title>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	
	<style type="text/css">
	<?php
	$style = file("../../global/admin_styles.css");
	foreach ($style as $line)
		echo $line;
	?>
	</style>

</head>
<body>

<p class='print_title'><?php echo mb_strtoupper($form_info['form_name'])?></p>

<table class="print_table" cellpadding="2" cellspacing="0" width="100%">
<tr>
  <?php
  foreach ($display_fields as $field)
  {
		if ($field["col_name"] == "ip_address" && $form_info["show_ip_address"] == "no")
  		continue;

    echo "<th>{$field['field_title']}</th>\n";
  }
  ?>
</tr>

<?php

  while ($submission = mysql_fetch_assoc($search_query))
  {
    // if the user has selected to only view specific items in this search result, check this is to be viewed
    if (!empty($submission_view_subset) && !in_array($submission["submission_id"], $submission_view_subset))
      continue;

    $submission_date = ft_get_date($settings['timezone_offset'], $submission['submission_date'], $settings['date_format']);

    echo "<tr>\n";

    foreach ($display_fields as $field)
    {
			if ($field["col_name"] == "ip_address" && $form_info["show_ip_address"] == "no")
				continue;

      // if this is a radio, checkbox or select 
      $field_template = ft_get_form_field($field['field_id']);
      $cell_value = "";

      switch ($field_template['field_type'])
      {
        case "select":
        case "radio-buttons":
          $field_options = ft_get_field_options($field['field_id']);
          while ($options = mysql_fetch_assoc($field_options))
          {
            if ($options['option_value'] == $submission[$field['col_name']])
              $cell_value = $options['option_name'];
          }          
          break;

        case "multi-select":
        case "checkboxes":
          $values = explode("$g_multi_val_delimiter", $submission[$field['col_name']]);
          $field_options = ft_get_field_options($field['field_id']);
          $display_vals = array();
          while ($options = mysql_fetch_assoc($field_options))
          {
            if (in_array($options['option_value'], $values))
              $display_vals[] = $options['option_name'];
          }
          $cell_value = join(", ", $display_vals);
          break;

        case "file":
          $file_upload_url = $field_template['file_upload_url'];
          if (!empty($submission[$field['col_name']]))
          {
            $filename = ft_trim_string($submission[$field['col_name']], 80, "page_break");
            $cell_value = "<a href='$file_upload_url/{$submission[$field['col_name']]}' target='_blank'>$filename</a>";
          }

				case "system":
					switch ($field["col_name"])
					{
						case "submission_id":
							$cell_value = $submission["submission_id"];
							break;
						case "submission_date":
							$submission_date = ft_get_date($settings['timezone_offset'], $submission['submission_date'], $settings['date_format']);
							$cell_value = $submission_date;
							break;
						case "ip_address":
							$cell_value = $submission['ip_address'];
							break;
					}
					break;

        default:
          $cell_value = $submission[$field['col_name']];
          break;
      }
    
      echo "<td>";

      // for empty cells, output a non-breaking space to retain the cell styles
      if (empty($cell_value) && $cell_value != "0")
        echo "&nbsp;";
      else
        echo $cell_value;

      echo "</td>\n";
    }
    
    echo "</tr>\n";
  }
  ?>

</table>

</body>
</html>