<?php
session_start();
header("Cache-control: private");
header("Content-Type: text/html; charset=utf-8");
require_once("_add_form4.php");

require_once("../../global/templates/admin_page_open.php");
?>

  <p class="title"><?php echo $LANG["phrase_add_form_uc"] ?></p>

  <table cellpadding="0" cellspacing="0" width="640" class="add_form_nav">
  <tr>
    <td class="selected"><a href="add_form1.php?form_id=<?php echo $form_id?>"><?php echo $LANG["phrase_main_info"]; ?></a></td>
    <td class="selected"><a href="add_form2.php?form_id=<?php echo $form_id?>&uninitialize=1"><?php echo $LANG["phrase_test_submission"]; ?></a></td>
    <td class="selected"><a href="add_form3.php?form_id=<?php echo $form_id?>"><?php echo $LANG["phrase_database_setup"]; ?></a></td>
    <td class="selected"><?php echo $LANG["phrase_display_options"]; ?></td>
    <td class="unselected"><?php echo $LANG["phrase_finalize_form"]; ?></td>
  </tr>
  </table>

  <br />

  <div class="common_width">
    <div class="subtitle underline"><?php echo $LANG["phrase_display_options_page_4_uc"]; ?></div>

    <p>
      <?php echo $LANG["text_add_form_step_4_para_1"]; ?>
    </p>

    <table cellpadding="0" cellspacing="0" width="100%">
    <tr>
      <td>      
        <ol>
          <li><?php echo $LANG["phrase_add_form_step_4_para_1"]; ?></li>
          <li><?php echo $LANG["phrase_add_form_step_4_para_2"]; ?></li>
          <li><?php echo $LANG["phrase_add_form_step_4_para_3"]; ?></li>
        </ol>
      </td>
      <td align="right" width="80" valign="top">
        <input type="button" value="<?php echo $LANG["phrase_smart_field_uc"]; ?>" onclick="smart_fill()" />
      </td>
    </tr>
    </table>
    
    <form action="<?php echo $_SERVER['PHP_SELF']?>" method="post">
    <input type='hidden' name='form_id' value='<?php echo $form_id?>' />
  
    <table class="list_table" width="650" cellpadding='0' cellspacing='1'>
    <tr style="height: 20px;">
      <th width='40'><?php echo $LANG["word_order"]; ?></th>
      <th width='60'><?php echo $LANG["word_column"]; ?></th>
      <th><?php echo $LANG["phrase_display_name"]; ?></th>
      <th><?php echo $LANG["phrase_field_name"]; ?></td>
    </tr>
  
    <?php
  
    $required_info = array();
  
    $row = 1;
    while ($field = mysql_fetch_assoc($form_info))
    {
      $field_id   = $field['field_id'];
      $test_value = ft_trim_string($field['field_test_value'], 30);  
    
      // store the information that's required to continue
      $required_info[] = array($field['admin_display'], $field['field_title']);
  
      if ($field['admin_display'] == 'yes')
        $display_checked = "checked";
      else
        $display_checked = "";
    
      if ($field['include_on_redirect'] == 'yes')
        $include_on_redirect = "checked";
      else
        $include_on_redirect = "";

      $display_name = htmlspecialchars($field['field_title'], ENT_QUOTES);
  
      echo "<tr>
              <td class='greyCell' align='center'>
                <input type='hidden' name='field_{$field_id}' value='1' />
                <input type='text' name='field_{$field_id}_order' style='width: 30px;' value='$row' />\n";

      // if this is a system field, mention that to the reorder function to prevent it from overwriting the 
      // column name in the form_templates table
      if ($field['field_type'] == "system")
        echo "<input type='hidden' name='field_{$field_id}_system' value='1' />";

      echo "</td>
              <td class='greyCell' align='center'><input type='checkbox' name='field_{$field_id}_display' $display_checked /></td>
              <td class='greyCell'><input type='text' name='field_{$field_id}_display_name' id='field_{$field_id}_display_name' style='width: 100%;' value='$display_name' /></td>
              <td class='greyCell' style='color:#336699;'>&nbsp;{$field['field_name']}</td>
            </tr>\n";
      $row++;
    }
    ?>
    </table>
  
    <p> 
      <input type="submit" name="action" value="<?php echo $LANG["word_update_uc"]; ?>" />
      <input type="button" value="<?php echo $LANG["phrase_resend_test_submission_uc"]; ?>" onclick="window.location='add_form2.php?form_id=<?php echo $form_id?>&uninitialize=1'"/>
    </p>
  
  
    <div id="show_help">
      <a href="javascript:toggle_help('show')"><?php echo $LANG["phrase_show_help"]; ?></a><br />    
    </div>
    
    <div id="hide_help" class="notify" style="width: 600px">
      <a href="javascript:toggle_help('hide')"><?php echo $LANG["phrase_hide_help"]; ?></a><br />    
      <br />
      
      <table cellpadding="1" cellspacing="2">
      <tr>
        <td width="100" class="blue" valign="top">&nbsp;<?php echo $LANG["word_order"]; ?></td>
        <td class="desc">
          <?php echo $LANG["text_add_form_column_order"]; ?>
        </td>
      </tr>
      <tr>
        <td width="100" class="blue" valign="top">&nbsp;<?php echo $LANG["word_column"]; ?></td>
        <td>
          <?php echo $LANG["text_add_form_column_info"]; ?>
        </td>
      </tr>
      <tr>
        <td width="100" class="blue" valign="top">&nbsp;<?php echo $LANG["phrase_display_name"]; ?></td>
        <td>
          <?php echo $LANG["text_add_form_display_name_info"]; ?>
        </td>
      </tr>
      <tr>
        <td width="100" class="blue" valign="top">&nbsp;<?php echo $LANG["phrase_field_name"]; ?></td>
        <td>
          <?php echo $LANG["text_add_form_name_field_info"]; ?>          
        </td>
      </tr>
      </table>
  
    </div>
  
    <?php

    // check that all required information has been entered
    $has_display = false;
    $has_all_display_names = true;
    for ($i=0; $i<count($required_info); $i++)
    {
      if ($required_info[$i][0] == "yes")
        $has_display = true;
      if (empty($required_info[$i][1]))
        $has_all_display_names = false;
    }
    if ($has_display && $has_all_display_names)
    {
      echo "<p><input type='submit' name='next_step' class='next_step' value='{$LANG["word_next_uc_rightarrow"]}' /></p>"; 
    }
    ?>

    </form>

  </div>
  
<?php require_once("../../global/templates/footer.php"); ?>