<?php
session_start();
header("Cache-control: private");
header("Content-Type: text/html; charset=utf-8");
require_once("_add_form3.php");

require("../../global/templates/admin_page_open.php");
?>

  <p class="title"><?php echo $LANG["phrase_add_form_uc"] ?></p>

  <table cellpadding="0" cellspacing="0" width="640" class="add_form_nav">
  <tr>
    <td class="selected"><a href="add_form1.php?form_id=<?php echo $form_id?>"><?php echo $LANG["phrase_main_info"]; ?></a></td>
    <td class="selected"><a href="add_form2.php?form_id=<?php echo $form_id?>&uninitialize=1"><?php echo $LANG["phrase_test_submission"]; ?></a></td>
    <td class="selected"><?php echo $LANG["phrase_database_setup"]; ?></td>
    <td class="unselected"><?php echo $LANG["phrase_display_options"]; ?></td>
    <td class="unselected"><?php echo $LANG["phrase_finalize_form"]; ?></td>
  </tr>
  </table>

  <br />

  <div class="common_width">
    <div class="subtitle underline"><?php echo $LANG["phrase_db_setup_page_3_uc"]; ?></div>

    <p>
      <?php echo $LANG["text_add_form_step_3_para_1"]; ?>

      <?php 
      if   ($form_type == "direct") 
        echo $LANG["text_add_form_step_3_para_2"];
      else 
        echo $LANG["text_add_form_step_3_para_3"]; 
      ?>

    </p>
    <p>
      <?php echo $LANG["text_add_form_step_3_para_4"]; ?>
    </p>   
    <p>
      <?php echo $LANG["text_add_form_step_3_para_5"]; ?>
    </p>
    
    <form action="<?php echo $_SERVER['PHP_SELF']?>" method="post">
    <input type='hidden' name='form_id' value='<?php echo $form_id?>' />
  
    <table class="list_table" width="650" cellpadding='0' cellspacing='1'>
    <tr style="height: 20px;">
      <th width='40'><?php echo $LANG["word_order"]; ?></th>
      <th><?php echo $LANG["phrase_form_field_name"]; ?></td>
      <th><?php echo $LANG["phrase_sample_data"]; ?></td>
      <th><?php echo $LANG["phrase_field_size"]; ?></th>
      <?php if ($form_type == "direct") echo "<th>{$LANG["phrase_pass_on"]}</th>"; ?> 
      <th width='40'><?php echo $LANG["word_delete"]; ?></th>
    </tr>

    <?php
  
    $required_info = array();
    
    $row = 1;
    while ($field = mysql_fetch_assoc($form_info))
    {
      $field_id   = $field['field_id'];
      $test_value = htmlspecialchars(stripslashes(ft_trim_string($field['field_test_value'], 30)), ENT_QUOTES);  
       if ($field['include_on_redirect'] == 'yes')
        $include_on_redirect = "checked";
      else
        $include_on_redirect = "";
  
      $display_name = htmlspecialchars($field['field_title'], ENT_QUOTES);
 
      $style = "";
      if ($field['field_type'] == "system")
        $style = "background-color: #DBECFE";

      echo "<tr style='$style'>
              <td class='greyCell' align='center'>
                <input type='hidden' name='field_{$field_id}' value='1' />
                <input type='text' name='field_{$field_id}_order' style='width: 30px;' value='$row' />
              </td>
              <td style='color:#336699;'>&nbsp;{$field['field_name']}</td>
              <td>&nbsp;$test_value</td>
              <td>";      

      if ($field['field_type'] == "system")
      {
        // pass along hidden field to let the reorder function know that this field is a system field. This 
        // prevents the program from trying to rename the column
        echo "&nbsp;{$LANG["word_na"]}
              <input type='hidden' name='field_{$field_id}_system' value='1' />
              <input type='hidden' name='field_{$field_id}_type' value='small' />";
        
      }
      else
      {
				if ($test_value == $LANG["word_file_b_uc"]) 
					echo "<select disabled>";
				else
					echo "<select name='field_{$field_id}_type'>\n";
	
				echo "<option "; if ($field['field_size'] == 'tiny')       echo "selected "; echo "value='tiny'>{$LANG["phrase_size_tiny"]}</option>\n";
				echo "<option "; if ($field['field_size'] == 'small')      echo "selected "; echo "value='small'>{$LANG["phrase_size_small"]}</option>\n";
				echo "<option "; if ($field['field_size'] == 'medium' || $test_value == $LANG["word_file_b_uc"]) echo "selected "; echo "value='medium'>{$LANG["phrase_size_medium"]}</option>\n";
				echo "<option "; if ($field['field_size'] == 'large')      echo "selected "; echo "value='large'>{$LANG["phrase_size_large"]}</option>\n";
				echo "<option "; if ($field['field_size'] == 'very_large') echo "selected "; echo "value='very_large'>{$LANG["phrase_size_very_large"]}</option>\n";
				echo "</select>";

				// if a file field, pass along a hidden field with the 256 character value
				if ($test_value == $LANG["word_file_b_uc"]) echo "<input type='hidden' name='field_{$field_id}_type' value='medium' />";
      }
      
      echo "</td>";

      if ($form_type == "direct")
        echo "<td class='greyCell' align='center'><input type='checkbox' name='field_{$field_id}_include_on_redirect' $include_on_redirect /></td>";
  
      echo "<td class='del'>";
      
      if ($field['field_type'] != "system")
        echo "<input type='checkbox' name='field_{$field_id}_remove' />";
      
      echo "</td>\n</tr>\n";
      $row++;
    }
    ?>
    </table>
  
    <p> 
      <input type="submit" name="action" value="<?php echo $LANG["word_update_uc"]; ?>" />
      <input type="button" value="<?php echo $LANG["phrase_resend_test_submission_uc"]; ?>" onclick="window.location = 'add_form2.php?form_id=<?php echo $form_id?>&uninitialize=1'"/>
    </p>
  
  
    <div id="show_help">
      <a href="javascript:toggleHelp('show')"><?php echo $LANG["phrase_show_help"]; ?></a><br />    
    </div>
    
    <div id="hide_help" class="notify" style="width: 600px">
      <a href="javascript:toggleHelp('hide')"><?php echo $LANG["phrase_hide_help"]; ?></a><br />    
      <br />
      
      <table cellpadding="1" cellspacing="2">
      <tr>
        <td width="100" class="blue" valign="top">&nbsp;<?php echo $LANG["word_order"]; ?></td>
        <td class="desc">
          <?php echo $LANG["text_add_form_column_order"]; ?>
        </td>
      </tr>
      <tr>
        <td width="100" class="blue" valign="top">&nbsp;<?php echo $LANG["phrase_form_field_name"]; ?></td>
        <td>
          <?php echo $LANG["text_add_form_step_3_para_7"]; ?>
        </td>
      </tr>
      <tr>
        <td width="100" class="blue" valign="top">&nbsp;<?php echo $LANG["phrase_sample_data"]; ?></td>
        <td>
          <?php echo $LANG["text_add_form_step_3_para_8"]; ?>          
        </td>
      </tr>
      <tr>
        <td width="100" class="blue" valign="top">&nbsp;<?php echo $LANG["phrase_field_size"]; ?></td>
        <td>
          <?php echo $LANG["text_add_form_step_3_para_9"]; ?>
        </td>
      </tr>
      <tr>
        <td width="100" class="blue" valign="top">&nbsp;<?php echo $LANG["phrase_pass_on"]; ?></td>
        <td>
          <?php echo $LANG["text_add_form_step_3_para_10"]; ?>          
        </td>
      </tr>
      <tr>
        <td width="100" class="blue" valign="top">&nbsp;<?php echo $LANG["word_delete"]; ?></td>
        <td>
          <?php echo $LANG["text_add_form_step_3_para_11"]; ?>
        </td>
      </tr>
      </table>
  
    </div>
  
    <p><input type="submit" name="next_step" class="next_step" value="<?php echo $LANG['word_next_uc_rightarrow']; ?>" /></p>

    </form>

  </div>
      
<?php require_once("../../global/templates/footer.php"); ?>