<?php

require_once("../../global/library.php");
require_once("../../global/scripts/js_messages.php");
ft_check_permission("admin");

$print_preview = false;
$excel_download = false;
$success = false;
$message =  "";

$form_id = isset($_POST['form_id']) ? $_POST['form_id'] : $_GET['form_id'];
if (empty($form_id))
{
  header("location: index.php");
  exit;
}

// delete submission(s)
if (!empty($_GET['delete']) && !empty($_GET['submission_ids']))
{
  // if required, delete ALL the submissions in this form
  if (isset($_SESSION["ft"]["form_{$form_id}_select_all_submissions"]) && $_SESSION["ft"]["form_{$form_id}_select_all_submissions"] == 1)
	  list ($success, $message) = ft_delete_submission($form_id, "all");
  
  // otherwise, just delete those that have been requested
  else
  {    
		// convert the list to an array
		$submission_ids = split(",", $_GET['submission_ids']);
		list ($success, $message) = ft_delete_submission($form_id, $submission_ids);
  }
}

// if required, generate the excel content
else if (isset($_POST['xls_download']))
{
  $_SESSION["ft"]["excel_type"] = $_POST['excel_type'];
  $_SESSION["ft"]["excel_submissions"] = ($_POST["excel_type"] == "selected" && isset($_POST['submissions'])) ? join(",", $_POST['submissions']) : "";

  $excel_download = true;
}
  
// otherwise, if requested, show a print preview page
else if (isset($_POST['print_view']))
{
  $_SESSION["ft"]["print_preview_type"] = $_POST['print_type'];
  $_SESSION["ft"]["print_preview_submissions"] = ($_POST["print_type"] == "selected" && isset($_POST['submissions'])) ? join(",", $_POST['submissions']) : "";

  $print_preview = true;
}


// -------------------------------------------------------------------------

$form_template = ft_get_form_template($form_id);
$form_info     = ft_get_form($form_id);


if (isset($_GET["reset"]) && $_GET["reset"] == "1")
{
  unset($_SESSION["ft"]["form_{$form_id}_search_field"]);
  unset($_SESSION["ft"]["form_{$form_id}_search_date"]);
  unset($_SESSION["ft"]["form_{$form_id}_search_keyword"]);  
  unset($_SESSION["ft"]["form_{$form_id}_sort_order"]);  
  unset($_SESSION["ft"]["form_{$form_id}_select_all_submissions"]);
}


// which page are we viewing?
$current_page = ft_load_field("page", "form_{$form_id}_page");
if (empty($current_page) || isset($_POST["search"]))
  $current_page = 1;

// examine the form template and determine which fields to display
$display_fields = array();
$columns = array();
while ($field = mysql_fetch_assoc($form_template))
{
  if ($field['admin_display'] == "yes")
  {
    $display_fields[] = array('field_id'    => $field['field_id'],
                              'is_sortable' => $field['is_sortable'],
                              'field_title' => $field['field_title'],
                              'col_name'    => $field['col_name'], 
                              'list_order'  => $field['list_order']);
    $columns[] = $field['col_name'];
  }
}

// determine the order
if (isset($_GET["order"]))
{
  $_SESSION["ft"]["form_{$form_id}_sort_order"] = $_GET["order"];
  $order = $_GET["order"];
}
else
{
  if (isset($_SESSION["ft"]["form_{$form_id}_sort_order"]))
    $order = $_SESSION["ft"]["form_{$form_id}_sort_order"];
  else
    $order = "{$form_info['default_sort_field']}-{$form_info['default_sort_field_order']}";
}


// piece together the search fields

// search field (database column name / "all" / "date")
$search_field   = ft_load_field("search_field", "form_{$form_id}_search_field");
$search_date    = ft_load_field("search_date", "form_{$form_id}_search_date");
$search_keyword = ft_load_field("search_keyword", "form_{$form_id}_search_keyword");

$search_fields = array(
  "search_field"   => $search_field,
  "search_date"    => $search_date,
  "search_keyword" => $search_keyword  
);

// -----------------------------------------------------------------------------

$results_per_page = $form_info['num_submissions_per_page'];
$results_info = ft_search_submissions($form_id, $results_per_page, $current_page, $order, $columns, $search_fields);

// store the current search settings. This is used on the item details page to provide "<< previous  next >>" links
$_SESSION["ft"]["new_search"] = "yes";
$_SESSION["ft"]["current_search"] = array( 
    "form_id" => $form_id, 
    "results_per_page" => $results_per_page, 
    "order" => $order, 
    "search_fields" => $search_fields
      );

$search_query = $results_info["search_query"]; // extract the MySQL query resource
$num_results  = $results_info["num_results"];  // extract the total number of results found

// check that the current page is stored in sessions is, in fact, a valid option. e.g.
// if the person was having 10 submissions listed per page, had 11 submissions, and was on 
// page 2 before deleting the 11th, when they returned to this page, they'd have page 2 stored
// in sessions, although there is no longer a second page. So update the session and redirect back
// to the page
$total_pages = ceil($num_results / $results_per_page);
if (isset($_SESSION["ft"]["form_{$form_id}_page"]) && $_SESSION["ft"]["form_{$form_id}_page"] > $total_pages)
{
  $_SESSION["ft"]["form_{$form_id}_page"] = $total_pages;

  // just in case QUERY_STRING is empty, set it to at least pass along the form ID
  $query_string = $_SERVER['QUERY_STRING'];
  if (empty($_SERVER['QUERY_STRING']))
    $query_string = "form_id=$form_id";

  header("location: submissions.php?$query_string");
}


$preselected_subids = isset($_POST['submissions']) ? $_POST['submissions'] : "";
if (empty($preselected_subids))
  $preselected_subids = array();

$excel_type = isset($_POST['excel_type']) ? $_POST['excel_type'] : "";
$print_type = isset($_POST['print_type']) ? $_POST['print_type'] : "";

$settings      = ft_get_settings();
$column_info   = ft_get_form_column_names($form_id);
$search_months = ft_get_search_months($form_id);
_ft_load_form_values();

// init page fields
if (!isset($_SESSION["ft"]["form_{$form_id}_search_field"]))   $_SESSION["ft"]["form_{$form_id}_search_field"] = "";
if (!isset($_SESSION["ft"]["form_{$form_id}_search_keyword"])) $_SESSION["ft"]["form_{$form_id}_search_keyword"] = "";
if (!isset($_SESSION["ft"]["form_{$form_id}_search_date"]))    $_SESSION["ft"]["form_{$form_id}_search_date"] = "";
if (!isset($_SESSION["ft"]["form_{$form_id}_select_all_submissions"])) $_SESSION["ft"]["form_{$form_id}_select_all_submissions"] = "";

// get a list of all submission IDs
$submission_ids = array();
while ($submission = mysql_fetch_assoc($search_query))
	$submission_ids[] = $submission['submission_id'];
@mysql_data_seek($search_query, 0);
$submission_id_str = join(",", $submission_ids);
$select_all_submissions_returned = ($_SESSION["ft"]["form_{$form_id}_select_all_submissions"] == "1") ? "true" : "false";

// header information
$g_head_title ="{$_SESSION['ft']['program_name']} - {$LANG['word_submissions']}";
$g_body_onload = "init_page('JS')";
$g_nav_page = "form";
$g_head_js = "
	var rules = new Array();
	rules.push(\"if:search_field!=submission_date,required,search_keyword,{$LANG["validation_please_enter_search_keyword"]}\");
	rules.push(\"if:search_field=submission_date,required,search_date,{$LANG["validation_please_enter_search_date_range"]}\");

	var selected_row_color   = '#dbecfe';
	var unselected_row_color = '#efefef';
	var submission_id_str = '$submission_id_str';
	var submission_arr = submission_id_str.split(\",\");
	var select_all_submissions_returned = $select_all_submissions_returned;
	var select_all_submissions_on_page = false;
	var num_results = $num_results;
	var form_id = $form_id;
  
  $js_messages
    ";

// open the print preview page
if ($print_preview)
	$g_head_js .= "window.open('print_preview.php?form_id=$form_id', '', 'height=520, width=720, scrollbars=yes, resizable=yes');";

$g_head_string = '<script type="text/javascript" src="../../global/scripts/manage_submissions.js"></script>';

?>
