<?php

require_once("../../global/library.php");
require_once("../../global/scripts/js_messages.php");
ft_check_permission("admin");

$success = false;
$message = "";

$request = array_merge($_POST, $_GET);
$form_id = $request['form_id'];

// store the current selected tab in memory - except for pages which require additional
// query string info. For those, use "parent" page
if (isset($request['page']) && !empty($request['page']))
{
  $remember_page = $request['page'];
  switch ($remember_page)
  {
    case "options":
    case "files":
      $remember_page = "display";
      break;
    case "addfields":
      $remember_page = "advanced";
      break;
  }

  $_SESSION["ft"]["form_{$form_id}_tab"] = $remember_page;
}
else
{
  if (isset($_SESSION["ft"]["form_{$form_id}_tab"]))
    $request['page'] = $_SESSION["ft"]["form_{$form_id}_tab"];
  else
    $request['page'] = "main";
}

// redirect to add field page
if (isset($request['add_field']))
{
	$num_fields = $request["num_fields"];
  header("Location: edit_form.php?page=addfields&form_id=$form_id&num_fields=$num_fields");
  exit;
}

// update the various tabs
if (isset($request['update_main']))
  list($success, $message) = ft_update_form_main_tab($request, $form_id);
if (isset($request['update_display']))
{ 
  ft_reorder_form_fields($request, $form_id);
  list ($success, $message) = ft_update_form_display_tab($request, $form_id);
}

if (isset($request['update_emails_basic']))
  list ($success, $message) = ft_update_form_email_basic_tab($request);
else if (isset($request['update_emails_advanced']))
  list ($success, $message) = ft_update_form_email_advanced_tab($request);

if (isset($request['update_advanced']))
{ 
  list($success, $message) = ft_update_form_advanced_tab($request);
  ft_delete_form_fields($request, $form_id);
}

if (isset($request['update_add_field']))
{
  $field_info = array();
  list($success, $message) = ft_add_form_fields($request, $form_id);

  if ($success)
  {
    header("Location: edit_form.php?page=advanced&form_id=$form_id");
    exit;
  }
  else
    $field_info = $_POST;
}

if (isset($request['update_field_options']))
{
  $field_id = $_POST['field_id']; 
  list($success, $message) = ft_update_field_options($request, $field_id);
}
if (isset($request['update_field_file_settings']))
{
  $field_id = $_POST['field_id'];
  list($success, $message) = ft_update_field_file_settings($request, $field_id);
}

// init various session values (this serves not purpose other than to prevent warnings when error_reporting 
// is cranked up high)
if (!isset($_SESSION["ft"]["test_email_data_source"])) $_SESSION["ft"]["test_email_data_source"] = ""; 
if (!isset($_SESSION["ft"]["email_template"])) $_SESSION["ft"]["email_template"] = ""; 
if (!isset($_SESSION["ft"]["test_email_recipient"])) $_SESSION["ft"]["test_email_recipient"] = ""; 
if (!isset($_SESSION["ft"]["test_email_submission_id"])) $_SESSION["ft"]["test_email_submission_id"] = ""; 


// retrieve all information about this form for use in the tabs
$form_info     = ft_get_form($form_id);
$form_template = ft_get_form_template($form_id);
$column_info   = ft_get_form_column_names($form_id);
$settings      = ft_get_settings();

$form_type       = $form_info['form_type'];
$emailing_method = $settings['emailing_method'];

// header information
$g_head_js = $js_messages; // from js_messages.php
$g_head_title = "{$_SESSION['ft']['program_name']} - {$LANG['phrase_form_settings']}";
$g_head_string = "<script type=\"text/javascript\" src=\"../../global/scripts/add_fields.js\"></script>
  <style type=\"text/css\">
  .greybg td { background-color: #efefef; }
  .template { font-family: Courier New, Courier, monospace; font-size: 9pt; }
  #tab1_not_selected, #tab2_selected, #tab3_selected, #tab4_selected, #tab5_selected, 
  #tab2_content, #tab3_content, #tab4_content, #tab5_content, #hidden_templates { display: none; }
  #user_recipient, #client_recipient { color: #990000; }

  .inner_table { border: 1px solid #cccccc; }
  .inner_table td { background-color: #EDF3FE; }
  
  #admin_email_reply_to_custom_section, #admin_email_from_custom_section,
  #user_email_from_custom_section, #user_email_reply_to_custom_section { 
    display: none;
  }
  ";
  if ($form_info['auto_email_admin'] == "no" && $form_info['auto_email_user'] == "no")
    $g_head_string .= "#tab_content { display: none; }\n";
  else
  {
    // hide the admin & user email notification settings by default
    if ($form_info['auto_email_admin'] == "no") 
      $g_head_string .= "#tab1, #tab2, #admin_settings { display: none; }\n";
    if ($form_info['auto_email_user']  == "no")
      $g_head_string .= "#tab3, #tab4, #user_settings { display: none; }\n";
  }
$g_head_string .= "</style>";  

?>