<?php

require_once("../../global/library.php");
ft_check_permission("admin");

$form_id = (isset($_GET['form_id'])) ? $_GET['form_id'] : $_POST['form_id'];

if (!empty($_POST) && isset($_POST['action']))
{
  // reorder fields 
  ft_reorder_form_fields($_POST, true);

  // update their values
  ft_set_form_display_settings($_POST);
}

// go to next page
else if (!empty($_POST) && isset($_POST['next_step']))
{
  $form_info = ft_get_form($form_id);
  if ($form_info['is_complete'] != 'yes')
    ft_finalize_form($form_id);

  header("location: add_form5.php?form_id=$form_id");
  exit;
}

$form_info  = ft_get_form_template($form_id);
$form_setup = ft_get_form($form_id);
$form_type  = $form_setup['form_type'];


// build the best guesses
$best_guesses = array();
while ($field = mysql_fetch_assoc($form_info))
{
  if ($field["field_type"] == "system")
    continue;

  // best guess at generating an appropriate Display Name
  $temp = preg_replace("/_/", " ", $field["field_name"]);
  $display_name_guess = ucwords($temp);

  $best_guesses[] = "\"{$field['field_id']}\": \"$display_name_guess\"";
}
@mysql_data_seek($form_info, 0);
$best_guesses_js = join(",\n", $best_guesses);


// header information
$g_head_title = "{$_SESSION['ft']['program_name']} - {$LANG['phrase_add_form']}";
$g_head_css = "
	.incomplete {
	  color: #cc0000; 
	  width: 125px; 
	  padding: 5px; 
	  border: 1px solid #cc0000;
	  background-color: #ffffcc;
	}
	
	#hide_help { display: none; }
	.heading { color: #336699; }
	  ";
$g_head_js = "	
	function toggle_help(flag)
	{
	  if (flag == 'show')
	  {
	    document.getElementById('show_help').style.display = 'none';
	    document.getElementById('hide_help').style.display = 'block';    
	  }
	  else if (flag == 'hide')
	  {
	    document.getElementById('show_help').style.display = 'block';
	    document.getElementById('hide_help').style.display = 'none';    
	  } 
	}

	function smart_fill()
	{
	  var smart_fill_values = {   
	    $best_guesses_js
	  };

	  // if any of the fields contain a value already, inform the user 
	  var str = '';
	  var has_value = false;
	  for (var field_id in smart_fill_values)
	  {
	    if (document.getElementById('field_' + field_id + '_display_name').value)
	      has_value = true;
	  }
	
	  var fill_fields = true;
	  if (has_value)
	    fill_fields = confirm(\"{$LANG["confirm_smart_fill_display_names"]}\");
	
	  if (fill_fields)
	  {
	    for (var field_id in smart_fill_values)
	      document.getElementById('field_' + field_id + '_display_name').value = smart_fill_values[field_id]; 
	  }
	}
  ";

?>
