<?php

require_once("../../global/library.php");
ft_check_permission("admin");

$form_id = (isset($_GET['form_id'])) ? $_GET['form_id'] : $_POST['form_id'];

if (!empty($_POST) && isset($_POST['action']))
{
  // reorder fields 
  ft_reorder_form_fields($_POST, $form_id, true);

  // update their values
  ft_set_form_database_settings($_POST, $form_id);

  // delete any unwanted fields
  ft_delete_form_fields($_POST, $form_id);
}

// go to next page
else if (!empty($_POST) && isset($_POST['next_step']))
{
  // reorder fields 
  ft_reorder_form_fields($_POST, $form_id, true);

  // update their values
  ft_set_form_database_settings($_POST, $form_id);

  // now delete unwanted fields
  ft_delete_form_fields($_POST, $form_id);

  header("location: add_form4.php?form_id=$form_id");
  exit;   
}

$form_info  = ft_get_form_template($form_id);
$form_setup = ft_get_form($form_id);
$form_type  = $form_setup['form_type'];


// header information
$g_head_title = "{$_SESSION['ft']['program_name']} - {$LANG['phrase_add_form']}";
$g_head_css = "
	#hide_help { display: none; }
	.heading { color: #336699; }
	.incomplete {
	  color: #cc0000;
	  width: 125px;
	  padding: 5px;
	  border: 1px solid #cc0000;
	  background-color: #ffffcc;
	}
";
$g_head_js = "	
	function toggleHelp(flag)
	{
	  if (flag == 'show')
	  {
	    document.getElementById('show_help').style.display = 'none';
	    document.getElementById('hide_help').style.display = 'block';    
	  }
	  else if (flag == 'hide')
	  {
	    document.getElementById('show_help').style.display = 'block';
	    document.getElementById('hide_help').style.display = 'none';    
	  }
	}";

?>
