<?php

require_once("../../global/library.php");
ft_check_permission("admin");
$success = false;
$message = "";

// if beginning to add form, prep form values
if (isset($_GET['add']))
  ft_preload_values("new_form");

// edit existing form (used for cases where user fails to complete form building
// process, then returns later to finish the job)
else if (isset($_GET['form_id']))
  ft_preload_values("database", $_GET['form_id']);

// set up the form
else if (isset($_POST['add_form']))
{
  list($success, $message, $form_id) = ft_setup_form($_POST);

  // store the uploading_files value for the duration of this session
  $_SESSION["ft"]["uploading_files"] = $_POST['uploading_files'];

  // form successfully added. Continue to step 2.
  if ($success)
  {
    header("location: add_form2.php?form_id=$form_id");
    exit;
  }
  // error. reload the page with the already entered form values, and display 
  // the appropriate error message.
  else
    ft_preload_values("post");
}

// update this form
else if (isset($_POST['update_form']) && !empty($_POST['form_id']))
{
  // store the uploading_files value for the duration of this session
  $_SESSION["ft"]["uploading_files"] = $_POST['uploading_files'];

  list($success, $message) = ft_set_form_main_settings($_POST);
  if ($success)
  {
    header("location: add_form2.php?form_id={$_POST['form_id']}");
    exit;
  }
  else
    ft_preload_values("post", $_POST['form_id']);
}


// helper function to preload the page values from different sources, depending 
// on what's required.
function ft_preload_values($source, $form_id = "")
{
  global $g_form_type, $g_user_info, $g_form_type, $g_form_name, $g_form_url, $g_redirect_url, 
    $g_finalized_submissions, $hidden_fields;

  switch ($source)
  {
    // if the user is ADDING a form, set up default values
    case "new_form":
      $g_form_type = "direct";
      $g_user_info = array();
      $g_form_name = "";
      $g_form_url = "";
      $g_redirect_url = "";
      $g_finalized_submissions = "";

      $hidden_fields = "<input type='hidden' name='add_form' value='1' />";   
      break;

    case "post":
      $g_form_type = $_POST['form_type'];
      $g_user_info = array();
      $g_form_name = $_POST['form_name'];
      $g_form_url  = $_POST['form_url'];
      $g_redirect_url = $_POST['redirect_url'];
      $g_finalized_submissions = $_POST['finalized_submissions'];

      if (!empty($form_id))
        $hidden_fields = "<input type='hidden' name='update_form' value='1' />"
                       . "<input type='hidden' name='form_id' value='$form_id' />";
      else
        $hidden_fields = "<input type='hidden' name='add_form' value='1' />";
      break;

    // if the source is the database, use $user_id to extract the 
    case "database":

      // check we have a form id
      if (empty($form_id))
      {
        return;
      }

      $form_id = $_GET['form_id'];
      $form_info = ft_get_form($form_id);
     
      $g_user_info = $form_info['user_info'];
      $g_form_type = $form_info['form_type'];
      $g_form_name = $form_info['form_name'];
      $g_form_url  = $form_info['form_url'];
      $g_redirect_url = $form_info['redirect_url'];  
      $g_finalized_submissions = $form_info['finalized_submissions'];

      $hidden_fields = "<input type='hidden' name='update_form' value='1' />"
                     . "<input type='hidden' name='form_id' value='$form_id' />";
      break;
  }
}


// header information
$g_head_title = "{$_SESSION['ft']['program_name']} - {$LANG['phrase_add_form']}";
$g_nav_page = "";
$g_head_js = "var rules = new Array();
	rules.push(\"required,form_name,{$LANG['validation_no_form_name']}\");
	rules.push(\"required,form_url,{$LANG['validation_no_form_url']}\");
	rules.push(\"if:form_type=direct,required,redirect_url,{$LANG['validation_no_redirect_url']}\");
	rules.push(\"required,uploading_files,{$LANG['validation_form_contains_file_fields']}\");
	
	// helper function to pop open a window containing a specific URL, to verify
	// to the user that it it what they had in mind
	function verify_url(url)
	{
	  window.open(url, \"verify_url\", \"width=700,height=500,menu=no,toolbar=no\");
	}
	
	function process_form(frm)
	{
	  // check that at least one client has been assigned to this form
	  if (frm[\"selected_user_ids[]\"].length == 0)
	  { 
	    alert(\"{$LANG['validation_no_client_assigned']}\");
	    return false;
	  }
	
	  if (!validateFields(frm, rules))
	    return false;   
	    
	  // select all clients
	  select_all(frm[\"selected_user_ids[]\"]);
	
	  return true;
	}";

?>