<?php

require("../../global/library.php");
require_once("../../global/scripts/js_messages.php");
ft_check_permission("admin");
$success = false;
$message = "";

$request = array_merge($_POST, $_GET);
$user_id = isset($request['client_id']) ? $request['client_id'] : "";

// store the current selected tab in memory
if (isset($request['page']) && !empty($request['page']))
  $_SESSION["ft"]["client_{$user_id}_tab"] = $request['page'];
else
{
  if (isset($_SESSION["ft"]["client_{$user_id}_tab"]))
    $request['page'] = $_SESSION["ft"]["client_{$user_id}_tab"];
  else
    $request['page'] = "main";
}


switch ($request['page'])
{
  // styles tab
  case "styles":

    if (isset($_POST['update_client']))
    {
      list($success, $message) = ft_admin_update_client($_POST, 2);
      if ($success)
        ft_preload_style_values("database", $user_id);
      else
        ft_preload_style_values("post", $user_id);
    }

    // if a user_id is specified in query string, edit existing client
    else if (isset($user_id))
      ft_preload_style_values("database", $user_id);

    $settings = ft_get_settings();
    $default_styles = preg_replace('/\r\n/', '\\n', $settings['default_css']);
    $g_page_titles = htmlspecialchars($g_page_titles);
    $g_footer_text = htmlspecialchars($g_footer_text);    
    break;

  // styles tab
  case "permissions":  
    if (isset($_POST['update_client']))
      list($success, $message) = ft_admin_update_client($_POST, 3);
  
    $g_user_id = $request['client_id'];
    break;

  case "filters":
  	if (isset($_POST['update_client']))
  	  list($success, $message) = ft_update_client_filters($_POST, $user_id);

  	$g_user_id = $user_id;
  	$filters = ft_get_client_filters($user_id);
  	$num_filters = count($filters);

  	$g_other_clients_have_filters = false;
  	foreach ($filters as $filter)
  	{
  	  if ($filter["user_id"] != $user_id)
  	  {
  	  	$g_other_clients_have_filters = true;
  	  	break;
  	  }
  	}
  	break;
 
  // main tab
  default:

    // add new client
    if (isset($_POST['add_client']))
      ft_preload_main_values("new_client");

    // update this client
    else if (isset($_POST['update_client']))
    {    
      list($success, $message) = ft_admin_update_client($_POST, 1);

      if ($success)
        ft_preload_main_values("database", $user_id);
      else
        ft_preload_main_values("post", $user_id);
    }

    // otherwise, if a user_id is specified in query string, just edit this existing client
    else if (isset($user_id))
      ft_preload_main_values("database", $user_id);
}


// helper function to preload the page values from different sources, depending 
// on what's needed
function ft_preload_main_values($source, $user_id = "")
{
  global $g_user_id, $g_username, $g_password, $g_first_name, 
         $g_last_name, $g_company, $g_email, $g_ui_language, $hidden_fields;

  switch ($source)
  {
    case "post":
      $g_user_id     = $_POST['client_id'];
      $g_username    = $_POST['username'];
      $g_password    = $_POST['password'];
      $g_first_name  = $_POST['first_name'];
      $g_last_name   = $_POST['last_name'];
      $g_company     = $_POST['company'];
      $g_email       = $_POST['email'];
      $g_ui_language = $_POST['ui_language'];
      break;

    // if the source is the database, use $client_id to extract the info
    case "database":

      $g_user_id    = $user_id;
      $client_info  = ft_get_account_info($g_user_id);

      $g_username   = $client_info['username'];
      $g_password   = $client_info['password'];   
      $g_first_name = $client_info['first_name'];
      $g_last_name  = $client_info['last_name'];
      $g_company    = $client_info['company'];
      $g_email      = $client_info['email'];
      $g_ui_language = $client_info['ui_language'];
      break;
  }
}


// helper function to preload the page values from different sources, depending 
// on what's currently required.
function ft_preload_style_values($source, $user_id = "")
{
  global $g_user_id, $g_page_titles, $g_footer_text, $g_logo_type, $g_preset_logo, 
         $g_display_logo, $g_css, $g_ui_language, $hidden_fields;

  switch ($source)
  {
    case "post":
      $g_logo_type    = $_POST['logo_type'];
      $g_user_id      = $_POST['client_id'];
      $g_page_titles  = $_POST['page_titles'];
      $g_footer_text  = $_POST['footer_text'];
      $g_display_logo = $_POST['logo'];
      $g_css          = $_POST['css'];
      break;

    // if the source is the database, use $client_id to extract the info
    case "database":
      $g_user_id   = $user_id;
      $client_info = ft_get_account_info($g_user_id);

      $g_page_titles  = !empty($client_info['page_titles']) ? $client_info['page_titles'] : $_SESSION["ft"]["program_name"];
      $g_footer_text  = !empty($client_info['footer_text']) ? $client_info['footer_text'] : $_SESSION["ft"]["footer_text"];
      $g_display_logo = !empty($client_info['logo']) ? $client_info['logo'] : "preset_1.gif";
      $g_preset_logo  = $g_display_logo;
      $g_css          = !empty($client_info['css']) ? $client_info['css'] : $_SESSION["ft"]["css"];
      $g_ui_language  = $client_info["ui_language"];

      if (preg_match("/^logo/", $g_display_logo))
        $g_logo_type = "preset";
      else
        $g_logo_type = "custom";

      break;
  }
}

$client_info = ft_get_account_info($g_user_id);
$first_name = $client_info['first_name'];
$last_name  = $client_info['last_name'];
$forms = ft_get_client_forms($user_id);
$clients = ft_get_client_list();
$settings = ft_get_settings();

// get the list of available languages
$available_language_info = $settings["available_languages"];
$available_language_arr = explode("|", $available_language_info);


// head information
$g_head_title = "{$_SESSION['ft']['program_name']} - {$LANG["phrase_manage_client"]}";
$g_head_string = "<script type='text/javascript' src='../../global/scripts/filters.js'></script>
  <link rel='stylesheet' type='text/css' media='all' href='../../global/jscalendar/skins/aqua/theme.css' title='Aqua' />
  <script type='text/javascript' src='../../global/jscalendar/calendar.js'></script>
  <script type='text/javascript' src='../../global/jscalendar/calendar-setup.js'></script>
  <script type='text/javascript' src='../../global/jscalendar/lang/calendar-en.js'></script>
  
  <script type='text/javascript'>
  function show_logo(logo_type)
  {
    if (logo_type == 'preset')
    {
      // find the image name of the currently selected logo
      for (i=0; i<document.style_info.preset_logo.length; i++)
      {
        if (document.style_info.preset_logo[i].selected)
          logo = document.style_info.preset_logo[i].value;
      }

      // show the logo
      document.getElementById('display_logo').src = '../../images/logos/' + logo;
    }
    else if (logo_type == 'custom')
    {
      custom_logo = '$g_display_logo';
  
      // if the user has already defined a custom logo, display it
      if (custom_logo != '')
        document.getElementById('display_logo').src = '../../images/logos/' + custom_logo;
    }
  }
  
  function load_default_styles()
  {
    document.style_info.css.value = $('default_styles').innerHTML;
  }
  </script>    
    ";
$g_head_js = $js_messages;

?>