<?php

require_once("../../global/library.php");
ft_check_permission("admin");
$success = true;
$message = "";

// update the administrator's account
if (isset($_POST) && !empty($_POST))
{
  list($success, $message) = ft_update_admin_account($_POST, $_SESSION["ft"]["login_user_id"]);
  
  // if the user just changed their language file, reset the value in sessions and refresh the page
  if ($success && ($_POST["old_ui_language"] != $_POST["ui_language"]))
  {
  	$_SESSION["ft"]["ui_language"] = $_POST["ui_language"];
  	header("location: index.php?updated");
  }
}

// here, the user has just changed their ui language
if (isset($_GET["updated"]))
{
  $success = true;
  $message = $LANG["notify_account_updated"];
}

$user_info = ft_get_account_info($_SESSION["ft"]["login_user_id"]);
$settings = ft_get_settings();

// get the list of available languages
$available_language_info = $settings["available_languages"];
$available_language_arr = explode("|", $available_language_info);


// define the header information
$g_head_title = "{$_SESSION['ft']['program_name']} - {$LANG['phrase_login_info']}";
$g_head_js = "
	var rules = new Array();
	rules.push(\"required,username,{$LANG["validation_no_username"]}\");
	rules.push(\"required,password,{$LANG["validation_no_password"]}\");
  rules.push(\"same_as,password,password_2,{$LANG["validation_passwords_different"]}\");
	rules.push(\"required,ui_language,{$LANG["validation_no_ui_language"]}\");
	            ";
$g_body_onload = "document.login_info.username.focus()";
$g_nav_page = "login_information";

?>