<?php

require_once("global/library.php");

// ALWAYS reset sessions on this page
$_SESSION["ft"] = array();

// verify setup
ft_verify_setup();
$is_upgraded = ft_upgrade_form_tools();

// default settings
$g_logo = "logo_1.gif";
$g_user_id = "";
$g_css = "";
$g_query_params = "";

$settings = ft_get_settings();
$g_title = $settings['program_name'];
$g_footer = "";

// if an user id is included in the query string, use it to determine the appearance of the
// interface, including logo and footer and even language
if (isset($_GET['id']) && !empty($_GET['id']))
{
  $info = ft_get_account_info($_GET['id']);

  if (!empty($info))
  {
    $g_user_id = $_GET['id'];
    $g_css     = $info['css'];
    $g_logo    = $info['logo'];
    $g_footer  = $info['footer_text'];
    $g_title   = $info['page_titles'];

    // just in case, boot up the appropriate language file (this overrides any language file already loaded)
    $language = $info["ui_language"];
    if (!empty($language) && is_file("global/lang/{$language}.php"))
      include_once("global/lang/{$language}.php");
    
    $g_query_params = "?id=$g_user_id";
  }
}

if (isset($_POST['username']) && !empty($_POST['username']))
  $error = ft_login($_POST);

$username = (isset($_POST["username"]) && !empty($_POST["username"])) ? $_POST["username"] : "";
$password = (isset($_POST["password"]) && !empty($_POST["password"])) ? $_POST["password"] : "";

?>
