<?php

require_once("global/library.php"); 

// default settings
$g_logo = "logo_1.gif";
$g_user_id = "";
$g_css = "";
$g_query_params = "";

$settings = ft_get_settings();
$g_title = $settings['program_name'];
$admin_email = $settings['administrator_email'];

// if an user id is included in the query string, use it to determine the appearance of the 
// interface (including logo)
if (isset($_GET['id']) && !empty($_GET['id']))
{
  $info = ft_get_account_info($_GET['id']);

  if (!empty($info))
  {
    $g_user_id = $_GET['id'];
    
    $g_css = $info['css'];
    $g_logo = $info['logo'];
    $g_footer = $info['footer_text'];
    $g_title = $info['page_titles'];
  }
  
  // just in case, boot up the appropriate language file
  $language = $info["ui_language"];
  require("global/lang/{$language}.php");
  
  $g_query_params = "?id=$g_user_id";
}

$success = false;
$message = "";

// if trying to send password
if (isset($_POST) && !empty($_POST))
  list($success, $message) = ft_send_password($_POST);

$username = (isset($_POST["username"]) && !empty($_POST["username"])) ? $_POST["username"] : "";

?>
