<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * For all classes that render DOM Templates.
 * 
 * @package Dom
 */
interface Dom_RendererInterface
{
    
    /**
     * Execute the renderer.
     * 
     * @return mixed
     */
    function show();
    
    /**
     * Get the Dom_Template
     * 
     * @return Dom_Template
     */
    function getTemplate();
    
    /**
     * Set the Dom_Template
     * 
     * @param Dom_Template $template
     */
    function setTemplate($template);
    
}
?>