<?php
/*
 * This file is part of the DkLib.
 *   You can redistribute it and/or modify
 *   it under the terms of the GNU Lesser General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public License
 *   If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Michael Mifsud <info@tropotek.com>
 * @author Darryl Ross <darryl.ross@aot.com.au>
 * @link http://www.tropotek.com/
 * @license Copyright 2007 Michael Mifsud
 */

/**
 * For all classes that render dom templates.
 * 
 * @package Dom
 */
abstract class Dk_Dom_Renderer extends Dk_Object implements Dk_Dom_RendererInterface
{
    
    /**
     * @var Dom_Template
     */
    private $template = null;
    
    
    
    /**
     * Set the template.
     * NOTE: No type hinting here to allow for null templates
     * 
     * @param Dom_Template $template
     */
    function __construct($template = null) 
    {
        $this->template = $template;
    }
    
    /**
     * Set a new template for this renderer.
     * NOTE: No type hinting here to allow for null templates
     * 
     * @param Dom_Template $template
     * @todo: we should type hint here so you cannot set null values???
     */
    function setTemplate($template)
    {
    	if ($template instanceof Dom_Template) {
            $this->template = $template;
    	}
    }
    
    /**
     * Get the template
     * This method will try to call the magic method __makeTemplate
     * to get a template if non exsits.
     * Use this for object that use internal templates.
     *
     * @return Dom_Template
     */
    function getTemplate() 
    {
        if ($this->template == null && method_exists($this, '__makeTemplate')) {
            $this->template = $this->__makeTemplate();
        }
        return $this->template;
    }
}
?>