<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam team
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *

You can include a team list into your web pages using several technics
- As a simple html page (i.e. when you use a framed web site, or an iframe)
- Included in a html or php page (i.e. included in php tags or in pseudo-frame)
The code you must used is here afer.

-------------------------
Making a simple html page
-------------------------
You can ask QuickTeam to make a simple html page.
For your website, we create a new page (i.e. mylist.php) that will include the team list generated by QuickTeam.
1) Copy the code in a new file (i.e. a text file that you rename mylist.php)
2) Put the value TRUE for the variable $qte_web_head
3) In the code, update the path in the include() function; depending on where you will place this new page.
Ex: If this page is placed at the root of your website and if you have installed the QuickTeam application in a subfolder (quickteam), the code should be: include('quickteam/qte_web.php');
Ex: If this page is placed in a subfolder of your website and if you have installed the QuickTeam application in an other subfolder (quickteam), the code should be: include('../quickteam/qte_web.php');
4) Update your home page or your menu frame of your website to add a link to this page (mylist.php)

-------------------------
Include the team list in a page
-------------------------
You can ask QuickTeam to make a your quickteam list as a part of an other page.
1) Copy the code in your page (don't forget the tag <?php ?> if you include the code in a html page, remove it if you include the code in a php page)
2) Put the value FALSE for the variable $qte_web_head
3) Update your home page or your menu frame to add a link to this page (mylist.php)

-------------------------
About the ID of the team
-------------------------
The procedure here will display one of your teams from QuickTeam.
The ID of the team can be found in administration page of QuickTeam (page Manage teams).

-------------------------
Here is the code to copy
-------------------------

<?php
$qte_web_path = 'quickteam/'; // the path where the quickteam application is installed (with final /)
$qte_web_team = 1;            // the ID of the team to display
$qte_web_head = false;        // use true to include html header (i.e. if you use frames or iframe), use false if included in a php page
$qte_web_skin = 'default';    // name of the skin
$qte_web_view = 'Normal';     // Normal or Compact (small picture and only 1 phone,adress)
$qte_web_link = false;        // Add hyperlink to open the profile in the QuickTeam application
$qte_web_banner = false;      // false/true to show the banner on top of the team list
$qte_web_logo = true;         // false/true to show the logo and the team name on top of the team list
include($qte_web_path."qte_web.php");
?>

-------------------------
Here after is a sample
-------------------------
You can run this page from your website...
This will create an html page showing the Team #2 with the team logo on top.
In the example here after, $qte_web_path is empty because we assume that this page is already in the quickteam directory.
If you move this page to the parent directory, the variable must be change (for example: $qte_web_path = 'quickteam/'; ).
*/



echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/2002/REC-xhtml1-20020801/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" dir="ltr" xml:lang="en" lang="en">
<head>
<title>Test</title>
<meta http-equiv="content-type" content="text/html; charset=iso-8859-1"/>
</head>
<body>
';

$qte_web_path = '';             // the path where the quickteam application is installed (with final /)
$qte_web_team = 2;              // the ID of the team to display
$qte_web_head = false;          // use true to include html header (i.e. if you use frames or iframe), use false if included in a php page
$qte_web_skin = 'professional'; // name of the skin
$qte_web_view = 'Normal';       // Normal or Compact (small picture and only 1 phone,adress)
$qte_web_link = true;           // Add hyperlink to allow opening profiles in the QuickTeam application
$qte_web_banner = false;        // false/true to show the banner on top of the team list
$qte_web_logo = true;           // false/true to show the logo and the team name on top of the team list
include($qte_web_path."qte_web.php");

// -- END OF PHP CODE TO BE COPIED ---

echo '</body></html>';

?>