<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Adressbook
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 */

session_start();

// Check application path

if ( !isset($qte_web_path) ) die('Missing variable $qte_web_path in your web page.');
if ( substr($qte_web_path,-1,1)!='/' ) $qte_web_path .= '/';
$qte_root = $qte_web_path;

// include ini

require_once($qte_root.'bin/qte_init.php');
if ( !$oVIP->CanAccess('MUV',2,true) ) $oVIP->EndMessage('!',$L['R_user'],$qte_root.'skin/default',0);

// ---------
// INITIALISE
// ---------

$intLimit = 0;
$strGroup = 'all';
$strOrder = 'lastname';
$strDirec = 'ASC';
$intPage  = 1;

// security check 1
if ( isset($_GET['s']) )     $qte_web_team = strip_tags($_GET['s']);
if ( isset($_GET['group']) ) $strGroup = strip_tags($_GET['group']);
if ( isset($_GET['order']) ) $strOrder = strip_tags($_GET['order']);
if ( isset($_GET['dir']) )   $strDirec = strip_tags($_GET['dir']);
if ( isset($_GET['page']) )  $intPage = intval(strip_tags($_GET['page']));

// security check 2 (no long argument)
if ( strlen($strGroup)>4 ) die('Invalid argument #group');
if ( strlen($strOrder)>12 ) die('Invalid argument #order');
if ( strlen($strDirec)>4 ) die('Invalid argument #dir');

// web setting
if ( !isset($qte_web_team) ) die('Missing team id...');
if ( !isset($qte_web_head) ) $qte_web_head = true;
if ( !isset($qte_web_skin) ) $qte_web_skin = 'default';
if ( !isset($qte_web_view) ) $qte_web_view = 'N';
if ( !isset($qte_web_banner) ) $qte_web_banner = true;
if ( !isset($qte_web_logo) ) $qte_web_logo = false;

// view setting
$_SESSION[QT]['viewmode'] = substr(strtoupper($qte_web_view),0,1);
$intLimit = ($intPage-1)*$_SESSION[QT]['items_per_page'];
$strShowZ = ''; if ( !$_SESSION[QT]['show_Z'] ) $strShowZ = ' AND u.status<>"Z"';

require_once($qte_root.'bin/qte_fn_limitsql.php');

$oSEC = new cSection($oDB,$qte_web_team);

if ( $oSEC->type==1 && ($oVIP->role=='V' || $oVIP->role=='U') )
{
  // exit
  $oVIP->selfname = $L['Section'];
  $oVIP->exitname = $_SESSION[QT]['section_index'];
  $oVIP->EndMessage(NULL,$L['R_staff'],$qte_root.'skin/default',0);
}
if ( $oSEC->type==2 && $oVIP->role=='V' )
{
  // exit
  $oVIP->selfname = $L['Section'];
  $oVIP->exitname = $_SESSION[QT]['section_index'];
  $oVIP->EndMessage(NULL,$L['R_user'],$qte_root.'skin/default',0);
}

$oVIP->selfurl = 'qte_web.php';
$oVIP->selfname = $L['Section'].': '.$oSEC->title;

// COUNT [$intMembers]

$strWhereGroup = '';
Switch ($strGroup)
{
  Case 'all': $strWhereGroup .= ' AND u.id>0'; Break;
  Case '0':   $strWhereGroup .= ' AND '.FirstCharCase($oDB,'u.lastname','a-z'); Break;
  Default:    $strWhereGroup .= ' AND '.FirstCharCase($oDB,'u.lastname','u').'="'.$strGroup.'"'; Break;
}
$oDB->Query('SELECT count(*) as countid FROM '.TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid=u.id WHERE l.sid='.$oSEC->id.$strShowZ.$strWhereGroup);
$row = $oDB->Getrow();
$intMembers = $row['countid'];

// LETTRES BAR [$strGroups]

if ( $intMembers>$_SESSION[QT]['items_per_page'] || isset($_GET['group']) )
{
  $strGroups = '<td class="td_lettres" style="width:35px;">'.($strGroup=='all' ? '<b>'.$L['All'].'</b>' : '<a class="a_lettres" href="'.$oVIP->selfurl.'?s='.$qte_web_team.'&amp;group=all">'.$L['All'].'</a>' ).'</td>';
  for ($g='A';$g!='AA';$g++)
  {
  $strGroups .= '<td class="td_lettres" style="width:18px;">'.($strGroup==$g ? '<b>'.$g.'</b>' : '<a class="a_lettres" href="'.$oVIP->selfurl.'?s='.$qte_web_team.'&amp;group='.$g.'">'.$g.'</a>' ).'</td>';
  }
  $strGroups .= '<td class="td_lettres" style="width:18px;">'.($strGroup=='0' ? '<b>#</b>' : '<a class="a_lettres" href="'.$oVIP->selfurl.'?s='.$qte_web_team.'&amp;group=0">#</a>' ).'</td>';
  $strGroups .= '<td class="td_hidden">&nbsp; '.$intMembers.($strGroup!='all' ? ' / '.$oSEC->members : '' ).S.LangS('User',$oSEC->members,$L,false).'</td>'.N;
}

// --------
// Pager
// --------

$strPager = MakePager("$oVIP->selfurl?s={$oSEC->id}&group=$strGroup",$intMembers,$_SESSION[QT]['items_per_page'],$intPage,$L); 
if ( $strPager!='' ) $strPager = $L['Page'].$strPager;

// --------
// HTML START
// --------

if ( $qte_web_head )
{
  HtmlDtd();
  HtmlHead($qte_root,'skin/'.$qte_web_skin,'','',true);
  echo '<body>';
}
else
{
  echo '
  <link rel="stylesheet" type="text/css" href="',$qte_root,'skin/',$qte_web_skin,'/qte_main.css"/>
  <link rel="shortcut icon" href="',$qte_root,'skin/',$qte_web_skin,'/qte_icon.ico"/>
  <script type="text/javascript" src="',$qte_root,'bin/qte_j_common.js"></script>
  ';
}

// --------
// Display banner
// --------

if ( $qte_web_banner ) HtmlBanner(0,$qte_root.'skin/'.$qte_web_skin);

// --------
// Display logo
// --------

if ( $qte_web_logo )
{
  echo '<!-- Section description -->',N;
  $oSEC->ShowInfo(
    'tab_si_section',
    'p_si_name_section',
    'p_si_descr_section',
    'img_si_section',
    'left',
    null,
    $qte_root);
  echo '<!-- end section description -->',N,N;
}

// --------
// Display no members
// --------

if ( $intMembers==0 )
{
  echo '<p>',$L['E_no_member'],'</p>';
  if ( $qte_web_head ) echo '</body></html>';
  exit;
}

// --------
// Display letters bar
// --------

if ( $intMembers>$_SESSION[QT]['items_per_page'] || isset($_GET['group']) ) echo '<br/><table class="tab_button" cellspacing="0"><tr>',N,$strGroups,N,'</tr></table><br/>',N;

// --------
// Display top pager
// --------

if ( $strPager )
{
echo '
<!-- Pager -->
<table class="tab_pager tab_pager_top" cellspacing="0">
<tr class="tr_pager tr_pager_top">
<td class="td_pager td_pager_top">',$strPager,'</td>
</tr>
</table>
<!-- End pager -->
';
}

// --------
// Display members
// --------

echo '<table class="tab_cnt tab_cnt_member" cellspacing="0">',N;
echo '<tr class="tr_cnt">',N;

  // ----------
  $arrPageFields = GetUsableFields($qte_fields,$oSEC->forder,'nid');
  // Add infofield (if exist)
  if ( isset($_SESSION[QT]['infofield']) ) {
  if ( !empty($_SESSION[QT]['infofield']) ) {
    $arrPageFields[]=$_SESSION[QT]['infofield'];
  }}

  // ----------
  // Prepare fields

  $arrFields = array();
  foreach($arrPageFields as $i => $strField)
  {
    if ( isset($qte_fields[$strField]) )
    {
      // extraclass
      $strExtraclass = '';
      if ( $i==0 ) $strExtraclass=' th_s_first';
      if ( $i>=(count($arrPageFields)-1) ) $strExtraclass=' th_s_last';
      
      // define the fields (sort must be false in webpage rendering)
      switch ($strField)
      {
      case 'fullname':$arrFields[$strField]=array('sort'=>false,'dir'=>'ASC', 'text'=>$qte_fields[$strField][0],'class'=>'th_s th_s_'.$strField.$strExtraclass); break;
      case 'status_i':$arrFields[$strField]=array('sort'=>false,'dir'=>'ASC', 'text'=>' &bull; ',               'class'=>'th_s th_s_'.$strField.$strExtraclass); break;
      case 'address': $arrFields[$strField]=array('sort'=>false,'dir'=>'ASC', 'text'=>$qte_fields[$strField][0],'class'=>'th_s th_s_'.$strField.$strExtraclass); break;
      case 'descr':   $arrFields[$strField]=array('sort'=>false,'dir'=>'ASC', 'text'=>$qte_fields[$strField][0],'class'=>'th_s th_s_'.$strField.$strExtraclass); break;
      case 'picture': $arrFields[$strField]=array('sort'=>false,'dir'=>'ASC', 'text'=>$qte_fields[$strField][0],'class'=>'th_s th_s_'.$strField.$strExtraclass); break;
      case 'phones':  $arrFields[$strField]=array('sort'=>false,'dir'=>'ASC', 'text'=>$qte_fields[$strField][0],'class'=>'th_s th_s_'.$strField.$strExtraclass); break;
      case 'age':     $arrFields[$strField]=array('sort'=>false,'dir'=>'DESC','text'=>$qte_fields[$strField][0],'class'=>'th_s th_s_'.$strField.$strExtraclass); break;
      case 'emails':  $arrFields[$strField]=array('sort'=>false,'dir'=>'ASC', 'text'=>$qte_fields[$strField][0],'class'=>'th_s th_s_'.$strField.$strExtraclass); break;
      case 'emails_i':$arrFields[$strField]=array('sort'=>false,'dir'=>'ASC', 'text'=>$qte_fields['emails'][0], 'class'=>'th_s th_s_'.$strField.$strExtraclass); break;
      default:        $arrFields[$strField]=array('sort'=>false,'dir'=>'ASC', 'text'=>$qte_fields[$strField][0],'class'=>'th_s th_s_'.$strField.$strExtraclass); break;
      }      
    }
  }
  // ----------
  TableHeader($arrFields,$intMembers,"$oVIP->selfurl?s=$qte_web_team&amp;page=1",$strOrder,$strDirec);
  // ----------

echo '</tr>',N;

  foreach ($arrFields as $strKey => $arrValues) { $arrFields[$strKey]['class']=str_replace('th_','td_',$arrFields[$strKey]['class']); }
  // ----------
  $strState  = 'u.* FROM '.TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid=u.id WHERE l.sid='.$oSEC->id.$strShowZ.$strWhereGroup;
  if ( $strOrder=='fullname' ) $strOrder='lastname';
  $oDB->Query( LimitSQL($oDB->type,$strState,$strOrder.' '.$strDirec,$intLimit,$_SESSION[QT]['items_per_page'],$intMembers) );
  // ----------
  $strSkin = 'skin/'.$qte_web_skin;
  include($qte_root.'qte_ind_inc.php');
  // ----------

echo '<tr class="tr_cnt">',N;
echo '<td class="tf_s tf_s_first"></td>',N;
For ($i=0;$i<(count($arrFields)-2);$i++)
{
echo '<td class="tf_s"></td>',N;
}
echo '<td class="tf_s tf_s_last"></td>',N;
echo '</tr>',N;
echo '</table>',N,N;

// --------
// Display bottom pager
// --------

if ( $strPager )
{
echo '
<!-- Pager -->
<table class="tab_pager tab_pager_bot" cellspacing="0">
<tr class="tr_pager tr_pager_bot">
<td class="td_pager td_pager_bot">',$strPager,'</td>
</tr>
</table>
<!-- End pager -->
';
}

// --------
// HTML END
// --------

echo '
<!-- COPYRIGHT LINE -->
<div class="div_footer">
<table class="tab_hidden">
<tr class="tr_hidden">
<td class="td_hidden" id="zone_footer_left">&nbsp;</td>
<td class="td_hidden" id="zone_footer_right"><a href="',$_SESSION[QT]['site_url'],'/qte_index.php" class="a_footer_copy">',$_SESSION[QT]['site_name'],'</a></td>
</tr>
</table>
</div>
<!-- END COPYRIGHT LINE -->
';

if ( $qte_web_head ) echo '</body></html>';

?>