<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( !$oVIP->CanAccess('MUV',4,true) ) $oVIP->EndMessage('!',$L['R_user'],$_SESSION[QT]['skin_dir'],0);

// --------
// INITIALISE
// --------

include('bin/qt_lib_smtp.php');
include($_SESSION[QT]['language'].'/qte_lang_reg.inc');

$oVIP->selfurl = 'qte_usr_t.php';
$oVIP->selfname = $L['TProfile'];

$id = -1;
if ( isset($_GET['id']) ) $id = intval(strip_tags($_GET['id']));
if ( isset($_POST['id']) ) $id = intval(strip_tags($_POST['id']));
if ( $id<0 ) die('Wrong id in '.$oVIP->selfurl);

if ( !isset($_SESSION[QT]['willedit']) ) $_SESSION[QT]['willedit']=false;
if ( isset($_GET['editstart']) ) $_SESSION[QT]['willedit']=true;
if ( isset($_GET['editstop']) ) $_SESSION[QT]['willedit']=false;

$bEdit = false;
if ( $oVIP->role=='A' || $oVIP->role=='M' ) $bEdit=true;
if ( $oVIP->id==$id && $_SESSION[QT]['member_right']=='2' ) $bEdit=true;
if ( $id<1 ) $bEdit=false;

$oUser = new cUser($oDB,$id,$qte_fields,$oVIP); // privatise

if ( isset($_SESSION[QT]['section']) ) {
if ( $_SESSION[QT]['section']>=0 ) {
  $oSEC = new cSection($oDB,$_SESSION[QT]['section']);
}}

$arrTeamFields = GetUsableFields($qte_fields,GetFields('team'));

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  if ( empty($qte_error) && isset($_POST['teamid1']) ) $oUser->teamid1 = ( get_magic_quotes_gpc() ? stripslashes(strip_tags($_POST['teamid1'])) : strip_tags($_POST['teamid1']) );
  if ( empty($qte_error) && isset($_POST['teamid2']) ) $oUser->teamid2 = ( get_magic_quotes_gpc() ? stripslashes(strip_tags($_POST['teamid2'])) : strip_tags($_POST['teamid2']) );
  if ( empty($qte_error) && isset($_POST['teamrole1']) ) $oUser->teamrole1 = ( get_magic_quotes_gpc() ? stripslashes(strip_tags($_POST['teamrole1'])) : strip_tags($_POST['teamrole1']) );
  if ( empty($qte_error) && isset($_POST['teamrole2']) ) $oUser->teamrole2 = ( get_magic_quotes_gpc() ? stripslashes(strip_tags($_POST['teamrole2'])) : strip_tags($_POST['teamrole2']) );
  if ( empty($qte_error) && isset($_POST['teamvalue1']) )
  {
    if ( is_numeric($_POST['teamvalue1']) ) $oUser->teamvalue1 = strip_tags($_POST['teamvalue1']);
  }
  if ( empty($qte_error) && isset($_POST['teamvalue2']) )
  {
    if ( is_numeric($_POST['teamvalue2']) ) $oUser->teamvalue2 = strip_tags($_POST['teamvalue2']);
  }
  if ( empty($qte_error) && isset($_POST['teamflag1']) ) $oUser->teamflag1 = ( get_magic_quotes_gpc() ? stripslashes(strip_tags($_POST['teamflag1'])) : strip_tags($_POST['teamflag1']) );
  if ( empty($qte_error) && isset($_POST['teamflag2']) ) $oUser->teamflag2 = ( get_magic_quotes_gpc() ? stripslashes(strip_tags($_POST['teamflag2'])) : strip_tags($_POST['teamflag2']) );
  if ( empty($qte_error) && isset($_POST['descr']) ) $oUser->descr = ( get_magic_quotes_gpc() ? stripslashes(strip_tags($_POST['descr'])) : strip_tags($_POST['descr']) );
  if ( empty($qte_error) && isset($_POST['teamdate1_y']) )
  {
    if ( empty($_POST['teamdate1_y']) || empty($_POST['teamdate1_d']) || empty($_POST['teamdate1_d']) )
    {
      $oUser->teamdate1 = '0';
    }
    else
    {
      $i = intval($_POST['teamdate1_y'])*10000+intval($_POST['teamdate1_m'])*100+intval($_POST['teamdate1_d']);
      // futur checking
      switch($qte_fields['teamdate1'][1])
      {
      case '0': if ( !QTisvaliddate($i,true,true) ) $qte_error = $qte_fields['teamdate1'][0].' ('.$_POST['teamdate1_y'].'-'.$_POST['teamdate1_m'].'-'.$_POST['teamdate1_d'].') '.$L['E_invalid'];
      case '1': if ( $i>intval(date('Ymd')) ) $qte_error = $L['No_future'][1].' '.$qte_fields['teamdate1'][0].' ('.$_POST['teamdate1_y'].'-'.$_POST['teamdate1_m'].'-'.$_POST['teamdate1_d'].') '.$L['E_invalid'];
      case '2': if ( !QTisvaliddate($i,true,false) ) $qte_error = $L['No_future'][2].' '.$qte_fields['teamdate1'][0].' ('.$_POST['teamdate1_y'].'-'.$_POST['teamdate1_m'].'-'.$_POST['teamdate1_d'].') '.$L['E_invalid'];
      }
      $oUser->teamdate1 = $i; // register the new value
    }
  }
  if ( empty($qte_error) && isset($_POST['teamdate2_y']) )
  {
    if ( empty($_POST['teamdate2_y']) || empty($_POST['teamdate2_d']) || empty($_POST['teamdate2_d']) )
    {
      $oUser->teamdate2 = '0';
    }
    else
    {
      $i = intval($_POST['teamdate2_y'])*10000+intval($_POST['teamdate2_m'])*100+intval($_POST['teamdate2_d']);
      // futur checking
      switch($qte_fields['teamdate2'][1])
      {
      case '0': if ( !QTisvaliddate($i,true,true) ) $qte_error = $qte_fields['teamdate2'][0].' ('.$_POST['teamdate2_y'].'-'.$_POST['teamdate2_m'].'-'.$_POST['teamdate2_d'].') '.$L['E_invalid'];
      case '1': if ( $i>intval(date('Ymd')) ) $qte_error = $L['No_future'][1].' '.$qte_fields['teamdate2'][0].' ('.$_POST['teamdate2_y'].'-'.$_POST['teamdate2_m'].'-'.$_POST['teamdate2_d'].') '.$L['E_invalid'];
      case '2': if ( !QTisvaliddate($i,true,false) ) $qte_error = $L['No_future'][2].' '.$qte_fields['teamdate2'][0].' ('.$_POST['teamdate2_y'].'-'.$_POST['teamdate2_m'].'-'.$_POST['teamdate2_d'].') '.$L['E_invalid'];
      }
      $oUser->teamdate2 = $i; // register the new value
    }
  }

  // update
  if ( empty($qte_error) )
  {
    $oUser->privacy = str_replace('descr;','',$oUser->privacy);
    if ( isset($_POST['hiddendescr']) ) $oUser->privacy .= 'descr;';

    // save changes
    $oDB->Query('UPDATE '.TABUSER.' SET teamid1="'.$oUser->teamid1.'",teamid2="'.$oUser->teamid2.'",teamrole1="'.$oUser->teamrole1.'",teamrole2="'.$oUser->teamrole2.'"'.(is_numeric($oUser->teamvalue1) ? ',teamvalue1='.$oUser->teamvalue1 : '').(is_numeric($oUser->teamvalue2) ? ',teamvalue2='.$oUser->teamvalue2 : '').',teamflag1="'.$oUser->teamflag1.'",teamflag2="'.$oUser->teamflag2.'",teamdate1="'.$oUser->teamdate1.'",teamdate2="'.$oUser->teamdate2.'",descr="'.$oUser->descr.'",privacy="'.$oUser->privacy.'" WHERE id='.$id);

    // update index
    $oUser->SaveKeywords($oDB,$oUser->GetKeywords(GetFields('index_t')));

    // exit
    $strInfo = $L['S_save'];
  }
}

// --------
// HTML START
// --------

include('qte_p_header.php');

// -- BUTTON BAR & TITLE --

if ( $oVIP->role=='A' || $oVIP->role=='M' ) include('qte_usr_menu.php');
include('qte_usr_tabtop.php');

// -- DISPLAY PROFILE --

echo '
<table class="tab_hidden" cellspacing="0">
<colgroup span="2">
<col width="175"></col>
<col></col>
</colgroup>
<tr class="tr_hidden">
<td class="td_hidden">
';
  include('qte_usr_inc.php');
  if ( $bEdit && $_SESSION[QT]['willedit'] )
  echo '<br/><br/><div class="div_pic_box"><span style="font-size:7pt"><b>',$L['Help'],'</b><br/><br/>',$L['H_hidden_fields'],'</span></div>';
echo '</td>',N;

echo '<td class="td_hidden">',N;

if ( $bEdit && $_SESSION[QT]['willedit'] ) echo '<form method="post" action="',$oVIP->selfurl,'?id='.$id.'">',N;

echo '<table class="tab_cnt" cellspacing="0">',N;
echo '<colgroup span="3"><col width="130"></col><col></col><col width="120"></col></colgroup>',N;

echo '
<tr class="tr_cnt">
<th class="th_u th_u_first th_u_empty"></th>
<th class="th_u th_u_empty"></th>
<th class="th_u th_u_last th_u_empty"></th>
</tr>
';

foreach ($arrTeamFields as $strField)
{
  echo '<tr>';
  echo '<th class="th_u">',$qte_fields[$strField][0],'</th>';

  switch($strField)
  {
    // --------------
    case 'teamdate1':
    // --------------
    echo '<td class="td_u">';
    if ( $bEdit && $_SESSION[QT]['willedit'] )
    {
      $strTeamdate_y = '';
      $strTeamdate_m = '';
      $strTeamdate_d = '';
      if ( !empty($oUser->$strField) )
      {
      $strTeamdate_y = intval(substr(strval($oUser->$strField),0,4));
      $strTeamdate_m = intval(substr(strval($oUser->$strField),4,2));
      $strTeamdate_d = intval(substr(strval($oUser->$strField),6,2));
      }
      echo '<select name="',$strField,'_d" size="1"/>',N;
      echo QTastags(array(0=>'',1=>1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31),null,$strTeamdate_d);
      echo '</select>',N;
      echo '<select name="',$strField,'_m" size="1"/>',N;
      echo '<option value="0"></option>',QTastags($L['dateMMM'],null,$strTeamdate_m);
      echo '</select>',N;
      echo '<input type="text" id="',$strField,'_y" name="',$strField,'_y" size="4" maxlength="4" value="',$strTeamdate_y,'"/>',N;
    }
    else
    {
      echo (!empty($oUser->$strField) ? QTdate($oUser->$strField,$arrQTdate) : S);
    }
    echo '</td><td class="td_u">&nbsp;</td>',N;
    break;
    // --------------
    case 'teamdate2':
    // --------------
    echo '<td class="td_u">';
    if ( $bEdit && $_SESSION[QT]['willedit'] )
    {
      $strTeamdate_y = '';
      $strTeamdate_m = '';
      $strTeamdate_d = '';
      if ( !empty($oUser->$strField) )
      {
      $strTeamdate_y = intval(substr(strval($oUser->$strField),0,4));
      $strTeamdate_m = intval(substr(strval($oUser->$strField),4,2));
      $strTeamdate_d = intval(substr(strval($oUser->$strField),6,2));
      }
      echo '<select name="',$strField,'_d" size="1"/>',N;
      echo QTastags(array(0=>'',1=>1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31),null,$strTeamdate_d);
      echo '</select>',N;
      echo '<select name="',$strField,'_m" size="1"/>',N;
      echo '<option value="0"></option>',QTastags($L['dateMMM'],null,$strTeamdate_m);
      echo '</select>',N;
      echo '<input type="text" id="',$strField,'_y" name="',$strField,'_y" size="4" maxlength="4" value="',$strTeamdate_y,'"/>',N;
    }
    else
    {
      echo (!empty($oUser->$strField) ? QTdate($oUser->$strField,$arrQTdate) : S);
    }
    echo '</td><td class="td_u">&nbsp;</td>',N;
    break;
    // --------------
    case 'teamvalue1':
    // --------------
    echo '<td class="td_u">';
    if ( $bEdit && $_SESSION[QT]['willedit'] )
    {
      if ( strstr($qte_fields[$strField][1],' ; ') )
      {
      echo '<select id="',$strField,'" name="',$strField,'">';
      echo QTastags(AsPopupList($qte_fields[$strField][1]),null,$oUser->$strField);
      echo '</select>';
      }
      else
      {
      echo '<input class="small" type="text" id="',$strField,'" name="',$strField,'" size="32" maxlength="32" value="',$oUser->$strField,'"/>';
      }
    }
    else
    {
      echo (is_numeric($oUser->$strField) ? AsFormat($oUser->$strField,$qte_fields[$strField]) : S);
    }
    echo '</td><td class="td_u">&nbsp;</td>',N;
    break;
    // --------------
    case 'teamvalue2':
    // --------------
    echo '<td class="td_u">';
    if ( $bEdit && $_SESSION[QT]['willedit'] )
    {
      if ( strstr($qte_fields[$strField][1],' ; ') )
      {
      echo '<select id="',$strField,'" name="',$strField,'">';
      echo QTastags(AsPopupList($qte_fields[$strField][1]),null,$oUser->$strField);
      echo '</select>';
      }
      else
      {
      echo '<input class="small" type="text" id="',$strField,'" name="',$strField,'" size="32" maxlength="32" value="',$oUser->$strField,'"/>';
      }
    }
    else
    {
      echo (is_numeric($oUser->$strField) ? AsFormat($oUser->$strField,$qte_fields[$strField]) : S);
    }
    echo '</td><td class="td_u">&nbsp;</td>',N;
    break;
    // --------------
    case 'descr':
    // --------------
    if ( $bEdit && $_SESSION[QT]['willedit'] )
    {
      echo '<td class="td_u"><textarea class="small" id="',$strField,'" name="',$strField,'" rows="4" cols="32">',strip_tags($oUser->$strField),'</textarea></td>';
      echo '<td class="td_u"><input type="checkbox" id="hiddendescr" name="hiddendescr"',(strstr($oUser->privacy,'descr') ? QCHE : ''),'/><label for="hiddendescr">',$L['Hidden'],'</label></td>';
    }
    else
    {
      echo '<td class="td_u">',(!empty($oUser->$strField) ? AsFormat($oUser->$strField,$qte_fields[$strField]) : S),'</td>';
      echo '<td class="td_u">&nbsp;</td>',N;
    }
    break;
    // --------------
    default:
    // --------------
    echo '<td class="td_u">';
    if ( $bEdit && $_SESSION[QT]['willedit'] )
    {
      if ( in_array($strField,array('teamrole1','teamrole2','teamvalue1','teamvalue2','teamflag1','teamflag2')) && strstr($qte_fields[$strField][1],' ; ') )
      {
      echo '<select id="',$strField,'" name="',$strField,'">';
      echo QTastags(AsPopupList($qte_fields[$strField][1]),null,$oUser->$strField);
      echo '</select>';
      }
      else
      {
      echo '<input class="small" type="text" id="',$strField,'" name="',$strField,'" size="32" maxlength="32" value="',$oUser->$strField,'"/>';
      }
    }
    else
    {
      echo (!empty($oUser->$strField) ? AsFormat($oUser->$strField,$qte_fields[$strField]) : S);
    }
    echo '</td><td class="td_u">&nbsp;</td>',N;
    break;
  }

  echo '</tr>',N;
}

if ( $bEdit && $_SESSION[QT]['willedit'] )
{
  echo '<tr><th class="th_u_submit" colspan="3">';
  if ( !empty($qte_error) ) echo '<span class="error">',$qte_error,'</span> ';
  if ( empty($qte_error) && !empty($qte_warning) ) echo '<span class="warning">',$qte_warning,'</span> ';
  if ( empty($qte_error) && isset($strInfo) ) echo '<span id="infomessage">',$strInfo,'</span> ';
  echo '<input type="hidden" name="id" value="',$id,'"/><input type="submit" name="ok" value="',$L['Save'],'"/></th></tr>';
}

echo '
<tr class="tr_cnt">
<td class="tf_u tf_u_first"></td>
<td class="tf_u"></td>
<td class="tf_u tf_u_last"></td>
</tr>
</table>
';

if ( $bEdit && $_SESSION[QT]['willedit'] ) echo '</form>';

echo '
</td>
</tr>
</table>
';

include('qte_usr_tabbot.php');

if ( $bEdit && $_SESSION[QT]['willedit'] && isset($strInfo) )
{
echo '
<script type="text/javascript">
<!--
setTimeout(\'document.getElementById("infomessage").style.color="#bbbbbb"\',3000);
setTimeout(\'document.getElementById("infomessage").style.color="#cccccc"\',3300);
setTimeout(\'document.getElementById("infomessage").style.color="#dddddd"\',3600);
setTimeout(\'document.getElementById("infomessage").innerHTML="&nbsp;"\',3900);
-->
</script>
';
}

// --------
// HTML END
// --------

include('qte_p_footer.php');

?>