<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */ 

session_start();
require_once('bin/qte_init.php');
if ( !$oVIP->CanAccess('MUV',4,true) ) $oVIP->EndMessage('!',$L['R_user'],$_SESSION[QT]['skin_dir'],0);

// --------
// INITIALISE
// --------

include('bin/qt_lib_smtp.php');
Include($_SESSION[QT]['language'].'/qte_lang_reg.inc');

$oVIP->selfurl = 'qte_usr_s.php';
$oVIP->selfname = $L['SProfile'];

$id = -1;
if ( isset($_GET['id']) ) $id = intval(strip_tags($_GET['id']));
if ( isset($_POST['id']) ) $id = intval(strip_tags($_POST['id']));
if ( $id<0 ) die('Wrong id in '.$oVIP->selfurl);

if ( !isset($_SESSION[QT]['willedit']) ) $_SESSION[QT]['willedit']=false;
if ( isset($_GET['editstart']) ) $_SESSION[QT]['willedit']=true;
if ( isset($_GET['editstop']) ) $_SESSION[QT]['willedit']=false;

$bEdit = false;
if ( $oVIP->role=='A' || $oVIP->role=='M' ) $bEdit=true;
if ( $id<1 ) $bEdit=false;

$oUser = new cUser($oDB,$id,$qte_fields,$oVIP); // privatise

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  // registration date
  if ( empty($qte_error) )
  {
    if ( empty($_POST['reg_y']) || empty($_POST['reg_m']) || empty($_POST['reg_d']) )
    {
      $oUser->firstdate = '0';
    }
    else
    {
      $i = intval($_POST['reg_y'])*10000+intval($_POST['reg_m'])*100+intval($_POST['reg_d']);
      $oUser->firstdate = $i;
    }
  }

  // SAVE
  if ( empty($qte_error) )
  {
    $oDB->Query('UPDATE '.TABUSER.' SET firstdate="'.$oUser->firstdate.'" WHERE id='.$id);

    // Exit
    $strInfo = $L['S_save'];
  }

}

// --------
// HTML START
// --------

$bJava=false;
include('qte_p_header.php');

// -- BUTTON BAR & TITLE --

if ( $oVIP->role=='A' || $oVIP->role=='M' ) include('qte_usr_menu.php');
include('qte_usr_tabtop.php');

// -- QUERY USER --

$strReg_y = '';
$strReg_m = '';
$strReg_d = '';
if ( !empty($oUser->firstdate) )
{
  $strReg_y = intval(substr(strval($oUser->firstdate),0,4));
  $strReg_m = intval(substr(strval($oUser->firstdate),4,2));
  $strReg_d = intval(substr(strval($oUser->firstdate),6,2));
}

// -- DISPLAY PROFILE --

echo '
<table class="tab_hidden" cellspacing="0">
<colgroup span="2">
<col width="175"></col>
<col></col>
</colgroup>
<tr class="tr_hidden">
<td class="td_hidden">
';
include('qte_usr_inc.php');
echo '</td>',N;

echo '<td class="td_hidden">',N;

if ( $bEdit && $_SESSION[QT]['willedit'] ) echo '<form method="post" action="qte_usr_s.php?id='.$id.'">',N;
echo '<table class="tab_cnt" cellspacing="0">',N;
echo '<colgroup span="3"><col width="130"></col><col></col><col width="150"></col></colgroup>',N;

echo '<tr class="tr_cnt">
<th class="th_u th_u_first th_u_empty"></th>
<th class="th_u th_u_empty"></th>
<th class="th_u th_u_last th_u_empty"></th>
</tr>
';

echo '<tr>',N;
echo '<th class="th_u">Id</th>',N;
echo '<td class="td_u">',$id,'</td>',N;
echo '<td class="td_u">&nbsp;</td>',N;
echo '</tr>',N;

echo '<tr>',N;
echo '<th class="th_u">',$qte_fields['username'][0],'</th>',N;
echo '<td class="td_u">',AsFormat($oUser->username,$qte_fields['username']),'</td>',N;
echo '<td class="td_u">';
if ( $oVIP->role=='A' || ($oVIP->id==$id && QTE_CHANGE_USERNAME) ) {
if ( $id>1 ) {
  echo '<a class="small" href="qte_usr_rename.php?id=',$id,'">',$L['Change_name'],'</a>';
}}
echo '&nbsp;</td>
</tr>
';
echo '<tr>',N;
echo '<th class="th_u">',$L['Password'],'</th>',N;
echo '<td class="td_u">&bull;&bull;&bull;&bull;&bull;&bull;&bull;&bull;</td>',N;
echo '<td class="td_u">';
if ( $oVIP->role=='A' || $oVIP->id==$id ) {
  echo '<a class="small" href="qte_usr_pwd_chg.php?id=',$id,'">',$L['Change_password'],'</a>';
}
echo '&nbsp;</td>
</tr>
';
echo '<tr>',N;
echo '<th class="th_u">',$L['Picture'],'</th>',N;
echo '<td class="td_u">',(empty($oUser->picture) ? $L['None'] : $L['Y']),'</td>',N;
echo '<td class="td_u">';
if ( $oVIP->role=='A' || $oVIP->id==$id ) {
  echo '<a class="small" href="qte_usr_img.php?id=',$id,'">',$L['Change_picture'],'</a>';
}
echo '&nbsp;</td>
</tr>
';
echo '<tr>',N;
echo '<th class="th_u">System role</th>',N;
echo '<td class="td_u">',$L['Userrole'][$oUser->role],'</td>',N;
echo '<td class="td_u">';
if ( $oVIP->role=='A' || $oVIP->role=='M' ) {
if ( $id>1 ) {
  echo '<a class="small" href="qte_cmd.php?a=userrole&amp;u=',$id,'">',$L['Change_role'],'</a>';
}}
echo '&nbsp;</td>',N;
echo '</tr>',N;

echo '<tr><th class="th_u">Registration</th>',N;
if ( $bEdit && $_SESSION[QT]['willedit'] )
{
  echo '<td class="td_u"><select name="reg_d" size="1"/>',N;
  echo QTastags(array(0=>'',1=>1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31),null,$strReg_d);
  echo '</select>',N;
  echo '<select name="reg_m" size="1"/>',N;
  echo '<option value="0"></option>',QTastags($L['dateMMM'],null,$strReg_m);
  echo '</select>',N;
  echo '<input type="text" id="breg_y" name="reg_y" size="4" maxlength="4" value="',$strReg_y,'"/></td><td class="td_u">',N;
  echo '</td>',N;
}
else
{
  echo '<td class="td_u">',(!empty($oUser->firstdate) ? QTdate($oUser->firstdate,$arrQTdate) : S),'</td><td class="td_u">&nbsp;</td>',N;
}
echo '</tr>',N;


// Index statistics

$arrIndex = array();
$oDB->Query('SELECT ufield,ukey FROM '.TABINDEX.' WHERE userid='.$id);
$i=0;
while( $row = $oDB->Getrow() )
{
  $arrIndex[] = '('.$row['ufield'].') '.strtolower($row['ukey']);
  if ( $i>30 ) { $arrIndex[] = '...'; break; }
  $i++  ;
}
echo '<tr><th class="th_u">Index keys</th>',N;
if ( $bEdit && $_SESSION[QT]['willedit'] && ($oVIP->role=='A' || $oVIP->role=='M') )
{
  echo '<td class="td_u">',count($arrIndex);
  if ( count($arrIndex)>0 ) echo ' <select class="small">',QTastags($arrIndex),'</select>';
  echo '</td><td class="td_u"><a class="small" href="qte_cmd.php?a=dropindex&amp;u=',$id,'">',$L['Delete'],'...</a> | <a class="small" href="qte_cmd.php?a=makeindex&amp;u=',$id,'">Index...</a></td>',N;
}
else
{
  echo '<td class="td_u">',count($arrIndex);
  if ( count($arrIndex)>0 ) echo ' <select class="small">',QTastags($arrIndex),'</select>';
  echo '</td><td class="td_u">&nbsp;</td>',N;
}
echo '</tr>',N;

// End form

if ( $bEdit && $_SESSION[QT]['willedit'] )
{
  echo '<tr><th class="th_u_submit" colspan="3">';
  if ( !empty($qte_error) ) echo '<span class="error">',$qte_error,'</span> ';
  if ( empty($qte_error) && !empty($qte_warning) ) echo '<span class="warning">',$qte_warning,'</span> ';
  if ( empty($qte_error) && isset($strInfo) ) echo '<span id="infomessage">',$strInfo,'</span> ';
  echo '<input type="hidden" name="id" value="',$id,'"/><input type="submit" name="ok" value="',$L['Save'],'"/></th></tr>';
}

echo '<tr class="tr_u">
<td class="tf_u tf_u_first"></td>
<td class="tf_u"></td>
<td class="tf_u tf_u_last"></td>
</tr>
</table>
';

if ( $bEdit && $_SESSION[QT]['willedit'] ) echo '</form>';

echo '
</td>
</tr>
</table>
';

include('qte_usr_tabbot.php');

if ( $bEdit && $_SESSION[QT]['willedit'] && isset($strInfo) )
{
echo '
<script type="text/javascript">
<!--
setTimeout(\'document.getElementById("infomessage").style.color="#bbbbbb"\',3000);
setTimeout(\'document.getElementById("infomessage").style.color="#cccccc"\',3300);
setTimeout(\'document.getElementById("infomessage").style.color="#dddddd"\',3600);
setTimeout(\'document.getElementById("infomessage").innerHTML="&nbsp;"\',3900);
-->
</script>
';
}

// --------
// HTML END
// --------

include('qte_p_footer.php');

?>