<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( !$oVIP->CanAccess('MU',0,true) ) die($L['E_member']);

// --------
// INITIALISE
// --------

include('bin/qt_lib_smtp.php');
Include($_SESSION[QT]['language'].'/qte_lang_reg.inc');

$id = -1;
if (isset($_GET['id'])) $id = intval(strip_tags($_GET['id']));
if (isset($_POST['id'])) $id = intval(strip_tags($_POST['id']));
if ($id<0) die('Missing parameters');

$oUser = new cUser($oDB,$id,$qte_fields);

$oVIP->selfurl = 'qte_usr_rename.php';
$oVIP->selfname = $L['Change_name'];
$oVIP->exiturl = 'qte_usr_s.php?id='.$id;
$oVIP->exitname = '&laquo;'.S.$L['Profile'];

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  // check name
  if ( empty($qte_error) )
  {
    $strName = trim(strip_tags($_POST['title'])); if ( get_magic_quotes_gpc() ) $strName = stripslashes($strName);
    if ( !QTislogin($strName) ) $qte_error = $qte_fields['username'][0].S.$L['E_invalid'];
    if ( empty($qte_error) )
    {
    $oDB->Query('SELECT count(*) as countid FROM '.TABUSER.' WHERE username="'.$strName.'"');
    $row = $oDB->Getrow();
    if ( $row['countid']!=0 ) $qte_error = $qte_fields['username'][0].S.$L['E_already_used'];
    }
  }

  // execute and exit
  if ( empty($qte_error) )
  {
    $oDB->Query('UPDATE '.TABUSER.' SET username="'.$strName.'" WHERE id='.$id);
    // index
    $oDB->query('DELETE FROM '.TABINDEX.' WHERE userid='.$id.' AND ufield="username"');
    $oDB->query('INSERT INTO '.TABINDEX.' (userid,ufield,ukey) VALUES ('.$id.',"username","'.$strName.'")');

    $oVIP->exiturl = 'qte_usr_login.php?dfltname='.$strName;
    $oVIP->exitname = '&laquo;'.S.$L['Login'];
    $oVIP->EndMessage(NULL,$L['S_update'],$_SESSION[QT]['skin_dir'],2);
  }
}

// --------
// HTML START
// --------

$bAjax = true;
include('qte_p_header.php');

// DISPLAY

if ( !empty($qte_error) ) echo '<p id="infomessage" class="error">',$qte_error,'</p>';

echo '
<table class="tab_hidden" cellspacing="0">
<tr class="tr_hidden">
<td class="td_hidden" style="width:175px;">',AsImgBox(AsImg($oUser->picture,null,$oUser->fullname),'div_pic_box',null,$oUser->fullname),'</td>
<td class="td_hidden">
<div class="div_msgboxtitle" id="login_header" style="width: 350px;">',$oVIP->selfname,'</div>
<div class="div_msgbox" id="login" style="width: 350px;">
';

echo '
<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.title.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Name'],'")); return false; }
  return null;
}
-->
</script>
';

echo '<form method="post" action="',$oVIP->selfurl,'" onsubmit="return ValidateForm(this);">';
echo '<input type="hidden" name="id" value="',$id,'"/>';
echo '<h2>',$oUser->username,'</h2>';
if ( $oUser->username!=$oUser->fullname ) echo '<p class="bold">('.$oUser->fullname.')</p><br/>';
echo '<p>',$L['Choose_name'],'&nbsp;<input type="text" id="title" name="title" size="20" maxlength="32" onblur="nameExist(this.name,this.value,\'',$_SESSION[QT]['language'],'\',\'',$L['E_min_4_char'],'\')"/><br/><span id="div_ajax" class="error"></span></p>';
echo '<p><input type="submit" name="ok" value="',$L['Save'],'"/></p>';
echo '</form>';
echo '<a href="',$oVIP->exiturl,'">',$oVIP->exitname,'</a>';
echo '</div>
<br/>
</td>
</tr>
</table>
';

// --------
// HTML END
// --------

include('qte_p_footer.php');

?>