<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( !$oVIP->CanAccess('V',0,true) ) die($L['E_access']);

// --------
// INITIALISE
// --------

include('bin/qt_lib_smtp.php');
Include($_SESSION[QT]['language'].'/qte_lang_reg.inc');

$oVIP->selfurl = 'qte_usr_pwd_for.php';
$oVIP->selfname = $L['Forgotten_pwd'];
$oVIP->exiturl = 'qte_index.php';
$oVIP->exitname = $L['Section'];

$strTitle = '';
$strMail = '';

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  // check value

  $strTitle = trim(strip_tags($_POST['title'])); if ( get_magic_quotes_gpc() ) $strTitle = stripslashes($strTitle);
  if (!QTislogin($strTitle)) $qte_error = $qte_fields['username'][0].S.$L['E_invalid'];

  $strMail = trim(strip_tags($_POST['mail'])); if ( get_magic_quotes_gpc() ) $strMail = stripslashes($strMail);
  if (!QTismail($strMail)) $qte_error=$L['Email'].S.$L['E_invalid'];

  if ( empty($qte_error) )
  {
    // check login exists
    $oDB->Query('SELECT count(*) as countid FROM '.TABUSER.' WHERE username="'.$strTitle.'" and mail="'.$strMail.'"');
    $row = $oDB->Getrow();
    if ($row['countid']<1) $qte_error = $qte_fields['username'][0].'/'.$L['Email'].S.$L['E_invalid'];

    // execute
    if ( empty($qte_error) )
    {
      // read user info
      $oDB->Query('SELECT id,emails,children FROM '.TABUSER.' WHERE username="'.$strTitle.'" and mail="'.$strMail.'"');
      $row = $oDB->Getrow();
      $id = intval($row['id']);

      // make new pwd
      $newpwd = 'qt'.rand(0,9).rand(0,9).rand(0,9).rand(0,9);
      $oDB->Query('UPDATE '.TABUSER.' SET pwd="'.sha1($newpwd).'" WHERE id='.$id);

      // send email
      $strSubject = $_SESSION[QT]['site_name'].' - New password';
      $strMessage = "Please find here after a new password to access the board {$_SESSION[QT]['site_name']}.\nLogin: %s\nPassword: %s";
      $strFile = $_SESSION[QT]['language'].'/mail_pwd.inc';
      if ( file_exists($strFile) ) include($strFile);
      $strMessage = sprintf($strMessage,$strTitle,$newpwd);
      QTmail($row['emails'],QTunquote($strSubject),QTunquote($strMessage),QTE_HTML_CHAR);
      $strEndmessage = str_replace("\n",'<br/>',$strMessage);

      // send parent email (if coppa)
      if ( $row['children']!='0' ) {
      if ( $_SESSION[QT]['register_coppa']=='1' ) {
        $oDB->Query('SELECT parentmail FROM '.TABCHILD.' WHERE id='.$id);
        $row = $oDB->Getrow();
        $strSubject = $_SESSION[QT]['site_name'].' - New password';
        $strMessage = "Here is then new password of your children.\nLogin: %s\nPassword: %s";
        $strFile = $_SESSION[QT]['language'].'/mail_pwd_coppa.inc';
        if ( file_exists($strFile) ) { include($strFile); }
        $strMessage = sprintf($strMessage, $strTitle,$newpwd);
        QTmail($row['parentmail'],QTunquote($strSubject),QTunquote($strMessage),QTE_HTML_CHAR);
      }}
      
      // exit
      if ( $_SESSION[QT]['register_mode']!='direct' ) $strEndmessage='';
      $oVIP->EndMessage(NULL,$L['S_update'].'<br/><br/>'.$strEndmessage,$_SESSION[QT]['skin_dir'],0);
    }
  }
}

// --------
// HTML START
// --------

include('qte_p_header.php');

echo '
<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.title.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': ',$qte_fields['username'][0],'")); return false; }
  if (theForm.mail.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Email'],'")); return false; }
  return null;
}
-->
</script>
';

echo '
<div class="div_msgboxtitle" id="login_header" style="width: 300px;">',$oVIP->selfname,'</div>
<div class="div_msgbox" style="width: 300px;">
<form method="post" action="',$oVIP->selfurl,'" onsubmit="return ValidateForm(this);">
<p>',$L['Reg_pass'],'</p>
<p style="text-align:right">',$qte_fields['username'][0],'&nbsp;<input type="text" id="title" name="title" size="24" maxlength="24" value="',$strTitle,'"/></p>
<p style="text-align:right">',$L['Email'],'&nbsp;<input type="text" id="mail" name="mail" size="24" maxlength="64" value="',$strMail,'" onKeyUp="handle_keypress(event,\'ok\')"/></p>
<p style="text-align:right">',(!empty($qte_error) ? '<span class="error">'.$qte_error.' </span>' : ''),'
<input type="submit" id="ok" name="ok" value="',$L['Ok'],'"/></p>
</form>
</div>
';

// --------
// HTML END
// --------

include('qte_p_footer.php');

?>