<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080613
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( !$oVIP->CanAccess('MUV',4,true) ) $oVIP->EndMessage('!',$L['R_user'],$_SESSION[QT]['skin_dir'],0);


// --------
// INITIALISE
// --------

include('bin/qt_lib_smtp.php');
include($_SESSION[QT]['language'].'/qte_lang_reg.inc');

$oVIP->selfurl = 'qte_usr_p_prt.php';
$oVIP->selfname = $L['PProfile'];

$id = -1;
if ( isset($_GET['id']) ) $id = intval(strip_tags($_GET['id']));
if ( $id<0 )  die('Wrong id in '.$oVIP->selfurl);

$bEdit = false;

$oUser = new cUser($oDB,$id,$qte_fields,$oVIP); // privatise

$arrTeamFields = GetUsableFields($qte_fields,GetFields('team'));

$bMap = UseModule('map');
if ( $bMap ) { if ( empty($_SESSION[QT]['m_map_gkey']) ) $bMap=false; }
if ( $bMap ) { require_once('qtem_map_lib.php'); include(Translate($_SESSION[QT]['language'],'qtem_map.inc')); }
$strPosition='';

// --------
// HTML START
// --------

$bToPrint=true;
if ( $bMap )
{ 
  $arrMapPoints = array();
  $strHeaderAddScript = QTgmapheader('http://gmaps-utility-library.googlecode.com/svn/trunk/markermanager/release/src/markermanager.js');
  $strBodyAddOnunload='GUnload()';
}
include('qte_p_header.php');

// -- QUERY USER --

$strBirth_y = '';
$strBirth_m = '';
$strBirth_d = '';
if ( !empty($oUser->birthdate) )
{
  $strBirth_y = intval(substr(strval($oUser->birthdate),0,4));
  $strBirth_m = intval(substr(strval($oUser->birthdate),4,2));
  $strBirth_d = intval(substr(strval($oUser->birthdate),6,2));
}

// -- DISPLAY PROFILE --

if ( !empty($qte_error) ) echo '<span class="error">',$qte_error,'</span>',N;
echo '<table class="tab_cnt" cellspacing="0">',N;
echo '<colgroup span="3">',N;
echo '<col width="150"></col>',N;
echo '<col></col>',N;
echo '<col width="50"></col>',N;
echo '</colgroup>',N;

echo '<tr>',N;
echo '<th class="th_u">',AsImg($oUser->picture),'</th>',N;
echo '<td class="td_u"><h2 style="margin:4px">',AsFormat($oUser->fullname,$qte_fields['fullname']),'</h2></td>',N;
echo '<td class="td_u"></td>',N;
echo '</tr>',N;

echo '<tr><th class="th_u" colspan="3"><h2 style="margin:4px">',$L['PProfile'],'</h2></th></tr>';

echo '<tr>',N;
echo '<th class="th_u">',$qte_fields['username'][0],'</th>',N;
echo '<td class="td_u">',AsFormat($oUser->username,$qte_fields['username']);
if ( $oUser->role=='A' || $oUser->role=='M' ) echo ' <span class="small">(',$L['Userrole'][$oUser->role],')</span>';
echo '</td>',N;
echo '<td class="td_u"></td>',N;
echo '</tr>',N;

echo '<tr>',N;
echo '<th class="th_u">',$L['Status'],'</th>',N;
echo '<td class="td_u">',$_SESSION['qte_status_name'][$oUser->status],S,AsImg($_SESSION[QT]['skin_dir'].'/'.$_SESSION['qte_status_icon'][$oUser->status]),'</td>',N;
echo '<td class="td_u">';
echo '</td>',N;
echo '</tr>',N;

$arr = GetUsableFields($qte_fields,array('title','firstname','midname','lastname','alias','phones'));
foreach ($arr as $strField)
{
  echo '<tr><th class="th_u">',$qte_fields[$strField][0],'</th>',N;
  echo '<td class="td_u">',AsFormat(AsTextList($oUser->$strField),$qte_fields[$strField]),'</td>',N;
  echo '<td class="td_u">&nbsp;</td>',N;
  echo '</tr>';
}

if ( $qte_fields['address'][2] )
{
  echo '<tr><th class="th_u">',$qte_fields['address'][0],'</th>',N;
  echo '<td class="td_u">',AsFormat(AsTextList($oUser->address),$qte_fields[$strField]),'</td>',N;
  echo '<td class="td_u">&nbsp;</td>',N;
  echo '</tr>',N;
}
if ( $qte_fields['emails'][2] )
{
  echo '<tr><th class="th_u">',$qte_fields['emails'][0],'</th>',N;
  echo '<td class="td_u">',AsFormat(AsTextList($oUser->emails),$qte_fields[$strField]),'</td>',N;
  echo '<td class="td_u">&nbsp;</td>',N;
  echo '</tr>';
}
if ( $qte_fields['www'][2] )
{
  echo '<tr><th class="th_u">',$qte_fields['www'][0],'</th>',N;
  echo '<td class="td_u">',AsFormat($oUser->www,$qte_fields['www']),'</td>',N;
  echo '<td class="td_u">&nbsp;</td>',N;
  echo '</tr>';
}

if ( $qte_fields['birthdate'][2] )
{
  echo '<tr><th class="th_u">',$qte_fields['birthdate'][0],'</th>',N;
  echo '<td class="td_u">',(!empty($oUser->birthdate) ? AsFormat(QTdate($oUser->birthdate,$arrQTdate),$qte_fields['birthdate']).' ('.AsFormat($oUser->age,$qte_fields['age']).')' : S),'</td>',N;
  echo '<td class="td_u">&nbsp;</td>',N;
  echo '</tr>',N;
}

// CHILD

if ( $oUser->coppa!='0' ) {
if ( $_SESSION[QT]['register_coppa']=='1' ) {
if ( $oVIP->role=='A' || $oVIP->role=='M' ) {

echo '<tr><th class="th_u" colspan="3"><h2 style="margin:4px">',$L['Coppa_status'],' ',$L['H_Coppa_status'],'</h2></th></tr>';

  echo '<tr>',N;
  echo '<th class="th_u">',$L['Coppa_status'],'</th>',N;
  echo '<td class="td_u">',$L['Coppa_child'][$oUser->coppa],'</td>',N;
  echo '<td class="td_u">&nbsp;</td>',N;
  echo '</tr>',N;

  $oDB->Query('SELECT * FROM '.TABCHILD.' WHERE id='.$id);
  $row = $oDB->Getrow();
  //if ( $row['countid']!=1 ) $qte_error = 'Unidentified child.';

  $strChilddate_y = '';
  $strChilddate_m = '';
  $strChilddate_d = '';
  if ( !empty($row['childdate']) )
  {
    $strChilddate_y = intval(substr(strval($row['childdate']),0,4));
    $strChilddate_m = intval(substr(strval($row['childdate']),4,2));
    $strChilddate_d = intval(substr(strval($row['childdate']),6,2));
  }
  $strParentdate_y = '';
  $strParentdate_m = '';
  $strParentdate_d = '';
  if ( !empty($row['Parentdate']) )
  {
    $strParentdate_y = intval(substr(strval($row['Parentdate']),0,4));
    $strParentdate_m = intval(substr(strval($row['Parentdate']),4,2));
    $strParentdate_d = intval(substr(strval($row['Parentdate']),6,2));
  }

  echo '<tr>',N;
  echo '<th class="th_u">Registration date</th>',N;
  echo '<td class="td_u">',(!empty($row['childdate']) ? QTdate($row['childdate'],$arrQTdate) : ''),'</td>',N;
  echo '<td class="td_u">&nbsp;</td>',N;
  echo '</tr>',N;

  echo '<tr>',N;
  echo '<th class="th_u">Parent agreement</th>',N;
  echo '<td class="td_u">',(!empty($row['parentdate']) ? QTdate($row['parentdate'],$arrQTdate) : ''),'</td>',N;
  echo '<td class="td_u">&nbsp;</td>',N;
  echo '</tr>',N;

  echo '<tr>',N;
  echo '<th class="th_u">Parent email</th>',N;
  echo '<td class="td_u"><a href="mailto:',$row['parentmail'],'" class="small">',$row['parentmail'],'</a></td>',N;
  echo '<td class="td_u">&nbsp;</td>',N;
  echo '</tr>',N;

}}}

echo '<tr><th class="th_u" colspan="3"><h2 style="margin:4px">',$L['TProfile'],'</h2></th></tr>';

foreach ($arrTeamFields as $strField)
{
  echo '<tr>';
  echo '<th class="th_u">',$qte_fields[$strField][0],'</th>';

  switch($strField)
  {
  case 'teamdate1':
    echo '<td class="td_u">',(!empty($oUser->$strField) ? QTdate($oUser->$strField,$arrQTdate) : S),'</td>';
    break;
  case 'teamdate2':
    echo '<td class="td_u">',(!empty($oUser->$strField) ? QTdate($oUser->$strField,$arrQTdate) : S),'</td>';
    break;
  default:
    echo '<td class="td_u">',(!empty($oUser->$strField) ? AsFormat($oUser->$strField,$qte_fields[$strField]) : S),'</td>';
    break;
  }
  echo '<td class="td_u">&nbsp;</td>',N;
  echo '</tr>',N;
}

// -- QUERY MEMBERSHIP --

echo '<tr>';
echo '<th class="th_u">',$L['MProfile'],'</th>';
echo '<td class="td_u">';

$arrMembership = array();
$oDB->Query('SELECT s.id,s.title,s.descr,s.picture,s.members FROM '.TABSECTION.' s INNER JOIN '.TABS2U.' l  ON l.sid=s.id WHERE l.userid='.$id.' ORDER BY l.sid DESC');
while ( $row=$oDB->Getrow() )
{
  $arrMembership[$row['id']] = $row;
}

foreach ($arrMembership as $intId => $arrSection)
{
  $oSEC = new cSection(null,$arrSection);
  echo '<b>',$oSEC->title,'</b> &middot; ',$oSEC->descr,' <span class="small">('.LangS('User',$oSEC->members,$L).')</span><br/>';
}
if ( count($arrMembership)==0 ) echo $L['E_no_membership'];

echo '</td>',N;
echo '<td class="td_u">&nbsp;</td>',N;
echo '</tr>',N;

// -- QUERY DOCUMENTS --

$arrDocs = array();
$oDB->Query('SELECT * FROM '.TABDOC.' WHERE id='.$id.' ORDER BY docname DESC');
while ( $row=$oDB->Getrow() )
{ 
  $arrDocs[] = $row;
}

echo '<th class="th_u">',$L['DProfile'],'</th>';
echo '<td class="td_u">';
if ( count($arrDocs)==0 ) 
{
  echo $L['None'];
}
else
{
  foreach ($arrDocs as $intId => $arrDoc)
  {
  echo '<span class="small">(',QTdate($arrDoc['docdate'],$arrQTdate),')</span> ',$arrDoc['docname'],', ';
  }
}
echo '</td>
<td class="td_u">&nbsp;</td>
</tr>
</table>',N;


// MAP
if ( $bMap )
{
  $strPosition = '<div id="map_canvas" style="width:100%; height:340px;"></div>';
  if ( empty($oUser->x) || empty($oUser->y) ) $strPosition = '<span class="p_gmap">'.$L['map']['E_noposition'].'</span>';
  if ( $row['privacy']=='0' && $oVIP->role!='A' ) $strPosition = S;
  if ( $row['privacy']=='1' && $oVIP->role=='V' ) $strPosition = S;
  echo '<div class="div_gmap" style="margin-top:10px;width:550px">',$strPosition,'</div>';
}

// ---------
// HTML END
// ---------

if ( $bMap )
{

  if ( !empty($oUser->x) && !empty($oUser->y) )
  {
    $strUsername = QTunquote($oUser->name);
    $x = floatval($oUser->x);
    $y = floatval($oUser->y);
    $arrMapPoints = array( array(
    'y'=>$y,
    'x'=>$x,
    'title'=>$strUsername,
    'icon'=>$_SESSION[QT]['m_map']['U']['icon'],
    'shadow'=>$_SESSION[QT]['m_map']['U']['shadow'],
    'printicon'=>$_SESSION[QT]['m_map']['U']['printicon'],
    'printshadow'=>$_SESSION[QT]['m_map']['U']['printshadow']
    ) );
  }

  if ( count($arrMapPoints)>0 ) $strFooterAddScript = QTgmappoints($L['map'],$y,$x,'',$arrMapPoints,false,false).N.'mapload();';

}

include('qte_p_footer.php');

?>