<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */ 

session_start();
require_once('bin/qte_init.php');
if ( !$oVIP->CanAccess('MUV',4,true) ) $oVIP->EndMessage('!',$L['R_user'],$_SESSION[QT]['skin_dir'],0);

// --------
// INITIALISE
// --------

include('bin/qt_lib_smtp.php');
Include($_SESSION[QT]['language'].'/qte_lang_reg.inc');

$oVIP->selfurl = 'qte_usr_p.php';
$oVIP->selfname = $L['PProfile'];

$id = -1;
if ( isset($_GET['id']) ) $id = intval(strip_tags($_GET['id']));
if ( isset($_POST['id']) ) $id = intval(strip_tags($_POST['id']));
if ( $id<0 ) die('Wrong id in '.$oVIP->selfurl);

if ( !isset($_SESSION[QT]['willedit']) ) $_SESSION[QT]['willedit']=false;
if ( isset($_GET['editstart']) ) $_SESSION[QT]['willedit']=true;
if ( isset($_GET['editstop']) ) $_SESSION[QT]['willedit']=false;

$bEdit = false;
if ( $oVIP->role=='A' || $oVIP->role=='M' ) $bEdit=true;
if ( $oVIP->id==$id && $_SESSION[QT]['member_right']!='0' ) $bEdit=true;
if ( $id<1 ) $bEdit=false;

$oUser = new cUser($oDB,$id,$qte_fields,$oVIP); // privatise
$strOldname = $oUser->firstname.' '.$oUser->lastname;

$bMap = UseModule('map');
if ( $bMap ) { if ( empty($_SESSION[QT]['m_map_gkey']) ) $bMap=false; }
if ( $bMap ) { require_once('qtem_map_lib.php'); include(Translate($_SESSION[QT]['language'],'qtem_map.inc')); }
$strPosition='';

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  // generic
  $arrFields = GetUsableFields($qte_fields,GetFields('useredit'));
  foreach ($arrFields as $strField)
  {
    if ( empty($qte_error) && isset($_POST[$strField]) )
    {
    if ( get_magic_quotes_gpc() ) { $oUser->$strField = QTformattitle(stripslashes($_POST[$strField]),255); } else { $oUser->$strField = QTformattitle($_POST[$strField],255); }
    }
  }
  // birthdate
  if ( empty($qte_error) )
  {
    if ( empty($_POST['birth_y']) || empty($_POST['birth_m']) || empty($_POST['birth_d']) )
    {
      $oUser->birthdate = '0';
    }
    else
    {
      $i = intval($_POST['birth_y'])*10000+intval($_POST['birth_m'])*100+intval($_POST['birth_d']);
      // futur checking
      switch($qte_fields['birthdate'][1])
      {
      case '0': if ( !QTisvaliddate($i,true,true) ) $qte_error = $qte_fields['birthdate'][0].' ('.$_POST['birth_y'].'-'.$_POST['birth_m'].'-'.$_POST['birth_d'].') '.$L['E_invalid'];
      case '1': if ( $i>intval(date('Ymd')) ) $qte_error = $L['No_future'][1].' '.$qte_fields['birthdate'][0].' ('.$_POST['birth_y'].'-'.$_POST['birth_m'].'-'.$_POST['birth_d'].') '.$L['E_invalid'];
      case '2': if ( !QTisvaliddate($i,true,false) ) $qte_error = $L['No_future'][2].' '.$qte_fields['birthdate'][0].' ('.$_POST['birth_y'].'-'.$_POST['birth_m'].'-'.$_POST['birth_d'].') '.$L['E_invalid'];
      }
      $oUser->birthdate = $i;
      if ( !empty($oUser->birthdate) ) $oUser->SetAge();
    }
  }
  // check www
  if ( empty($qte_error) && isset($_POST['www']) )
  {
    $oUser->www = QTformattitle($_POST['www'],255);
    if ( !empty($oUser->www) && substr($oUser->www,0,4)!='http' ) { $oUser->www=''; $qte_error=$qte_fields['www'][0].S.$L['E_invalid']; }
    if ( $oUser->www=='http://' || $oUser->www=='https://' ) $oUser->www='';
  }
  // check emails
  if ( empty($qte_error) && !empty($_POST['emails']) )
  {
    $arrEmails = explode(' ; ',$_POST['emails']);
    foreach ($arrEmails as $strEmail)
    {
      if ( !QTismail($strEmail) ) $qte_error=$qte_fields['emails'][0].S.$L['E_invalid'];
    }
  }
  // privacy
  if ( empty($qte_error) )
  {
    $oUser->privacy = str_replace('address;','',$oUser->privacy);
    $oUser->privacy = str_replace('emails;','',$oUser->privacy);
    $oUser->privacy = str_replace('phones;','',$oUser->privacy);
    if ( isset($_POST['hiddenaddress']) ) $oUser->privacy .= 'address;';
    if ( isset($_POST['hiddenemails']) )  $oUser->privacy .= 'emails;';
    if ( isset($_POST['hiddenphones']) )  $oUser->privacy .= 'phones;';
  }

  // --- SAVE CHILD INFO (if any) ---

  if ( isset($_POST['coppastatus']) )
  {
    // childdate
    if ( empty($qte_error) )
    {
      if ( empty($_POST['childdate_y']) || empty($_POST['childdate_d']) || empty($_POST['childdate_d']) )
      {
        $strChilddate = '0';
      }
      else
      {
        $i = intval($_POST['childdate_y'])*10000+intval($_POST['childdate_m'])*100+intval($_POST['childdate_d']);
        if ( !QTisvaliddate($i,true,false,false) ) $qte_error = 'Child registration date ('.$_POST['childdate_y'].'-'.$_POST['childdate_m'].'-'.$_POST['childdate_d'].') '.$L['E_invalid'];
        $strChilddate = $i;
      }
    }
    // parentdate
    if ( empty($qte_error) )
    {
      if ( empty($_POST['parentdate_y']) || empty($_POST['parentdate_d']) || empty($_POST['parentdate_d']) )
      {
        $strParentdate = '0';
      }
      else
      {
        $i = intval($_POST['parentdate_y'])*10000+intval($_POST['parentdate_m'])*100+intval($_POST['parentdate_d']);
        if ( !QTisvaliddate($i,true,false,false) ) $qte_error = 'Parent agreement date ('.$_POST['parentdate_y'].'-'.$_POST['parentdate_m'].'-'.$_POST['parentdate_d'].') '.$L['E_invalid'];
        $strParentdate = $i;
      }
    }
    // check emails
    if ( empty($qte_error) && !empty($_POST['parentmail']) )
    {
      $arrEmails = explode(' ; ',$_POST['parentmail']);
      foreach ($arrEmails as $strParentmail)
      {
        if ( !QTismail($strParentmail) ) $qte_error='Parent email '.$L['E_invalid'];
      }
    }
    // save coppa
    if ( empty($qte_error) )
    {
      $oDB->Query('UPDATE '.TABCHILD.' SET childdate="'.$strChilddate.'",parentdate="'.$strParentdate.'",parentmail="'.$strParentmail.'" WHERE id='.$id);
      $oDB->Query('UPDATE '.TABUSER.' SET children="'.$_POST['coppastatus'].'" WHERE id='.$id);
    }
  }
  // --- END SAVE CHILD INFO (if any) ---

  // SAVE
  if ( empty($qte_error) )
  {
    // save changes
    $strUpdate = '';
    foreach ($arrFields as $strField)
    {
    $strUpdate .= $strField.'="'.$oUser->$strField.'",';
    }
    $strUpdate .= 'privacy="'.$oUser->privacy.'"';
    $oDB->Query('UPDATE '.TABUSER.' SET '.$strUpdate.' WHERE id='.$id);

    if ( isset($_POST['m_map_gcenter']) )
    {
      if ( empty($_POST['m_map_gcenter']) )
      {
      $oUser->y=0;
      $oUser->x=0;
      QTgpointdelete($oDB,TABUSER,$id);
      }
      else
      {
      $oUser->y=QTgety($_POST['m_map_gcenter']);
      $oUser->x=QTgetx($_POST['m_map_gcenter']);
      QTgpoint($oDB,TABUSER,$id,$oUser->y,$oUser->x);
      }      
    }

    // check moderator name
    if ( $oUser->role=='A' || $oUser->role=='M' )
    {
      $strNewname = $oUser->firstname.' '.$oUser->lastname;
      if ( $strOldname!=$strNewname ) $oDB->Query('UPDATE '.TABSECTION.' SET modname="'.$strNewname.'" WHERE modid='.$id);
    }

    // check fullname
    $oUser->SetFullname($qte_fields);

    // update index
    $oUser->SaveKeywords($oDB,$oUser->GetKeywords(GetFields('index_p')));

    // parent warning if coppa (and if edited by the kid himself)
    if ( $oUser->coppa != '0' ) {
    if ( $_SESSION[QT]['register_coppa']=='1' ) {
    if ( $oVIP->id==$id ) {
      $oDB->Query('SELECT parentmail FROM '.TABCHILD.' WHERE id='.$id);
      $row = $oDB->Getrow();
      $strSubject = $_SESSION[QT]['site_name'].' - Profile updated';
      $strMessage="Your children (login: %s) has modified his/her profile on the board {$_SESSION[QT]['site_name']}.";
      $strFile = $_SESSION[QT]['language'].'/mail_profile_coppa.inc';
      if ( file_exists($strFile) ) include($strFile);
      $strMessage = sprintf($strMessage, $oUser->username);
      QTmail($row['parentmail'],QTunquote($strSubject),QTunquote($strMessage),QTE_HTML_CHAR);
    }}}

    // Exit
    $strInfo = $L['S_save'];
  }

}

// --------
// HTML START
// --------

if ( $bMap )
{ 
  $strHeaderAddScript = QTgmapheader();
  $strBodyAddOnunload='GUnload()';
}
include('qte_p_header.php');

// -- BUTTON BAR & TITLE --

if ( $oVIP->role=='A' || $oVIP->role=='M' ) include('qte_usr_menu.php');
include('qte_usr_tabtop.php');

// -- QUERY USER --

$strBirth_y = '';
$strBirth_m = '';
$strBirth_d = '';
if ( !empty($oUser->birthdate) )
{
  $strBirth_y = intval(substr(strval($oUser->birthdate),0,4));
  $strBirth_m = intval(substr(strval($oUser->birthdate),4,2));
  $strBirth_d = intval(substr(strval($oUser->birthdate),6,2));
}

// -- DISPLAY PROFILE --

echo '
<table class="tab_hidden" cellspacing="0">
<colgroup span="2">
<col width="175"></col>
<col></col>
</colgroup>
<tr class="tr_hidden">
<td class="td_hidden">
';

  include('qte_usr_inc.php');
  if ( $bEdit && $_SESSION[QT]['willedit'] )
  echo '<br/><br/><div class="div_pic_box"><span style="font-size:7pt"><b>',$L['Help'],'</b><br/><br/>',$L['H_hidden_fields'],'<br/><br/>',$L['H_semicolon_useredit'],'</span></div>';

echo '</td>',N;

echo '<td class="td_hidden">',N;

if ( $bEdit && $_SESSION[QT]['willedit'] ) echo '<form method="post" action="qte_usr_p.php?id='.$id.'">',N;
echo '<table class="tab_cnt" cellspacing="0">',N;
echo '<colgroup span="3"><col width="130"></col><col></col><col width="120"></col></colgroup>',N;

echo '<tr class="tr_cnt">
<th class="th_u th_u_first th_u_empty"></th>
<th class="th_u th_u_empty"></th>
<th class="th_u th_u_last th_u_empty"></th>
</tr>
';

$arr = GetUsableFields($qte_fields,array('title','firstname','midname','lastname','alias'));
foreach ($arr as $strField)
{
  echo '<tr><th class="th_u">',$qte_fields[$strField][0],'</th>',N;
  if ( $bEdit && $_SESSION[QT]['willedit'] )
  {
    echo '<td class="td_u">';
    if ( $strField=='title' && strstr($qte_fields[$strField][1],';') )
    {
      echo '<select id="',$strField,'" name="',$strField,'">';
      echo QTastags(AsPopupList($qte_fields[$strField][1]),null,$oUser->$strField);
      echo '</select>';
    }
    else
    {
      echo '<input class="small" type="text" id="',$strField,'" name="',$strField,'" size="32" maxlength="32" value="',$oUser->$strField,'"/>';
    }
    echo '</td>',N;
  }
  else
  {
    echo '<td class="td_u"><b>',AsFormat($oUser->$strField,$qte_fields[$strField]),'</b></td>',N;
  }
  echo '<td class="td_u">&nbsp;</td>',N;
  echo '</tr>';
}

echo '<tr>',N;
echo '<th class="th_u">',$L['Status'],'</th>',N;
if ( $bEdit && $_SESSION[QT]['willedit'] && ($oVIP->role=='A' || $oVIP->role=='M') )
{
  echo '<td class="td_u"><select id="status" name="status" class="small" onchange="if (this.value==\'',$oUser->status,'\' ) { document.getElementById(\'statusicon\').style.visibility=\'visible\'; } else {document.getElementById(\'statusicon\').style.visibility=\'hidden\'; }">',QTastags($_SESSION['qte_status_name'],null,$oUser->status),'</select> <span id="statusicon">',AsImg($_SESSION[QT]['skin_dir'].'/'.$_SESSION['qte_status_icon'][$oUser->status]),'</span>';
}
else
{
  echo '<td class="td_u">',$_SESSION['qte_status_name'][$oUser->status],S,AsImg($_SESSION[QT]['skin_dir'].'/'.$_SESSION['qte_status_icon'][$oUser->status]),'</td>',N;
}
echo '<td class="td_u">&nbsp;</td>',N;
echo '</tr>',N;

$arr = GetUsableFields($qte_fields,array('address','phones'));
foreach ($arr as $strField)
{
  echo '<tr><th class="th_u">',$qte_fields[$strField][0],'</th>',N;
  if ( $bEdit && $_SESSION[QT]['willedit'] )
  {
    echo '<td class="td_u"><input class="small" type="text" id="',$strField,'" name="',$strField,'" size="32" maxlength="255" value="',strip_tags($oUser->$strField),'"/></td>
    <td class="td_u"><input type="checkbox" id="hidden',$strField,'" name="hidden',$strField,'"',(strstr($oUser->privacy,$strField) ? QCHE : ''),'/> <label for="hidden',$strField,'">',$L['Hidden'],'</label></td>',N;
  }
  else
  {
    echo '<td class="td_u',($strField=='emails' ? ' small' : ''),'">',AsFormat(AsTextList($oUser->$strField),$qte_fields[$strField]),'</td><td class="td_u">&nbsp;</td>',N;
  }
  echo '</tr>',N;
}

if ( $qte_fields['emails'][2] )
{
  echo '<tr><th class="th_u">',$qte_fields['emails'][0],'</th>',N;
  if ( $bEdit && $_SESSION[QT]['willedit'] )
  {
    echo '<td class="td_u"><input class="small" type="text" id="emails" name="emails" size="32" maxlength="255" value="',strip_tags($oUser->emails),'"/></td>
    <td class="td_u"><input type="checkbox" id="hiddenemails" name="hiddenemails"',(strstr($oUser->privacy,'emails') ? QCHE : ''),'/> <label for="hiddenemails">',$L['Hidden'],'</label></td>',N;
  }
  else
  {
    if ( $_SESSION[QT]['javamail']=='1' ) { $strJava='java'; } else { $strJava = ''; }
    $str = AsEmails($oUser->emails,$oUser->id,'0','txt'.$strJava,($_SESSION[QT]['viewmode']=='C'),$_SESSION[QT]['skin_dir'],'Java protected email','&nbsp;','<br/>');
    $str = AsTextList($str);
    echo '<td class="td_u">',$str,'</td><td class="td_u">&nbsp;</td>',N;
  }
  echo '</tr>';
}

if ( $qte_fields['www'][2] )
{
  echo '<tr><th class="th_u">',$qte_fields['www'][0],'</th>',N;
  if ( $bEdit && $_SESSION[QT]['willedit'] )
  {
    echo '<td class="td_u"><input class="small" type="text" id="www" name="www" size="32" maxlength="255" value="',(!empty($oUser->www) ? $oUser->www : 'http://'),'"/></td>',N;
  }
  else
  {
    echo '<td class="td_u">';
    if ( !empty($oUser->www) ) { echo '<a href="',$oUser->www,'" class="small">',AsFormat($oUser->www,$qte_fields['www']),'</a>'; } else { echo S; }
    echo '</td>',N;
  }
  echo '<td class="td_u">&nbsp;</td>',N;
  echo '</tr>';
}

if ( $qte_fields['birthdate'][2] )
{
  echo '<tr><th class="th_u">',$qte_fields['birthdate'][0],'</th>',N;
  if ( $bEdit && $_SESSION[QT]['willedit'] )
  {
    echo '<td class="td_u"><select name="birth_d" size="1"/>',N;
    echo QTastags(array(0=>'',1=>1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31),null,$strBirth_d);
    echo '</select>',N;
    echo '<select name="birth_m" size="1"/>',N;
    echo '<option value="0"></option>',QTastags($L['dateMMM'],null,$strBirth_m);
    echo '</select>',N;
    echo '<input type="text" id="birth_y" name="birth_y" size="4" maxlength="4" value="',$strBirth_y,'"/>',(!empty($oUser->birthdate) ? ' ('.AsFormat($oUser->age,$qte_fields['age']).')' : ''),'</td><td class="td_u">',N;
    if ( $oUser->age<13 && $oUser->coppa==0 ) {
    if ( $oVIP->role=='A' || $oVIP->role=='M' ) {
      echo '<a class="small" href="qte_cmd.php?a=userchild&amp;u=',$id,'&amp;v=1">',$L['Coppa_apply'],'</a>';
    }}
    if ( $oUser->age>=13 && $oUser->coppa!=0 ) {
    if ( $oVIP->role=='A' || $oVIP->role=='M' ) {
      echo '<a class="small" href="qte_cmd.php?a=userchild&amp;u=',$id,'&amp;v=0">',$L['Coppa_notapply'],'</a>';
    }}
    echo '&nbsp;</td>',N;
  }
  else
  {
    echo '<td class="td_u">',(!empty($oUser->birthdate) ? QTdate($oUser->birthdate,$arrQTdate).' ('.AsFormat($oUser->age,$qte_fields['age']).')' : S),'</td><td class="td_u">&nbsp;</td>',N;
  }
  echo '</tr>',N;
}

if ( $qte_fields['nationality'][2] )
{
  echo '<tr><th class="th_u">',$qte_fields['nationality'][0],'</th>',N;
  if ( $bEdit && $_SESSION[QT]['willedit'] )
  {
    echo '<td class="td_u">';
    if ( strstr($qte_fields['nationality'][1],' ; ') )
    {
    echo '<select id="nationality" name="nationality">';
    echo QTastags(AsPopupList($qte_fields['nationality'][1]),null,$oUser->nationality);
    echo '</select>';
    }
    else
    {
    echo '<input class="small" type="text" id="nationality" name="nationality" size="32" maxlength="32" value="',$oUser->nationality,'"/>';
    }
    echo ' </td>',N;
  }
  else
  {
    echo '<td class="td_u">',(!empty($oUser->nationality) ? AsFormat($oUser->nationality,$qte_fields['nationality']) : S),'</td>';
  }
  echo '<td class="td_u">&nbsp;</td>',N;
  echo '</tr>',N;
}

if ( $qte_fields['sexe'][2] )
{
  echo '<tr><th class="th_u">',$qte_fields['sexe'][0],'</th>',N;
  if ( $bEdit && $_SESSION[QT]['willedit'] )
  {
    echo '<td class="td_u">';
    if ( strstr($qte_fields['sexe'][1],' ; ') )
    {
    echo '<select id="sexe" name="sexe">';
    echo QTastags(AsPopupList($qte_fields['sexe'][1]),null,$oUser->sexe);
    echo '</select>';
    }
    else
    {
    echo '<input class="small" type="text" id="sexe" name="sexe" size="32" maxlength="32" value="',$oUser->sexe,'"/>';
    }
    echo ' </td>',N;
  }
  else
  {
    echo '<td class="td_u">',(!empty($oUser->sexe) ? AsFormat($oUser->sexe,$qte_fields['sexe']) : S),'</td>';
  }
  echo '<td class="td_u">&nbsp;</td>',N;
  echo '</tr>',N;
}

// CHILD

if ( $oUser->coppa!='0' ) {
if ( $_SESSION[QT]['register_coppa']=='1' ) {
if ( $oVIP->role=='A' || $oVIP->role=='M' ) {

  echo '<tr><th class="th_u" colspan="3">&nbsp;</th></tr>';

  echo '<tr>',N;
  echo '<th class="th_u">',$L['Coppa_status'],'</th>',N;
  echo '<td class="td_u">';
  if ( $bEdit && $_SESSION[QT]['willedit'] )
  {
    echo '<select name="coppastatus" size="1"/>';
    echo QTastags($L['Coppa_child'],null,$oUser->coppa);
    echo '</select>';
  }
  else
  {
  echo $L['Coppa_child'][$oUser->coppa];
  }
  echo '</td><td class="td_u">&nbsp;</td>',N;
  echo '</tr>',N;

  $oDB->Query('SELECT * FROM '.TABCHILD.' WHERE id='.$id);
  $row = $oDB->Getrow();
  //if ( $row['countid']!=1 ) $qte_error = 'Unidentified child.';

  echo '<tr>',N;
  echo '<th class="th_u">Registration date</th>',N;
  echo '<td class="td_u">';
  if ( $bEdit && $_SESSION[QT]['willedit'] )
  {
    $strChilddate_y = '';
    $strChilddate_m = '';
    $strChilddate_d = '';
    if ( !empty($row['childdate']) )
    {
      $strChilddate_y = intval(substr(strval($row['childdate']),0,4));
      $strChilddate_m = intval(substr(strval($row['childdate']),4,2));
      $strChilddate_d = intval(substr(strval($row['childdate']),6,2));
    }
    echo '<select name="childdate_d" size="1"/>';
    echo QTastags(array(0=>'',1=>1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31),null,$strChilddate_d);
    echo '</select>',N;
    echo '<select name="childdate_m" size="1"/>';
    echo '<option value="0"></option>',QTastags($L['dateMMM'],null,$strChilddate_m);
    echo '</select>',N;
    echo '<input type="text" id="childdate_y" name="childdate_y" size="4" maxlength="4" value="',$strChilddate_y,'"/>';
  }
  else
  {
    echo (!empty($row['childdate']) ? QTdate($row['childdate'],$arrQTdate) : '');
  }
  echo '</td><td class="td_u">&nbsp;</td>',N;
  echo '</tr>',N;

  echo '<tr>',N;
  echo '<th class="th_u">Parent agreement</th>',N;
  echo '<td class="td_u">';
  if ( $bEdit && $_SESSION[QT]['willedit'] )
  {
    $strParentdate_y = '';
    $strParentdate_m = '';
    $strParentdate_d = '';
    if ( !empty($row['parentdate']) )
    {
    $strParentdate_y = intval(substr(strval($row['parentdate']),0,4));
    $strParentdate_m = intval(substr(strval($row['parentdate']),4,2));
    $strParentdate_d = intval(substr(strval($row['parentdate']),6,2));
    }
    echo '<select name="parentdate_d" size="1"/>';
    echo QTastags(array(0=>'',1=>1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31),null,$strParentdate_d);
    echo '</select>',N;
    echo '<select name="parentdate_m" size="1"/>';
    echo '<option value="0"></option>',QTastags($L['dateMMM'],null,$strParentdate_m);
    echo '</select>',N;
    echo '<input type="text" id="parentdate_y" name="parentdate_y" size="4" maxlength="4" value="',$strParentdate_y,'"/>';
  }
  else
  {
    echo (!empty($row['parentdate']) ? QTdate($row['parentdate'],$arrQTdate) : '');
  }
  echo '</td><td class="td_u">&nbsp;</td>',N;
  echo '</tr>',N;

  echo '<tr>',N;
  echo '<th class="th_u">Parent email</th>',N;
  echo '<td class="td_u">';
  if ( $bEdit && $_SESSION[QT]['willedit'] )
  {
    echo '<input class="small" type="text" id="parentmail" name="parentmail" size="32" maxlength="255" value="',$row['parentmail'],'"/>';
  }
  else
  {
    echo '<a href="mailto:',$row['parentmail'],'" class="small">',AsTextList($row['parentmail']),'</a>';
  }
  echo '</td><td class="td_u">&nbsp;</td>',N;
  echo '</tr>',N;

}}}

if ( $bEdit )
{
  if ( $_SESSION[QT]['willedit'] )
  {
  echo '<tr><th class="th_u_submit" colspan="3">';
  if ( !empty($qte_error) ) echo '<span class="error">',$qte_error,'</span> ';
  if ( empty($qte_error) && !empty($qte_warning) ) echo '<span class="warning">',$qte_warning,'</span> ';
  if ( empty($qte_error) && isset($strInfo) ) echo '<span id="infomessage">',$strInfo,'</span> ';
  echo '<input type="hidden" name="id" value="',$id,'"/><input type="submit" name="ok" value="',$L['Save'],'"/></th></tr>';
  }
}

echo '<tr class="tr_u">
<td class="tf_u tf_u_first"></td>
<td class="tf_u"></td>
<td class="tf_u tf_u_last"></td>
</tr>
</table>
';

if ( $bMap )
{  
  if ( $bEdit && $_SESSION[QT]['willedit'] )
  {
    $strPosition .= '<p class="small" style="margin:2px 0 4px 2px;text-align:right">'.$L['map']['canmove'];
    if ( empty($oUser->x) || empty($oUser->y) ) 
    {
    $strPosition .= ' | <a class="small" href="javascript:void(0)" onclick="createMarker(); return false;" title="'.$L['map']['H_pntadd'].'"/>'.$L['map']['pntadd'].'</a>';
    }
    else
    {
    $strPosition .= ' | <a class="small" href="javascript:void(0)" onclick="deleteMarker(); return false;"/>'.$L['map']['pntdelete'].'</a>';
    }
    $strPosition .= ' | <a class="small" href="javascript:void(0)" onclick="undoChanges(); return false;"/>'.$L['map']['undo'].'</a></p>';
  
    $strPosition .= '
    <div id="map_canvas" style="width:100%; height:345px;"></div>
    <input type="hidden" id="m_map_gcenter" name="m_map_gcenter" value="'.(!empty($oUser->y) ? $oUser->y.','.$oUser->x : '').'"/>
    ';
    $strPosition .= '<p class="small" style="margin:4px 0 2px 2px;text-align:right">'.$L['map']['addrlatlng'].' <input type="text" size="24" id="find" name="find" class="small" value="'.$_SESSION[QT]['m_map_gfind'].'" onKeyUp="handle_keypress(event,\'findit\')" title="'.$L['map']['H_addrlatlng'].'"/> <input type="submit" id="findit" class="small" onclick="showLocation(document.getElementById(\'find\').value); return false;" value="'.$L['Search'].'"/></p>';
  }
  else
  {
    $strPosition .= '<div id="map_canvas" style="width:100%; height:340px;"></div>';
    if ( empty($oUser->x) || empty($oUser->y) ) $strPosition = '<span class="p_gmap">'.$L['map']['E_noposition'].'</span>';
  }
  echo '<div class="div_gmap" style="margin-top:10px">',$strPosition,'</div>';
}

if ( $bEdit && $_SESSION[QT]['willedit'] ) echo '</form>';

echo '
</td>
</tr>
</table>
';

include('qte_usr_tabbot.php');

if ( $bEdit && $_SESSION[QT]['willedit'] && isset($strInfo) )
{
echo '
<script type="text/javascript">
<!--
setTimeout(\'document.getElementById("infomessage").style.color="#bbbbbb"\',3000);
setTimeout(\'document.getElementById("infomessage").style.color="#cccccc"\',3300);
setTimeout(\'document.getElementById("infomessage").style.color="#dddddd"\',3600);
setTimeout(\'document.getElementById("infomessage").innerHTML="&nbsp;"\',3900);
-->
</script>
';
}

// --------
// HTML END
// --------

if ( $bMap )
{

  // center
  if ( !empty($oUser->x) && !empty($oUser->y) )
  {
    $strUsername = QTunquote($oUser->name);
    $x = floatval($oUser->x);
    $y = floatval($oUser->y);
    $arrMapPoints = array( array(
    'y'=>$y,
    'x'=>$x,
    'title'=>$strUsername,
    'icon'=>$_SESSION[QT]['m_map']['U']['icon'],
    'shadow'=>$_SESSION[QT]['m_map']['U']['shadow'],
    'printicon'=>$_SESSION[QT]['m_map']['U']['printicon'],
    'printshadow'=>$_SESSION[QT]['m_map']['U']['printshadow']
    ) );
  }
  else
  {
  $x = QTgetx($_SESSION[QT]['m_map_gcenter']);
  $y = QTgety($_SESSION[QT]['m_map_gcenter']);
  $arrMapPoints = array();
  }

  if ( $bEdit && $_SESSION[QT]['willedit'] )
  {
  $strFooterAddScript = QTgmappoints($L['map'],$y,$x,'drag',$arrMapPoints,true,false).N.'mapload();';
  }
  else
  {
  $strFooterAddScript = QTgmappoints($L['map'],$y,$x,'',$arrMapPoints,false,false).N.'mapload();';
  }

}

include('qte_p_footer.php');

?>