<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( !$oVIP->CanAccess('V',0,true) ) $oVIP->EndMessage('!',$L['R_user'],$_SESSION[QT]['skin_dir'],0);

// --------
// INITIALISE
// --------

Include($_SESSION[QT]['language'].'/qte_lang_reg.inc');

$intY = ''; // no year at start-up
$intM = 1;
$intD = 1; 
if ( isset($_GET['y']) ) { $intY = intval(strip_tags($_GET['y'])); } 
if ( isset($_GET['m']) ) { $intM = intval(strip_tags($_GET['m'])); } 
if ( isset($_GET['d']) ) { $intD = intval(strip_tags($_GET['d'])); } 
if ( isset($_POST['y']) ) { $intY = intval(strip_tags($_POST['y'])); } 
if ( isset($_POST['m']) ) { $intM = intval(strip_tags($_POST['m'])); } 
if ( isset($_POST['d']) ) { $intD = intval(strip_tags($_POST['d'])); } 

$oVIP->selfurl = 'qte_usr_new.php';
$oVIP->selfname = $L['Register'];
$oVIP->exitname = '&laquo;'.S.$L['Register'];

// --------
// EXECUTE FORM
// --------

if ( isset($_POST['ok']) )
{
  if ( !isset($_POST['agreed']) )
  {
    include('qte_p_header.php');
    echo '<br/><div class="div_msgboxtitle" style="width: 350px;">',$oVIP->selfname,'</div>',N;
    echo '<div class="div_msgbox" style="width: 350px;">',N;
    $strFile = $_SESSION[QT]['language'].'/sys_not_agree.txt';
    if ( file_exists($strFile) ) { include($strFile); } else { echo 'Rules not agreed...'; }
    echo '<br/><a href="',$oVIP->selfurl,'?y=',$intY,'&amp;m=',$intM,'&amp;d=',$intD,'">',$oVIP->selfname,'</a></div><br/>',N;
    include('qte_p_footer.php');
    Exit;
  }

  if ( !QTisvaliddate($intY*10000+$intM*100+$intD,true,false,false) ) $qte_error = $L['Birthday'].S.$L['E_invalid'];  

  if ( empty($qte_error) )
  {
    // continue to registration form
    if ( headers_sent() )
    {
    echo '<a id="exiturl" href="qte_form_reg.php?y=',$intY,'&m=',$intM,'&d=',$intD,'">',$L['Register'],'</a><meta http-equiv="REFRESH" content="0;url=qte_form_reg.php?y=',$intY,'&m=',$intM,'&d=',$intD,'">';
    }
    else
    {
    header('Location: qte_form_reg.php?y='.$intY.'&m='.$intM.'&d='.$intD);
    }
    Exit;
  }
}

// --------
// HTML START
// --------

$strHeaderAddCss = 'qte_register.css';
include('qte_p_header.php');

echo '
<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.y.value.length!=4) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Year'],'")); return false; }
  return null;
}
-->
</script>
';

echo '<form method="post" action="',$oVIP->selfurl,'" onsubmit="return ValidateForm(this);">',N;
echo '<div class="scrollmessage">',N;

$strFile = $_SESSION[QT]['language'].'/sys_section_rules.txt';
if (file_exists($strFile)) { include($strFile); } else { echo 'Missing file:<br/>',$strFile; }

echo '</div>',N;
echo '<p><input type="checkbox" id="agreed" name="agreed"/><label for="agreed"><b>&nbsp;',$L['Agree'],'</b></label></p>',N;
echo '<div class="div_msgboxtitle" id="login_header" style="width: 300px;">',$oVIP->selfname,'</div>',N;
echo '<div class="div_msgbox" id="login" style="width: 300px;"><p>';
echo '<label for="y">',$L['Birthday'],'</label></p><p>';
echo '<select name="d" size="1">',N;
echo QTastags(array(1=>1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31),null,$intD);
echo '</select>',N;
echo '<select name="m" size="1">',N;
echo QTastags($L['dateMMM'],null,$intM);
echo '</select>',N;
echo '<input type="text" id="y" name="y" size="4" maxlength="4" value="',$intY,'"/>';
echo '</p><p><input type="submit" name="ok" value="',$L['Register'],'"/></p>';
if ( !empty($qte_error) ) echo '<span class="error">',$qte_error,'</span>&nbsp;';
echo '</div>',N,'</form>',N,N;

// --------
// HTML END
// --------

include('qte_p_footer.php');

?>