<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( !$oVIP->CanAccess('MUV',4,true) ) $oVIP->EndMessage('!',$L['R_user'],$_SESSION[QT]['skin_dir'],0);

// --------
// INITIALISE
// --------

include($_SESSION[QT]['language'].'/qte_lang_reg.inc');

$oVIP->selfurl = 'qte_usr_m.php';
$oVIP->selfname = $L['MProfile'];

$id = -1;
if ( isset($_GET['id']) ) $id = intval(strip_tags($_GET['id']));
if ( $id<0 ) die('Wrong id in '.$oVIP->selfurl);

if ( !isset($_SESSION[QT]['willedit']) ) $_SESSION[QT]['willedit']=false;
if ( isset($_GET['editstart']) ) $_SESSION[QT]['willedit']=true;
if ( isset($_GET['editstop']) ) $_SESSION[QT]['willedit']=false;

$bEdit = false; 
if ( $oVIP->role=='M' || $oVIP->role=='A' ) $bEdit=true;
if ( $id<1 ) $bEdit=false;

$oUser = new cUser($oDB,$id,$qte_fields);

// -- QUERY USER --

$arrMembership = array();
$oDB->Query('SELECT s.id,s.title,s.descr,s.picture,s.members,s.type FROM '.TABSECTION.' s INNER JOIN '.TABS2U.' l  ON l.sid=s.id WHERE l.userid='.$id.' ORDER BY l.sid DESC');
while ( $row=$oDB->Getrow() )
{ 
  if ( $row['type']=='0' ) $arrMembership[intval($row['id'])] = $row;
  if ( $row['type']=='1' && $oVIP->role=='A' ) $arrMembership[intval($row['id'])] = $row;
  if ( $row['type']=='1' && $oVIP->role=='M' ) $arrMembership[intval($row['id'])] = $row;
}

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  $bEdited = false;
  if ( !isset($_POST['id'])  ) die('Missing id');
  $id = intval($_POST['id']);

  // -- ADD TO TEAM --

  if ( isset($_POST['addteam']) ) {
  if ( $_POST['addteam']!='no' ) {
    // update add team
    $oUser->InSection($oDB,$_POST['addteam'],'add',$id);
    cSection::UpdateStats($oDB,$_POST['addteam']);
    $bEdited = true;
  }}

  // -- REM FROM TEAM --

  if ( isset($_POST['delteam']) ) {
  if ( $_POST['delteam']!='no' ) {
    // update del team
    if ( $_POST['delteam']=='all' )
    {
      $oDB->Query('DELETE FROM '.TABS2U.' WHERE sid<>0 AND userid='.$id);
      foreach ( $arrMembership as $intId => $strTeam)
      {
        if ( $intId>0 ) cSection::UpdateStats($oDB,$intId);
      }
      $bEdited = true;
    }
    else
    {
      $oUser->InSection($oDB,$_POST['delteam'],'rem',$id);
      cSection::UpdateStats($oDB,$_POST['delteam']);
      $bEdited = true;
    }
  }}
    
  // -- exit --
  
  if ( $bEdited ) 
  {
    $arrMembership = array();
    $oDB->Query('SELECT s.id,s.title,s.descr,s.picture,s.members,s.type FROM '.TABSECTION.' s INNER JOIN '.TABS2U.' l  ON l.sid=s.id WHERE l.userid='.$id);
    while ( $row=$oDB->Getrow() )
    {
      if ( $row['type']=='0' ) $arrMembership[$row['id']] = $row;
      if ( $row['type']=='1' && $oVIP->role=='A' ) $arrMembership[$row['id']] = $row;
      if ( $row['type']=='1' && $oVIP->role=='M' ) $arrMembership[$row['id']] = $row;
    }
    $strInfo = $L['S_save'];
  }
}

// --------
// HTML START
// --------

$bJava=false;
include('qte_p_header.php');

// -- BUTTON BAR & TITLE --

if ( $oVIP->role=='A' || $oVIP->role=='M' ) include('qte_usr_menu.php');
include('qte_usr_tabtop.php');

// -- DISPLAY PROFILE --

echo '
<table class="tab_hidden" cellspacing="0">
<colgroup span="2">
<col width="175"></col>
<col></col>
</colgroup>
<tr class="tr_hidden">
<td class="td_hidden">
';
include('qte_usr_inc.php');
echo '</td>',N;

echo '<td class="td_hidden">',N;

if ( $bEdit && $_SESSION[QT]['willedit'] ) echo '<form method="post" action="',$oVIP->selfurl,'?id='.$id.'">',N;

if ( !empty($qte_error) ) echo '<span class="error">',$qte_error,'</span>',N;

  echo '<table class="tab_cnt" cellspacing="0">',N;
  
  echo '<tr class="tr_cnt">
  <th class="th_u th_u_first th_u_empty"></th>
  <th class="th_u th_u_empty"></th>
  <th class="th_u th_u_last th_u_empty"></th>
  </tr>
  ',N;

  foreach ($arrMembership as $intId => $arrSection)
  {
    echo '<tr>';
    echo '<td class="td_u td_u_first">&nbsp;</td>',N;
    echo '<td class="td_u">';
    $oSEC = new cSection($oDB,$arrSection);
    $oSEC->descr .= '<br/><a href="qte_ind_section.php?s='.$oSEC->id.'" class="small">'.LangS('User',$oSEC->members,$L).'</a>';
    $oSEC->ShowInfo(
      'tab_si_section',
      'p_si_name_profile',
      'p_si_descr_profile',
      'img_si_profile',
      'right',
      'qte_ind_section.php?s='.$oSEC->id);
    echo ' </td>',N;
    echo '<td class="td_u td_u_last">&nbsp;</td>',N;
    echo '</tr>',N;
  }
  if ( count($arrMembership)==0 ) echo '<tr><td class="td_u td_u_first">&nbsp;</td><td class="td_u">',$L['E_no_membership'],'</td><td class="td_u td_u_last">&nbsp;</td></tr>';
  
  if ( $bEdit )
  {
    if ( $_SESSION[QT]['willedit'] )
    {
      echo '<tr><th class="th_u center" colspan="3">&nbsp;</th></tr>';
      // get the team list (without those in $arrMembership)
      $arrTeams = array('no'=>' ');
      foreach ($_SESSION['qteGoto'] as $strKey => $strTeam)
      {
        if ( !array_key_exists($strKey,$arrMembership) ) $arrTeams[$strKey] = $strTeam;
      }
      if ( count($arrTeams)>1 )
      {
        echo '<tr>';
        echo '<td class="td_u td_u_first">&nbsp;</td>',N;
        echo '<td class="td_u">';
        echo $L['User_section_add'],' <select name="addteam" id="addteam" size="1">',QTastags($arrTeams),'</select>';
        echo '</td>',N;
        echo '<td class="td_u td_u_last">&nbsp;</td>',N;
        echo '</tr>',N;
      }
      // get the team list (add [all])
      $arrTeams = array('no'=>' ');
      foreach ($arrMembership as $strKey => $arrTeam)
      {
        $arrTeams[$strKey] = $arrTeam['title'];
      }
      //if ( isset($arrTeams[0]) ) unset($arrTeams[0]);
      if ( count($arrTeams)>1 )
      {
        $arrTeams['all'] = '['.$L['All'].']';
        echo '<tr>';
        echo '<td class="td_u td_u_first">&nbsp;</td>',N;
        echo '<td class="td_u">';
        echo $L['User_section_del'],' <select name="delteam" id="delteam" size="1">',QTastags($arrTeams),'</select>';
        echo '</td>',N;
        echo '<td class="td_u td_u_last">&nbsp;</td>',N;
        echo '</tr>',N;
      }
      echo '<tr><th class="th_u_submit" colspan="3">';
      if ( !empty($qte_error) ) echo '<span class="error">',$qte_error,'</span> ';
      if ( empty($qte_error) && !empty($qte_warning) ) echo '<span class="warning">',$qte_warning,'</span> ';
      if ( empty($qte_error) && isset($strInfo) ) echo '<span id="infomessage">',$strInfo,'</span> ';
      echo '<input type="hidden" name="id" value="',$id,'"/><input type="submit" name="ok" value="',$L['Save'],'"/></th></tr>';
    }
  }

  echo '<tr class="tr_cnt">
  <td class="tf_u tf_u_first"></td>
  <td class="tf_u"></td>
  <td class="tf_u tf_u_last"></td>
  </tr>
  ';
  
echo '</table>';

if ( $bEdit && $_SESSION[QT]['willedit'] ) echo '</form>';

echo '
</td>
</tr>
</table>
';

include('qte_usr_tabbot.php');

if ( $bEdit && $_SESSION[QT]['willedit'] && isset($strInfo) )
{
echo '
<script type="text/javascript">
<!--
setTimeout(\'document.getElementById("infomessage").style.color="#bbbbbb"\',3000);
setTimeout(\'document.getElementById("infomessage").style.color="#cccccc"\',3300);
setTimeout(\'document.getElementById("infomessage").style.color="#dddddd"\',3600);
setTimeout(\'document.getElementById("infomessage").innerHTML="&nbsp;"\',3900);
-->
</script>
';
}

// --------
// HTML END
// --------

include('qte_p_footer.php');

?>