<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080613
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');

// --------
// INITIALISE
// --------

Include($_SESSION[QT]['language'].'/qte_lang_reg.inc');

$oVIP->selfurl = 'qte_usr_login.php';
$oVIP->selfname = $L['Login'];

$strName = '';
if ( isset($_GET['dfltname']) )
{
  $strName=$_GET['dfltname'];  if ( get_magic_quotes_gpc() ) $strName = stripslashes($strName);
  $strName=QThtmlquote(urldecode($strName));
}

// --------
// SUBMITTED for login
// --------

if ( isset($_POST['ok']) )
{

  // CHECK VALUE

  $strName = trim($_POST['title']); if ( get_magic_quotes_gpc() ) $strName = stripslashes($strName);
  $strName = QTformattitle($strName,24);
  if ( !QTislogin($strName) ) $qte_error = $qte_fields['username'][0].S.$L['E_invalid'];

  $strPwd = trim($_POST['pwd']); if ( get_magic_quotes_gpc() ) $strPwd = stripslashes($strPwd);
  $strPwd = QTformattitle($strPwd,24);
  if ( !QTispassword($strPwd) ) $qte_error = $L['E_pwd_char'];

  // LOGGING IN
  
  if ( empty($qte_error) )
  {

    $arrLog = $oVIP->Login($oDB, $strName, $strPwd, isset($_POST['remember']));

    if ( $oVIP->auth ) 
    {

      // check registered if children (and coppa active)
      if ( $_SESSION[QT]['register_coppa']=='1' ) {
      if ( isset($arrLog['coppa']) ) {
      if ( $arrLog['coppa']==2 ) {
        $oVIP->exitname = $_SESSION[QT]['section_index'];
        $oVIP->EndMessage(NULL,'<h2>'.$L['Welcome'].' '.(isset($arrLog['fullname']) ? $arrLog['fullname'] : '').'</h2>'.$L['E_access'].'<br/>'.$L['E_coppa_confirm'],$_SESSION[QT]['skin_dir'],0);
      }}}
            
      // end message
      $oVIP->exitname = $_SESSION[QT]['section_index'];
      $oVIP->EndMessage(NULL,'<h2>'.$L['Welcome'].' '.(isset($arrLog['fullname']) ? $arrLog['fullname'] : '').'</h2><br/><br/>',$_SESSION[QT]['skin_dir'],2,'350px','login_header','login');
    }
    else
    {
      $qte_error = $L['E_access'];
    }
  }
  
}

// --------
// SUBMITTED for logout
// --------

if ( isset($_GET['a']) ) {
if ( $_GET['a']=='out' ) {

  // LOGGING OUT

  $oVIP->Logout();
    
  // REBOOT
  
  GetParam($oDB,true);
  
    // check major parameters
    if ( !isset($_SESSION[QT]['skin_dir']) ) $_SESSION[QT]['skin_dir']='skin/default';
    if ( !isset($_SESSION[QT]['language']) ) $_SESSION[QT]['language']='language/english';
    if ( empty($_SESSION[QT]['skin_dir']) ) $_SESSION[QT]['skin_dir']='skin/default';
    if ( empty($_SESSION[QT]['language']) ) $_SESSION[QT]['language']='language/english';
    if ( substr($_SESSION[QT]['skin_dir'],0,5)!='skin/' ) $_SESSION[QT]['skin_dir'] = 'skin/'.$_SESSION[QT]['skin_dir'];
    if ( substr($_SESSION[QT]['language'],0,9)!='language/' ) $_SESSION[QT]['language'] = 'language/'.$_SESSION[QT]['language'];

  // End message
  $oVIP->selfurl = 'qte_usr_login.php?a=out';
  $oVIP->selfname = $L['Logout'];  
  $oVIP->exitname = $_SESSION[QT]['section_index'];
  $oVIP->EndMessage(NULL,'<br/>'.$L['Goodbye'].'<br/><br/>', $_SESSION[QT]['skin_dir'],2,'300px','login_header','login');

}}

// --------
// HTML START
// --------

include('qte_p_header.php');

echo '
<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.title.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': ',$qte_fields['username'][0],'")); return false; }
  if (theForm.pwd.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Password'],'")); return false; }
  return null;
}
-->
</script>
';

echo '<br/>
<div class="div_msgboxtitle" id="login_header" style="width: 350px;">',$oVIP->selfname,'</div>
<div class="div_msgbox" id="login" style="width: 350px;">
';
if ( !empty($qte_error) ) echo '<span class="error">',$qte_error,'</span>&nbsp;';
echo '<form method="post" action="',$oVIP->selfurl,'" onsubmit="return ValidateForm(this);">
<p style="text-align:right"><label for="title">',$qte_fields['username'][0],'</label>&nbsp;<input type="text" id="title" name="title" size="20" maxlength="24" value="',$strName,'"/>&nbsp;</p>
<p style="text-align:right"><label for="pwd">',$L['Password'],'</label>&nbsp;<input type="password" id="pwd" name="pwd" size="20" maxlength="24" onKeyUp="handle_keypress(event,\'ok\')"/>&nbsp;</p>
<p style="text-align:right"><input type="checkbox" id="remember" name="remember"/>&nbsp;<label for="remember">',$L['Remember'],'</label>&nbsp;&nbsp;
<input type="submit" id="ok" name="ok" value="',$L['Ok'],'"/>&nbsp;</p>
<p style="text-align:right"><a class="small" href="qte_usr_new.php">',$L['Register'],'</a> &middot; <a class="small" href="qte_usr_pwd_for.php">',$L['Forgotten_pwd'],'</a>&nbsp;</p>
</form>
</div>
<br/>
';

// --------
// HTML END
// --------

echo '
<script type="text/javascript">
<!--
document.getElementById("title").focus();
if ( document.getElementById("title").value.length>1 ) { document.getElementById("pwd").focus(); }
-->
</script>
';

include('qte_p_footer.php');

?>