<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080613
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( $_SESSION[QT]['picture']=='0' ) die($L['E_access']);
if ( !$oVIP->CanAccess('MU',0,true) ) die($L['R_user']);

// --------
// INITIALISE
// --------

include('bin/qt_lib_smtp.php');
Include($_SESSION[QT]['language'].'/qte_lang_reg.inc');

$id = -1;
if ( isset($_GET['id']) ) $id = intval(strip_tags($_GET['id']));
if ( isset($_POST['id']) ) $id = intval(strip_tags($_POST['id']));
if ( $id<0 ) die('Missing parameters');

$oVIP->selfurl = 'qte_usr_img.php';
$oVIP->selfname = $L['Change_picture'];
$oVIP->exiturl = 'qte_usr_s.php?id='.$id;
$oVIP->exitname = $L['Profile'];

// --------
// SUBMITTED FOR DELETE
// --------

if ( isset($_POST['del']) )
{
  $oDB->Query('UPDATE '.TABUSER.' SET picture=null WHERE id='.$id);
  if (file_exists("picture/$id.gif")) unlink("picture/$id.gif");
  if (file_exists("picture/$id.jpg")) unlink("picture/$id.jpg");
  if (file_exists("picture/$id.jpeg")) unlink("picture/$id.jpeg");
  if (file_exists("picture/$id.png")) unlink("picture/$id.png");
  // exit
  $oVIP->EndMessage(NULL,$L['S_delete'],$_SESSION[QT]['skin_dir'],2);
}

// --------
// SUBMITTED FOR UPLOAD
// --------

if ( isset($_POST['ok']) )
{
  $bUpload = false;
  // ---------
  // load picture
  // ---------
  if ( !is_uploaded_file($_FILES['title']['tmp_name']) ) $qte_error = 'You did not upload a file!';

  // ---------
  // is size (kb) ok
  // ---------
  if ( empty($qte_error) )
  {
    if ( $_FILES['title']['size'] > (intval($_SESSION[QT]['picture_size'])*1024+16) )
    {
    $qte_error = $L['E_file_size'].' (&lt;'.$_SESSION[QT]['picture_size'].' Kb)';
    unlink($_FILES['title']['tmp_name']);
    }
  }

  // ---------
  // check extension
  // ---------
  if ( empty($qte_error) )
  {
    $arrFileextensions = explode(',',$_SESSION[QT]['picture']);
    $strExt = strtolower(substr(strrchr($_FILES['title']['name'],'.'),1));
    if ( in_array($strExt,$arrFileextensions) )
    {
      $bUpload=true;
    }
    else
    {
      $qte_error = 'Format ('.$strExt.') not supported... You must use '.$_SESSION[QT]['picture'];
      unlink($_FILES['title']['tmp_name']);
      $bUpload = false;
    }
  }
  
  // ---------
  // is size ok
  // ---------
  if ( empty($qte_error) )
  {
    $size = getimagesize($_FILES['title']['tmp_name']);
    $width = $size[0];
    $height = $size[1];
    if (($width-2 > $_SESSION[QT]['picture_width']) or ($height-2 > $_SESSION[QT]['picture_height']))
    {
      $qte_error = $_SESSION[QT]['picture_width'].'x'.$_SESSION[QT]['picture_height'].S.$L['E_pixels_max'];
      unlink($_FILES['title']['tmp_name']);
    }
  }
  
  // ---------
  // define target name
  // ---------
  if ( empty($qte_error) && $bUpload )
  {
    //File has passed all validation, copy it to the final destination and remove the temporary file:
    copy($_FILES['title']['tmp_name'],"picture/$id.$strExt");
    $oDB->Query('UPDATE '.TABUSER.' SET picture="picture/'.$id.'.'.$strExt.'" WHERE id='.$id);
    unlink($_FILES['title']['tmp_name']);

    // send parent email (if coppa)
    if ($_POST['children']!='0') {
    if ( $_SESSION[QT]['register_coppa']=='1') {
      $oDB->Query('SELECT parentmail FROM '.TABCHILD.' WHERE id='.$id);
      $row = $oDB->Getrow();
      $strSubject = $_SESSION[QT]['site_name'].' - New picture';
      $strMessage = "We inform you that your children has changed his/her picture on the board {$_SESSION[QT]['site_name']}.\nLogin: %s\nPassword: %s";
      $strFile = $_SESSION[QT]['language'].'/mail_img_coppa.inc';
      if ( file_exists($strFile) ) include($strFile);
      $strMessage = sprintf($strMessage,$_POST['username']);
      QTmail($row['parentmail'],QTunquote($strSubject),QTunquote($strMessage),QTE_HTML_CHAR);
    }}
    // exit
    $oVIP->EndMessage(NULL,$L['S_update'],$_SESSION[QT]['skin_dir'],2);
  }

}

// --------
// HTML START
// --------

if ( $oVIP->role!='A' ) { if ($oVIP->id!=$id) die($L['R_user']); }

include('qte_p_header.php');

$oUser = new cUser($oDB,$id,$qte_fields);

echo '<br/>',N;
echo '<table class="tab_hidden" cellspacing="0">',N;
echo '<tr class="tr_hidden">',N;
echo '<td class="td_hidden" style="width:175px;">',
AsImgBox(AsImg($oUser->picture),'div_pic_box',null,$oUser),'</td>',N;
echo '<td class="td_hidden">',N;

echo '<div class="div_msgboxtitle" style="width: 350px;">',$oVIP->selfname,'</div>',N;
echo '<div class="div_msgbox" style="width:350px;">',N;

echo '
<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.title.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': File")); return false; }
  return null;
}
-->
</script>
';

echo '<form method="post" action="',$oVIP->selfurl,'" enctype="multipart/form-data" onsubmit="return ValidateForm(this);">',N;
if ( !empty($qte_error) ) echo '<span class="error">',$qte_error,'</span>',N;
echo '<p class="small" style="text-align:right">',$L['H_Change_picture'],'</p>',N;
echo '<p style="text-align:right">',N;
echo '<input type="file" id="title" name="title" size="32"/>',N;
echo '<input type="hidden" name="max_file_size" value="10000"/>',N;
echo '<input type="hidden" name="username" value="',$oUser->username,'"/>',N;
echo '<input type="hidden" name="id" value="',$id,'"/>',N;
echo '<input type="hidden" name="children" value="',$oUser->coppa,'"/>',N;
echo '<input type="submit" name="ok" value="',$L['Save'],'"/></p>',N;
echo '</form><br/>',N;
echo '<form method="post" action="',$oVIP->selfurl,'">',N;
echo '<p style="text-align:right">',N;
echo $L['Delete_picture'],S,N;
echo '<input type="hidden" name="id" value="',$id,'"/>',N;
echo '<input type="submit" name="del" value="',$L['Delete'],'"/></p>',N;
echo '</form>',N;
echo '&laquo;&nbsp;<a href="',$oVIP->exiturl,'">',$oVIP->exitname,'</a>',N;
echo '</div>',N;

echo '</td>',N;
echo '</tr>',N;
echo '</table>',N,'<br/>',N;

// --------
// HTML END
// --------

include('qte_p_footer.php');

?>