<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( !$oVIP->CanAccess('MUV',4,true) ) $oVIP->EndMessage('!',$L['R_user'],$_SESSION[QT]['skin_dir'],0);
if ( $_SESSION[QT]['upload']!='1' ) die('Upload not allowed');

// --------
// INITIALISE
// --------

include($_SESSION[QT]['language'].'/qte_lang_reg.inc');

$id = -1;
if ( isset($_POST['id']) ) $id = intval($_POST['id']);
if ( isset($_GET['id']) ) $id = intval($_GET['id']);
if ( $id<0 ) die('Wrong id in '.$oVIP->selfurl);

if ( !isset($_SESSION[QT]['willedit']) ) $_SESSION[QT]['willedit']=false;
if ( isset($_GET['editstart']) ) $_SESSION[QT]['willedit']=true;
if ( isset($_GET['editstop']) ) $_SESSION[QT]['willedit']=false;

$bEdit = false;
if ( $oVIP->role=='A' || $oVIP->role=='M' ) $bEdit=true;
if ( $oVIP->id==$id && $_SESSION[QT]['member_right']!='0' ) $bEdit=true;
if ( $id<1 ) $bEdit=false;

$oUser = new cUser($oDB,$id);
$bUpload = false;

$oVIP->selfurl = 'qte_usr_d.php';
$oVIP->selfname = $L['DProfile'];
$oVIP->exiturl = 'qte_usr_d.php?id='.$id;
$oVIP->exitname = $L['DProfile'];

// --------
// SUBMITTED UPLOAD
// --------

if ( isset($_POST['ok']) )
{  
  $strFile = strtolower($_FILES['title']['name']);
  $strName = strip_tags($_POST['name']); if ( get_magic_quotes_gpc() ) $strName = stripslashes($strName);
  $strName = QThtmlquote($strName); if ( empty($strName) ) $strName = $strFile;

  $strExt = substr(strrchr($strFile,'.'),1);
  $strDate = date('Ymd');
  $strFile = $id.'_'.$strDate.'_'.date('Hi').'_'.substr($strFile,0,4).'.'.$strExt;

  // ---------
  // load picture
  // ---------
  if ( !is_uploaded_file($_FILES['title']['tmp_name']) ) $qte_error = 'You did not upload a file!';

  // ---------
  // is size (kb) ok
  // ---------
  if ( empty($qte_error) )
  {
    if ( !isset($_SESSION[QT]['uploadsize']) ) $_SESSION[QT]['uploadsize']=1000;
    if ( $_FILES['title']['size'] > (intval($_SESSION[QT]['uploadsize'])*1024+16) )
    {
      $qte_error = $L['E_file_size'].' (&lt;'.$_SESSION[QT]['uploadsize'].' Kb)';
      unlink($_FILES['title']['tmp_name']);
    }
  }

  // ---------
  // check extension and mimetype
  // ---------
  if ( empty($qte_error) )
  {
    include('bin/qte_upload.php');
    if ( isset($arrFileextensions) ) {
    if ( !empty($arrFileextensions) ) {
    if ( !in_array($strExt,$arrFileextensions) ) {
      $qte_error = "Format not supported... [.$str]";
      unlink($_FILES['title']['tmp_name']);
    }}}
    if ( isset($arrMimetypes) ) {
    if ( !empty($arrMimetypes) ) {
    if ( !in_array(strtolower($_FILES['title']['type']),$arrMimetypes) ) {
      $qte_error = 'Format not supported... '.$_FILES['title']['type'];
      unlink($_FILES['title']['tmp_name']);
    }}}
  }

  // ---------
  // copy the file
  // ---------
  if ( empty($qte_error) )
  {
    // File has passed all validation, copy it to the final destination and remove the temporary file:
    if ( copy($_FILES['title']['tmp_name'],QTE_DIR_DOC.$strFile) )
    {
      $oDB->Query( 'INSERT INTO '.TABDOC.' (id,docname,docfile,docpath,docdate) VALUES ('.$id.',"'.$strName.'","'.$strFile.'","'.QTE_DIR_DOC.'","'.$strDate.'")' );
      $bUpload=true;
    }
    else
    {
      echo '<p class="error">Unable to copy the file. The directory /',QTE_DIR_DOC,' is probably not writeable...</p>';
    }
    unlink($_FILES['title']['tmp_name']);

  }

  // ---------
  // Exit
  // ---------
  if ( $bUpload ) $strInfo = $L['S_save'];

}

// --------
// SUBMITTED DELETE
// --------

if ( isset($_GET['del']) )
{
  if ( strstr($_GET['del'],strval($id).'_') )
  {
    $oDB->Query( 'DELETE FROM '.TABDOC.' WHERE id='.$id.' AND docfile="'.$_GET['del'].'"' );
    if (file_exists(QTE_DIR_DOC.$_GET['del'])) unlink(QTE_DIR_DOC.$_GET['del']);
    // exit
    $oVIP->EndMessage(NULL,$L['S_delete'],$_SESSION[QT]['skin_dir'],2);
  }
  else
  {
    die('Unable to delete the file: Invalid document filename.');
  }
}

// --------
// HTML START
// --------

// -- QUERY DOCS --

$arrDocs = array();
$oDB->Query('SELECT * FROM '.TABDOC.' WHERE id='.$id.' ORDER BY docdate DESC');
while ( $row=$oDB->Getrow() )
{ 
  $arrDocs[] = $row;
}

$bJava=false;
include('qte_p_header.php');

// -- BUTTON BAR & TITLE --

if ( $oVIP->role=='A' || $oVIP->role=='M' ) include('qte_usr_menu.php');
include('qte_usr_tabtop.php');

// -- DISPLAY DOCS --

echo '
<table class="tab_hidden" cellspacing="0">
<colgroup span="2"><col width="175"></col><col></col></colgroup>
<tr class="tr_hidden">
<td class="td_hidden">
';
include('qte_usr_inc.php');
echo '</td>',N;

echo '<td class="td_hidden">',N;

if ( $bEdit && $_SESSION[QT]['willedit'] ) echo '<form method="post" action="',$oVIP->selfurl,' " enctype="multipart/form-data">',N;

if ( !empty($qte_error) ) echo '<span class="error">',$qte_error,'</span>',N;

  echo '<table class="tab_cnt" cellspacing="0">
  <colgroup span="3"><col width="100"></col><col></col><col width="150"></col></colgroup>
  <tr class="tr_cnt">
  <th class="th_u th_u_first th_u_empty"></th>
  <th class="th_u th_u_empty"></th>
  <th class="th_u th_u_last th_u_empty"></th>
  </tr>
  ',N;

  foreach ($arrDocs as $intId => $arrDoc)
  {
    echo '<tr>';
    echo '<td class="td_u td_u_first small">',QTdate($arrDoc['docdate'],$arrQTdate),'</td>',N;
    echo '<td class="td_u">';
    if ( file_exists(QTE_DIR_DOC.$arrDoc['docfile']) )
    {
      echo '<a href="',QTE_DIR_DOC.$arrDoc['docfile'],'" target="_blank">',$arrDoc['docname'],'</a>';
    }
    else
    {
      echo $arrDoc['docname'];
    }
    echo '</td>';
    echo '<td class="td_u td_u_last">';
    if ( $bEdit && $_SESSION[QT]['willedit'] )
    {
      echo '<a class="small" href="qte_cmd.php?u=',$id,'&a=renamedoc&v=',$arrDoc['docfile'],'">',$L['Rename'],'</a> | ';
      echo '<a class="small" href="',$oVIP->selfurl,'?id=',$id,'&del=',$arrDoc['docfile'],'">',$L['Delete'],'</a>';
    }
    echo '&nbsp;</td>',N;
    echo '</tr>',N;
  }
  if ( count($arrDocs)==0 ) echo '<tr><td class="td_u center" colspan="3">',$L['E_no_document'],'</td></tr>';
  
  if ( $bEdit )
  {
    if ( $_SESSION[QT]['willedit'] )
    {
      echo '<tr><th class="th_u" colspan="3">&nbsp;</th></tr>';
      echo '<tr><td class="td_u" colspan="3">',$L['Document_add'],' <input type="file" name="title" id="title" size="35" /></td></tr>',N;
      echo '<tr><td class="td_u" colspan="3">',$L['Document_name'],' <input type="text" name="name" id="name" size="40" maxlength="255"/></td></tr>',N;
      echo '<tr><th class="th_u_submit" colspan="3"><input type="hidden" name="id" value="',$id,'"/><input type="submit" name="ok" value="',$L['Add'],'"/></th></tr>',N;
    }
  }

  echo '<tr class="tr_cnt">
  <td class="tf_u tf_u_first"></td>
  <td class="tf_u"></td>
  <td class="tf_u tf_u_last"></td>
  </tr>
  ';
  
echo '</table>';

if ( $bEdit && $_SESSION[QT]['willedit'] ) echo '</form>';

echo '
</td>
</tr>
</table>
';

include('qte_usr_tabbot.php');

if ( $bEdit && $_SESSION[QT]['willedit'] && isset($strInfo) )
{
echo '
<script type="text/javascript">
<!--
setTimeout(\'document.getElementById("infomessage").style.color="#bbbbbb"\',3000);
setTimeout(\'document.getElementById("infomessage").style.color="#cccccc"\',3300);
setTimeout(\'document.getElementById("infomessage").style.color="#dddddd"\',3600);
setTimeout(\'document.getElementById("infomessage").innerHTML="&nbsp;"\',3900);
-->
</script>
';
}


// --------
// HTML END
// --------

include('qte_p_footer.php');

?>