<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam team
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');

$oVIP->selfurl = 'qte_index.php';

// current section
if ( isset($_SESSION[QT]['section']) ) unset($_SESSION[QT]['section']);

// --------
// SECURITY
// --------

if ( $_SESSION[QT]['board_offline']=='1' )
{
  include('qte_p_header.php');

  $strFile = $_SESSION[QT]['language'].'/sys_offline.txt';
  if ( file_exists($strFile) ) { include($strFile); } else { echo "<h1>Board off-line</h1><p>The administrator has turned this board off-line.<br/>Please wait...</p>\n"; }
  echo "<br/>\n";
  include('qte_p_footer.php');
  exit;
}

if ( $_SESSION[QT]['visitor_right']<1 && $oVIP->role=='V' )
{
  include('qte_p_header.php');
  echo '<br/><div class="div_msgbox" style="width: 300px;">',$L['R_user'],'</div><br/>';
  include('qte_p_footer.php');
  exit;
}

// --------
// HTML START
// --------

$bJava=false;
include('qte_p_header.php');

// END IF NO DOMAIN
if ( count($_SESSION['qteDomains'])==0 )
{
echo '<br/>',$L['E_no_public_section'],'<br/><br/>';
include('qte_p_footer.php');
exit;
}

// DISPLAY
$intDom = 0;
foreach ($_SESSION['qteDomains'] as $intDomid => $strDomtitle)
{
  $intDom++;
  
  $arrSections = GetSections($oDB,$oVIP->role,$intDomid);

  if ( count($arrSections)>0 )
  {
    echo '<!-- domain ',$intDomid,': ',$strDomtitle,' -->',N;
    echo '<table class="tab_cnt tab_cnt_dom" cellspacing="0">',N;
    echo '<colgroup span="4">',N;
    echo '<col style="width:50px"></col>',N;
    echo '<col></col>',N;
    echo '<col style="width:200px"></col>',N;
    echo '<col style="width:60px"></col>',N;
    echo '</colgroup>',N;
    echo '<tr>',N;
    echo '<th class="th_i th_i_first">',S,'</th>',N;
    echo '<th class="th_i">',$strDomtitle,'</th>',N;
    echo '<th class="th_i center">',S,'</th>',N;
    echo '<th class="th_i center th_i_last">',$L['Users'],'</th>',N;
    echo '</tr>',N;

    // SHOW SECTIONS
    $i=0;
    $strAlt='1';

    foreach ($arrSections as $intKey => $arrValues)
    {
      $i++;
      $oSEC = new cSection(null,$arrValues);
      echo '<tr class="tr_cnt">',N;
      echo '<td class="td_i td_i_',$strAlt,' td_i_first center">',AsImg($_SESSION[QT]['skin_dir'].'/ico_section_'.$oSEC->type.'_'.$oSEC->status.'.gif','[+]',$L['Ico_section_'.$oSEC->type.'_'.$oSEC->status],'ico_section'),'</td>',N;
      echo '<td class="td_i td_i_',$strAlt,'"><a class="a_section" href="qte_ind_section.php?s=',$oSEC->id,'">',$oSEC->title,'</a><br/><span class="p_sectiondescr">',$oSEC->descr,'</span></td>',N;
      echo '<td class="td_i td_i_',$strAlt,' center">',(!empty($oSEC->picture) ? AsImg($oSEC->picture,'logo',$oSEC->title,null,null,'qte_ind_section.php?s='.$oSEC->id) : S),'</td>',N;
      echo '<td class="td_i td_i_',$strAlt,' td_i_last center">',$oSEC->members,'</td>',N;
      echo '</tr>',N;
      if ( $strAlt=='1' ) { $strAlt='2'; } else { $strAlt='1'; }
    }

    // no data
    echo '<tr>',N;
    echo '<td class="tf_i tf_i_first"></td>',N;
    echo '<td class="tf_i"></td>',N;
    echo '<td class="tf_i"></td>',N;
    echo '<td class="tf_i tf_i_last"></td>',N;
    echo '</tr>',N;

    echo '</table>',N;
    if ( $intDom<count($_SESSION['qteDomains']) ) echo '<!-- domain separator -->',N,'<div class="div_dom_separator"></div>',N;
  }
}

// --------
// HTML END
// --------

if ( isset($oSEC) ) unset($oSEC);
include('qte_p_footer.php');

?>