<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( !$oVIP->CanAccess('MUV',3,true) ) $oVIP->EndMessage('!',$L['R_user'],$_SESSION[QT]['skin_dir'],0);

// --------
// INITIALISE
// --------

include('bin/qte_fn_limitsql.php');

$strOrder = 'username';
$strDirec = 'ASC';
$intPage  = 1;
$intLimit = 0;
$intCount = 0;
if ( isset($_GET['view'])) $_SESSION[QT]['viewmode'] = $_GET['view'];

$oVIP->selfurl = 'qte_ind_result_prt.php';
$oVIP->selfname = $L['Search_result'];
$oVIP->exiturl = 'qte_ind_search.php';
$oVIP->exitname = $L['Search'];

// --------
// SUBMITTED
// --------

if ( isset($_GET['title']) ) {
if ( strlen($_GET['title'])<2 ) {
  // exit
  $oVIP->exiturl = 'qte_ind_search.php?';
  if ( isset($_GET['title']) ) $oVIP->exiturl .= '?title='.$_GET['title'];
  if ( isset($_GET['role']) ) $oVIP->exiturl .= '&amp;role='.$_GET['role'];
  if ( isset($_GET['status']) ) $oVIP->exiturl .= '&amp;status='.$_GET['status'];
  if ( isset($_GET['s']) ) $oVIP->exiturl .= '&amp;s='.$_GET['s'];
  $oVIP->EndMessage(NULL,$L['E_min_2_char'],$_SESSION[QT]['skin_dir'],2);
}}

$strInfo = '';
$strParam = '';

if ( isset($_GET['role']) )
{  
  $strSelect = '"role" as ufield,"'.$L['Userrole'][$_GET['role']].'" as ukey,u.id,u.username,u.title,u.firstname,u.midname,u.lastname,u.picture,u.status,u.phones,u.emails';
  $strFrom = TABUSER.' u';
  $strWhere = 'u.id>0 AND u.role="'.$_GET['role'].'"';
  $strInfo .= $L['Userroles'][$_GET['role']];
  $strParam .= (!empty($strParam) ? '&amp;' : '').'a=1&amp;role='.$_GET['role'];
  if ( isset($_GET['s']) )
  {  
    if ( $_GET['s']>=0 )
    {  
    $strFrom = TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid = u.id';
    $strWhere = 'u.id>0 AND l.sid='.$_GET['s'];
    $strInfo .= ' '.$L['In_section'].' "'.$_SESSION['qteGoto'][$_GET['s']].'"';
    $strParam .= (!empty($strParam) ? '&amp;' : '').'s='.$_GET['s'];
    }
  }  
}
if ( isset($_GET['age_criteria']) && isset($_GET['age']) )
{  
  $strFrom = TABUSER.' u';
  $intDate = date('Ymd');
  $intDate = intval($intDate)-intval($_GET['age'].'0000');
  switch ($_GET['age_criteria'])
  {
  case 'l':
    $strSelect = '"age" as ufield,"< '.$_GET['age'].'" as ukey,u.id,u.username,u.title,u.firstname,u.midname,u.lastname,u.picture,u.status,u.phones,u.emails,u.birthdate';
    $strWhere = 'birthdate <> "0" AND "'.$intDate.'" < birthdate';
    $strInfo .= $L['Age'].' < '.$_GET['age'];
    break;
  case 'u':
    $strSelect = '"age" as ufield,">= '.$_GET['age'].'" as ukey,u.id,u.username,u.title,u.firstname,u.midname,u.lastname,u.picture,u.status,u.phones,u.emails,u.birthdate';
    $strWhere = 'birthdate <> "0" AND "'.$intDate.'" >= birthdate';
    $strInfo .= $L['Age'].' >= '.$_GET['age'];
    break;
  case 'e':
    $strSelect = '"age" as ufield,"= '.$_GET['age'].'" as ukey,u.id,u.username,u.title,u.firstname,u.midname,u.lastname,u.picture,u.status,u.phones,u.emails,u.birthdate';
    $strInfo .= $L['Age'].' = '.$_GET['age'];
    if ( $_GET['age']=="0" )
    {
    $strWhere = 'birthdate = "0"';
    }
    else
    {
    $strWhere = 'birthdate <> "0" AND "'.$intDate.'" >= birthdate AND "'.($intDate-10000).'" < birthdate';
    }
    break;
  }    
  $strParam .= (!empty($strParam) ? '&amp;' : '').'age_criteria='.$_GET['age_criteria'].'&amp;age='.$_GET['age'];
  if ( isset($_GET['s']) )
  {  
    if ( $_GET['s']>=0 )
    {  
    $strFrom = TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid = u.id';
    $strWhere = 'u.id>0 AND l.sid='.$_GET['s'];
    $strInfo .= ' '.$L['In_section'].' "'.$_SESSION['qteGoto'][$_GET['s']].'"';
    $strParam .= (!empty($strParam) ? '&amp;' : '').'s='.$_GET['s'];
    }
  }  
}
if ( isset($_GET['status']) )
{  
  $strSelect = '"status" as ufield,"'.$_SESSION['qte_status_name'][$_GET['status']].'" as ukey,u.id,u.username,u.title,u.firstname,u.midname,u.lastname,u.picture,u.status,u.phones,u.emails';
  $strFrom = TABUSER.' u';
  $strWhere = 'u.id>0  AND u.status="'.$_GET['status'].'"';
  $strInfo .= $L['Status'].' "'.$_SESSION['qte_status_name'][$_GET['status']].'"';
  $strParam .= (!empty($strParam) ? '&amp;' : '').'a=1&amp;status='.$_GET['status'];
  if ( isset($_GET['s']) )
  {  
    if ( $_GET['s']>=0 )
    {  
    $strFrom = TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid = u.id';
    $strWhere = 'u.id>0 AND l.sid='.$_GET['s'];
    $strInfo .= ' '.$L['In_section'].' "'.$_SESSION['qteGoto'][$_GET['s']].'"';
    $strParam .= (!empty($strParam) ? '&amp;' : '').'s='.$_GET['s'];
    }
  }  
}
if ( isset($_GET['title']) )
{
  $strSelect = 'i.ufield,i.ukey,u.id,u.username,u.title,u.firstname,u.midname,u.lastname,u.picture,u.status,u.phones,u.emails';
  $strFrom = TABINDEX.' i INNER JOIN '.TABUSER.' u ON i.userid=u.id';
  $str = trim($_GET['title']); if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
  $str = strtoupper($str);
  $strWhere = 'i.userid>0 AND UPPER(i.ukey) LIKE "%'.$str.'%"';
  $strInfo .= $L['Users_with'].' "'.$str.'"';
  $strParam .= (!empty($strParam) ? '&amp;' : '').'title='.$str;
  if ( isset($_GET['s']) )
  {  
    if ( $_GET['s']>=0 )
    {  
    $strFrom = TABINDEX.' i INNER JOIN '.TABUSER. ' u ON i.userid=u.id INNER JOIN '.TABS2U.' l ON l.userid = u.id';
    $strWhere .= ' AND l.sid='.$_GET['s'];
    $strInfo .= ' '.$L['In_section'].' "'.$_SESSION['qteGoto'][$_GET['s']].'"';
    $strParam .= (!empty($strParam) ? '&amp;' : '').'s='.$_GET['s'];
    }
  }
}

if ( empty($strInfo) ) die('Missing parameters');
if (isset($_GET['page'])) { $intLimit = ($_GET['page']-1)*$_SESSION[QT]['items_per_page']; $intPage=$_GET['page']; } else { $intLimit=0; $intPage=1; }
if (isset($_GET['order'])) $strOrder = $_GET['order'];
if (isset($_GET['dir']))   $strDirec = $_GET['dir'];

// --------
// QUERY PREPARATION
// --------

// Order
$strFullOrder = 'u.'.$strOrder.' '.$strDirec;
if ( $strOrder=='fullname' ) $strFullOrder='u.lastname'.' '.$strDirec;
  // second order
  if ( $strOrder!='firstname' ) $strFullOrder .= ',u.firstname ASC';

// -----
// COUNT
// -----

$oDB->Query('SELECT count(id) as countid FROM '.$strFrom.' WHERE '.$strWhere);
$row = $row = $oDB->Getrow();
$intCount = $row['countid'];

// --------
// HTML START
// --------

$bToPrint=true;
if ( $bMap )
{ 
  $arrMapPoints = array();
  $strHeaderAddScript = QTgmapheader('http://gmaps-utility-library.googlecode.com/svn/trunk/markermanager/release/src/markermanager.js');
  $strBodyAddOnunload='GUnload()';
}
include('qte_p_header.php');

// --------
// Display info
// --------

echo '<h2>'.$oVIP->selfname.'</h2>',N;
echo '<p>'.$strInfo,S,'&middot;',S,LangS('Found',$intCount,$L),S,'&middot; <a href="qte_ind_search.php?',$strParam,'">',$L['Search'],'</a></p>',N;

if ( $intCount==0 )
{
  echo '
  <!-- COPYRIGHT LINE -->
  <div class="div_footer">
  <table class="tab_hidden">
  <tr class="tr_hidden">
  <td class="td_hidden" id="zone_footer_left"> </td>
  <td class="td_hidden" id="zone_footer_right">powered by <a href="http://www.qt-cute.org" class="a_footer_copy">QT-cute</a> v',QTEVERSION,'</td>
  </tr>
  </table>
  </div>
  <!-- END COPYRIGHT LINE -->

  </body>
  </html>';
  exit;
}

// --------
// Pager
// --------

$strPager = MakePager("$oVIP->selfurl?$strParam",$intCount,$_SESSION[QT]['items_per_page'],$intPage,$L);
if ( $strPager ) $strPager = $L['Page'].$strPager;

// --------
// Display top pager
// --------

if ( $strPager )
{
echo '
<!-- Pager -->
<table class="tab_pager tab_pager_top" cellspacing="0">
<tr class="tr_pager tr_pager_top">
<td class="td_pager td_pager_top">',$strPager,'</td>
</tr>
</table>
<!-- End pager -->
';
}
else
{
echo '<p></p>';
}

// --------
// Display members
// --------

echo '<table class="tab_cnt tab_cnt_member" cellspacing="0">',N;
echo '<tr class="tr_cnt">',N;

  // ----------
  // Prepare fields

  $arrFields = array();
  $arrPageFields = array('ufield','status_i','fullname','phones','emails','picture');
  
  foreach($arrPageFields as $i => $strField)
  {
    // extraclass
    $strExtraclass = '';
    if ( $i==0 ) $strExtraclass=' th_s_first';
    if ( $i>=(count($arrPageFields)-1) ) $strExtraclass=' th_s_last';

    if ( isset($qte_fields[$strField]) )
    {      
      switch ($strField)
      {
      case 'fullname':$arrFields[$strField]=array('sort'=>'lastname','dir'=>'ASC', 'text'=>$qte_fields[$strField][0], 'class'=>'th_s th_s_'.$strField.$strExtraclass); break;
      case 'status_i':$arrFields[$strField]=array('sort'=>'status',  'dir'=>'ASC', 'text'=>' &bull; ',                'class'=>'th_s th_s_'.$strField.$strExtraclass); break;
      case 'address': $arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>$qte_fields[$strField][0], 'class'=>'th_s th_s_'.$strField.$strExtraclass); break;
      case 'descr':   $arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>$qte_fields[$strField][0], 'class'=>'th_s th_s_'.$strField.$strExtraclass); break;
      case 'picture': $arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>$qte_fields[$strField][0], 'class'=>'th_s th_s_'.$strField.$strExtraclass); break;
      case 'phones':  $arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>$qte_fields[$strField][0], 'class'=>'th_s th_s_'.$strField.$strExtraclass); break;
      case 'age':     $arrFields[$strField]=array('sort'=>$strField, 'dir'=>'DESC','text'=>$qte_fields[$strField][0], 'class'=>'th_s th_s_'.$strField.$strExtraclass); break;
      case 'emails':  $arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>$qte_fields[$strField][0], 'class'=>'th_s th_s_'.$strField.$strExtraclass); break;
      case 'emails_i':$arrFields[$strField]=array('sort'=>false,     'dir'=>'ASC', 'text'=>$qte_fields['emails'][0],  'class'=>'th_s th_s_'.$strField.$strExtraclass); break;
      default:        $arrFields[$strField]=array('sort'=>$strField, 'dir'=>'ASC', 'text'=>$qte_fields[$strField][0], 'class'=>'th_s th_s_'.$strField.$strExtraclass); break;
      }      
    }
    else
    {
      switch ($strField)
      {
      case 'ufield':  $arrFields[$strField]=array('sort'=>false,'dir'=>'ASC','text'=>$L['Found'],'class'=>'th_s th_s_'.$strField.$strExtraclass); break;
      default:        $arrFields[$strField]=array('sort'=>false,'dir'=>'ASC','text'=>$strField,  'class'=>'th_s th_s_'.$strField.$strExtraclass); break;
      }
    }
  }
  // ---------
  TableHeader($arrFields,$intCount,"$oVIP->selfurl?page=1&amp;$strParam",$strOrder,$strDirec);
  // ---------

echo '</tr>',N;

  foreach($arrFields as $strKey => $arrValues) { $arrFields[$strKey]['class']=str_replace('th_','td_',$arrFields[$strKey]['class']); }
  // ----------
  $oDB->Query( LimitSQL($oDB->type, $strSelect.' FROM '.$strFrom.' WHERE '.$strWhere, $strFullOrder,$intLimit,$_SESSION[QT]['items_per_page'],$intCount) );
  // ----------
  include('qte_ind_inc.php');
  // ----------

echo '</table>',N;

// --------
// Display bottom pager
// --------

if ( $strPager )
{
echo '
<!-- Pager -->
<table class="tab_pager tab_pager_bot" cellspacing="0">
<tr class="tr_pager tr_pager_bot">
<td class="td_pager td_pager_bot">',$strPager,'</td>
</tr>
</table>
<!-- End pager -->
';
}

// MAP MODULE

if ( $bMap )
{
  if ( count($arrMapPoints)==0 )
  {
  echo '<p class="p_gmap">'.$L['map']['E_noposition'].'</p>';
  }
  else
  {
     //select zoomto (maximum 15 items in the list)
     if ( count($arrMapPoints)>1 )
     {
       $str = '<p class="p_gmap" style="margin:0 0 4px 0"><a class="a_gmap" href="javascript:void(0)" onclick="zoomToFullExtend(); return false;">'.$L['map']['zoomtoall'].'</a> | '.$L['Goto'].' <select class="gmap" id="zoomto" name="zoomto" size="1" onchange="map.setCenter(eval(this.value));">';
       $str .= '<option class="gmap" value="new GLatLng('.QTgety($_SESSION[QT]['m_map_gcenter']).','.QTgetx($_SESSION[QT]['m_map_gcenter']).')"> </option>';
       $i=0;
       foreach ( $arrMapPoints as $intKey => $arrMapPoint )
       {
       $str .= '<option class="gmap" value="new GLatLng('.$arrMapPoint['y'].','.$arrMapPoint['x'].')">'.$arrMapPoint['title'].'</option>';
       $i++; if ( $i>15 ) break;       
       }
       $str .= '</select></p>';
     }
     
  echo '
  <div class="div_gmap" style="margin-top:10px;width:550px">
  ',( count($arrMapPoints)>1 ? $str :'' ),'
  <div id="map_canvas" style="width:100%; height:350px;"></div>
  <p class="p_gmap" style="margin:4px 0 0 0">',sprintf($L['map']['items'],strtolower( LangS('User',count($arrMapPoints),$L)),strtolower(LangS('User',$oSEC->members,$L)) ),'</p>
  </div>
  ';
  }
}

// ---------
// HTML END
// ---------

if ( $bMap ) {
if ( count($arrMapPoints)>0 ) {

  $x = floatval(QTgetx($_SESSION[QT]['m_map_gcenter']));
  $y = floatval(QTgety($_SESSION[QT]['m_map_gcenter']));
  // center on the first ticket
  foreach ($arrMapPoints as $intKey => $arrMapPoint)
  {
    if ( !empty($arrMapPoints[$intKey]['y']) && !empty($arrMapPoints[$intKey]['x']) )
    {
    $y=$arrMapPoints[$intKey]['y'];
    $x=$arrMapPoints[$intKey]['x'];
    break;
    }
  }
  $strFooterAddScript = QTgmappoints($L['map'],$y,$x,'',$arrMapPoints).N.'mapload();';
  
  // add zoom full extend if option is set
  if ( count($arrMapPoints)>1 ) {
  if ( isset($_SESSION[QT]['m_map']['S']['zoom']) ) {  
  if ( $_SESSION[QT]['m_map']['S']['zoom'] ) {
    $strFooterAddScript .= ' zoomToFullExtend();';
  }}}
  
}}

include('qte_p_footer.php'); 

?>