<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Adressbook
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 */

session_start();
require_once('bin/qte_init.php');
if ( !$oVIP->CanAccess('MUV',2,true) ) $oVIP->EndMessage('!',$L['R_user'],$_SESSION[QT]['skin_dir'],0);

// ---------
// INITIALISE
// ---------

$s = -1;
if ( isset($_GET['s']) ) $s = intval(strip_tags($_GET['s']));
if ( $s<0 )  die('Missing team id...');

$strGroup = 'all';
$strOrder = 'username';
$strDirec = 'ASC';
$intLimit = 0;
$intPage  = 1;

// security check 1
if ( isset($_GET['group']) ) $strGroup = strip_tags($_GET['group']);
if ( isset($_GET['order']) ) $strOrder = strip_tags($_GET['order']);
if ( isset($_GET['dir']) ) $strDirec = strip_tags($_GET['dir']);
if ( isset($_GET['page']) ) $intPage = intval(strip_tags($_GET['page']));
if ( isset($_GET['view']) ) $_SESSION[QT]['viewmode'] = strip_tags($_GET['view']);

// security check 2 (no long argument)
if ( strlen($strGroup)>4 ) die('Invalid argument #group');
if ( strlen($strOrder)>12 ) die('Invalid argument #order');
if ( strlen($strDirec)>4 ) die('Invalid argument #dir');

$intLimit = ($intPage-1)*$_SESSION[QT]['items_per_page'];

$_SESSION[QT]['section'] = $s;

include('bin/qte_fn_limitsql.php');

$oSEC = new cSection($oDB,$s);

if ( $oSEC->type==1 && ($oVIP->role=='V' || $oVIP->role=='U') )
{
  // exit
  $oVIP->selfname = $L['Section'];
  $oVIP->exitname = $_SESSION[QT]['section_index'];
  $oVIP->EndMessage(NULL,$L['R_staff'],$_SESSION[QT]['skin_dir'],0);
}
if ( $oSEC->type==2 && $oVIP->role=='V' )
{
  // exit
  $oVIP->selfname = $L['Section'];
  $oVIP->exitname = $_SESSION[QT]['section_index'];
  $oVIP->EndMessage(NULL,$L['R_user'],$_SESSION[QT]['skin_dir'],0);
}

$oVIP->selfurl = 'qte_ind_email.php';
$oVIP->selfname = $L['Section'].': '.$oSEC->title;

$strShowZ   = ''; if ( !$_SESSION[QT]['show_Z'] ) $strShowZ = ' AND u.status<>"Z"';

  // COUNT [$intMembers]

  $strWhereGroup = '';
  Switch ($strGroup)
  {
    Case 'all': $strWhereGroup .= ' AND u.id>0'; Break;
    Case '0':   $strWhereGroup .= ' AND '.FirstCharCase($oDB,'u.username','a-z'); Break;
    Default:    $strWhereGroup .= ' AND '.FirstCharCase($oDB,'u.username','u').'="'.$strGroup.'"'; Break;
  }
  $oDB->Query('SELECT count(*) as countid FROM '.TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid=u.id WHERE l.sid='.$oSEC->id.$strShowZ.$strWhereGroup);
  $row = $oDB->Getrow();
  $intMembers = $row['countid'];

// --------
// Letters bar
// --------

$strGroups='';

if ( $intMembers>$_SESSION[QT]['items_per_page'] )
{
  $strGroups = '<td class="td_lettres" style="width:35px;">'.($strGroup=='all' ? '<b>'.$L['All'].'</b>' : '<a class="a_lettres" href="'.$oVIP->selfurl.'?s='.$s.'&amp;group=all">'.$L['All'].'</a>' ).'</td>';
  for ($g='A';$g!='AA';$g++)
  {
  $strGroups .= '<td class="td_lettres" style="width:18px;">'.($strGroup==$g ? '<b>'.$g.'</b>' : '<a class="a_lettres" href="'.$oVIP->selfurl.'?s='.$s.'&amp;group='.$g.'">'.$g.'</a>' ).'</td>';
  }
  $strGroups .= '<td class="td_lettres" style="width:18px;">'.($strGroup=='0' ? '<b>#</b>' : '<a class="a_lettres" href="'.$oVIP->selfurl.'?s='.$s.'&amp;group=0">#</a>' ).'</td>';
  $strGroups .= '<td class="td_hidden">&nbsp;</td>'.N;
}

// --------
// Pager
// --------

$strPager = MakePager("$oVIP->selfurl?s={$oSEC->id}&group=$strGroup",$intMembers,$_SESSION[QT]['items_per_page'],$intPage,$L);
if ( !empty($strPager) ) { $strPager = $L['Page'].$strPager; } else { $strPager=S; }
if ( $intMembers<$oSEC->members ) $strPager = '<span class="small">'.$intMembers.' '.$L['Selected_from'].' '.$oSEC->members.' '.strtolower($L['Users']).'</span>'.($strPager==S ? '' : ' | '.$strPager);

// --------
// HTML START
// --------

include('qte_p_header.php');

// --------
// Display description
// --------

if ( $_SESSION[QT]['section_descr']=='1' )
{
  $oSEC->descr .= '<br/><span class="small">('.LangS('User',$oSEC->members,$L).')</span>';
  $oSEC->ShowInfo(
    'tab_si_section',
    'p_si_name_section',
    'p_si_descr_section',
    'img_si_section',
    'left');
}

// --------
// Display no member
// --------
if ( $intMembers==0 )
{
  echo '<br/>',$L['E_no_member'],'<br/><br/>';
  include('qte_p_footer.php');
  exit;
}

// --------
// Display letters bar
// --------

if ( $intMembers>0 || isset($_GET['group']) ) echo '<table class="tab_lettres" cellspacing="0"><tr>',N,$strGroups,N,'</tr></table>',N;

// --------
// Display top pager
// --------

if ( $strPager )
{
echo '
<!-- Pager -->
<table class="tab_pager tab_pager_top" cellspacing="0">
<tr class="tr_pager tr_pager_top">
<td class="td_pager td_pager_top">',$strPager,'</td>
</tr>
</table>
<!-- End pager -->
';
}
else
{
echo '<br/>';
}

// --------
// Display members
// --------

echo '<table class="tab_cnt tab_cnt_member" cellspacing="0">',N;
echo '<tr class="tr_cnt">',N;

  $arrFields[0] = array('sort'=>false,
                        'text'=>'&nbsp;',
                        'class'=>'th_s th_s_first',
                        'style'=>'');
  $arrFields['emails'] = array('sort'=>false,
                                'text'=>$qte_fields['emails'][0],
                                'class'=>'th_s',
                                'style'=>'');
  $arrFields[9] = array('sort'=>false,
                        'text'=>'&nbsp;',
                        'class'=>'th_s th_s_last',
                        'style'=>'');

  // ----------
  TableHeader($arrFields,$intMembers,"$oVIP->selfurl?s=$s&amp;page=1",$strOrder,$strDirec);
  // ----------

echo '</tr>',N;

echo '<tr class="tr_cnt">',N;
echo '<td class="td_s td_s_first">&nbsp;</td>',N;
echo '<td class="td_s">',N;
  // ----------
  $strState  = 'u.id,u.title,u.firstname,u.midname,u.lastname,u.alias,u.privacy,u.emails FROM '.TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid=u.id WHERE l.sid='.$oSEC->id.$strShowZ.$strWhereGroup;
  $oDB->Query( LimitSQL($oDB->type,$strState,$strOrder.' '.$strDirec,$intLimit,$_SESSION[QT]['items_per_page'],$intMembers) );
  // ----------
  $strText='';
  while ( $row=$oDB->Getrow() )
  {
    $oUser = new cUser($oDB,$row,$qte_fields,$oVIP);  // privatise
    if ( !empty($oUser->emails) )
    {
    $strText .= strip_tags($oUser->emails).'; ';
    echo $oUser->fullname,'&nbsp;&nbsp; <a class="small" href="mailto:',strip_tags($oUser->emails),'" title="',$oUser->fullname,'">',$oUser->emails,'</a>',(strstr($oUser->privacy,'emails') ? ' ('.$L['Hidden'].')' : ''),'<br/>';
    }
  }
  // ----------
echo '</td>',N;
echo '<td class="td_s th_d_last">&nbsp;</td>',N;
echo '</tr>',N;

echo '<tr class="tr_cnt">',N;
echo '<td class="td_s td_s_first">&nbsp;</td>',N;
echo '<td class="td_s"><textarea class="small" rows="10" cols="64">',$strText,'</textarea></td>',N;
echo '<td class="td_s td_d_last">&nbsp;</td>',N;
echo '</tr>',N;

echo '<tr class="tr_cnt">',N;
echo '<td class="tf_s tf_s_first"></td>',N;
echo '<td class="tf_s"></td>',N;
echo '<td class="tf_s tf_s_last"></td>',N;
echo '</tr>',N;

echo '</table>',N,N;

// --------
// Display bottom pager
// --------

if ( $strPager )
{
echo '
<!-- Pager -->
<table class="tab_pager tab_pager_bot" cellspacing="0">
<tr class="tr_pager tr_pager_bot">
<td class="td_pager td_pager_bot">',$strPager,'</td>
</tr>
</table>
<!-- End pager -->
';
}

// --------
// HTML END
// --------

include('qte_p_footer.php');

?>