<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Adressbook
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 */

session_start();
require_once('bin/qte_init.php');
if ( !$oVIP->CanAccess('M') ) $oVIP->EndMessage('!',$L['R_staff'],$_SESSION[QT]['skin_dir'],0);

// ---------
// INITIALISE
// ---------

$s = -1;
if ( isset($_GET['s']) ) $s = intval(strip_tags($_GET['s']));
if ( $s<0 )  die('Missing team id...');

include('bin/qte_fn_limitsql.php');

$oVIP->selfurl = 'qte_ind_csv.php';
$oVIP->selfname = $L['Export_csv'];

$strShowZ   = ''; if ( !$_SESSION[QT]['show_Z'] ) $strShowZ = ' AND u.status<>"Z"';
$intLimit = 0;

// COUNT [$intMembers]

$strWhereGroup = ' AND u.id>0';
$oDB->Query('SELECT count(*) as countid FROM '.TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid=u.id WHERE l.sid='.$s.$strShowZ.$strWhereGroup);
$row = $oDB->Getrow();
$intMembers = $row['countid'];

// --------
// CSV START
// --------

header('Content-Type: text/plain; charset='.QTE_HTML_CHAR);
header('Content-Disposition: attachment; filename="qt_'.date('Ymd').'.csv');

// --------
// Header
// --------

$arrPageFields = GetUsableFields($qte_fields,GetFields('all'),'name');
if ( isset($arrPageFields['picture']) ) unset($arrPageFields['picture']);
if ( isset($arrPageFields['status_i']) ) unset($arrPageFields['status_i']);

$arr = array();
foreach ($arrPageFields as $strKey => $strName )
{
  $arr[$strKey] = '"'.str_replace('&nbsp;',' ',$strName).'"';
}
$strTxt = implode(';',$arr);

echo $strTxt,"\r\n";

// --------
// Content
// --------

$oDB->Query( 'SELECT u.* FROM '.TABUSER.' u INNER JOIN '.TABS2U.' l ON l.userid=u.id WHERE l.sid='.$s.$strShowZ.$strWhereGroup );
while ( $row=$oDB->Getrow() )
{
  $oUser = new cUser($oDB,$row,$qte_fields);
  
  $arr = array();
  foreach ($arrPageFields as $strKey => $strName )
  {
    switch ($strKey)
    {
    case 'role': $arr[$strKey] = '"'.str_replace('&nbsp;',' ',$L['Userrole'][$oUser->role]).'"'; break;
    case 'status': $arr[$strKey] = '"'.str_replace('&nbsp;',' ',$_SESSION['qte_status_name'][$oUser->status]).'"'; break;
    default:
      $strTxt = str_replace('&nbsp;',' ',$oUser->$strKey);
      $strTxt = str_replace('&quot;',"'",$strTxt);
      $strTxt = str_replace('&#39;',"'",$strTxt);
      $strTxt = str_replace('"',"'",$strTxt);
      $strTxt = str_replace(';',",",$strTxt);
      $arr[$strKey] = '"'.$strTxt.'"';
      break;
    }
  }
  $strTxt = implode(';',$arr);
  echo $strTxt,"\r\n";
}

// --------
// CSV END
// --------

?>