<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam team
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( !$oVIP->CanAccess('V',0,true) ) $oVIP->EndMessage('!',$L['R_user'],$_SESSION[QT]['skin_dir'],0);

// ---------
// INITIALISE
// ---------

include('bin/qt_lib_smtp.php');
Include($_SESSION[QT]['language'].'/qte_lang_reg.inc');

$oVIP->selfurl = 'qte_form_reg.php';
$oVIP->selfname = $L['Register'];

$strChild = '0';
if ( isset($_GET['c']) ) $strChild = $_GET['c'];
if ( isset($_POST['child']) ) $strChild = $_POST['child'];

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  // pre-check code
  if ( empty($qte_error) )
  {
    if ( $_SESSION[QT]['register_safe']<>'none' )
    {
    if ( trim($_POST['code'])=='' )  $qte_error = $L['Type_code'];
    if ( strlen($_POST['code'])<>6 ) $qte_error = $L['Type_code'];
    }
  }
  
  // check name
  if ( empty($qte_error) )
  {
    if ( get_magic_quotes_gpc() ) $_POST['title'] = stripslashes($_POST['title']);
    $_POST['title'] = QTformattitle($_POST['title'],24);
    if ( !QTislogin($_POST['title']) ) $qte_error=$L['Username'].S.$L['E_invalid'];
    if ( empty($qte_error) )
    {
    $oDB->Query('SELECT count(*) as countid FROM '.TABUSER.' WHERE username="'.$_POST['title'].'"');
    $row = $oDB->Getrow();
    if ($row['countid']!=0) $qte_error=$L['Username'].S.$L['E_already_used'];
    }
  }

  // check mail
  if ( empty($qte_error) )
  {
    $_POST['mail'] = trim($_POST['mail']);
    if (!QTismail($_POST['mail'])) $qte_error=$L['Email'].S.$L['E_invalid'];
    if ( empty($qte_error) )
    {
    $oDB->Query('SELECT count(*) as countid FROM '.TABUSER.' WHERE emails="'.$_POST['mail'].'"');
    $row = $oDB->Getrow();
    if ($row['countid']!=0) $qte_error=$L['Email'].S.$L['E_already_used'];
    }
  }
  
  // check parentmail
  if ( empty($qte_error) ) {
  if ( $_SESSION[QT]['register_coppa']=='1' && $strChild!='0' ) {  
    $_POST['parentmail'] = trim($_POST['parentmail']);
    if ( !QTismail($_POST['parentmail']) ) $qte_error=$L['Parent_mail'].S.$L['E_invalid'];
  }}
  if ( !isset($_POST['parentmail']) ) $_POST['parentmail'] = '';


  // check password
  if ( empty($qte_error) && $_SESSION[QT]['register_mode']=='direct' )
  {
    if ( get_magic_quotes_gpc() ) $_POST['pwd'] = stripslashes($_POST['pwd']);
    $_POST['pwd'] = QTformattitle($_POST['pwd'],24);
    if ( !QTispassword($_POST['pwd']) ) $qte_error = $L['Password'].S.$L['E_invalid'];
    
    if ( get_magic_quotes_gpc() ) $_POST['conpwd'] = stripslashes($_POST['conpwd']);
    $_POST['conpwd'] = QTformattitle($_POST['conpwd'],24);
    if ( !QTispassword($_POST['conpwd']) ) $qte_error = $L['Password'].S.$L['E_invalid'];
  }
  if ( empty($qte_error) && $_SESSION[QT]['register_mode']=='direct' )
  {
    if ( $_POST['conpwd']!=$_POST['pwd'] ) $qte_error = $L['Password'].S.$L['E_invalid'];
  }

  // check code
  if ( empty($qte_error) )
  {
    if ( $_SESSION[QT]['register_safe']<>'none' )
    {
    $strCode = strtoupper(strip_tags(trim($_POST['code'])));
    if ($strCode=='') $qte_error = $L['Type_code'];
    if ( $_SESSION['textcolor'] <> sha1($strCode) ) $qte_error = $L['Type_code'];
    }
  }

  // --------
  // register user
  // --------
  if ( empty($qte_error) )
  {
    // email code
    if ( $_SESSION[QT]['register_mode']=='email' ) $_POST['pwd'] = 'QT'.rand(0,9).rand(0,9).rand(0,9).rand(0,9);

    $id = QTnextid($oDB,TABUSER);
    $strBirth = intval($_POST['y'])*10000 + intval($_POST['m'])*100 + intval($_POST['d']);
    $oDB->Query( 'INSERT INTO '.TABUSER.' (id,username,lastname,pwd,role,emails,birthdate,status,children) VALUES ('.$id.',"'.$_POST['title'].'","'.$_POST['title'].'","'.sha1($_POST['pwd']).'","U","'.$_POST['mail'].'","'.$strBirth.'","Z","'.$strChild.'")' );
    $oDB->Query( 'INSERT INTO '.TABS2U.' (sid,userid,issuedate) VALUES (0,'.$id.',"'.date('Ymd').'")' );
    $oDB->Query( 'UPDATE '.TABSECTION.' SET members=members+1 WHERE id=0' );
    if ( $strChild!='0' )
    {
    $oDB->Query( 'INSERT INTO '.TABCHILD.' (id,childdate,parentmail) VALUES ('.$id.',"'.date('Ymd').'","'.$_POST['parentmail'].'")' );      
    }

    // Unregister global sys (will be recomputed on next page)
    Unset($_SESSION[QT]['sys_members']);

    // send email
    $strSubject = $_SESSION[QT]['site_name'].' - Welcome';
    $strMessage = "Please find here after your login and password to access the board {$_SESSION[QT]['site_name']}.\nLogin: %s\nPassword: %s";
    $strFile = $_SESSION[QT]['language'].'/mail_registred.inc';
    if ( file_exists($strFile) ) include($strFile);
    $strMessage = sprintf($strMessage,$_POST['title'],$_POST['pwd']);
    QTmail($_POST['mail'],QTunquote($strSubject),QTunquote($strMessage),QTE_HTML_CHAR);

    // parent mail
    if ( $_SESSION[QT]['register_coppa']=='1' && $strChild!='0' )
    {
      $strSubject = $_SESSION[QT]['site_name'].' - Welcome';
      $strMessage = "We inform you that your children has registered on the team {$_SESSION[QT]['site_name']}.\nLogin: %s\nPassword: %s\nYour agreement is required to activte this account.";
      $strFile = $_SESSION[QT]['language'].'/mail_registred_coppa.inc';
      if ( file_exists($strFile) ) include($strFile);
      $strMessage = sprintf($strMessage,$_POST['title'],$_POST['pwd']);
      QTmail($_POST['parentmail'],QTunquote($strSubject),QTunquote($strMessage),QTE_HTML_CHAR);
    }
    
    // index
    $oUser = new cUser($oDB,$id);
    $oUser->SaveKeywords($oDB,$oUser->GetKeywords(GetFields('index_p')));

    // END MESSAGE
    if ($_SESSION[QT]['register_mode']=='email')
    {
      $oVIP->exiturl = 'qte_index.php';
      $oVIP->exitname = $_SESSION[QT]['section_index'];
      $oVIP->EndMessage(NULL,'<h2>'.$L['Register_completed'].'</h2><p>'.$L['Reg_mail'].'</p>',$_SESSION[QT]['skin_dir'],0);
    }
    else
    {
      $oVIP->exiturl = 'qte_usr_login.php?dfltname='.urlencode($_POST['title']);
      $oVIP->exitname = $L['Login'];
      $oVIP->EndMessage(NULL,'<h2>'.$L['Register_completed'].'</h2><p>&nbsp;</p>',$_SESSION[QT]['skin_dir'],2);
    }
  }
}

// --------
// HTML START
// --------

$bAjax = true;
$strHeaderAddCss = 'qte_register.css';
$intY = 1970;
$intM = 1;
$intD = 1;
if ( isset($_POST['y']) ) $intY = intval(strip_tags($_POST['y']));
if ( isset($_POST['m']) ) $intM = intval(strip_tags($_POST['m']));
if ( isset($_POST['d']) ) $intD = intval(strip_tags($_POST['d']));
if ( isset($_GET['y']) ) $intY = intval(strip_tags($_GET['y']));
if ( isset($_GET['m']) ) $intM = intval(strip_tags($_GET['m']));
if ( isset($_GET['d']) ) $intD = intval(strip_tags($_GET['d']));

$intMajor = ($intY+13)*10000+$intM*100+$intD;
if ( intval(date('Ymd',strtotime('now')))>$intMajor ) { $strChild='0'; } else { $strChild='2'; }

include('qte_p_header.php');

// DEFAULT VALUE RECOVERY (na)

if ( !isset($_POST['title']) ) $_POST['title']='';
if ( !isset($_POST['pwd']) ) $_POST['pwd']='';
if ( !isset($_POST['conpwd']) ) $_POST['conpwd']='';
if ( !isset($_POST['mail']) ) $_POST['mail']='';
if ( !isset($_POST['parentmail']) ) $_POST['parentmail']='';

if ( !isset($_SESSION[QT]['register_mode']) ) $_SESSION[QT]['register_mode']='direct';
if ( !isset($_SESSION[QT]['register_safe']) ) $_SESSION[QT]['register_safe']='text';

if ( $_SESSION[QT]['register_safe']=='text' )
{
  $keycode = 'QT'.rand(0,9).rand(0,9).rand(0,9).rand(0,9);
  $_SESSION['textcolor'] = sha1($keycode);
}


// --------
// CONTENT
// --------

if ( $_SESSION[QT]['register_coppa']=='1' &&  $strChild!='0' )
{
  echo '<div class="scrollmessage">';
  $strFile = $_SESSION[QT]['language'].'/sys_section_rules_coppa.txt';
  if ( file_exists($strFile) ) { include($strFile); } else { echo 'Missing file:<br/>',$strFile; }
  echo '</div>';
}

echo '<div class="div_msgboxtitle" id="login_header" style="width:620px;">',$oVIP->selfname,'</div>',N;
echo '<div class="div_msgbox" style="width:620px;">',N;

echo '
<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.title.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Choose_name'],'")); return false; }
  if (theForm.mail.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Your_mail'],'")); return false; }
  if (theForm.code.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Security'],'")); return false; }
  if (theForm.code.value=="QT") { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Security'],'")); return false; }
  return null;
}
-->
</script>
';

echo '<form method="post" action="',$oVIP->selfurl,'" onsubmit="return ValidateForm(this);">',N;
echo '<table class="tab_hidden" cellspacing="0">',N;
echo '<tr class="tr_hidden">',N;
echo '<td class="td_hidden" style="width: 370px;"><div id="login">',N;
if ( !empty($qte_error) ) echo '<span class="error">',$qte_error,'</span><br/>';
echo '<fieldset class="fs_register">',N;
echo '<legend>',$qte_fields['username'][0],'</legend>',N;
echo '<span class="small">',$L['Choose_name'],'</span>&nbsp;<input type="text" id="title" name="title" size="20" maxlength="24" value="',$_POST['title'],'" onblur="nameExist(this.name,this.value,\'',$_SESSION[QT]['language'],'\',\'',$L['E_min_4_char'],'\')"/><br/><span id="div_ajax" class="error"></span>',N;
echo '</fieldset>',N;
echo '<fieldset class="fs_register">',N;
echo '<legend>',$L['Password'],'</legend>',N;
if ( $_SESSION[QT]['register_mode']=='direct' )
{
  echo '<span class="small">',$L['Choose_password'],'</span>&nbsp;<input type="password" id="pwd" name="pwd" size="20" maxlength="24" value="',$_POST['pwd'],'" onblur="minChar(this.name,this.value,\'',$L['E_min_4_char'],'\')"/><br/><span id="pwd_err" class="error"></span>',N;
  echo '<span class="small">',$L['Confirm_password'],'</span>&nbsp;<input type="password" id="conpwd" name="conpwd" size="20" maxlength="24" value="',$_POST['conpwd'],'" onblur="minChar(this.name,this.value,\'',$L['E_min_4_char'],'\')"/><br/><span id="conpwd_err" class="error"></span>',N;
}
else
{
  echo '<span class="small">',$L['Password_by_mail'],'</span><br/>',N;
}
echo '</fieldset>',N;
echo '<fieldset class="fs_register">',N;
echo '<legend>',$L['Email'],'</legend>',N;
echo '<span class="small">',$L['Your_mail'],'</span>&nbsp;<input type="text" id="mail" name="mail" size="30" maxlength="64" value="',$_POST['mail'],'"/><br/>',N;
if ( $_SESSION[QT]['register_coppa']=='1' && $strChild!='0' ) echo ' <span class="small">',$L['Parent_mail'],'</span>&nbsp;<input type="text" id="parentmail" name="parentmail" size="30" maxlength="64" value="',$_POST['parentmail'],'"/><br/>',N;
echo '</fieldset>',N;
echo '<fieldset class="fs_register">',N;
echo '<legend>',$L['Security'],'</legend>',N;
if ( $_SESSION[QT]['register_safe']=='image') echo '<img width="100" height="35" src="admin/qte_icode.php" alt="security" style="text-align:right"/> <input type="text" name="code" size="8" maxlength="8" value="QT"/><br/><span class="small">',$L['Type_code'],'</span>',N;
if ( $_SESSION[QT]['register_safe']=='text') echo $keycode,'&nbsp;<input type="text" id="code" name="code" size="8" maxlength="8" value="QT"/><br/><span class="small">',$L['Type_code'],'</span>',N;
echo '</fieldset>',N;
echo '<input type="hidden" name="register_mode" value="',$_SESSION[QT]['register_mode'],'"/>';
echo '<input type="hidden" name="register_safe" value="',$_SESSION[QT]['register_safe'],'"/>';
echo '<input type="hidden" name="child" value="',$strChild,'"/>';
echo '<input type="hidden" name="y" value="',$intY,'"/>';
echo '<input type="hidden" name="m" value="',$intM,'"/>';
echo '<input type="hidden" name="d" value="',$intD,'"/>';
echo '<p><input type="submit" name="ok" value="',$L['Register'],'"/></p>',N;
echo '</div></td>',N;
echo '<td class="td_hidden" style="width:20px;">&nbsp;</td>',N;
echo '<td class="td_hidden"><span class="small">',$L['Reg_help'],'</span></td>
</tr>
</table>
</form>
</div>
';

// --------
// HTML END
// --------

include('qte_p_footer.php');

?>