<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080613
 * @link       http://www.qt-cute.org/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
include('bin/qt_lib_smtp.php');

if ( !isset($_GET['a'])) die('Wrong action');

// ---------
// INITIALISE
// ---------

include(Translate($_SESSION[QT]['language'],'qte_lang_adm.inc'));

$bCmdok = false;
$strMails = '';
$a = strip_tags($_GET['a']); // mandatory action
$d = -1; // domain 
$s = -1; // section
$u = -1; // id (user id)
$v = ''; // value
if (isset($_GET['d'])) $d = intval(strip_tags($_GET['d']));
if (isset($_GET['s'])) $s = intval(strip_tags($_GET['s']));
if (isset($_GET['u'])) $u = intval(strip_tags($_GET['u']));
if (isset($_GET['v'])) $v = strip_tags($_GET['v']);

$oVIP->selfurl  = 'qte_cmd.php';
$oVIP->selfname = 'QuickTeam command';

// --------
// EXECUTE COMMAND
// --------

switch($a)
{
// --------------
case 'deletesection':
// --------------

  if ( $oVIP->role!='A' ) die($L['R_admin']);
  if ( $s<1 ) die('Wrong id in '.$oVIP->selfurl);

  $oVIP->selfname = $L['Section_del'];
  $oVIP->exiturl  = 'qte_adm_sections.php';
  $oVIP->exitname = '&laquo;'.S.$L['Section_man'];

  $oSEC = new cSection($oDB,$s);

  // ask confirmation
  if ( !isset($_GET['ok']) )
  {
    // list content
    if ( $oSEC->members>0 )
    {
      $arrDest = array(); // array_diff_key() not supported in php<5.1      
      foreach ($_SESSION['qteGoto'] as $intKey => $strValue) { if ( $intKey!=$s ) $arrDest[$intKey] = $strValue; }
      
      $strList = '<tr class="tr">
      <th class="th_o th_o_first">'.$L['Users'].'</th>
      <td class="td_o">
      <select name="d" size="1" class="small">'.QTastags($arrDest,$L['Move_to'].': %s').'</select>
      </td>
      </tr>';
    }
    else
    {
      $strList = '';
    }    

    $oVIP->EndMessage
    (
    NULL,
    '<form method="get" action="'.$oVIP->selfurl.'">
    <table class="tab" cellspacing="0">
    <tr class="tr">
    <th class="th_o th_o_first" style="width:150px">'.$L['Section'].'</th>
    <td class="td_o">'.$oSEC->title.'</td>
    </tr>
    <tr class="tr">
    <th class="th_o th_o_first">'.$L['Containing'].'</th>
    <td class="td_o">'.LangS('User',$oSEC->members,$L).'</td>
    </tr>
    '.$strList.'
    <tr class="tr">
    <th class="th_o th_o_first">&nbsp;</th>
    <td class="td_o">
    <input type="hidden" name="a" value="'.$a.'"/>
    <input type="hidden" name="s" value="'.$s.'"/>
    <input type="submit" name="ok" value="'.$L['Delete'].'"/>
    </td>
    </tr>
    </table>
    </form>',
    'admin',
    0,
    '600px'
    );
    exit;
  }

  // delete team
  $oSEC->MoveContent($oDB,$s);
  $oDB->Query('DELETE FROM '.TABSECTION.' WHERE id='.$s);
  Unset($_SESSION[QT]['sys_messages']);
  Unset($_SESSION['qteGoto']);

  // exit
  $oVIP->EndMessage(NULL,$L['S_delete'],'admin',2);
  exit;
  break;

// --------------
case 'deletedomain':
// --------------

  if ( $oVIP->role!='A' ) die($L['R_admin']);
  if ( $s<1 ) die('Wrong id in '.$oVIP->selfurl);

  $oVIP->selfname = $L['Domain_del'];
  $oVIP->exiturl  = 'qte_adm_sections.php';
  $oVIP->exitname = '&laquo;'.S.$L['Section_man'];

  // ask destination
  if ( !isset($_GET['ok']) )
  {
    $strTitle = $_SESSION['qteDomains'][$s];
    $arrTeams = GetSectionTitles($oDB,$oVIP->role,$s);

    // list the domain content
    if ( count($arrTeams)==0 )
    {
      $strDcont = '<span class="small">0 '.$L['Section'].'</span>';
    }
    else
    {
      $strDcont = '';
      foreach ($arrTeams as $intKey => $strValue)
      {
      $strDcont .= '<span class="small">'.$L['Section'].': '.$strValue.'</span><br/>';
      }
    }

    // list of domain destination
    if ( count($arrTeams)>0 )
    {
      $arrDest = array(); // array_diff_key() not supported in php<5.1      
      foreach ($_SESSION['qteDomains'] as $intKey => $strValue) { if ( $intKey!=$s ) $arrDest[$intKey] = $strValue; }
      
      $strDest = '<tr class="tr">
      <th class="th_o th_o_first">'.$L['Sections'].'</th>
      <td class="td_o">
      <select name="d" size="1" class="small">'.QTastags($arrDest,$L['Move_to'].': %s').'</select>
      </td>
      </tr>';
    }    
    else
    {
      $strDest = '';
    }

    // form
    $oVIP->EndMessage
    (
    NULL,
    '<form method="get" action="'.$oVIP->selfurl.'">
    <table class="tab" cellspacing="0">
    <tr class="tr">
    <th class="th_o th_o_first" style="width:150px">'.$L['Title'].'</th>
    <td class="td_o"><b>'.$strTitle.'</b></td>
    </tr>
    <tr class="tr">
    <th class="th_o th_o_first">'.$L['Containing'].'</th>
    <td class="td_o">'.$strDcont.'</td>
    </tr>'.N.$strDest.'
    <tr class="tr">
    <th class="th_o th_o_first">&nbsp;</th>
    <td class="td_o">
    <input type="hidden" name="a" value="'.$a.'"/>
    <input type="hidden" name="s" value="'.$s.'"/>
    <input type="submit" name="ok" value="'.$L['Delete'].'"/></td>
    </tr>
    </table>
    </form>',      
    'admin',
    0,
    '600px'
    );
    exit;
  }

  // delete domain $s and move content to destination $d
  if ( $d>=0 ) 
  {
    $oDB->Query('UPDATE '.TABSECTION.' SET domainid='.$d.' WHERE domainid='.$s);
  }
  $oDB->Query('DELETE FROM '.TABDOMAIN.' WHERE id='.$s);

  // exit
  Unset($_SESSION['qteGoto']);
  Unset($_SESSION['qteDomains']);
  $oVIP->EndMessage(NULL,$L['S_delete'],'admin',2);
  exit;
  break;

// --------------
case 'pwdreset':
// --------------

  if ( $oVIP->role!='A' && $oVIP->role!='M' ) die($L['R_staff']);
  if ( $u<0 ) die('Wrong id in '.$oVIP->selfurl);

  include(Translate($_SESSION[QT]['language'],'qte_lang_reg.inc'));

  $oVIP->selfname = $L['Reset_pwd'];
  $oVIP->exiturl  = 'qte_usr_p.php?id='.$u;
  $oVIP->exitname = '&laquo;'.S.$L['Profile'];

  $oUser = new cUser($oDB,$u,$qte_fields);
    
  // ask delay
  if ( !isset($_GET['ok']) )
  {
    $oVIP->EndMessage
    (
    NULL,
    '<form method="get" action="'.$oVIP->selfurl.'">
    <table class="tab_hidden" cellspacing="0">
    <tr class="tr_hidden">
    <td class="td_hidden">'.AsImgBox(AsImg($oUser->picture,null,$oUser->fullname),'div_pic_box',null,$oUser).'</td>
    <td class="td_hidden">
    <p style="text-align:right">'.$L['Reset_pwd_help'].'<br/><br/>'.$oVIP->selfname.'&nbsp;
    <input type="hidden" name="a" value="'.$a.'"/>
    <input type="hidden" name="u" value="'.$u.'"/>
    <input type="submit" name="ok" value="'.$L['Send'].'"/></p>
    </td>
    </tr>
    </table></form>',
    'admin',
    0,
    '500px'
    );
    exit;
  }

  // reset user
  $strNewpwd = 'qt'.rand(0,9).rand(0,9).rand(0,9).rand(0,9);
  $oDB->Query('UPDATE '.TABUSER.' SET pwd="'.sha1($strNewpwd).'" WHERE id='.$u);

  // send email
  $strSubject = $_SESSION[QT]['site_name'].' - New password';
  $strMessage = "Here are your login and password\nLogin: %s\nPassword: %s";
  $strFile = $_SESSION[QT]['language'].'/mail_pwd.inc';
  if ( file_exists($strFile) ) include($strFile);
  $strMessage = sprintf($strMessage,$oUser->username,$strNewpwd);
  QTmail($oUser->emails,QTunquote($strSubject),QTunquote($strMessage),QTE_HTML_CHAR);
  $strEndmessage = str_replace("\n",'<br/>',$strMessage);

  // parent warning if coppa (and if edited by the kid himself)
  if ( $oUser->coppa != '0' ) {
  if ( $_SESSION[QT]['register_coppa']=='1' ) {
    $oDB->Query('SELECT parentmail FROM '.TABCHILD.' WHERE id='.$u);
    $row = $oDB->Getrow();    
    $strSubject = $_SESSION[QT]['site_name'].' - Profile updated';
    $strMessage = "Your children (login: %s) has modified his/her profile on the board {$_SESSION[QT]['site_name']}.";
    $strFile = $_SESSION[QT]['language'].'/mail_pwd_coppa.inc';
    if ( file_exists($strFile) ) include($strFile);
    $strMessage = sprintf($strMessage,$oUser->username,$strNewpwd);
    QTmail($row['parentmail'],QTunquote($strSubject),QTunquote($strMessage),QTE_HTML_CHAR);
  }}

  // exit
  if ( $_SESSION[QT]['register_mode']!='direct' ) $strEndmessage='';
  $oVIP->EndMessage(NULL,$L['S_update'].'<br/><br/>'.$strEndmessage,$_SESSION[QT]['skin_dir'],0);
  exit;
  break;

// --------------
case 'renamedoc':
// --------------

  if ( $u<0 ) die('Wrong id in '.$oVIP->selfurl);
  if ( $oVIP->role!='A' && $oVIP->role!='M')
  {
    if ( $u!=$oVIP->id ) die('Wrong id in '.$oVIP->selfurl);
  }

  $oVIP->selfname = $L['Rename'];
  $oVIP->exiturl  = 'qte_usr_d.php?id='.$u;
  $oVIP->exitname = '&laquo;'.S.$L['Profile'];

  // ask confirmation
  if ( !isset($_GET['ok']) )
  {
    $oDB->Query('SELECT * FROM '.TABDOC.' WHERE docfile="'.$v.'"');
    $row=$oDB->Getrow();

    $oVIP->EndMessage
    (
    NULL,
    '<table class="tab_hidden" cellspacing="0">
    <tr class="tr_hidden">
    <td class="td_hidden"></td>
    <td class="td_hidden">
    <form method="get" action="'.$oVIP->selfurl.'">
    <p><span class="bold">'.$row['docname'].'</span> ('.QTdate($row['docdate'],$arrQTdate).')<p>
    <input type="text" name="name" id="name" size="40" maxlength="255"/>
    <input type="hidden" name="a" value="'.$a.'"/>
    <input type="hidden" name="u" value="'.$u.'"/>
    <input type="hidden" name="v" value="'.$v.'"/>
    <input type="submit" name="ok" value="'.$L['Ok'].'"/>
    </form></td>
    </tr></table>',
    $_SESSION[QT]['skin_dir'],
    0,
    '500px'
    );
    exit;
  }

  // CHANGE
  
  $str = QThtmlquote(trim(strip_tags($_GET['name']))); if ( empty($str) ) $str='untitled';  
  $oDB->Query( 'UPDATE '.TABDOC.' SET docname="'.$str.'" WHERE docfile="'.$v.'"');

  // EXIT

  $oVIP->EndMessage(NULL,$L['S_update'],$_SESSION[QT]['skin_dir'],2);
  exit;
  break;
  
// --------------
case 'userstatus':
// --------------

  if ( $oVIP->role!='A' && $oVIP->role!='M' ) die($L['R_staff']);

  $oVIP->selfname = $L['Change_status'];
  $oVIP->exiturl  = 'qte_usr_p.php?id='.$u;
  $oVIP->exitname = '&laquo;'.S.$L['Profile'];

  // ask confirmation
  if ( !isset($_GET['ok']) )
  {
    $oUser = new cUser($oDB,$u);
    $oVIP->EndMessage
    (
    NULL,
    '<table class="tab_hidden" cellspacing="0">
    <tr class="tr_hidden">
    <td class="td_hidden">'.AsImgBox(AsImg($oUser->picture,null,$oUser->fullname),'div_pic_box',null,$oUser).'</td>
    <td class="td_hidden">
    <form method="get" action="'.$oVIP->selfurl.'">
    <h2>'.$oUser->fullname.'<br/>'.AsImg($_SESSION[QT]['skin_dir'].'/'.$_SESSION['qte_status_icon'][$oUser->status],$oUser->status,$_SESSION['qte_status_name'][$oUser->status]).' ('.$_SESSION['qte_status_name'][$oUser->status].')</h2>
    <br/>'.$L['Change_status'].' <select name="v" size="1">'.QTastags($_SESSION['qte_status_name'],null,$oUser->status).'</select>&nbsp;
    <input type="hidden" name="a" value="'.$a.'"/>
    <input type="hidden" name="u" value="'.$u.'"/>
    <input type="submit" name="ok" value="'.$L['Ok'].'"/>
    </form></td>
    </tr></table>',
    'admin',
    0,
    '500px'
    );
    exit;
  }

  // CHANGE STATUS
  
  $oDB->Query('UPDATE '.TABUSER.' SET status="'.$v.'" WHERE id='.$u);

  // EXIT

  $oVIP->EndMessage(NULL,$L['S_update'],$_SESSION[QT]['skin_dir'],2);
  exit;
  break;

// --------------
case 'userrole':
// --------------

  if ( $oVIP->role!='A' && $oVIP->role!='M' ) die($L['R_staff']);
  if ( $u<2 ) die('Wrong parameters: user 0 and 1 cannot be changed');
  include(Translate($_SESSION[QT]['language'],'qte_lang_reg.inc'));

  $oVIP->selfname = $L['Change_role'];
  $oVIP->exiturl  = 'qte_usr_s.php?id='.$u;
  $oVIP->exitname = '&laquo;'.S.$L['Profile'];

  // ask confirmation
  if ( !isset($_GET['ok']) )
  {
    $oUser = new cUser($oDB,$u);
    $oVIP->EndMessage
    (
    NULL,
    '<table class="tab_hidden" cellspacing="0">
    <tr class="tr_hidden">
    <td class="td_hidden">'.AsImgBox(AsImg($oUser->picture,null,$oUser->fullname),'div_pic_box',null,$oUser).'</td>
    <td class="td_hidden">
    <form method="get" action="'.$oVIP->selfurl.'">
    <h2>'.$oUser->fullname.'</h2>
    <p style="text-align:right">'.$L['Change_role'].' <select name="v" size="1">
    <option value="A"'.($oUser->role=='A' ? QSEL : '').($oVIP->role!='A' ? ' disabled="disabled"' : '').'>'.$L['Userrole']['A'].'</option>
    <option value="M"'.($oUser->role=='M' ? QSEL : '').'>'.$L['Userrole']['M'].'</option>
    <option value="U"'.($oUser->role=='U' ? QSEL : '').'>'.$L['Userrole']['U'].'</option>
    </select></p>
    <p style="text-align:right"><input type="hidden" name="a" value="'.$a.'"/><input type="hidden" name="u" value="'.$u.'"/><input type="submit" name="ok" value="'.$L['Ok'].'"/>
    </form>
    </td>
    </tr>
    </table>',
    'admin',
    0,
    '500px'
    );
    exit;
  }

  //update role
  if ( $oVIP->role!='A' && $v=='A' ) die($L['R_admin']);
  $oDB->Query('UPDATE '.TABUSER.' SET role="'.$v.'" WHERE id='.$u);
  if ( $v=='U' ) $oDB->Query('UPDATE '.TABSECTION.' SET modid=1, modname="Administrator" WHERE modid='.$u);

  // exit
  $oVIP->EndMessage(NULL,$L['S_update'],'admin',2);
  exit;
  break;
  
// --------------
case 'deleteuser':
// --------------

  if ( $oVIP->role!='A' && $oVIP->role!='M' ) die($L['R_staff']);
  if ( $u<2 ) die('Wrong parameters: user 0 and 1 cannot be deleted');
  include(Translate($_SESSION[QT]['language'],'qte_lang_reg.inc'));

  $oVIP->selfname = $L['User_del'];
  if ( $v=='qte_adm_users' ) $oVIP->exiturl='qte_adm_users.php';

  // ask confirmation
  if ( !isset($_GET['ok']) )
  {
    $oUser = new cUser($oDB,$u);
    $oVIP->EndMessage
    (
    NULL,
    '<table class="tab_hidden" cellspacing="0">
    <tr class="tr_hidden">
    <td class="td_hidden">'.AsImgBox(AsImg($oUser->picture,null,$oUser->fullname),'div_pic_box',null,$oUser).'</td>
    <td class="td_hidden">
    <form method="get" action="'.$oVIP->selfurl.'">
    <h2>'.$oUser->username.'</h2>'.($oUser->username!=$oUser->fullname ? '<p class="bold"> ('.$oUser->fullname.')</p><br/>' : '').'
    <p style="text-align:right">'.$L['User_del'].'
    <input type="hidden" name="a" value="'.$a.'"/>
    <input type="hidden" name="v" value="'.$v.'"/>
    <input type="hidden" name="u" value="'.$u.'"/>
    <input type="submit" name="ok" value="'.$L['Delete'].'"/></p>
    </form>
    </td>
    </tr>
    </table>',
    'admin',
    0,
    '500px'
    );
    exit;
  }

  // delete user
  cUser::Delete($oDB,$u);
  cSection::UpdateStats($oDB,'all');

  // Unregister global sys (will be recomputed on next page)
  Unset($_SESSION[QT]['sys_members']);

  // exit
  $oVIP->EndMessage(NULL,$L['S_delete'],'admin',2);
  exit;
  break;
  
// --------------
case 'deletestatus':
// --------------

  if ( $v=='Z' ) die('Wrong id in '.$oVIP->selfurl);

  $oVIP->selfname = $L['Status_del'];
  $oVIP->exiturl  = 'qte_adm_status.php';
  $oVIP->exitname = '&laquo;'.S.$L['Status_man'];

  // ask confirmation
  if ( !isset($_GET['ok']) || !isset($_GET['target']) )
  {
    // list of status destination
    $strSdest = '';
    foreach ( $_SESSION['qte_status_name'] as $strKey => $strName)
    {
      if ( $strKey!=$v ) $strSdest .= '<option value="'.$strKey.'"/>'.$strName.'</option>';
    }
    // icon
    if ( !empty($_SESSION['qte_status_icon'][$v]) )
    {
    $strIcon = AsImg($_SESSION[QT]['skin_dir'].'/'.$_SESSION['qte_status_icon'][$v],$v,$_SESSION['qte_status_name'][$v]).' ';
    }
    else
    {
    $strIcon = '';
    }

    $oVIP->EndMessage
    (
    NULL,
    '<form method="get" action="'.$oVIP->selfurl.'">
    <table cellspacing="0" class="tab">
    <tr>
    <th class="th_o th_o_first" style="width:150px;">'.$L['Status'].'</th>
    <td class="td_o"><b>'.$strIcon.$_SESSION['qte_status_name'][$v].'</b></td>
    </tr>
    <tr>
    <th class="th_o th_o_first">'.$L['Description'].'</th>
    <td class="td_o">'.$_SESSION['qte_status_descr'][$v].'</td>
    </tr>
    <tr>
    <th class="th_o th_o_first">'.$L['Move'].'</th>
    <td class="td_o">'.$L['H_Status_move'].' <select name="target" size="1" class="small">'.$strSdest.'</select></td>
    </tr>
    <tr>
    <th class="th_o th_o_first">&nbsp;</th>
    <td class="td_o">
    <input type="hidden" name="a" value="'.$a.'"/>
    <input type="hidden" name="v" value="'.$v.'"/>
    <input type="submit" name="ok" value="'.$L['Delete'].'"/></td>
    </tr>
    </table>
    </form><br/>',
    'admin',
    0,
    '600px'
    );
    exit;
  }

  // delete status
  $target = substr($_GET['target'],0,1);
  $oDB->Query('UPDATE '.TABUSER.' SET status="'.$target.'" WHERE status="'.$v.'"');
  $oDB->Query('DELETE FROM '.TABSTATUS.' WHERE id="'.$v.'"');
  unset($_SESSION['qte_status_name']);

  // exit
  $oVIP->EndMessage(NULL,$L['S_delete'],'admin',2);
  exit;
  break;

// --------------
case 'moveallmembers':
// --------------

  if ( $s<0 ) die('Wrong id in '.$oVIP->selfurl);
  
  $oVIP->selfname = $L['Members_moveall'];
  $oVIP->exiturl  = 'qte_adm_sections.php';
  $oVIP->exitname = '&laquo;'.S.$L['Section_man'];
    if ( isset($_GET['exit2']) )
    {
    $oVIP->exiturl  = 'qte_adm_users_move.php?s='.$s;
    $oVIP->exitname = '&laquo;'.S.$L['User_man'];
    }
  $oSEC = new cSection($oDB,$s);

  // ask confirmation
  if ( !isset($_GET['ok']) )
  {
    $arrDest = array(); // array_diff_key() not supported in php<5.1      
    foreach ($_SESSION['qteGoto'] as $intKey => $strValue) { if ( $intKey!=$s ) $arrDest[$intKey] = $strValue; }

    // form
    $oVIP->EndMessage
    (
    NULL,
    '<form method="get" action="'.$oVIP->selfurl.'">
    <table cellspacing="0" class="tab">
    <tr>
    <th class="th_o th_o_first" style="width:150px;">'.$L['Section'].'</th>
    <td class="td_o">'.$oSEC->title.'</td>
    </tr>
    <tr>
    <th class="th_o th_o_first">'.$L['Containing'].'</th>
    <td class="td_o">'.LangS('User',$oSEC->members,$L).'</td>
    </tr>
    <tr>
    <th class="th_o th_o_first">'.$L['Move_to'].'</th>
    <td class="td_o"><select name="d" size="1">'.QTastags($arrDest).'</select></td>
    </tr>
    <tr>
    <th class="th_o th_o_first">&nbsp;</th>
    <td class="td_o">
    <input type="hidden" name="a" value="'.$a.'"/>
    <input type="hidden" name="s" value="'.$s.'"/>
    <input type="submit" name="ok" value="'.$L['Move'].'"/>
    </td>
    </tr>
    </table>
    </form><br/>',
    'admin',
    0,
    '600px'
    );
    exit;
  }

  // move items from section $s into destination $d
  $oSEC->MoveContent($oDB,$s,$d);

  // exit
  $oVIP->EndMessage(NULL,$L['S_update'],'admin',2);
  exit;
  break;

// --------------
case 'userchild':
// --------------

  if ( $oVIP->role!='A' && $oVIP->role!='M' ) die($L['R_staff']);

  $oVIP->selfname = $L['Coppa_apply'];
  $oVIP->exiturl  = 'qte_usr_p.php?id='.$u;
  $oVIP->exitname = '&laquo;'.S.$L['Profile'];

  // ask confirmation
  if ( !isset($_GET['ok']) )
  {
    $oUser = new cUser($oDB,$u);
    
    // form
    $oVIP->EndMessage
    (
    NULL,
    '<table class="tab_hidden" cellspacing="0">
    <tr class="tr_hidden">
    <td class="td_hidden">'.AsImgBox(AsImg($oUser->picture,null,$oUser->fullname),'div_pic_box',null,$oUser).'</td>
    <td class="td_hidden">
    <form method="get" action="'.$oVIP->selfurl.'">
    <h2>'.$oUser->fullname.'</h2>
    '.AsImg($_SESSION[QT]['skin_dir'].'/'.$_SESSION['qte_status_icon'][$oUser->status],$oUser->status,$_SESSION['qte_status_name'][$oUser->status]).' ('.$_SESSION['qte_status_name'][$oUser->status].')<br/><br/>
    <p style="text-align:right">'.$L['Coppa_status'].' <select name="v" size="1">'.QTastags($L['Coppa_child'],null,$v).'</select><input type="hidden" name="a" value="'.$a.'"/><input type="hidden" name="u" value="'.$u.'"/></p>
    <p style="text-align:right"><input type="submit" name="ok" value="'.$L['Ok'].'"/></p>
    </form>
    </td>
    </tr>
    </table>',
    'admin',
    0,
    '500px'
    );
    exit;

  }

  // CHANGE CHILD STATUS
  
  $oDB->Query('UPDATE '.TABUSER.' SET children="'.$v.'" WHERE id='.$u);
  if ( $v!=0 )
  {
    $oDB->Query('SELECT count(id) as countid FROM '.TABCHILD.' WHERE id='.$u);
    $row = $oDB->Getrow();
    if ( $row['countid']==0 ) $oDB->Query( 'INSERT INTO '.TABCHILD.' (id,childdate) VALUES ('.$u.',"'.date('Ymd').'")' );
  }
  else
  {
    $oDB->Query( 'DELETE FROM '.TABCHILD.' WHERE id='.$u);
  }  
  // exit
  $oVIP->EndMessage(NULL,$L['S_update'],'admin',2);
  exit;
  break;

// --------------
case 'dropindex':
// --------------

  if ( $oVIP->role!='A' && $oVIP->role!='M' ) die($L['R_staff']);
  if ( $u<0 ) die('Wrong id');

  $oVIP->selfname = $L['Delete'].' index keys';
  $oVIP->exiturl='qte_usr_s.php?id='.$u;
  $oUser = new cUser($oDB,$u);

  // ask confirmation
  if ( !isset($_GET['ok']) )
  {
    $arrIndex = array();
    $oDB->Query('SELECT ufield,ukey FROM '.TABINDEX.' WHERE userid='.$u);
    while( $row = $oDB->Getrow() )
    {
      $arrIndex[] = strtolower($row['ukey']).' ('.$row['ufield'].')';
    }    
    $oVIP->EndMessage
    (
    NULL,
    '<table class="tab_hidden" cellspacing="0">
    <tr class="tr_hidden">
    <td class="td_hidden">'.AsImgBox(AsImg($oUser->picture,null,$oUser->fullname),'div_pic_box',null,$oUser).'</td>
    <td class="td_hidden">
    <form method="get" action="'.$oVIP->selfurl.'">
    <p>'.count($arrIndex).' index keys:</p><p>'.implode('<br/>',$arrIndex).'</p>
    <p><input type="hidden" name="a" value="'.$a.'"/>
    <input type="hidden" name="u" value="'.$u.'"/>
    <input type="submit" name="ok" value="'.$L['Delete'].'"/></p>
    </form>
    </td>
    </tr>
    </table>',
    'admin',
    0,
    '500px'
    );
    exit;
  }

  // drop index
  $oDB->query('DELETE FROM '.TABINDEX.' WHERE userid='.$u);

  // exit
  $oVIP->EndMessage(NULL,$L['S_delete'],'admin',2);
  exit;
  break;

// --------------
case 'makeindex':
// --------------

  if ( $oVIP->role!='A' && $oVIP->role!='M' ) die($L['R_staff']);
  if ( $u<0 ) die('Wrong id');

  $oVIP->selfname = 'New index keys';
  $oVIP->exiturl='qte_usr_s.php?id='.$u;
  $oUser = new cUser($oDB,$u);
  // new keywords
  $arrIndex = GetFields('index_p');
  $arrIndex = array_merge($arrIndex,GetFields('index_t'));
  $arrIndex = $oUser->GetKeywords($arrIndex);

  // ask confirmation
  if ( !isset($_GET['ok']) )
  {
    
    $str = '';
    foreach ($arrIndex as $strKey => $strValue)
    {
      if ( !empty($strValue) ) $str .= '('.$strKey.') '.strtolower(implode(', ',$strValue)).'<br/>';
    }

    $oVIP->EndMessage
    (
    NULL,
    '<table class="tab_hidden" cellspacing="0">
    <tr class="tr_hidden">
    <td class="td_hidden">'.AsImgBox(AsImg($oUser->picture,null,$oUser->fullname),'div_pic_box',null,$oUser).'</td>
    <td class="td_hidden">
    <form method="get" action="'.$oVIP->selfurl.'">
    <p>New index keys:</p><p>'.$str.'</p>
    <p><input type="hidden" name="a" value="'.$a.'"/>
    <input type="hidden" name="u" value="'.$u.'"/>
    <input type="submit" name="ok" value="'.$L['Save'].'"/></p>
    </form>
    </td>
    </tr>
    </table>',
    'admin',
    0,
    '500px'
    );
    exit;
  }

  // save index
  $oUser->SaveKeywords($oDB,$arrIndex);

  // exit
  $oVIP->EndMessage(NULL,$L['S_update'],'admin',2);
  exit;
  break;
  
// --------------
default:
// --------------

  echo 'Unknown action';
  break;

// --------------

}

$oVIP->EndMessage('!',"Command [$a] failled...",$_SESSION[QT]['skin_dir'],2);

?>