<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute.org/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( !CanPerform('show_calendar',$oVIP->role) ) $oVIP->EndMessage('!',$L['R_member'],$_SESSION[QT]['skin_dir'],0);

// ---------
// INITIALISE
// ---------

$v = 'birthdate';
$intYear   = date('Y');
if ( isset($_GET['y']) ) $intYear = strip_tags($_GET['y']);
$intYearN  = $intYear;
$intMonth  = date('n');
if ( isset($_GET['m']) ) $intMonth = strip_tags($_GET['m']);
$intMonthN = $intMonth+1; if ( $intMonthN>12 ) { $intMonthN=1; $intYearN++; }
$strMonth  = '0'.$intMonth; $strMonth = substr($strMonth,-2,2);
$strMonthN = '0'.$intMonthN; $strMonthN = substr($strMonthN,-2,2);

$dToday = mktime(0,0,0,date('n'),date('j'),date('Y'));

if ( $intYear>2100 ) die('Invalid year');
if ( $intYear<1900 ) die('Invalid year');
if ( $intMonth>12 ) die('Invalid month');
if ( $intMonth<1 ) die('Invalid month');

$oVIP->selfurl = 'qte_cal_main.php';
$oVIP->selfname = $L['Calendar'];

// --------
// LIST OF ITEMS
// --------

$arrEvents = array();
$arrEventsN = array();
$intEvents = 0;
$intEventsN = 0;

switch($oDB->type)
{
// Select 2 months
case 'mysql': $oDB->Query( 'SELECT id,username,lastname,role,'.$v.' FROM '.TABUSER.' WHERE SUBSTRING('.$v.',5,2)="'.$strMonth.'" OR SUBSTRING('.$v.',5,2)="'.$strMonthN.'"' ); break;
case 'mssql': $oDB->Query( 'SELECT id,username,lastname,role,'.$v.' FROM '.TABUSER.' WHERE SUBSTRING('.$v.',5,2)="'.$strMonth.'" OR SUBSTRING('.$v.',5,2)="'.$strMonthN.'"' ); break;
case 'pg':    $oDB->Query( 'SELECT id,username,lastname,role,'.$v.' FROM '.TABUSER.' WHERE SUBSTRING('.$v.',5,2)="'.$strMonth.'" OR SUBSTRING('.$v.',5,2)="'.$strMonthN.'"' ); break;
case 'ibase': $oDB->Query( 'SELECT id,username,lastname,role,'.$v.' FROM '.TABUSER.' WHERE SUBSTRING('.$v.' FROM 5 FOR 2)="'.$strMonth.'" OR SUBSTRING('.$v.' FROM 5 FOR 2)="'.$strMonthN.'"' ); break;
case 'sqlite':$oDB->Query( 'SELECT id,username,lastname,role,'.$v.' FROM '.TABUSER.' WHERE SUBSTR('.$v.',5,2)="'.$strMonth.'" OR SUBSTR('.$v.',5,2)="'.$strMonthN.'"' ); break;
case 'access':$oDB->Query( 'SELECT id,username,lastname,role,'.$v.' FROM '.TABUSER.' WHERE MID('.$v.',5,2)="'.$strMonth.'" OR MID('.$v.',5,2)="'.$strMonthN.'"' ); break;
case 'db2':   $oDB->Query( 'SELECT id,username,lastname,role,'.$v.' FROM '.TABUSER.' WHERE SUBSTR('.$v.',5,2)="'.$strMonth.'" OR SUBSTR('.$v.',5,2)="'.$strMonthN.'"' ); break;
case 'ifx':   $oDB->Query( 'SELECT id,username,lastname,role,'.$v.' FROM '.TABUSER.' WHERE SUBSTRING('.$v.',5,2)="'.$strMonth.'" OR SUBSTRING('.$v.',5,2)="'.$strMonthN.'"' ); break;
case 'oci':   $oDB->Query( 'SELECT id,username,lastname,role,'.$v.' FROM '.TABUSER.' WHERE SUBSTR('.$v.',5,2)="'.$strMonth.'" OR SUBSTR('.$v.',5,2)="'.$strMonthN.'"' ); break;
default: die('Unknown db type '.$oDB->type);
}
while($row=$oDB->Getrow())
{
  if ( strlen($row[$v])==8 )
  {
    $strM = substr($row[$v],4,2); $intM = intval($strM);
    $strD = substr($row[$v],6,2); $intD = intval($strD);
    if ( $strM==$strMonth ) { $arrEvents[$intD][]=$row; $intEvents++; }
    if ( $strM==$strMonthN ) { $arrEventsN[$intD]=$row; $intEventsN++; }
  }
}

// --------
// HTML START
// --------

$bAjax = true;
$strHeaderAddCss = 'qte_calendar.css';
include('qte_p_header.php');

// STAFF MEMBER ACTIONS

if ( $oVIP->role=='M' || $oVIP->role=='A' ) include('qte_cal_menu.php');

// PREPARE MAIN CALENDAR

$dCurrentDate = mktime(0,0,0,$intMonth,1,$intYear);
$dMainDate = $dCurrentDate;
$dFirstDay = mktime(0,0,0,$intMonth,1,$intYear);
if ( date('l',$dFirstDay)!='Monday' )
{
  $dFirstDay = strtotime('-1 week',$dFirstDay);
  $dFirstMonday = strtotime('next monday',$dFirstDay);
  // correction for php 4.2
  // find last monday
  for ($i=date('j',$dFirstDay);$i<32;$i++)
  {
    $dI = mktime(0,0,0,date('n',$dFirstDay),$i,date('Y',$dFirstDay));
    if ( !$dI )
    {
    if ( date('N',$dI)==1 ) $dFirstMonday = $dI;
    }
  }
  $dFirstDay = $dFirstMonday;
}  
$intShiftWeek = intval(date('W',$dFirstDay)); if ( $intShiftWeek>53 ) $intShiftWeek==1;

// DISPLAY MAIN CALENDAR

echo '<table class="tab_hidden" cellspacing="0" style="width:700px">',N,'<tr class="tr_hidden" style="vertical-align:middle">',N;
echo '<td><h2>';
if ( date('n',$dCurrentDate)>1 ) echo '<a href="',$oVIP->selfurl,'?m=',(date('n',$dCurrentDate)-1),'">[&lt;]</a>&nbsp;';
echo $L['dateMMM'][date('n',$dCurrentDate)].' '.date('Y',$dCurrentDate);
if ( date('n',$dCurrentDate)<12 ) echo '&nbsp;<a href="',$oVIP->selfurl,'?m=',(date('n',$dCurrentDate)+1),'">[&gt;]</a>';
echo '</h2></td>',N;

echo '<td style="text-align:right;">';
echo '<form method="get" action="',$oVIP->selfurl,'">';
echo '<input type="hidden" name="v" id="v" value="',$v,'"/>',N;
echo '<input type="hidden" name="y" id="y" value="',$intYear,'"/> ',N;
echo $L['Month'],' <select name="m" onchange="document.getElementById(\'ok\').click();">';
for ($i=1;$i<13;$i++)
{
echo '<option',($i==date('n') ? ' class="bold"' : ''),' value="',$i,'"',($i==$intMonth ? QSEL : ''),'>',$L['dateMMM'][$i],'</option>',N;
}
echo '</select> <input type="submit" name="ok" id="ok" value="',$L['Ok'],'"/><script type="text/javascript">document.getElementById("ok").style.visibility="hidden";document.getElementById("ok").value="";</script></td>',N;
echo '</form></td>',N;
echo '</tr>',N,'</table>',N;

echo '<table class="tab_cnt" cellspacing="0" style="width:700px">',N;
echo '<tr class="tr_cnt">',N;
echo '<th class="th_week th_date_first">&nbsp;</th>';
for ($i=1;$i<8;$i++)
{
  echo '<th class="th_date',($i==7 ? ' th_date_last' : ''),'" style="width:95px">',$L['dateDDD'][$i],'</th>',N;
}
echo '</tr>',N;

  $iShift=0;
  for ($intWeek=0;$intWeek<6;$intWeek++)
  {
    echo '<tr class="tr_cnt">',N;
    echo '<td class="td_week">',$intShiftWeek,'</td>'; $intShiftWeek++;
    for ($intDay=1;$intDay<8;$intDay++)
    {
      $d = strtotime("+$iShift days",$dFirstDay); $iShift++;
      $intShiftYear = date('Y',$d);
      $intShiftMonth = date('n',$d);
      $intShiftDay = date('j',$d);

      // date number
      if ( date('n',$dCurrentDate)==date('n',$d) )
      {
        echo '<td class="td_date"',(date('z',$dToday)==date('z',$d) ? ' id="zone_today">' : '>');
        echo '<p class="p_datenumber">',$intShiftDay,'</p><p class="p_dateicon">&nbsp;';
        // date item
        if ( isset($arrEvents[$intShiftDay]) )
        { 
          $intDayEvents = 0;
          Foreach ($arrEvents[$intShiftDay] as $intKey => $arrValues)
          {
            $intDayEvents++;
            $intAge = $intShiftYear - intval(substr($arrValues[$v],0,4));
            if ( $intDayEvents<4 )
            {
              echo '<a href="qte_usr_p.php?id=',$arrValues['id'],'" onmouseover="getUserDetails(',$arrValues['id'],')">',$arrValues['lastname'],'</a> (',$intAge,')<br/>';
            }
            else
            {
              echo '<a href="qte_usr_p.php?id=',$arrValues['id'],'" onmouseover="getUserDetails(',$arrValues['id'],')"><img class="ico_user" src="',$_SESSION[QT]['skin_dir'],'/ico_user_p_1.gif" alt="-" title="',$arrValues['username'],' (',$intAge,')"/></a> ';
            }
            if ( $intDayEvents>9 ) { echo '...'; break; }
          }
        }
      }
      else
      {
        echo '<td class="td_date_out">';
        echo '<p class="p_datenumber">',$intShiftDay,'</p><p class="p_dateicon">&nbsp;';
      }
      echo '</p></td>',N;
    }
    echo '</tr>',N;
    if ( $intShiftMonth>$intMonth && $intShiftYear==$intYear ) break;    
  }

echo '</table>',N,N;

// DISPLAY SUBDATA

echo '<table class="tab_hidden" cellspacing="0">',N,'<tr class="tr_hidden">',N;
echo '<td style="width:220px">',N;

  // PREPARE NEXT MONTH

  $dCurrentDate = mktime(0,0,0,$intMonthN,1,$intYearN);
  $dFirstDay = mktime(0,0,0,$intMonthN,1,$intYearN);
  if ( date("l",$dFirstDay)!='Monday' )
  {
    $dFirstDay = strtotime('-1 week',$dFirstDay);
    $dFirstMonday = strtotime('next monday',$dFirstDay);
    // correction for php 4.2
    // find last monday
    for ($i=date('j',$dFirstDay);$i<32;$i++)
    {
      $dI = mktime(0,0,0,date('n',$dFirstDay),$i,date('Y',$dFirstDay));
      if ( !$dI )
      {
      if ( date('N',$dI)==1 ) $dFirstMonday = $dI;
      }
    }
    $dFirstDay = $dFirstMonday;
  }  

  // DISPLAY NEXT MONTH
  
  echo '<h2>',$L['dateMMM'][date('n',$dCurrentDate)],'</h2>';
  echo '<table class="tab_cnt" cellspacing="0" style="width:200px">',N;
  echo '<tr class="tr_cnt">',N;
  for ($intDay=1;$intDay<8;$intDay++)
  {
  echo '<th class="th_date_next">',$L['dateD'][$intDay],'</th>',N;
  }
  echo '</tr>',N;

    $iShift=0;
    for ($intWeek=0;$intWeek<6;$intWeek++)
    {
      echo '<tr class="tr_cnt">',N;
      for ($intDay=1;$intDay<8;$intDay++)
      {
        $d = strtotime("+$iShift days",$dFirstDay); $iShift++;
        $intShiftYear = date('Y',$d);
        $intShiftMonth = date('n',$d);
        $intShiftDay = date('j',$d);
        // date number
        if ( date('n',$dCurrentDate)==date('n',$d) )
        {
          echo '<td class="td_date_next"',(date('z',$dToday)==date('z',$d) ? ' id="zone_today"' : ''),'>';
          if ( isset($arrEventsN[$intShiftDay]) )
          {
            echo '<a class="a_date_next" href="qte_cal_main.php?m=',$intMonthN,'">',$intShiftDay,'</a> ';
          }
          else
          {
            echo $intShiftDay;
          }
        }
        else
        {
          echo '<td class="td_date_out_next">';
          echo $intShiftDay;
        }
        echo '</td>',N;
      }
      echo '</tr>',N;
      if ( $intShiftMonth>$intMonthN && $intShiftYear==$intYearN ) break;    
    }

  echo '</table>',N,N;

echo '</td>',N;
echo '<td style="width:220px">',N;

  // DISPLAY STATS
  
  echo '<h2>',$L['Total'],'</h2>',N;
  echo '<br/>';
  echo '<p class="preview_forum"><b>',$L['dateMMM'][date('n',$dMainDate)],'</b></p>',N;
  echo '<p class="preview_forum">',($intEvents>0 ? '<a href="qte_cal_list.php?y='.$intYear.'&amp;m='.$intMonth.'">' : ''),LangS('User',$intEvents,$L),($intEvents>0 ? '</a>' : ''),'</p>',N;
  echo '<br/>';
  echo '<p class="preview_forum"><b>',$L['dateMMM'][date('n',$dCurrentDate)],'</b></p>',N;
  echo '<p class="preview_forum">',($intEventsN>0 ? '<a href="qte_cal_list.php?y='.$intYearN.'&amp;m='.$intMonthN.'">' : ''),LangS('User',$intEventsN,$L),($intEventsN>0 ? '</a>' : ''),'</p>',N;

echo '</td>',N;
echo '<td style="width:220px">',N;

  // DISPLAY Preview
  
  echo '<h2>',$L['Information'],'</h2>';
  echo '<script type="text/javascript"></script><noscript>Your browser does not support JavaScript</noscript>';
  echo '<div style="width:250px" id="div_ajax"></div>',N;

echo '</td>',N;

echo '<td>&nbsp;</td>',N;

echo '</tr>',N,'</table>',N,N;

// --------
// HTML END
// --------

include('qte_p_footer.php');

?>