<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute.org/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( !$oVIP->CanAccess('MUV',4) ) $oVIP->EndMessage('!',$L['R_member'],$_SESSION[QT]['skin_dir'],0);

// --------
// INITIALISE
// --------

$v = 'birthdate';
$intYear   = date('Y');
if ( isset($_GET['y']) ) $intYear = strip_tags($_GET['y']);
$intYearN  = $intYear;
$intMonth  = date('n');
if ( isset($_GET['m']) ) $intMonth = strip_tags($_GET['m']);
$intMonthN = $intMonth+1; if ( $intMonthN>12 ) { $intMonthN=1; $intYearN++; }
$strMonth  = '0'.$intMonth; $strMonth = substr($strMonth,-2,2);
$strMonthN = '0'.$intMonthN; $strMonthN = substr($strMonthN,-2,2);

$arrEvents = array();
$arrEventsN = array();
$intEvents = 0;
$intEventsN = 0;

if ( $intYear>2100 ) die('Invalid year');
if ( $intYear<1900 ) die('Invalid year');
if ( $intMonth>12 ) die('Invalid month');
if ( $intMonth<1 ) die('Invalid month');

$oVIP->selfurl = 'qte_cal_list.php';
$oVIP->selfname = $L['Calendar'];
$oVIP->exiturl = 'qte_cal_main.php?y='.$intYear.'&amp;m='.$intMonth;
$oVIP->exitname = '&laquo;'.S.$L['Calendar'];

$strJava = ''; if ( $_SESSION[QT]['javamail']=='1' ) $strJava='java';

// --------
// HTML START
// --------

$bToPrint=true;
include('qte_p_header.php');

// USERS

switch($oDB->type)
{
// Select month
case 'mysql': $oDB->Query( 'SELECT id,username,title,firstname,lastname,emails,alias,picture,'.$v.' FROM '.TABUSER.' WHERE SUBSTRING('.$v.',5,2)="'.$strMonth.'" OR SUBSTRING('.$v.',5,2)="'.$strMonthN.'"' ); break;
case 'mssql': $oDB->Query( 'SELECT id,username,title,firstname,lastname,emails,alias,picture,'.$v.' FROM '.TABUSER.' WHERE SUBSTRING('.$v.',5,2)="'.$strMonth.'" OR SUBSTRING('.$v.',5,2)="'.$strMonthN.'"' ); break;
case 'pg':    $oDB->Query( 'SELECT id,username,title,firstname,lastname,emails,alias,picture,'.$v.' FROM '.TABUSER.' WHERE SUBSTRING('.$v.',5,2)="'.$strMonth.'" OR SUBSTRING('.$v.',5,2)="'.$strMonthN.'"' ); break;
case 'ibase': $oDB->Query( 'SELECT id,username,title,firstname,lastname,emails,alias,picture,'.$v.' FROM '.TABUSER.' WHERE SUBSTRING('.$v.' FROM 5 FOR 2)="'.$strMonth.'" OR SUBSTRING('.$v.' FROM 5 FOR 2)="'.$strMonthN.'"' ); break;
case 'sqlite':$oDB->Query( 'SELECT id,username,title,firstname,lastname,emails,alias,picture,'.$v.' FROM '.TABUSER.' WHERE SUBSTR('.$v.',5,2)="'.$strMonth.'" OR SUBSTR('.$v.',5,2)="'.$strMonthN.'"' ); break;
case 'access':$oDB->Query( 'SELECT id,username,title,firstname,lastname,emails,alias,picture,'.$v.' FROM '.TABUSER.' WHERE MID('.$v.',5,2)="'.$strMonth.'" OR MID('.$v.',5,2)="'.$strMonthN.'"' ); break;
case 'db2':   $oDB->Query( 'SELECT id,username,title,firstname,lastname,emails,alias,picture,'.$v.' FROM '.TABUSER.' WHERE SUBSTR('.$v.',5,2)="'.$strMonth.'" OR SUBSTR('.$v.',5,2)="'.$strMonthN.'"' ); break;
case 'ifx':   $oDB->Query( 'SELECT id,username,title,firstname,lastname,emails,alias,picture,'.$v.' FROM '.TABUSER.' WHERE SUBSTRING('.$v.',5,2)="'.$strMonth.'" OR SUBSTRING('.$v.',5,2)="'.$strMonthN.'"' ); break;
case 'oci':   $oDB->Query( 'SELECT id,username,title,firstname,lastname,emails,alias,picture,'.$v.' FROM '.TABUSER.' WHERE SUBSTR('.$v.',5,2)="'.$strMonth.'" OR SUBSTR('.$v.',5,2)="'.$strMonthN.'"' ); break;
default: die('Unknown db type '.$oDB->type);
}
while($row=$oDB->Getrow())
{
  if ( strlen($row[$v])==8 )
  {
    $strM = substr($row[$v],4,2); $intM = intval($strM);
    $strD = substr($row[$v],6,2); $intD = intval($strD);
    if ( $strM==$strMonth ) { $arrEvents[$intD][]=$row; $intEvents++; }
    if ( $strM==$strMonthN ) { $arrEventsN[$intD][]=$row; $intEventsN++; }
  }
}
ksort($arrEvents);
ksort($arrEventsN);

echo '<h1>',$L['Birthdays_calendar'],' ',$L['dateMMM'][$intMonth],' ',$intYear,'</h1>',N;

echo '<table class="tab_cnt tab_cnt_member" cellspacing="0">',N;  
echo '<colgroup span="5"><col width="50"></col><col></col><col width="50"></col></colgroup>',N;

if ( count($arrEvents)==0 )
{
  echo '<tr class="tr_s"><td class="td_s" colspan="6">',$L['None'],'</td>';
}
else
{
  foreach ($arrEvents as $intDay => $arrEvent) {
  foreach ($arrEvent as $intNum => $arrUser) {  
  $oUser = new cUser($oDB,$arrUser,$qte_fields,$oVIP);  // privatise
  echo '<tr class="tr_s">';
  echo '<td class="td_s"><p class="p_datenumber">',$intDay,'</p></td>';
  echo '<td class="td_s">',$oUser->fullname,' (',$oUser->age,')</td>';
  echo '<td class="td_s center">',QTdate($oUser->birthdate,$arrQTdate),'</td>';
  echo '<td class="td_s center">',AsFormat($oUser->emails,$qte_fields['emails']),'</td>';
  echo '<td class="td_s center">',AsImg($oUser->picture,null,$oUser->fullname,null,'height:35px;'),'</td>';
  echo '</tr>',N;
  }}
}
echo '</table><br/>',N;

echo '<h1>',$L['Birthdays_calendar'],' ',$L['dateMMM'][$intMonthN],' ',$intYearN,'</h1>',N;

echo '<table class="tab_cnt tab_cnt_member" cellspacing="0">',N;  
echo '<colgroup span="5"><col width="50"></col><col></col><col width="50"></col></colgroup>',N;

if ( count($arrEventsN)==0 )
{
  echo '<tr class="tr_s"><td class="td_s" colspan="6">',$L['None'],'</td>';
}
else
{
  foreach ($arrEventsN as $intDay => $arrEvent) {
  foreach ($arrEvent as $intNum => $arrUser) {  
  $oUser = new cUser($oDB,$arrUser,$oVIP);  // privatise
  echo '<tr class="tr_s">';
  echo '<td class="td_s"><p class="p_datenumber">',$intDay,'</p></td>';
  echo '<td class="td_s">',$oUser->fullname,' (',$oUser->age,')</td>';
  echo '<td class="td_s center">',QTdate($oUser->birthdate,$arrQTdate),'</td>';
  echo '<td class="td_s center">',AsFormat($oUser->emails,$qte_fields['emails']),'</td>';
  echo '<td class="td_s center">',AsImg($oUser->picture,null,$oUser->fullname,null,'height:35px;'),'</td>';
  echo '</tr>',N;
  }}
}
echo '</table><br/>',N;

echo '<br/><a href="',$oVIP->exiturl,'">',$oVIP->exitname,'</a><br/><br/>',N;

// --------
// HTML END
// --------

include('qte_p_footer.php');

?>