<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
include(Translate($_SESSION[QT]['language'],'qte_lang_adm.inc'));

if ( $oVIP->role!='A' ) die($L['R_admin']);

// ---------
// INITIALISE
// ---------

$strTitle   = '';
$strDelimit = ',';
$strEnclose = '"';
$strSkip    = 'N';

$oVIP->selfurl = 'qte_adm_users_imp.php';
$oVIP->selfname = $L['Users_import_csv'];
$oVIP->exiturl = 'qte_adm_users.php';
$oVIP->exitname = '&laquo;&nbsp;'.$L['User_man'];

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  // check file
  if (!is_uploaded_file($_FILES['title']['tmp_name'])) $qte_error = 'File not found';

  // check form value
  if ( empty($qte_error) )
  {
    $strDelimit = trim($_POST['delimit']);
    if ( isset($_POST['skip']) ) $strSkip='Y';
    if ( empty($strDelimit) ) $qte_error="{$L['Separator']} {$L['E_invalid']}";
  }

  // check values
  if ( empty($qte_error) )
  {
    if ( strlen($strDelimit)==1 )
    {
    if ( ereg("[0-9A-Za-z]",$strDelimit) ) $qte_error="{$L['Separator']} {$L['E_invalid']}";
    }
  }

  // save and run
  if ( empty($qte_error) )
  {
    if ( $_FILES['title']['type']!='text/plain' )
    {
    $qte_error = 'Unknown file format';
    unlink($_FILES['title']['tmp_name']);
    }

    // read lines
    $handle = fopen($_FILES['title']['tmp_name'],'r');
    if ( $handle )
    {
      if ( $strSkip=='Y' ) $str = fgets($handle);

      // -----
      $i = 0;
      $intCountUser = 0;
      $intNextUser = QTnextid($oDB,TABUSER);
      $strStatus = 'Z'; if ( isset($_POST['status']) ) $strStatus = substr($_POST['status'],0,1);

      while ( !feof($handle) )
      {
        $i++;
        $str = fgets($handle);
        if ( strlen($str)<4 ) continue;

        // import line (0:role 1:name 2:pwd 3:email
        if ( substr_count($str, $strDelimit)>2 )
        {
          $arrStr = explode($strDelimit,$str);

          if ( count($arrStr)==4 )
          {
            // pre-process values, remove encloser, html quote
            For ($j=0;$j<4;$j++)
            {
              $arrStr[$j]=trim($arrStr[$j]);
              if ( substr($arrStr[$j],0,1)=='"' && substr($arrStr[$j],-1,1)=='"' ) $arrStr[$j] = substr($arrStr[$j],1,-1);
              if ( substr($arrStr[$j],0,1)=="'" && substr($arrStr[$j],-1,1)=="'" ) $arrStr[$j] = substr($arrStr[$j],1,-1);
              if ( substr($arrStr[$j],0,1)=="`" && substr($arrStr[$j],-1,1)=="`" ) $arrStr[$j] = substr($arrStr[$j],1,-1);
            }
            
            $strLog = $arrStr[1];
            $strPwd = $arrStr[2];
            if ( substr($strPwd,0,3)=='SHA' || substr($strPwd,0,3)=='sha' ) $strPwd = sha1(substr($strPwd,3));
            if ( empty($strPwd) ) $strPwd=sha1($strLog);
            $strMail = $arrStr[3];
            
            if ( $oDB->Query( 'INSERT INTO '.TABUSER.' (id,username,pwd,status,emails,children,firstdate) VALUES ('.$intNextUser.',"'.$strLog.'","'.$strPwd.'","'.$strStatus.'","'.$strMail.'","0","'.date('Ymd').'")' ) )
            { 
              $oDB->Query( 'INSERT INTO '.TABS2U.' (sid,userid,issuedate) VALUES (0,'.$intNextUser.',"'.date('Ymd').'")' );
              if ( $_POST['section']!=0 )
              {
              $oDB->Query( 'INSERT INTO '.TABS2U.' (sid,userid,issuedate) VALUES ('.$_POST['section'].','.$intNextUser.',"'.date('Ymd').'")' );
              }
              $intNextUser++;
              $intCountUser++;              
            }
            else
            {
              echo ' - Cannot insert a new user with username ',$strLog,'<br/>';
            }
          }
          else
          {
            $qte_error='Number of parameters ('.count($arrStr).") not matching in line $i";
          }
        }
        else
        {
        $qte_error='Not enough delimiters ('.substr_count($str, $strDelimit).") in line $i";
        }
      }
      // ----
      fclose($handle);

      // Unregister global sys (will be recomputed on next page)
      Unset($_SESSION[QT]['sys_members']);
      Unset($_SESSION[QT]['sys_nomembers']);
      cSection::UpdateStats($oDB,0);
      if ( $_POST['section']!=0 ) cSection::UpdateStats($oDB,$_POST['section']);
    }
  }

  if ( empty($qte_error) )
  {
    unlink($_FILES['title']['tmp_name']);
    if ( $intCountUser==0 ) 
    {
    $oVIP->EndMessage(NULL, 'No user inserted... Check the file and check that you don\'t have duplicate usernames.', 'admin',0);
    }
    else
    {
    $oVIP->EndMessage(NULL,"$intCountUser {$L['Users']}<br/>".$L['S_insert'],'admin',0);
    }
  }
}

// --------
// HTML START
// --------

include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

echo '
<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.title.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': File")); return false; }
  if (theForm.delimit.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Separator'],'")); return false; }
  return null;
}
-->
</script>
';

echo '<form method="post" action="',$oVIP->selfurl,'" enctype="multipart/form-data" onsubmit="return ValidateForm(this);">
<input type="hidden" name="maxsize" value="5242880"/>
<table class="tab" cellspacing="0">
';
echo '<tr class="tr">
<th class="th_o th_o_all" colspan="2">File</th>
</tr>
';
echo '<tr class="tr">
<th class="th_o th_o_first" style="width:200px"><label for="title">CSV file</label></th>
<td class="td_o"><input type="file" id="title" name="title" size="32" value="',$strTitle,'"/></td>
</tr>
';
echo '<tr class="tr">
<th class="th_o th_o_all" colspan="2">',$L['Adm_settings'],'</th>
</tr>
';
echo '<tr class="tr">
<th class="th_o th_o_first"><label for="delimit">',$L['Separator'],'</label></th>
<td class="td_o"><input type="text" id="delimit" name="delimit" size="1" maxlength="5" value="',$strDelimit,'"/></td>
</tr>
';
echo '<tr class="tr">
<th class="th_o th_o_first">',$L['First_line'],'</th>
<td class="td_o"><input type="checkbox" id="skip" name="skip"',($strSkip=='Y' ? QCHE : ''),'/><label for="skip">',$L['Skip_first_line'],'</label></td>
</tr>
';
echo '<tr class="tr">
<th class="th_o th_o_all" colspan="2">',$L['User_man'],'</th>
</tr>
';
echo '<tr class="tr">
<th class="th_o th_o_first">',$L['Status'],'</th>
<td class="td_o"> <select name="status" size="1">',QTastags($_SESSION['qte_status_name'],null,'Z'),'</select></td>
</tr>
';
echo '<tr class="tr">
<th class="th_o th_o_first">',$L['Destination'],'</th>
<td class="td_o"> <select name="section" size="1">',QTastags($_SESSION['qteGoto'],null,0),'</select></td>
</tr>
';
echo '<tr class="tr">
<th class="th_o th_o_all" colspan="2"><input type="submit" name="ok" value="',$L['Ok'],'"/></th>
</tr>
';
echo '</table>
</form>
';

// HTML END

include('qte_adm_p_footer.php');

?>