<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute.org/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
require_once('bin/qte_fn_sort.php');
if ( $oVIP->role!='A' ) die($L['R_admin']);

// ---------
// INITIALISE
// ---------

$id = '-1';
if ( isset($_GET['id']) ) $id = strip_tags($_GET['id']);
if ( isset($_POST['id']) ) $id = strip_tags($_POST['id']);
if ( $id=='-1' ) die('Missing parameter: id');

include(Translate($_SESSION[QT]['language'],'qte_lang_adm.inc'));

$oVIP->selfurl = 'qte_adm_status_upd.php';
$oVIP->exiturl = 'qte_adm_status.php';
$oVIP->selfname = $L['Status_upd'];
$oVIP->exitname = '&laquo;'.S.$L['Status_man'];

// --------
// SUBMITTED
// --------

if (isset($_POST['ok']))
{
  // check id
  $newid = strtoupper(strip_tags($_POST['newid']));
  if (!ereg('[A-Z]',$newid)) $qte_error="Id $newid ".$L['E_invalid'].' (B-Y)';

  // check unic id
  if ( empty($qte_error) )
  {
    if ($newid!=$id)
    {
    $oDB->Query('SELECT count(id) as countid FROM '.TABSTATUS.' WHERE id="'.$newid.'"');
    $row = $oDB->Getrow();
    if ($row['countid']>0) $qte_error = 'Id ['.$newid.'] '.$L['E_already_used'];
    }
  }

  // check name
  if ( empty($qte_error) )
  {
    $newname = trim(strip_tags($_POST['newname'])); if ( get_magic_quotes_gpc() ) $newname = stripslashes($newname);
    if ( $newname=='' ) $qte_error = $L['name'].S.$L['E_invalid'];
    $newname = QThtmlquote($newname,true,true,QTE_CONVERT_AMP);
    // find duplicates
    if ( $newname != $_SESSION['qte_status_name'][$id] )
    {
      foreach ($_SESSION['qte_status_name'] as $strKey => $strValue)
      {
      if ( $strKey!=$id && $newname==$strValue ) $qte_warning = $L['Duplicate_fieldname_possible'].' '.$strValue;
      }      
    }
  }

  // check description
  if ( empty($qte_error) )
  {
    $descr = trim(strip_tags($_POST['descr'])); if ( get_magic_quotes_gpc() ) $descr = stripslashes($descr);
    $descr = QThtmlquote($descr,true,true,QTE_CONVERT_AMP);
  }

  // check icon
  if ( empty($qte_error) )
  {
    $icon = trim(strip_tags($_POST['icon']));
    $icon = htmlspecialchars($icon,ENT_QUOTES);
    if ( $icon!=trim($_POST['icon']) ) $qte_error = $L['Icon'].S.$L['E_invalid'];
  }

  // update status
  if ( empty($qte_error) )
  {
    // update user status if required
    if ($newid!=$id)
    {
      $oDB->Query('UPDATE '.TABUSER.' SET status="'.$newid.'" WHERE status="'.$id.'"');
    }

    // update status
    $oDB->Query('UPDATE '.TABSTATUS.' SET id="'.$newid.'",name="'.$newname.'",icon="'.$icon.'",descr="'.$descr.'" WHERE id="'.$id.'"');

    //Exit
    unset($_SESSION['qte_status_name']);
    $oVIP->EndMessage(NULL,$L['S_update'].'<br/><br/><span class="warning">'.$qte_warning.'</span>','admin',(!empty($qte_warning) ? 0: 2));
  }
}

// --------
// HTML START
// --------

include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

$oDB->Query('SELECT * FROM '.TABSTATUS.' WHERE id="'.$id.'"');
$row = $oDB->Getrow();

// DISPLAY RESULT

echo '<table cellspacing="0" class="tab_hidden">
<tr>
<td style="width:25px">',$id,'</td>
<td style="width:30px">',AsImg($_SESSION[QT]['skin_dir'].'/'.$row['icon'],'-',$row['descr'],'ico_status'),'</td>
<td style="width:25px; text-align:center; background-color:',$row['color'],'; border-style:solid; border-color:#black; border-width:1px">&nbsp;</td>
<td style="width:10px">&nbsp;</td>
<td>',$row['name'],'</td>
</tr>
</table>
';

echo '
<form method="post" action="',$oVIP->selfurl,'">
<table width="500" cellspacing="0" class="tab">
<tr class="tr">
<th class="th_o th_o_all" colspan="2">',$L['Definition'],'</th>
</tr>
<tr>
<th class="th_o th_o_first" style="width:150px;"><label for="newid">Id</label></th>
<td class="td_o">';
if ( $id=='Z' )
{
  echo $id.'&nbsp;<input type="hidden" name="newid" value="',$id,'"/>';
}
else
{
  echo '<input type="text" id="newid" name="newid" size="1" maxlength="1" value="',$id,'"/>';
}
echo '</td>
</tr>
<tr>
<th class="th_o th_o_first"><label for="newname">Name</label></th>
<td class="td_o"><input type="text" id="newname" name="newname" size="24" maxlength="32" value="',str_replace('&','&amp;',$row['name']),'"/></td>
</tr>
<tr>
<th class="th_o th_o_first"><label for="icon">Icon</label></th>
<td class="td_o"><input type="text" id="icon" name="icon" size="24" maxlength="32" value="',$row['icon'],'"/>&nbsp;',AsImg($_SESSION[QT]['skin_dir'].'/'.$row['icon'],'-',$row['descr'],'ico_status'),'&nbsp;&nbsp;<a href="qte_adm_status_ico.php" target="_blank">show icons</a></td>
</tr>
<tr>
<th class="th_o th_o_first"><label for="descr">',$L['Description'],'</label></th>
<td class="td_o"><input type="text" id="descr" name="descr" size="64" maxlength="255" value="',str_replace('&','&amp;',$row['descr']),'"/></td>
</tr>
<tr>
<th class="th_o" colspan="2" style="padding:6px; text-align:center"><input type="hidden" name="id" value="',$id,'"/><input type="hidden" name="name" value="',$row['name'],'"/><input type="submit" name="ok" value="',$L['Save'],'"/></th>
</tr>
</table>
</form>
<p><a href="',$oVIP->exiturl,'">',$oVIP->exitname,'</a></p>
';

// --------
// HTML END
// --------

include('qte_adm_p_footer.php');

?>