<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080618
 * @link       http://www.qt-cute.org/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
require_once('bin/qte_fn_sort.php');
if ( $oVIP->role!='A' ) die($L['R_admin']);

// ---------
// INITIALISE
// ---------

include(Translate($_SESSION[QT]['language'],'qte_lang_adm.inc'));

$oVIP->selfurl = 'qte_adm_status.php';
$oVIP->exiturl = 'qte_adm_status.php';
$oVIP->selfname = $L['Status_man'];
$oVIP->exitname = $L['Status_man'];

// --------
// SUBMITTED
// --------

if ( isset($_POST['add']) )
{
  // check id
  $id = strtoupper($_POST['id']);
  if ( !ereg('[A-Y]',$id) ) $qte_error="Id $id ".$L['E_invalid']." (A-Y)";

  // check unic
  if ( empty($qte_error) )
  {
    $oDB->Query('SELECT count(id) as countid FROM '.TABSTATUS.' WHERE id="'.$id.'"');
    $row = $oDB->Getrow();
    if ( $row['countid']!=0 ) $qte_error = 'Id ['.$id.'] '.$L['E_already_used'];
  }
  // check name
  if ( empty($qte_error) )
  {
    $name = trim($_POST['name']); if ( get_magic_quotes_gpc() ) $name = stripslashes($name);
    if ( $name=='' ) $qte_error = $L['Status'].S.$L['E_invalid'];
    $name = QThtmlquote($name,true,true,QTE_CONVERT_AMP);

    // check name already used (cas insensitive)
    if ( empty($qte_error) )
    {
      $arr = $_SESSION['qte_status_name'];
      $arr['0'] = $name;
      $str = FindDuplicates($arr,false);
      if ( $str ) $qte_warning = $L['Duplicate_fieldname_possible'].' '.$str;
    }
  }
  // check description
  if ( empty($qte_error) )
  {
    $desc = trim($_POST['desc']); if ( get_magic_quotes_gpc() ) $desc = stripslashes($desc);
    $desc = QThtmlquote($desc,true,true,QTE_CONVERT_AMP);
  }

  // Add status
  if ( empty($qte_error) )
  {
    $oDB->Query('INSERT INTO '.TABSTATUS.' (id,name,descr) VALUES ("'.$id.'","'.$name.'","'.$desc.'")');
    $_SESSION['qte_status_name'][$id] = $name;
    $_SESSION['qte_status_descr'][$id] = $desc;
    $_SESSION['qte_status_icon'][$id] = '';
    $strInfo = $L['S_save'];
  }
}
if ( isset($_POST['ok']) )
{
  if ( $_POST['show_Z']=='0' ) { $_SESSION[QT]['show_Z']='0'; }  else { $_SESSION[QT]['show_Z']='1'; }
  $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['show_Z'].'" WHERE param="show_Z"');
  $strInfo = $L['S_save'];
}

// --------
// HTML START
// --------

$bJava=true;
include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

echo '<table cellspacing="0" class="tab">
<colgroup span="7">
<col width="30"></col>
<col width="30"></col>
<col></col>
<col></col>
<col width="150"></col>
</colgroup>',N;
echo '<tr class="tr">
<th class="th_o">Id</th>
<th class="th_o">&nbsp;</th>
<th class="th_o" style="text-align:left">',$L['Status'],'</th>
<th class="th_o" style="text-align:left">',$L['Description'],'</th>
<th class="th_o">',$L['Action'],'</th>
</tr>',N;

// Table content
$oDB->Query('SELECT * FROM '.TABSTATUS.' ORDER BY id');
while ( $row=$oDB->Getrow() )
{
  echo '<tr onmouseover="this.style.backgroundColor=\'#eeeeee\';" onmouseout="this.style.backgroundColor=\'#ffffff\';">',N;
  echo '<td class="td_o" style="text-align:center">',$row['id'],'</td>',N;
  echo '<td class="td_o" style="text-align:center">',AsImg($_SESSION[QT]['skin_dir'].'/'.$row['icon'],'-',$row['descr'],'ico_status'),'</td>',N;
  echo '<td class="td_o">',$row['name'],'</td>',N;
  echo '<td class="td_o"><span class="small">',$row['descr'],'</span></td>',N;
  echo '<td class="td_o" style="text-align:center"><a class="small" href="qte_adm_status_upd.php?id=',$row['id'],'">',$L['Edit'],'</a>&nbsp;&middot;&nbsp;';
  if ( $row['id']=='Z' ) { echo '<span class="disabled">',$L['Delete']; } else { echo '<a class="small" href="qte_cmd.php?a=deletestatus&amp;v=',$row['id'],'">',$L['Delete'],'</a>'; }
  echo '</td>',N,'</tr>',N;
}
echo "</table></form>\n\n";

echo '<h2>',$L['Display_options'],'</h2>',N;

echo '
<form method="post" action="',$oVIP->selfurl,'">
<table cellspacing="0" class="tab">
<tr class="tr">
<th class="th_o th_o_first" style="width:150px"><label for="show_Z">',$L['Show_z'],'</label></th>
<td class="td_o"><select id="show_Z" name="show_Z">
<option value="0"',($_SESSION[QT]['show_Z']=='0' ? QSEL : ''),'>',$L['N'],'</option>
<option value="1"',($_SESSION[QT]['show_Z']=='1' ? QSEL : ''),'>',$L['Y'],'</option>
</select> <span class="small">',sprintf($L['H_Show_z'],$_SESSION['qte_status_name']['Z']),'</span></td>
<td class="td_o"><input type="submit" name="ok" value="',$L['Ok'],'"/></td>
</tr>
</table>
</form>
';

echo '
<h2>',$L['Status_add'],'</h2>
<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.id.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': Id")); return false; }
  if (theForm.name.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Status'],'")); return false; }
  return null;
}
-->
</script>
';

echo '
<form method="post" action="',$oVIP->selfurl,'" onsubmit="return ValidateForm(this);">
<table cellspacing="0" class="tab">
<colgroup span=""><col width="30"></col><col width="30"></col><col></col><col></col><col width="150"></col></colgroup>
<tr>
<th class="th_o">Id</th>
<th class="th_o">&nbsp;</th>
<th class="th_o" style="text-align:left">',$L['Status'],'</th>
<th class="th_o" style="text-align:left">',$L['Description'],'</th>
<th class="th_o">',$L['Action'],'</th>
</tr>
<tr>
<td class="td_o" style="text-align:center"><input type="text" name="id" value="" size="1" maxlength="1" class="small"/></td>
<td class="td_o" style="text-align:center">-</td>
<td class="td_o"><input type="text" name="name" value="" size="20" maxlength="24" class="small"/></td>
<td class="td_o"><input type="text" name="desc" value="" size="30" maxlength="255" class="small" onKeyUp="handle_keypress(event,\'add\')"/></td>
<td class="td_o" style="text-align:center"><input type="submit" id="add" name="add" value="',$L['Add'],'"/></td>
</tr>
</table>
</form>
';

// --------
// HTML END
// --------

include('qte_adm_p_footer.php');

?>