<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam team
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080620
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( $oVIP->role!='A' ) die($L['R_admin']);

// ---------
// INITIALISE
// ---------

include('bin/qt_lib_smtp.php');

$oVIP->selfurl = 'qte_adm_smtp.php';
$oVIP->selfname = 'SMTP test';

if ( isset($_GET['h']) ) $_SESSION[QT]['smtp_host'] = strip_tags($_GET['h']);
if ( isset($_GET['u']) ) $_SESSION[QT]['smtp_username'] = strip_tags($_GET['u']);
if ( isset($_GET['p']) ) $_SESSION[QT]['smtp_password'] = strip_tags($_GET['p']);

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  // register value used
  $_SESSION[QT]['smtp_host'] = $_POST['smtphost']; if ( get_magic_quotes_gpc() ) $_SESSION[QT]['smtp_host'] = stripslashes($_POST['smtphost']);
  $_SESSION[QT]['smtp_username'] = $_POST['smtpusr']; if ( get_magic_quotes_gpc() ) $_SESSION[QT]['smtp_username'] = stripslashes($_POST['smtpusr']);
  $_SESSION[QT]['smtp_password'] = $_POST['smtppwd']; if ( get_magic_quotes_gpc() ) $_SESSION[QT]['smtppwd'] = stripslashes($_POST['smtppwd']);
  if ( !QTismail($_POST['mailto']) ) die($L['Email'].S.$L['E_invalid']);

  // send mail
  smtpmail($_POST['mailto'],$_POST['subject'],$_POST['message'],'From:'.$_SESSION[QT]['admin_email']);

  // exit
  $oVIP->exiturl = 'qte_adm_smtp.php';
  $oVIP->exitname = 'SMTP test';
  $oVIP->EndMessage(NULL,'Process completed...<br/><br/>If you have changed the smtp settings during the test, go to the Administration page and SAVE your new settings!','admin',0);
}

// --------
// HTML START
// --------

include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

echo '
<form method="post" action="',$oVIP->selfurl,'">
<table class="tab" cellspacing="0">
<tr class="tr">
<th class="th_o th_o_all" colspan="2">SMTP Settings</th>
</tr>
<tr class="tr">
<th class="th_o th_o_first" style="width:150px"><label for="smtphost">Smtp host</label></th>
<td class="td_o"><input type="text" id="smtphost" name="smtphost" size="30" maxlength="64" value="',$_SESSION[QT]['smtp_host'],'"/></td>
</tr>
<tr class="tr">
<th class="th_o th_o_first"><label for="smtpusr">Smtp username</label></th>
<td class="td_o"><input type="text" id="smtpusr" name="smtpusr" size="30" maxlength="64" value="',$_SESSION[QT]['smtp_username'],'"/></td>
</tr>
<tr class="tr">
<th class="th_o th_o_first"><label for="smtppwd">Smtp password</label></th>
<td class="td_o"><input type="text" id="smtppwd" name="smtppwd" size="30" maxlength="64" value="',$_SESSION[QT]['smtp_password'],'"/></td>
</tr>
<tr class="tr">
<th class="th_o th_o_all" colspan="2">',$L['Email'],'</th>
</tr>
<tr class="tr">
<th class="th_o th_o_first"><label for="mailto">SEND TO</label></th>
<td class="td_o"><input type="text" id="mailto" name="mailto" size="30" maxlength="64" value=""/></td>
</tr>
<tr class="tr">
<th class="th_o th_o_first"><label for="subject">Subject</label></th>
<td class="td_o"><input type="text" id="subject" name="subject" size="30" maxlength="64" value="Test smtp"/></td>
</tr>
<tr class="tr">
<th class="th_o th_o_first"><label for="message">Message</label></th>
<td class="td_o"><input type="text" id="message" name="message" size="30" maxlength="64" value="Test mail send by smtp server"/></td>
</tr>
<tr class="tr">
<th class="th_o th_o_all">&nbsp;</th>
<td class="td_o"><input type="submit" name="ok" value="',$L['Send'],'"/></td>
</tr>
</table>
</form>
';

// --------
// HTML END
// --------

include('qte_adm_p_footer.php');

?>