<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam team
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080618
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( $oVIP->role!='A' ) die($L['R_admin']);

// ---------
// INITIALISE
// ---------

include(Translate($_SESSION[QT]['language'],'qte_lang_adm.inc'));

$oVIP->selfurl = 'qte_adm_skin.php';
$oVIP->selfname = $L['Adm_layout'];

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  // CHECK INPUTS

  $str = strip_tags(trim($_POST['width']));
    if ( substr($str,-1,1)=='%' ) { $procent = '%'; } else { $procent = ''; }
    $str = str_replace('%','',$str);
    if ( !is_numeric($str) )
    {
      $qte_error = $L['Site_width'].'<br/>'.$L['E_invalid'].' (500-1024, 50%-100%)';
    }
    else
    {
      if ( $procent=='%' )
      {
      if ( !QTisbetween($str,50,100) ) { $qte_error = $L['Site_width'].'<br/>'.$L['E_invalid'].' (500-1024 or 50%-100%)'; }
      }
      else
      {
      if ( !QTisbetween($str,500,1024) ) { $qte_error = $L['Site_width'].'<br/>'.$L['E_invalid'].' (500-1024, 50%-100%)'; }
      }
    }
    $str .= $procent;
    if ( empty($qte_error) )
    {
    $_SESSION[QT]['site_width'] = $str;
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['site_width'].'" WHERE param="site_width"');
    }

  if ( empty($qte_error) )
  {
  $str = strip_tags(trim($_POST['items_per_page']));
  if ( !QTisbetween($str,10,100) ) $qte_error = $L['Items_per_section_page'].'<br/>'.$L['E_invalid'].' (10-100)';
  }
    if ( empty($qte_error) )
    {
    $_SESSION[QT]['items_per_page'] = $str;
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['items_per_page'].'" WHERE param="items_per_page"');
    }

  // check skin
  if ( empty($qte_error) )
  {
    if ( !file_exists('skin/'.$_POST['skin'].'/qte_main.css') )
    {
    $qte_error=$L['Section_skin'].S.$L['E_invalid'].' (qte_main.css not found)';
    }
  }

  // check banner/welcome/legend/home
  if ( empty($qte_error) )
  {
    $_SESSION[QT]['skin_dir'] = 'skin/'.$_POST['skin'];
    $_SESSION[QT]['show_welcome'] = $_POST['welcome'];
    $_SESSION[QT]['show_legend'] = $_POST['legend'];
    $_SESSION[QT]['show_banner'] = $_POST['banner'];
    $_SESSION[QT]['home_menu'] = $_POST['home'];
    $_SESSION[QT]['section_descr'] = $_POST['section_descr'];
    $_SESSION[QT]['show_calendar'] = $_POST['show_calendar'];
    $_SESSION[QT]['show_stats'] = $_POST['show_stats'];
  }

  // check homename
  if ( $_SESSION[QT]['home_menu']=='1' )
  {
    if ( empty($qte_error) )
    {
      $str = strip_tags(trim($_POST['homename'])); if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
      $str = QThtmlquote($str);
      if ( !empty($str) ) { $_SESSION[QT]['home_name'] = $str; } else { $qte_error = $L['Home_website_name'].S.$L['E_invalid']; }
    }
    if ( empty($qte_error) )
    {
      $str = $_POST['homeurl'];
      $str = QTformattitle($str,100);
      if ( !empty($str) ) { $_SESSION[QT]['home_url'] = $str; } else { $qte_error = $L['site_url'].': '.$L['E_invalid']; }
      if ( !ereg('^(http://|https://)',$str) ) $qte_warning = $L['Home_website_url'].': '.$L['E_missing_http'];
      $_SESSION[QT]['home_url'] = $str;
    }
  }

  // save value
  if ( empty($qte_error) )
  {
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_POST['skin'].'" WHERE param="skin_dir"');
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['show_welcome'].'" WHERE param="show_welcome"');
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['show_banner'].'" WHERE param="show_banner"');
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['show_legend'].'" WHERE param="show_legend"');
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['home_menu'].'" WHERE param="home_menu"');
    if ( $_SESSION[QT]['home_menu']=='1' )
    {
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['home_name'].'" WHERE param="home_name"');
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['home_url'].'" WHERE param="home_url"');
    }
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['section_descr'].'" WHERE param="section_descr"');
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['show_calendar'].'" WHERE param="show_calendar"');
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['show_stats'].'" WHERE param="show_stats"');
    $strInfo = $L['S_save'];
  }
}

// --------
// HTML START
// --------

// WARNINGS

if ( !ereg("^(http://|https://)",$_SESSION[QT]['home_url']) ) $qte_warning = $L['Home_website_url'].': '.$L['E_missing_http'];

include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

// Read directory in language
$intHandle = opendir('skin');
$arrFiles = array();
while ( false!==($strFile = readdir($intHandle)) )
{
if ( $strFile!='.' && $strFile!='..' ) $arrFiles[$strFile]=ucfirst($strFile);
}
closedir($intHandle);
asort($arrFiles);

// Current skin
$strDfltskin = substr($_SESSION[QT]['skin_dir'],5);

// FORM

echo '
<script type="text/javascript">
<!--
function homedisabled(str)
{
  if (str=="0")
  {
  document.getElementById("homename").disabled=true;
  document.getElementById("homeurl").disabled=true;
  }
  else
  {
  document.getElementById("homename").disabled=false;
  document.getElementById("homeurl").disabled=false;
  }
  return;
}
function ValidateForm(theForm)
{
  if (theForm.width.value.length < 1) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Site_width'],'")); return false; }
  if (theForm.items_per_page.value.length < 1) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Items_per_section_page'],'")); return false; }
  return null;
}
-->
</script>
';

echo '<form method="post" action="',$oVIP->selfurl,'" onsubmit="return ValidateForm(this);">
<table class="tab" cellspacing="0">
<colgroup span="2"><col width="250"></col><col></col></colgroup>
';
echo '<tr class="tr">
<th class="th_o th_o_all" colspan="2">',$L['Skin'],'</th>
</tr>
';
echo '<tr class="tr" title="',$L['H_Team_skin'],'">
<th class="th_o th_o_first"><label for="skin">',$L['Section_skin'],'</label></th>
<td class="td_o"><select id="skin" name="skin">',QTastags($arrFiles,null,$strDfltskin),'</select>
</td>
</tr>
';
echo '<tr class="tr" title="',$L['H_Show_banner'],'">
<th class="th_o th_o_first"><label for="banner">',$L['Show_banner'],'</label></th>
<td class="td_o">
<select id="banner" name="banner">',QTastags(array($L['N'],$L['Y']),null, $_SESSION[QT]['show_banner']),'</select>
</td>
</tr>
';
echo '<tr class="tr" title="',$L['H_Show_legend'],'">
<th class="th_o th_o_first"><label for="legend">',$L['Show_legend'],'</label></th>
<td class="td_o">
<select id="legend" name="legend">',QTastags(array($L['N'],$L['Y']),null, $_SESSION[QT]['show_legend']),'</select>
</td>
</tr>
';

echo '<tr class="tr">
<th class="th_o th_o_all" colspan="2">',$L['Layout'],'</th>
</tr>
';
echo '<tr class="tr" title="',$L['H_Site_width'],'">
<th class="th_o th_o_first"><label for="width">',$L['Site_width'],'</label></th>
<td class="td_o"><input type="text" id="width" name="width" size="4" maxlength="4" value="',$_SESSION[QT]['site_width'],'"/>
</tr>
';
echo '<tr class="tr" title="',$L['H_Items_per_section_page'],'">
<th class="th_o th_o_first"><label for="items_per_page">',$L['Items_per_section_page'],'</label></th>
<td class="td_o"><input type="text" id="items_per_page" name="items_per_page" size="3" maxlength="3" value="',$_SESSION[QT]['items_per_page'],'"/>/',$L['Page'],'</td>
</tr>
';
echo '<tr class="tr" title="',$L['H_Show_welcome'],'">
<th class="th_o th_o_first"><label for="welcome">',$L['Show_welcome'],'</label></th>
<td class="td_o"><select id="welcome" name="welcome">
<option value="2"',($_SESSION[QT]['show_welcome']=='2' ? QSEL : ''),'>',$L['Y'],'</option>
<option value="0"',($_SESSION[QT]['show_welcome']=='0' ? QSEL : ''),'>',$L['N'],'</option>
<option value="1"',($_SESSION[QT]['show_welcome']=='1' ? QSEL : ''),'>',$L['While_unlogged'],'</option>
</select></td>
</tr>
';
echo '<tr class="tr">
<th class="th_o th_o_all" colspan="2">',$L['Your_website'],'</th>
</tr>
';
echo '<tr class="tr" title="',$L['H_Home_website_name'],'">
<th class="th_o th_o_first"><label for="home">',$L['Add_home'],'</label></th>
<td class="td_o">
<select id="home" name="home"  onchange="homedisabled(this.value)">',QTastags(array($L['N'],$L['Y']),null, $_SESSION[QT]['home_menu']),'</select>
&nbsp;<input type="text" id="homename" name="homename" size="20" maxlength="32" value="',QThtmlquote($_SESSION[QT]['home_name'],true,true,true),'"',($_SESSION[QT]['home_menu']=='0' ? QDIS : ''),'/></td>
</tr>
';
echo '<tr class="tr" title="',$L['H_Website'],'">
<th class="th_o th_o_first"><label for="homeurl">',$L['Home_website_url'],'</label></th>
<td class="td_o"><input type="text" id="homeurl" name="homeurl" size="30" maxlength="100" value="',$_SESSION[QT]['home_url'],'"',($_SESSION[QT]['home_menu']=='0' ? QDIS : ''),'/></td>
</tr>
';

echo '<tr class="tr">
<th class="th_o th_o_all" colspan="2">',$L['Display_options'],'</th>
</tr>
';
echo '<tr class="tr" title="',$L['H_Repeat_section_description'],'">
<th class="th_o th_o_first"><label for="section_descr">',$L['Repeat_section_description'],'</label></th>
<td class="td_o"><select id="team_descr" name="section_descr">',QTastags(array($L['N'],$L['Y']),null, $_SESSION[QT]['section_descr']),'</select></td>
</tr>
';
echo '<tr title="',$L['H_Show_calendar'],'">
<th class="th_o th_o_first"><label for="show_calendar">',$L['Show_calendar'],'</label></th>
<td class="td_o"><select id="show_calendar" name="show_calendar">',QTastags($L['Userroles'],null,$_SESSION[QT]['show_calendar']),'</select></td>
</tr>
';
echo '<tr title="',$L['H_Show_statistics'],'">
<th class="th_o th_o_first"><label for="show_stats">',$L['Show_statistics'],'</label></th>
<td class="td_o"><select id="show_stats" name="show_stats">',QTastags($L['Userroles'],null,$_SESSION[QT]['show_stats']),'</select></td>
</tr>
';
echo '<tr class="tr">
<th class="th_o" colspan="2" style="padding:6px; text-align:center"><input type="submit" name="ok" value="',$L['Save'],'"/></th>
</tr>
';
echo '</table>
</form>
';

// --------
// HTML END
// --------

include('qte_adm_p_footer.php');

?>