<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam team
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080618
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( $oVIP->role!='A' ) die($L['R_admin']);

// ---------
// INITIALISE
// ---------

include(Translate($_SESSION[QT]['language'],'qte_lang_adm.inc'));

$oVIP->selfurl = 'qte_adm_site.php';
$oVIP->selfname = $L['Adm_general'];

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  // check sitename
  $str = $_POST['sitename']; if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
  $str = QTformattitle($str,64);
  if ( !empty($str) ) { $_SESSION[QT]['site_name'] = $str; } else { $qte_error=$L['Site_name'].S.$L['E_invalid']; }

  // check siteurl
  if ( empty($qte_error) )
  {
    $str = QTformattitle($_POST['siteurl'],255);
    if ( substr($str,-1,1)=='/' ) $str = substr($str,0,-1);
    if ( !empty($str) ) { $_SESSION[QT]['site_url'] = $str; } else { $qte_error=$L['Site_url'].': '.$L['E_invalid']; }
    if ( !ereg('^(http://|https://)',$str) ) $qte_warning = $L['Site_url'].': '.$L['E_missing_http'];
  }

  // check Findexname
  if ( empty($qte_error) )
  {
    $str = $_POST['title']; if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
    $str = QTformattitle($str,64);
    if ( !empty($str) ) { $_SESSION[QT]['section_index'] = $str; } else { $qte_error = $L['Name_of_index'].S.$L['E_invalid']; }
  }

  // check Fadminemail
  if ( empty($qte_error) )
  {
    $str = trim($_POST['adminmail']);
    if ( QTismail($str) ) { $_SESSION[QT]['admin_email'] = $str; } else { $qte_error = $L['Adm_e_mail'].S.$L['E_invalid']; }
  }

  // check others
  if ( empty($qte_error) )
  {
    $str = $_POST['adminfax']; if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
    $_SESSION[QT]['admin_fax'] = QTformattitle($str,255);
    $str = $_POST['adminname']; if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
    $_SESSION[QT]['admin_name'] = QTformattitle($str,255);
    $str = $_POST['adminaddr']; if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
    $_SESSION[QT]['admin_addr'] = QTformattitle($str,255);
    $_SESSION[QT]['use_smtp'] = $_POST['smtp'];
    if ( $_SESSION[QT]['smtp_host']=='1' )
    {
    $_SESSION[QT]['smtp_host'] = trim($_POST['smtphost']);
    $_SESSION[QT]['smtp_username'] = trim($_POST['smtpusr']);
    $_SESSION[QT]['smtp_password'] = trim($_POST['smtppwd']);
    if ( empty($_SESSION[QT]['smtp_host']) ) $qte_error = 'Smtp host '.$L['E_invalid'];
    }
  }

  // save value
  if ( empty($qte_error) )
  {
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['site_name'].'" WHERE param="site_name"');
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['site_url'].'" WHERE param="site_url"');
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['section_index'].'" WHERE param="section_index"');
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['admin_email'].'" WHERE param="admin_email"');
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['admin_fax'].'" WHERE param="admin_fax"');
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['admin_name'].'" WHERE param="admin_name"');
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['admin_addr'].'" WHERE param="admin_addr"');
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['use_smtp'].'" WHERE param="use_smtp"');
    if ( $_SESSION[QT]['smtp_host']=='1' )
    {
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['smtp_host'].'" WHERE param="smtp_host"');
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['smtp_username'].'" WHERE param="smtp_username"');
    $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['smtp_password'].'" WHERE param="smtp_password"');
    }
    $strInfo = $L['S_save'];
  }
}

// --------
// HTML START
// --------

// WARNINGS

if ( !ereg("^(http://|https://)",$_SESSION[QT]['site_url']) ) $qte_warning = $L['Site_url'].': '.$L['E_missing_http'];

include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

// INITIALISE

echo '
<script type="text/javascript">
<!--
function smtpdisabled(str)
{
  if (str=="0")
  {
  document.getElementById("smtphost").disabled=true;
  document.getElementById("smtpusr").disabled=true;
  document.getElementById("smtppwd").disabled=true;
  }
  else
  {
  document.getElementById("smtphost").disabled=false;
  document.getElementById("smtpusr").disabled=false;
  document.getElementById("smtppwd").disabled=false;
  }
  return null;
}
function PassInLink()
{
  strHost = document.getElementById("smtphost").value;
  strUser = document.getElementById("smtpusr").value;
  strPass = document.getElementById("smtppwd").value;
  document.getElementById("smtplink").href="qte_adm_smtp.php?h=" + strHost + "&u=" + strUser + "&p=" + strPass;
  document.getElementById("smtplink").target="_blank";
  return null;
}
function ValidateForm(theForm)
{
  if (theForm.sitename.value.length < 1) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Site_name'],'")); return false; }
  if (theForm.siteurl.value.length < 1) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Site_url'],'")); return false; }
  if (theForm.siteurl.value.substr(0,4) != "http") { alert(html_entity_decode("http:// or https:// required in ',$L['Site_url'],'")); return false; }
  if (theForm.title.value.length < 1) { alert(html_entity_decode("',$L['E_mandatory'],' ',$L['Name_of_index'],'")); return false; }
  if (theForm.adminmail.value.length < 1) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Adm_e_mail'],'")); return false; }
  return null;
}
-->
</script>
';

echo '<form method="post" action="',$oVIP->selfurl,'" onsubmit="return ValidateForm(this);">
<table class="tab" cellspacing="0">
<tr class="tr">
<th class="th_o th_o_all" colspan="2">',$L['General_site'],'</th>
</tr>
';
echo '<tr class="tr" title="',$L['H_Site_name'],'">
<th class="th_cnt th_o th_o_first" style="width:200px;"><label for="sitename">',$L['Site_name'],'</label></th>
<td class="td_o"><input type="text" id="sitename" name="sitename" size="50" maxlength="64" value="',$_SESSION[QT]['site_name'],'"/></td>
</tr>
';
echo '<tr class="tr" title="',$L['H_Site_url'],'">
<th class="th_o th_o_first"><label for="siteurl">',$L['Site_url'],'</label></th>
<td class="td_o"><input type="text" id="siteurl" name="siteurl" size="50" maxlength="255" value="',$_SESSION[QT]['site_url'],'"/></td>
</tr>
';
echo '<tr class="tr" title="',$L['H_Name_of_index'],'">
<th class="th_o th_o_first"><label for="title">',$L['Name_of_index'],'</label></th>
<td class="td_o"><input type="text" id="title" name="title" size="50" maxlength="64" value="',$_SESSION[QT]['section_index'],'"/></td>
</tr>
';
echo '<tr class="tr">
<th class="th_o th_o_all" colspan="2">',$L['Contact'],'</th>
</tr>
';
echo '<tr class="tr" title="',$L['H_Admin_e_mail'],'">
<th class="th_o th_o_first"><label for="adminmail">',$L['Adm_e_mail'],'</label></th>
<td class="td_o"><input type="text" id="adminmail" name="adminmail" size="50" maxlength="255" value="',$_SESSION[QT]['admin_email'],'" style="background-color:#FFFF99"/></td>
</tr>
';
echo '<tr class="tr" title="',$L['H_Admin_fax'],'">
<th class="th_o th_o_first"><label for="adminfax">',$L['Adm_fax'],'</label></th>
<td class="td_o"><input type="text" id="adminfax" name="adminfax" size="50" maxlength="255" value="',$_SESSION[QT]['admin_fax'],'"/></td>
</tr>
';
echo '<tr class="tr" title="',$L['Adm_name'],'">
<th class="th_o th_o_first"><label for="adminname">',$L['Adm_name'],'</label></th>
<td class="td_o"><input type="text" id="adminname" name="adminname" size="50" maxlength="255" value="',$_SESSION[QT]['admin_name'],'"/></td>
</tr>
';
echo '<tr class="tr" title="',$L['Adm_addr'],'">
<th class="th_o th_o_first"><label for="adminaddr">',$L['Adm_addr'],'</label></th>
<td class="td_o"><input type="text" id="adminaddr" name="adminaddr" size="50" maxlength="255" value="',$_SESSION[QT]['admin_addr'],'"/></td>
</tr>
';
echo '<tr class="tr">
<th class="th_o th_o_all" colspan="2">',$L['Email_settings'],'</th>
</tr>
';
echo '<tr class="tr" title="',$L['H_Use_smtp'],'">
<th class="th_o th_o_first"><label for="smtp">',$L['Use_smtp'],'</label></th>
<td class="td_o">
<select id="smtp" name="smtp" onchange="smtpdisabled(this.value)">',QTastags(array($L['N'],$L['Y']),null, $_SESSION[QT]['use_smtp']),'</select>
</td>
</tr>
';
echo '<tr class="tr" title="',$L['H_Use_smtp'],'">
<th class="th_o th_o_first"><label for="smtphost">Smtp host</label></th>
<td class="td_o"><input type="text" id="smtphost" name="smtphost" size="28" maxlength="64" value="',$_SESSION[QT]['smtp_host'],'"'.($_SESSION[QT]['use_smtp']=='0' ? QDIS : '').'/></td>
</tr>
';
echo '<tr class="tr" title="',$L['H_Use_smtp'],'">
<th class="th_o th_o_first"><label for="smtpusr">Smtp username</label></th>
<td class="td_o"><input type="text" id="smtpusr" name="smtpusr" size="28" maxlength="64" value="',$_SESSION[QT]['smtp_username'],'"'.($_SESSION[QT]['use_smtp']=='0' ? QDIS : '').'/></td>
</tr>
';
echo '<tr class="tr" title="',$L['H_Use_smtp'],'">
<th class="th_o th_o_first"><label for="smtppwd">Smtp password</label></th>
<td class="td_o"><input type="text" id="smtppwd" name="smtppwd" size="28" maxlength="64" value="',$_SESSION[QT]['smtp_password'],'"'.($_SESSION[QT]['use_smtp']=='0' ? QDIS : '').'/> <a id="smtplink" href="qte_adm_smtp.php" onclick="PassInLink()" target="_blank">test smtp</a></td>
</tr>
';
echo '<tr class="tr">
<th class="th_o" colspan="2" style="padding:6px; text-align:center"><input type="submit" name="ok" value="',$L['Save'],'"/></th>
</tr>
';
echo '</table>
</form>',N,N;

// --------
// HTML END
// --------

include('qte_adm_p_footer.php');

?>