<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam team
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080618
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */
session_start();
require_once('bin/qte_init.php');
if ( $oVIP->role!='A' ) die($L['R_admin']);

// ---------
// INITIALISE
// ---------

Include($_SESSION[QT]['language'].'/qte_lang_adm.inc');

$oVIP->selfurl = 'qte_adm_secu.php';
$oVIP->selfname = $L['Adm_security'];

// --------
// SUBMITTED
// --------

if ( isset($_POST['ok']) )
{
  // check form

  $_SESSION[QT]['visitor_right']=$_POST['pal'];
  $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['visitor_right'].'" WHERE param="visitor_right"');
  
  $_SESSION[QT]['member_right']=$_POST['mal'];
  $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_SESSION[QT]['member_right'].'" WHERE param="member_right"');

  $_SESSION[QT]['register_mode']=$_POST['regmode'];
  $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_POST['regmode'].'" WHERE param="register_mode"');

  $_SESSION[QT]['register_safe']=$_POST['regsafe'];
  $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_POST['regsafe'].'" WHERE param="register_safe"');

  $_SESSION[QT]['register_coppa']=$_POST['regcoppa'];
  $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_POST['regcoppa'].'" WHERE param="register_coppa"');

  $_SESSION[QT]['javamail']=$_POST['javamail'];
  $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_POST['javamail'].'" WHERE param="javamail"');

  $_SESSION[QT]['picture']=$_POST['picture'];
  $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_POST['picture'].'" WHERE param="picture"');

  if ( $_SESSION[QT]['picture']!='0' )
  {
    if ( isset($_POST['picturewidth']) )
    {
      $str = strip_tags(trim($_POST['picturewidth']));
      if ( !QTisbetween($str,20,200) ) { $qte_error = $L['Max_picture_size'].S.$L['E_invalid'].' (20-200 pixels)'; }
      if ( empty($qte_error) )
      {
      $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$str.'" WHERE param="picture_width"');
      $_SESSION[QT]['picture_width']=$str;
      }
    }
    if ( isset($_POST['pictureheight']) )
    {
      $str = strip_tags(trim($_POST['pictureheight']));
      if ( !QTisbetween($str,20,200) ) { $qte_error = $L['Max_picture_size'].S.$L['E_invalid'].' (20-200 pixels)'; }
      if ( empty($qte_error) )
      {
      $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$str.'" WHERE param="picture_height"');
      $_SESSION[QT]['picture_height']=$str;
      }
    }
    if ( isset($_POST['picturesize']) )
    {
      $str = strip_tags(trim($_POST['picturesize']));
      if ( !QTisbetween($str,10,100) ) { $qte_error = $L['Max_picture_size'].S.$L['E_invalid'].' (10-100 kb)'; }
      if ( empty($qte_error) )
      {
      $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$str.'" WHERE param="picture_size"');
      $_SESSION[QT]['picture_size']=$str;
      }
    }
  }

  $_SESSION[QT]['upload']=$_POST['upload'];
  $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$_POST['upload'].'" WHERE param="upload"');

  if ( $_SESSION[QT]['upload']!='0' )
  {
    if ( isset($_POST['uploadsize']) )
    {
      $str = strip_tags(trim($_POST['uploadsize']));
      if ( !QTisbetween($str,100,10000) ) { $qte_error = $L['Maximum'].S.$L['E_invalid'].' (100-10000 kb)'; }
      if ( empty($qte_error) )
      {
      $oDB->Query('UPDATE '.TABSETTING.' SET setting="'.$str.'" WHERE param="uploadsize"');
      $_SESSION[QT]['uploadsize']=$str;
      }
    }
  }

  if ( empty($qte_error) )
  {
     $strInfo = $L['S_save'];
  }
}

// --------
// HTML START
// --------

include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

// FORM

echo '
<script type="text/javascript">
<!--
function picturedisabled(str)
{
  ctrl1 = document.getElementById("picturewidth");
  ctrl2 = document.getElementById("pictureheight");
  ctrl3 = document.getElementById("picturesize");
  if (str=="0")
  {
  ctrl1.disabled=true;
  ctrl2.disabled=true;
  ctrl3.disabled=true;
  }
  else
  {
  ctrl1.disabled=false; if (ctrl1.value.length==0) { ctrl1.value="100"; }
  ctrl2.disabled=false; if (ctrl2.value.length==0) { ctrl2.value="100"; }
  ctrl3.disabled=false; if (ctrl3.value.length==0) { ctrl3.value="12"; }
  }
  return null;

}
function uploaddisabled(str)
{
  ctrl1 = document.getElementById("uploadsize");
  if (str=="0")
  {
  ctrl1.disabled=true;  
  }
  else
  {
  ctrl1.disabled=false; if (ctrl1.value.length==0) { ctrl1.value="500"; }
  }
  return null;
}
function ValidateForm(theForm)
{
  if (theForm.tpf.value.length < 1) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Max_users_per_section'],'")); return false; }
  if (!theForm.picturewidth.disabled)
  {
    if (theForm.picturewidth.value.length < 1) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Maximum'],' pixels")); return false; }
  }
  if (!theForm.pictureheight.disabled)
  {
    if (theForm.pictureheight.value.length < 1) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Maximum'],' pixels")); return false; }
  }
  if (!theForm.picturesize.disabled)
  {
    if (theForm.picturesize.value.length < 1) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Maximum'],' Kb")); return false; }
  }
  if (!theForm.uploadsize.disabled)
  {
    if (theForm.uploadsize.value.length < 1) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Maximum'],' Kb")); return false; }
  }
  return null;
}
-->
</script>
';

echo '<form method="post" action="',$oVIP->selfurl,'" onsubmit="return ValidateForm(this);">
';
echo '<table class="tab" cellspacing="0">
';
echo '<tr class="tr">
<th class="th_o th_o_all" colspan="2">',$L['Public_access_level'],'</th>
</tr>
';
echo '<tr class="tr" title="',$L['H_Visitors_can'],'">
<th class="th_o th_o_first"><label for="pal">',$L['Visitors_can'],'</label></th>
<td class="td_o">
<select id="pal" name="pal">',QTastags($L['Pal'],null,$_SESSION[QT]['visitor_right']),'</select></td>
</tr>
';
echo '<tr class="tr" title="',$L['H_Members_can'],'">
<th class="th_o th_o_first"><label for="pal">',$L['Members_can'],'</label></th>
<td class="td_o">
<select id="mal" name="mal">',QTastags($L['Mal'],null,$_SESSION[QT]['member_right']),'</select></td>
</tr>
';
echo '<tr class="tr">
<th class="th_o th_o_all" colspan="2">',$L['Registration'],'</th>
</tr>
';
echo '<tr class="tr" title="',$L['Reg_mode'],'">
<th class="th_o th_o_first" style="width:250px;"><label for="regmode">',$L['Reg_mode'],'</label></th>
<td class="td_o">
<select id="regmode" name="regmode">
<option value="direct"',($_SESSION[QT]['register_mode']=='direct' ? QSEL : ''),'>',$L['Direct'],'</option>
<option value="email"',($_SESSION[QT]['register_mode']=='email' ? QSEL : ''),'>',$L['By_email'],'</option>
</select>
</tr>
';
echo '<tr class="tr" title="',$L['H_Reg_security'],'">
<th class="th_o th_o_first"><label for="regsafe">',$L['Reg_security'],'</label></th>
<td class="td_o">
<select id="regsafe" name="regsafe">
<option value="none"',($_SESSION[QT]['register_safe']=='none' ? QSEL : ''),'>',$L['None'],'</option>
<option value="text"',($_SESSION[QT]['register_safe']=='text' ? QSEL : ''),'>',$L['Text_code'],'</option>
<option value="image"',($_SESSION[QT]['register_safe']=='image' ? QSEL : ''),'>',$L['Image_code'],'</option>
</select>
</tr>
';
echo '<tr class="tr" title="',$L['H_Register_coppa'],'">
<th class="th_o th_o_first"><label for="regcoppa">',$L['Register_coppa'],'</label></th>
<td class="td_o">
<select id="regcoppa" name="regcoppa">
<option value="0"',($_SESSION[QT]['register_coppa']=='0' ? QSEL : ''),'>',$L['N'],'</option>
<option value="1"',($_SESSION[QT]['register_coppa']=='1' ? QSEL : ''),'>',$L['Y'],'</option>
</select>
</tr>
';
echo '<tr class="tr">
<th class="th_o th_o_all" colspan="2">',$L['Security_rules'],'</th>
</tr>
';
echo '<tr class="tr" title="',$L['H_java_mail'],'">
<th class="th_o th_o_first"><label for="javamail">',$L['Java_mail'],'</label></th>
<td class="td_o"><select id="javamail" name="javamail">
<option value="0"',($_SESSION[QT]['javamail']=='0' ? QSEL : ''),'>',$L['N'],'</option>
<option value="1"',($_SESSION[QT]['javamail']=='1' ? QSEL : ''),'>',$L['Y'],'</option>
</select></td>
</tr>
';
echo '<tr class="tr" title="',$L['H_Allow_picture'],'">
<th class="th_o th_o_first"><label for="picture">',$L['Allow_picture'],'</label></th>
<td class="td_o"><select id="picture" name="picture" onchange="picturedisabled(this.value)">
<option value="0"',($_SESSION[QT]['picture']=='0' ? QSEL : ''),'>',$L['N'],'</option>
<option value="jpg,jpeg"',($_SESSION[QT]['picture']=='jpg,jpeg' ? QSEL : ''),'>',$L['Y'],' (',$L['Jpg_only'],')</option>
<option value="gif,jpg,jpeg,png"'.($_SESSION[QT]['picture']=='gif,jpg,jpeg,png' ? QSEL : '').'>',$L['Y'],' (',$L['Gif_jpg_png'],')</option>
</select> ',$L['Maximum'],' <input type="text" id="picturewidth" name="picturewidth" size="3" maxlength="3" value="',$_SESSION[QT]['picture_width'],'"'.($_SESSION[QT]['picture']=='0' ? QDIS : '').'/> x <input type="text" id="pictureheight" name="pictureheight" size="3" maxlength="3" value="',$_SESSION[QT]['picture_height'],'"'.($_SESSION[QT]['picture']=='0' ? QDIS : '').'/> pixels, <input type="text" id="picturesize" name="picturesize" size="3" maxlength="3" value="',$_SESSION[QT]['picture_size'],'"'.($_SESSION[QT]['picture']=='0' ? QDIS : '').'/>Kb</td>
</tr>
';
echo '<tr class="tr" title="',$L['H_Allow_upload'],'">
<th class="th_o th_o_first"><label for="upload">',$L['Allow_upload'],'</label></th>
<td class="td_o"><select id="upload" name="upload" onchange="uploaddisabled(this.value)">
<option value="0"',($_SESSION[QT]['upload']=='0' ? QSEL : ''),'>',$L['N'],'</option>
<option value="1"',($_SESSION[QT]['upload']=='1' ? QSEL : ''),'>',$L['Y'],'</option>
</select> ',$L['Maximum'],' <input type="text" id="uploadsize" name="uploadsize" size="5" maxlength="5" value="',$_SESSION[QT]['uploadsize'],'"'.($_SESSION[QT]['upload']=='0' ? QDIS : '').'/>Kb</td>
</tr>
';
echo '<tr class="tr">
<th class="th_o" colspan="2" style="padding:6px; text-align:center"><input type="submit" name="ok" value="',$L['Save'],'"/></th>
</tr>
';
echo '</table>
</form>
';

// --------
// HTML END
// --------

include('qte_adm_p_footer.php');

?>