<?php

/*
 * PHP versions 4 and 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   Team
 * @package    QuickTeam
 * @author     Philippe Vandenberghe <info@qt-cute.org>
 * @copyright  2007-2010 The PHP Group
 * @license    http://www.php.net/license  PHP License 3.0
 * @version    1.8 build:20080618
 * @link       http://www.qt-cute/doc/package/qte
 * @since      File available since Release 1.0.0
 * @deprecated File deprecated in Release 2.0.0
 *
 */

session_start();
require_once('bin/qte_init.php');
if ( $oVIP->role!='A' ) die($L['R_admin']);

// ---------
// INITIALISE
// ---------

include(Translate($_SESSION[QT]['language'],'qte_lang_adm.inc'));

function arrShift($arrSrc,$intObject,$strDir)
{
  $arrTemp = $arrSrc;

  // search for the value
  foreach ($arrSrc as $intKey => $intValue)
  {
  if ( $intValue==$intObject ) $intNewkey = $intKey;
  }
  if ( !isset($intNewkey) ) return false;
  if ( $intNewkey==0 && $strDir=='up' ) return $arrSrc;
  if ( $intNewkey==(count($arrSrc)-1) && $strDir=='down' ) return $arrSrc;

  // reorder the elements
  if ( $strDir=='up' ) { $intDir = -1; } else { $intDir = 1; }
  $arrTemp[$intNewkey+$intDir] = $arrSrc[$intNewkey];
  $arrTemp[$intNewkey] = $arrSrc[$intNewkey+$intDir];

  // return the ordered array
  return $arrTemp;
}

if ( isset($_SESSION['fields']) ) unset($_SESSION['fields']);

$oVIP->selfurl = 'qte_adm_sections.php';
$oVIP->selfname = $L['Section_man'];

// --------
// SUBMITTED
// --------

// ADD DOMAIN

if ( isset($_POST['adddomain']) )
{
  // CHECK TITLE
  $str = $_POST['title']; if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
  $str = QThtmlquote($str,true,true,QTE_CONVERT_AMP);
  if ( empty($str) ) $qte_error = $L['Title'].S.$L['E_invalid'];

  // SAVE
  if ( empty($qte_error) )
  {
  $intNewid = QTnextid($oDB,TABDOMAIN);
  $oDB->Query( 'INSERT INTO '.TABDOMAIN.' (id,title,vorder) VALUES ('.$intNewid.',"'.$str.'",255)' );
  }
}

// ADD SECTION

if ( isset($_POST['addteam']) )
{
  // CHECK TITLE
  $str = $_POST['title']; if ( get_magic_quotes_gpc() ) $str = stripslashes($str);
  $str = QThtmlquote($str,true,true,QTE_CONVERT_AMP);
  if ( empty($str) ) $qte_error = $L['Title'].S.$L['E_invalid'];

  // SAVE
  if ( empty($qte_error) )
  {
  $oSEC = new cSection;
  $oSEC->domainid = $_POST['indomain'];
  $oSEC->title = $str;
  $oSEC->MakeNew($oDB);
  }
}

// Move domain/team

if ( isset($_GET['a']) )
{
  if ( $_GET['a']=='d_up' )
  {
    $oDB->Query('SELECT id FROM '.TABDOMAIN.' ORDER BY vorder');
    $arrList = array();
    while ($row = $oDB->Getrow())
    {
    $arrList[]=$row['id'];
    }
    $arrOrdered = arrShift($arrList,$_GET['d'],'up');
    $i = 0;
    foreach ($arrOrdered as $intId)
    {
    $oDB->Query('UPDATE '.TABDOMAIN." SET vorder=$i WHERE id=$intId");
    $i++;
    }
  }
  if ( $_GET['a']=='d_down' )
  {
    $oDB->Query('SELECT id FROM '.TABDOMAIN.' ORDER BY vorder');
    $arrList = array();
    while ($row = $oDB->Getrow())
    {
    $arrList[]=$row['id'];
    }
    $arrOrdered = arrShift($arrList,$_GET['d'],'down');
    $i = 0;
    foreach ($arrOrdered as $intId)
    {
    $oDB->Query('UPDATE '.TABDOMAIN." SET vorder=$i WHERE id=$intId");
    $i++;
    }
  }
  if ( $_GET['a']=='f_up' )
  {
    $oDB->Query('SELECT id FROM '.TABSECTION.' ORDER BY vorder');
    $arrList = array();
    while ($row = $oDB->Getrow())
    {
    $arrList[]=$row['id'];
    }
    $arrOrdered = arrShift($arrList,$_GET['s'],'up');
    $i = 0;
    foreach ($arrOrdered as $intId)
    {
    $oDB->Query('UPDATE '.TABSECTION." SET vorder=$i WHERE id=$intId");
    $i++;
    }
  }
  if ( $_GET['a']=='f_down' )
  {
    $oDB->Query('SELECT id FROM '.TABSECTION." ORDER BY vorder");
    $arrList = array();
    while ($row = $oDB->Getrow())
    {
    $arrList[]=$row['id'];
    }
    $arrOrdered = arrShift($arrList,$_GET['s'],'down');
    $i = 0;
    foreach ($arrOrdered as $intId)
    {
    $oDB->Query('UPDATE '.TABSECTION." SET vorder=$i WHERE id=$intId");
    $i++;
    }
  }
}

// --------
// HTML START
// --------

$bJava=true;
include('qte_adm_p_header.php');
include('qte_adm_p_title.php');

GetDomains($oDB);
$_SESSION['qteGoto'] = GetSectionTitles($oDB,$oVIP->role,null,-1,'',QTE_SHOW_DOMAIN);

$strYes = '<b>'.$L['Y'].'</b>';
$strNo  = '<span class="disabled">'.$L['N'].'</span>';

echo '<table class="tab" cellspacing="0">
<colgroup span="7"><col width="30"></col><col width="50"></col><col></col><col></col><col width="110"></col><col width="110"></col><col></col></colgroup>
<tr class="tr">
<th class="th_o">Id</th>
<th class="th_o" colspan="2" style="text-align:left">',$L['Domain'],'/',$L['Section'],'</th>
<th class="th_o">',$L['Section_moderator'],'</th>
<th class="th_o">',$L['Action'],'</th>
<th class="th_o">',$L['Move'],'</th>
<th class="th_o">',$L['Users'],'</th>
</tr>
';

$i=0;
foreach ($_SESSION['qteDomains'] as $intDomain => $strDomain)
{
  // GET SECTIONS (with hidden)

  $arrTeams = GetSectionTitles($oDB,'A',$intDomain);

  // DISPLAY

  echo '<tr class="tr">',N;
  echo '<td class="td_o_all">&nbsp;</td>',N;
  echo '<td class="td_o_all" colspan="2">',$strDomain,'</td>',N;
  echo '<td class="td_o_all">&nbsp;</td>',N;
  echo '<td class="td_o_all" style="text-align:center"><a class="small" href="qte_adm_domain.php?d=',$intDomain,'">',$L['Edit'],'</a>';
  echo ' &middot; ',($intDomain==0 ? '<span class="disabled">'.$L['Delete'].'</span>' : '<a class="small" href="qte_cmd.php?a=deletedomain&amp;s='.$intDomain.'">'.$L['Delete'].'</a>'),'</td>',N;
  echo '<td class="td_o_all" style="text-align:center">';
  if ( $i==0 )
  {
  echo '<span class="disabled">',$L['Up'],'</span>';
  }
  else
  {
  echo '<a class="small" href="qte_adm_sections.php?d=',$intDomain,'&amp;a=d_up">',$L['Up'],'</a>';
  }
  echo ' &middot; ';
  if ( $i+1==count($_SESSION['qteDomains']) )
  {
  echo '<span class="disabled">',$L['Down'],'</span>';
  }
  else
  {
  echo '<a class="small" href="qte_adm_sections.php?d=',$intDomain,'&amp;a=d_down">',$L['Down'],'</a>';
  }
  echo '</td>',N;
  echo '<td class="td_o_all" style="text-align:center">&nbsp;</td>',N;

  $i += 1;

  $j = 0;
  foreach ($arrTeams as $intSection => $strSection)
  {
    // GET SECTION
    $oSEC = new cSection($oDB,$intSection);
    echo '<tr class="tr">',N;
    echo '<td class="td_o" style="text-align:center">',$oSEC->id,'</td>',N;
    echo '<td class="td_o" style="text-align:center">',AsImg($_SESSION[QT]['skin_dir'].'/ico_section_'.$oSEC->type.'_'.$oSEC->status.'.gif','[+]',$L['Ico_section_'.$oSEC->type.'_'.$oSEC->status],'ico_section'),'</td>',N;
    echo '<td class="td_o"><b>',$oSEC->title,'</b><br/><span class="small">',$L['Section_type'][$oSEC->type],($oSEC->status=='1' ? '<br><span class="small">('.$L['Section_status'][1].')</span>' : ''),'</span></td>',N;
    echo '<td class="td_o" style="text-align:center">',$oSEC->modname,'</td>',N;
    echo '<td class="td_o" style="text-align:center">
    <a class="small" href="qte_adm_section.php?d=',$intDomain,'&amp;s=',$oSEC->id,'">',$L['Edit'],'</a> &middot; 
    '.($intSection==0 ? '<span class="disabled">'.$L['Delete'].'</span>' : '<a class="small" href="qte_cmd.php?a=deletesection&amp;s='.$intSection.'">'.$L['Delete'].'</a>'),'</td>',N;
    echo '<td class="td_o" style="text-align:center">';
    if ( $j==0 )
    {
    echo '<span class="disabled">',$L['Up'],'</span>';
    }
    else
    {
    echo '<a class="small" href="qte_adm_sections.php?d=',$intDomain,'&amp;s=',$intSection,'&amp;a=f_up">',$L['Up'],'</a>';
    }
    echo ' &middot; ';
    if ( $j+1==count($arrTeams) )
    {
    echo '<span class="disabled">',$L['Down'],'</span>';
    }
    else 
    {
    echo '<a class="small" href="qte_adm_sections.php?d=',$intDomain,'&amp;s=',$intSection,'&amp;a=f_down">',$L['Down'],'</a>';
    }
    $j += 1;
    echo '</td>',N;
    echo '<td class="td_o" style="text-align:center">',$oSEC->members,'<br/><a class="small" href="qte_adm_users_move.php?s=',$oSEC->id,'">',$L['User_man'],'</a></td>',N;
    echo '</tr>',N;
  }
}
echo '</table>',N,N;

echo '<h2>',$L['Section_add'],'</h2>',N;

echo '
<script type="text/javascript">
<!--
function ValidateForm(theForm)
{
  if (theForm.title.value.length==0) { alert(html_entity_decode("',$L['E_mandatory'],': ',$L['Domain'],'/',$L['Section'],'")); return false; }
  return null;
}
-->
</script>
';

echo '<form method="post" action="qte_adm_sections.php" onsubmit="return ValidateForm(this);">
<table class="tab" cellspacing="0">
<tr class="tr">
<td class="td_o_all" style="width:130px;">',$L['Domain_add'],'</td>
<td class="td_o_all"><input name="title" type="text" size="30" maxlength="64" onKeyUp="handle_keypress(event,\'adddomain\')"/></td>
<td class="td_o_all" style="width:75px;"><input id="adddomain" name="adddomain" type="submit" value="',$L['Add'],'"/></td>
</tr>
</table>
</form>
',N;
echo '<form method="post" action="qte_adm_sections.php" onsubmit="return ValidateForm(this);">
<table class="tab" cellspacing="0">
<tr class="tr">
<td class="td_o" style="width:130px;">',$L['Section_add'],'</td>
<td class="td_o">
<input name="title" type="text" size="30" maxlength="64"/>
&nbsp;',$L['In_domain'],S,'<select name="indomain" size="1" class="small">',QTastags($_SESSION['qteDomains']),'</select>
</td>
<td class="td_o" style="width:75px;"><input name="addteam" type="submit" value="',$L['Add'],'"/></td>
</tr>
</table>
</form>
',N;

// --------
// HTML END
// --------

include('qte_adm_p_footer.php');

?>